/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.ServantNotificationListener;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServantNotificationListenerManager {
    private static TraceComponent tc = Tr.register(ServantNotificationListenerManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private static ServantNotificationListenerManager manager = null;
    private Hashtable listeners = new Hashtable();

    public static synchronized ServantNotificationListenerManager getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (manager == null) {
            manager = new ServantNotificationListenerManager();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", manager);
        }
        return manager;
    }

    private ServantNotificationListenerManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public ListenerIdentifier addServantNotificationListener(ConsolidatedFilter consolidatedFilter, ServantNotificationListener servantNotificationListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServantNotificationListener", servantNotificationListener);
        }
        AdminServiceDelegator adminServiceDelegator = new AdminServiceDelegator();
        ListenerIdentifier listenerIdentifier = adminServiceDelegator.addNotificationListener(consolidatedFilter, servantNotificationListener);
        this.listeners.put(servantNotificationListener.getServantStoken(), listenerIdentifier);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServantNotificationListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    public void cleanupServantJVM(String string) {
        block5: {
            ListenerIdentifier listenerIdentifier;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanupServantJVM", string);
            }
            if ((listenerIdentifier = (ListenerIdentifier)this.listeners.remove(string)) != null) {
                AdminServiceDelegator adminServiceDelegator = new AdminServiceDelegator();
                try {
                    adminServiceDelegator.removeNotificationListener(listenerIdentifier);
                }
                catch (ReceiverNotFoundException receiverNotFoundException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Unable to remove listener for servant " + string, receiverNotFoundException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupServantJVM");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ServantNotificationListenerManager:");
        Set set = this.listeners.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("servant=");
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append(",listenerId=");
            stringBuffer.append(((ListenerIdentifier)entry.getValue()).toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }
}

