/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControllerAdminService;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushToServantNotificationSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.Utils;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZControlNotificationManager
implements DownstreamProcessManager {
    private static TraceComponent tc = Tr.register(ZControlNotificationManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map filterMap;
    private ServerInfo controlServerInfo = null;
    private DSMEntry controlDSMEntry = null;
    private boolean deploymentManager = false;
    private RemoteNotificationBroadcaster rnb = null;

    public ZControlNotificationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.filterMap = new HashMap();
        String string = AdminServiceFactory.getAdminService().getProcessType();
        if (string.equals("DeploymentManager")) {
            this.deploymentManager = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deploymentManager", new Boolean(this.deploymentManager));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void addDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDownstreamProcess", serverInfo);
        }
        this.controlServerInfo = serverInfo;
        if (this.isFilterAdded()) {
            this.controlDSMEntry = this.createDSMEntry();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDownstreamProcess");
        }
    }

    public synchronized void removeDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDownstreamProcess", serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDownstreamProcess");
        }
    }

    public synchronized void setFilter(Object object, ConsolidatedFilter consolidatedFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilter", new Object[]{object, consolidatedFilter});
        }
        this.filterMap.put(object, consolidatedFilter);
        this.updateControllerListener();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilter");
        }
    }

    public synchronized void unsetFilter(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetFilter", object);
        }
        this.filterMap.remove(object);
        this.updateControllerListener();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetFilter");
        }
    }

    private void updateControllerListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateControllerListener");
        }
        if (this.controlServerInfo != null) {
            try {
                if (this.controlDSMEntry == null) {
                    if (this.isFilterAdded()) {
                        this.controlDSMEntry = this.createDSMEntry();
                    }
                } else {
                    if (this.rnb == null) {
                        this.rnb = this.getControllerProxy();
                    }
                    if (this.isFilterAdded()) {
                        ConsolidatedFilter consolidatedFilter = this.createFilter();
                        if (!consolidatedFilter.equals(this.controlDSMEntry.filter)) {
                            this.controlDSMEntry.filter = consolidatedFilter;
                            this.rnb.resetFilter(this.controlDSMEntry.listenerId, this.controlDSMEntry.filter);
                        }
                    } else {
                        this.rnb.removeNotificationListener(this.controlDSMEntry.listenerId);
                        this.controlDSMEntry = null;
                    }
                }
            }
            catch (ReceiverNotFoundException receiverNotFoundException) {
                FFDCFilter.processException((Throwable)receiverNotFoundException, "com.ibm.ws.management.event.ZControlNotificationManager.updateControllerListener", "187", this);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.ZControlNotificationManager.updateControllerListener", "193", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateControllerListener");
        }
    }

    private DSMEntry createDSMEntry() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDSMEntry");
        }
        ConsolidatedFilter consolidatedFilter = this.createFilter();
        DSMEntry dSMEntry = null;
        if (!consolidatedFilter.isEmpty()) {
            ListenerIdentifier listenerIdentifier = this.addRemoteListener(consolidatedFilter);
            dSMEntry = new DSMEntry(consolidatedFilter, listenerIdentifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDSMEntry", dSMEntry);
        }
        return dSMEntry;
    }

    private ListenerIdentifier addRemoteListener(ConsolidatedFilter consolidatedFilter) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoteListener", consolidatedFilter);
        }
        if (this.rnb == null) {
            this.rnb = this.getControllerProxy();
        }
        PushToServantNotificationSender pushToServantNotificationSender = new PushToServantNotificationSender();
        ListenerIdentifier listenerIdentifier = this.rnb.addNotificationListener(consolidatedFilter, pushToServantNotificationSender);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoteListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    private boolean isFilterAdded() {
        return !this.filterMap.isEmpty();
    }

    private ConsolidatedFilter createFilter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFilter");
        }
        ConsolidatedFilter consolidatedFilter = new ConsolidatedFilter();
        Iterator iterator = this.filterMap.values().iterator();
        while (iterator.hasNext()) {
            ConsolidatedFilter consolidatedFilter2 = (ConsolidatedFilter)iterator.next();
            if (this.deploymentManager) {
                consolidatedFilter.appendAllFilterEntries(consolidatedFilter2);
                continue;
            }
            consolidatedFilter.appendFilterEntries(consolidatedFilter2, this.controlServerInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFilter", consolidatedFilter);
        }
        return consolidatedFilter;
    }

    private RemoteNotificationBroadcaster getControllerProxy() throws ConnectorException {
        ControllerAdminService controllerAdminService = null;
        try {
            controllerAdminService = Utils.getControllerAdminService();
        }
        catch (RemoteException remoteException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to create controller proxy", remoteException);
            }
            throw new ConnectorException("unable to create controller proxy", remoteException);
        }
        return controllerAdminService;
    }

    class DSMEntry {
        ConsolidatedFilter filter = null;
        ListenerIdentifier listenerId = null;

        DSMEntry(ConsolidatedFilter consolidatedFilter, ListenerIdentifier listenerIdentifier) {
            this.filter = consolidatedFilter;
            this.listenerId = listenerIdentifier;
        }

        public String toString() {
            return "DSMEntry:[listenerId=" + this.listenerId + ";filter=" + this.filter + "]";
        }
    }
}

