/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.AsyncListenerWrapper;
import com.ibm.ws.management.event.NotificationService;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ZServantListener
implements NotificationListener {
    private static TraceComponent tc = Tr.register(ZServantListener.class, "Admin", "com.ibm.ws.management.resources.event");
    private NotificationService notifService;
    private static ZServantListener instance = null;

    public ZServantListener(NotificationService notificationService) {
        this.notifService = notificationService;
        instance = this;
    }

    public static ZServantListener getInstance() {
        return instance;
    }

    public void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string = adminService.getNodeName();
            String string2 = adminService.getProcessName();
            ObjectName objectName = new ObjectName(adminService.getDomainName() + ":" + "type=ControlAdminService,node=" + string + ",process=" + string2 + ",*");
            MBeanServer mBeanServer = adminService.getMBeanFactory().getMBeanServer();
            Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
            if (set.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ControlAdminService MBean not registered");
                }
            } else {
                Iterator<ObjectName> iterator = set.iterator();
                ObjectName objectName2 = iterator.next();
                AdminServiceFactory.getAdminService().getMBeanFactory().getMBeanServer().addNotificationListener(objectName2, new AsyncListenerWrapper(this), (NotificationFilter)new ControlAdminServiceFilter(), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", notification);
            }
            if (notification.getType().equals("websphere.ws390.servant.terminated")) {
                ServantMBeanStatus servantMBeanStatus = (ServantMBeanStatus)notification.getUserData();
                String string = servantMBeanStatus.getServantStoken();
                String string2 = AdminServiceFactory.getAdminService().getCellName();
                String string3 = AdminServiceFactory.getAdminService().getNodeName();
                ServerInfo serverInfo = new ServerInfo(null, string2, string3, string, null, null, null);
                try {
                    this.notifService.getServantProcessManager().removeDownstreamProcess(serverInfo);
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.ZServantListener.servantRemoved", "92", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error removing servant", connectorException);
                    }
                    break block9;
                }
            }
            if (notification.getType().equals("websphere.ws390.servant.started")) {
                ServantMBeanStatus servantMBeanStatus = (ServantMBeanStatus)notification.getUserData();
                String string = servantMBeanStatus.getServantStoken();
                String string4 = AdminServiceFactory.getAdminService().getCellName();
                String string5 = AdminServiceFactory.getAdminService().getNodeName();
                ServerInfo serverInfo = new ServerInfo(null, string4, string5, string, null, null, null);
                try {
                    this.notifService.getServantProcessManager().addDownstreamProcess(serverInfo);
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.ZServantListener.servantAdded", "82", this);
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "error adding servant", connectorException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private class ControlAdminServiceFilter
    implements NotificationFilter {
        private static final long serialVersionUID = -3657264784563371234L;

        private ControlAdminServiceFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ControlAdminServiceFilter.isNotificationEnabled", notification.getType());
            }
            boolean bl = false;
            if (notification.getType().equals("websphere.ws390.servant.terminated") || notification.getType().equals("websphere.ws390.servant.started")) {
                bl = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ControlAdminServiceFilter.isNotificationEnabled", new Boolean(bl));
            }
            return bl;
        }
    }
}

