/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.ServantAdminService;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushToControlNotificationSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZServantNotificationManager
implements DownstreamProcessManager {
    private static TraceComponent tc = Tr.register(ZServantNotificationManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map filterMap;
    private Map servantMap;

    public ZServantNotificationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.filterMap = new HashMap();
        this.servantMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void addDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDownstreamProcess", serverInfo);
        }
        DSMEntry dSMEntry = null;
        if (this.isFilterAdded()) {
            dSMEntry = this.createDSMEntry(serverInfo);
        }
        this.servantMap.put(serverInfo, dSMEntry);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDownstreamProcess");
        }
    }

    private DSMEntry createDSMEntry(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDSMEntry", serverInfo);
        }
        ConsolidatedFilter consolidatedFilter = this.createFilter(serverInfo);
        DSMEntry dSMEntry = null;
        if (!consolidatedFilter.isEmpty()) {
            ListenerIdentifier listenerIdentifier = this.addRemoteListener(serverInfo, consolidatedFilter);
            dSMEntry = new DSMEntry(consolidatedFilter, listenerIdentifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDSMEntry", dSMEntry);
        }
        return dSMEntry;
    }

    private ConsolidatedFilter createFilter(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFilter", serverInfo);
        }
        ConsolidatedFilter consolidatedFilter = new ConsolidatedFilter();
        Iterator iterator = this.filterMap.values().iterator();
        while (iterator.hasNext()) {
            consolidatedFilter.appendFilterEntries((ConsolidatedFilter)iterator.next(), serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFilter", consolidatedFilter);
        }
        return consolidatedFilter;
    }

    private ListenerIdentifier addRemoteListener(ServerInfo serverInfo, ConsolidatedFilter consolidatedFilter) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoteListener", new Object[]{serverInfo, consolidatedFilter});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        PushToControlNotificationSender pushToControlNotificationSender = new PushToControlNotificationSender();
        ListenerIdentifier listenerIdentifier = remoteNotificationBroadcaster.addNotificationListener(consolidatedFilter, pushToControlNotificationSender);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoteListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    private void updateRemoteListener(ServerInfo serverInfo, DSMEntry dSMEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRemoteListener", new Object[]{serverInfo, dSMEntry});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        remoteNotificationBroadcaster.resetFilter(dSMEntry.listenerId, dSMEntry.filter);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRemoteListener");
        }
    }

    private void removeRemoteListener(ServerInfo serverInfo, DSMEntry dSMEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRemoteListener", new Object[]{serverInfo, dSMEntry});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        remoteNotificationBroadcaster.removeNotificationListener(dSMEntry.listenerId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRemoteListener");
        }
    }

    private RemoteNotificationBroadcaster getRemoteProxy(ServerInfo serverInfo) throws ConnectorException {
        ServantAdminService servantAdminService = Utils.getServantAdminService();
        servantAdminService.setServantToken(serverInfo.getName());
        return servantAdminService;
    }

    public synchronized void removeDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        this.servantMap.remove(serverInfo);
    }

    public synchronized void setFilter(Object object, ConsolidatedFilter consolidatedFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilter", new Object[]{object, consolidatedFilter});
        }
        if (AdminHelper.getPlatformHelper().isServerShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setFilter", "server shutdown");
            }
            return;
        }
        this.filterMap.put(object, consolidatedFilter);
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilter");
        }
    }

    public synchronized void unsetFilter(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetFilter", object);
        }
        if (AdminHelper.getPlatformHelper().isServerShuttingDown()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setFilter", "server shutdown");
            }
            return;
        }
        this.filterMap.remove(object);
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetFilter");
        }
    }

    private boolean isFilterAdded() {
        return !this.filterMap.isEmpty();
    }

    private void updateServerListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerListeners");
        }
        Iterator iterator = this.servantMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                DSMEntry dSMEntry;
                ServerInfo serverInfo = (ServerInfo)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "examining server " + serverInfo);
                }
                if ((dSMEntry = (DSMEntry)this.servantMap.get(serverInfo)) == null) {
                    if (!this.isFilterAdded()) continue;
                    dSMEntry = this.createDSMEntry(serverInfo);
                    this.servantMap.put(serverInfo, dSMEntry);
                    continue;
                }
                RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
                if (this.isFilterAdded()) {
                    ConsolidatedFilter consolidatedFilter = this.createFilter(serverInfo);
                    if (consolidatedFilter.equals(dSMEntry.filter)) continue;
                    dSMEntry.filter = consolidatedFilter;
                    this.updateRemoteListener(serverInfo, dSMEntry);
                    continue;
                }
                this.removeRemoteListener(serverInfo, dSMEntry);
                this.servantMap.put(serverInfo, null);
            }
            catch (ReceiverNotFoundException receiverNotFoundException) {
                FFDCFilter.processException((Throwable)receiverNotFoundException, "com.ibm.ws.management.event.DownstreamProcessManager.updateServerListeners", "206", this);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.DownstreamProcessManager.updateServerListeners", "210", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServerListeners");
        }
    }

    class DSMEntry {
        ConsolidatedFilter filter;
        ListenerIdentifier listenerId;

        DSMEntry(ConsolidatedFilter consolidatedFilter, ListenerIdentifier listenerIdentifier) {
            this.filter = consolidatedFilter;
            this.listenerId = listenerIdentifier;
        }

        public String toString() {
            return "DSMEntry:[listenerId=" + this.listenerId + ";filter=" + this.filter + "]";
        }
    }
}

