/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.fileservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.fileservice.FileBrowser;
import com.ibm.websphere.management.fileservice.FileServiceException;
import com.ibm.websphere.management.fileservice.RemoteFile;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class FileBrowserImpl
implements FileBrowser {
    private static TraceComponent tc = Tr.register(FileBrowserImpl.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static Properties fileSystemProperties = null;
    private VariableMap vMap = null;

    public FileBrowserImpl() {
    }

    public FileBrowserImpl(VariableMap variableMap) {
        this.vMap = variableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile mkdir(String string) throws FileServiceException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "mkdir");
            }
            RemoteFile remoteFile = null;
            boolean bl = false;
            File file = null;
            file = new File(string = this.expand(string));
            bl = file.mkdir();
            if (bl) {
                remoteFile = this.getFileProperties(file);
            } else {
                Tr.service(tc, "ADFS0103", new Object[]{string});
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "create directory : " + string);
            }
            RemoteFile remoteFile2 = remoteFile;
            return remoteFile2;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mkdir");
            }
        }
    }

    public String getPathSeparator() {
        return System.getProperty("path.separator");
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public String getWASHome() {
        return System.getProperty("server.root");
    }

    public Properties getRemoteFileSystemProperties() {
        if (fileSystemProperties == null) {
            fileSystemProperties = new Properties();
        }
        fileSystemProperties.put("file.separator", this.getFileSeparator());
        fileSystemProperties.put("path.separator", this.getPathSeparator());
        if (this.getWASHome() != null) {
            fileSystemProperties.put("server.root", this.getWASHome());
        }
        return fileSystemProperties;
    }

    public Boolean exists(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists", string);
        }
        string = this.expand(string);
        File file = new File(string);
        boolean bl = file.exists();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists", string);
        }
        return new Boolean(bl);
    }

    public Boolean rename(String string, String string2) {
        throw new UnsupportedOperationException("FileBrowser MBean rename method is not supported!");
    }

    public synchronized RemoteFile[] listRoots() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listRoots");
        }
        File[] fileArray = File.listRoots();
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(fileArray.length);
        RemoteFile remoteFile = null;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                remoteFile = this.getFileProperties(fileArray[i]);
                if (remoteFile == null) continue;
                arrayList.add(remoteFile);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.fileservice.FileBrowserImpl.listRoots", "213", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception trying to get file properties");
            }
        }
        RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
        arrayList.toArray(remoteFileArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listRoots", remoteFileArray);
        }
        return remoteFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] listRemoteFiles(String string) throws FileServiceException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listRemoteFiles", " Dir : " + string);
            }
            string = this.expand(string);
            RemoteFile[] remoteFileArray = null;
            File file = new File(string);
            Vector<File> vector = new Vector<File>();
            if (!file.exists()) {
                throw new FileServiceException("Directory " + file + " does not exist");
            }
            boolean bl = this.canShowFilesForThisDir(string);
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "listRemotrFiles: " + string + " is a child of " + this.getWASHome());
                }
                RemoteFile[] remoteFileArray2 = null;
                return remoteFileArray2;
            }
            File[] fileArray = file.listFiles();
            int n = fileArray == null ? 0 : fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                if (!file2.isFile() && !file2.isDirectory() || file2.isHidden()) continue;
                vector.addElement(file2);
            }
            RemoteFile[] remoteFileArray3 = remoteFileArray = this.filesToRemoteFileArray(vector);
            return remoteFileArray3;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listRemoteFiles");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteFile getRemoteFileProperties(String string, String string2) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteFileProperties1", string + File.separator + string2);
        }
        string = this.expand(string);
        string2 = this.expand(string2);
        RemoteFile remoteFile2 = null;
        try {
            File file = new File(string, string2);
            if (file.exists()) {
                remoteFile2 = this.getFileProperties(file);
            }
            remoteFile = remoteFile2;
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRemoteFileProperties1", remoteFile2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteFileProperties1", remoteFile2);
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RemoteFile getRemoteFileProperties(String string) throws FileServiceException {
        RemoteFile remoteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteFileProperties2", string);
        }
        string = this.expand(string);
        RemoteFile remoteFile2 = null;
        try {
            string = string.equals("HOME_DIR") ? System.getProperty("user.home") : string;
            File file = new File(string);
            if (file.exists()) {
                remoteFile2 = this.getFileProperties(file);
            }
            remoteFile = remoteFile2;
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRemoteFileProperties2", remoteFile2);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteFileProperties2", remoteFile2);
        }
        return remoteFile;
    }

    private RemoteFile getFileProperties(File file) throws FileServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileProperties", file);
        }
        if (file.getPath().equals("A:\\") || file.getPath().equals("B:\\")) {
            throw new FileServiceException(file.getPath() + " is not a valid selection.");
        }
        try {
            RemoteFile remoteFile = new RemoteFile();
            remoteFile.setName(file.getName());
            remoteFile.setAbsolutePath(file.getAbsolutePath());
            if (file.isDirectory()) {
                remoteFile.setType("Directory");
            } else {
                remoteFile.setType("NormalFile");
            }
            String string = file.getParent();
            if (string != null) {
                remoteFile.setParentDirectory(string);
            }
            remoteFile.setSeparator(File.separator);
            RemoteFile remoteFile2 = remoteFile;
            return remoteFile2;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.fileservice.FileBrowserImpl.getFileProperties", "383", this);
            Tr.service(tc, "ADFS0104", new Object[]{exception.getMessage()});
            throw new FileServiceException(exception, "");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFileProperties:");
            }
        }
    }

    private RemoteFile[] filesToRemoteFileArray(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filesToRemoteFileArray", vector);
        }
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            try {
                arrayList.add(this.getFileProperties((File)vector.elementAt(i)));
                continue;
            }
            catch (FileServiceException fileServiceException) {
                FFDCFilter.processException((Throwable)fileServiceException, "com.ibm.ws.management.fileservice.FileBrowserImpl.filesToRemoteFileArray", "411", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception: ", fileServiceException);
            }
        }
        RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
        arrayList.toArray(remoteFileArray);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filesToRemoteFileArray", remoteFileArray);
        }
        return remoteFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileLength(String string) throws FileServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileLength", string);
        }
        try {
            long l;
            string = this.expand(string);
            File file = new File(string);
            if (!file.exists()) {
                throw new FileServiceException(new FileNotFoundException(string), string + " not found.");
            }
            long l2 = l = file.length();
            return l2;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLineCount");
            }
        }
    }

    public long getLineCount(String string) throws FileServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLineCount", string);
        }
        string = this.expand(string);
        BufferedReader bufferedReader = null;
        String string2 = null;
        long l = 0L;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                ++l;
                string2 = bufferedReader.readLine();
            }
            long l2 = l;
            return l2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getLineCount failed", exception);
            }
            throw new FileServiceException(exception, "getLineCount failed with an exception");
        }
        finally {
            block14: {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "error closing input file", iOException);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLineCount");
            }
        }
    }

    public long[] translateLineNumbersToOffsets(String string, long[] lArray) throws FileServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertLineNumbersToBytes", string);
        }
        if (lArray == null || lArray.length == 0) {
            throw new FileServiceException("lineNumbers array is empty");
        }
        int n = 0;
        for (n = 0; n < lArray.length - 1; ++n) {
            if (lArray[n] <= lArray[n + 1]) continue;
            throw new FileServiceException("The lineNumbers input are not ascending");
        }
        string = this.expand(string);
        String string2 = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long[] lArray2 = new long[lArray.length];
        n = 0;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            string2 = randomAccessFile.readLine();
            for (n = 0; n < lArray.length && (lArray[n] == 0L || lArray[n] == 1L); ++n) {
                lArray2[n] = 0L;
            }
            while (string2 != null && n < lArray.length) {
                if (lArray[n] == ++l + 1L) {
                    lArray2[n] = randomAccessFile.getFilePointer();
                    if (++n < lArray.length && lArray[n] == lArray[n - 1]) {
                        lArray2[n] = lArray2[n - 1];
                        ++n;
                    }
                }
                string2 = randomAccessFile.readLine();
            }
            while (n < lArray.length) {
                lArray2[n] = randomAccessFile.length();
                ++n;
            }
            randomAccessFile.close();
            long[] lArray3 = lArray2;
            return lArray3;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "convertLineNumbersToBytes failed", exception);
            }
            throw new FileServiceException(exception, "convertLineNumbersToBytes failed with an exception");
        }
        finally {
            block20: {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "error closing input file", iOException);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLineCount");
            }
        }
    }

    public String getName() {
        return "FileBrowser";
    }

    private String expand(String string) {
        if (this.vMap != null) {
            string = this.vMap.expand(string);
        }
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        return string;
    }

    private boolean canShowFilesForThisDir(String string) throws FileServiceException {
        String string2;
        String string3 = this.getRepositoryRoot().replace('\\', '/');
        String string4 = string.toLowerCase().replace('\\', '/');
        if (string4.startsWith(string2 = string3.toLowerCase())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot show files in " + string + " because it points into " + string3);
            }
            return false;
        }
        return true;
    }

    private String getRepositoryRoot() throws FileServiceException {
        String string = null;
        try {
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            Properties properties = configRepository.getConfig();
            string = properties.getProperty("was.repository.root");
            if (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.fileservice.FileBrowserImpl.getRepositoryRoot", "138", this);
            throw new FileServiceException(exception, "Unable to get repository temporary directory.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The repository root=[" + string + "]");
        }
        return string;
    }
}

