/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.fileservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.fileservice.FileBrowserImpl;
import com.ibm.ws.runtime.service.VariableMap;

public class FileServiceFactory {
    private static TraceComponent tc = Tr.register(FileServiceFactory.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static FileBrowserImpl fs = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFileBrowserMBean(VariableMap variableMap) {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFileServiceMBean");
            }
            fs = new FileBrowserImpl(variableMap);
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(fs);
            AdminService adminService = AdminServiceFactory.getAdminService();
            adminService.getMBeanFactory().activateMBean("FileBrowser", defaultRuntimeCollaborator, fs.getName(), null);
        }
        catch (AdminException adminException) {
            Object[] objectArray = new Object[]{fs.getName()};
            Tr.warning(tc, "ADFS0100", objectArray);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createFileBrowserMBean");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deactivateFileBrowserMBean() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivateFileServiceMBean");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            adminService.getMBeanFactory().deactivateMBean("FileBrowser");
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{"FileBrowser", exception};
            Tr.service(tc, "ADFS0101", objectArray);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deactivateFileServiceMBean");
            }
        }
    }
}

