/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.fileservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.server.FileTransferServer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.util.ImplFactory;
import java.util.Properties;
import javax.management.ObjectName;

public class FileTransferFactory {
    private static TraceComponent tc = Tr.register(FileTransferFactory.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static ObjectName fileTransferObjectName = null;
    private static FileTransferConfig ftsConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(FileTransferConfig fileTransferConfig) {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", fileTransferConfig);
            }
            ftsConfig = fileTransferConfig;
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (string.equals("NodeAgent")) {
                FileTransferFactory.createFileTransferClientMBean();
            } else if (string.equals("DeploymentManager") || string.equals("UnManagedProcess")) {
                FileTransferFactory.createFileTransferServerMBean();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.fileservice.FileTransferFactory.initialize", "104");
            Tr.error(tc, "ADFS0102", exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    public static FileTransferClient getFileTransferClient(FileTransferConfig fileTransferConfig) throws AdminException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeFileTransferClient");
            }
            ftsConfig = fileTransferConfig;
            FileTransferClient fileTransferClient = (FileTransferClient)ImplFactory.loadImplFromKey(FileTransferClient.class);
            fileTransferClient.initialize(ftsConfig);
            FileTransferClient fileTransferClient2 = fileTransferClient;
            return fileTransferClient2;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.fileservice.FileTransferFactory.getFileTransferClient", "172");
            Tr.service(tc, "ADFS0102", exception);
            throw new AdminException(exception, "Error Creating FileTransferClient");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    public static FileTransferClient getFileTransferClient(AdminClient adminClient) throws AdminException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFileTransferClient");
            }
            FileTransferClient fileTransferClient = (FileTransferClient)ImplFactory.loadImplFromKey(FileTransferClient.class);
            fileTransferClient.initialize(adminClient);
            FileTransferClient fileTransferClient2 = fileTransferClient;
            return fileTransferClient2;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.fileservice.FileTransferFactory.getFileTransferClient", "158");
            Tr.service(tc, "ADFS0102", exception);
            throw new AdminException(exception, "Error Creating FileTransferClient");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    private static void createFileTransferServerMBean() throws AdminException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFileTransferServerMBean");
            }
            FileTransferServer fileTransferServer = (FileTransferServer)ImplFactory.loadImplFromKey(FileTransferServer.class);
            fileTransferServer.startServer(ftsConfig);
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(fileTransferServer);
            AdminService adminService = AdminServiceFactory.getAdminService();
            fileTransferObjectName = adminService.getMBeanFactory().activateMBean("FileTransferServer", defaultRuntimeCollaborator, "FileTransferServer", null);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException(adminException, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferServerMBean", "218");
            Object[] objectArray = new Object[]{"FileTransferServer"};
            Tr.service(tc, "ADFS0100", objectArray);
            throw adminException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferServerMBean", "225");
            Tr.service(tc, "ADFS0105", exception);
            throw new AdminException(exception, "The file transfer server can not be created");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createFileTransferServerMBean");
            }
        }
    }

    private static void createFileTransferClientMBean() throws AdminException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFileTransferClientMBean");
            }
            FileTransferClient fileTransferClient = FileTransferFactory.getFileTransferClient(ftsConfig);
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(fileTransferClient);
            AdminService adminService = AdminServiceFactory.getAdminService();
            fileTransferObjectName = adminService.getMBeanFactory().activateMBean("FileTransferClient", defaultRuntimeCollaborator, "FileTransferClient", null);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException(adminException, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferClientMBean", "254");
            Object[] objectArray = new Object[]{"FileTransferClient"};
            Tr.service(tc, "ADFS0100", objectArray);
            throw adminException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferClientMBean", "261");
            Tr.service(tc, "ADFS0105", exception);
            throw new AdminException(exception, "The file transfer client can not be created");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createFileTransferClientMBean");
            }
        }
    }

    public static void uninitialize() {
        FileTransferFactory.deactivateFileTransferMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deactivateFileTransferMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivateFileTransferMBean");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            adminService.getMBeanFactory().deactivateMBean("FileTransferClient");
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.fileservice.FileTransferFactory.deactivateFileTransferMBean", "293");
            Object[] objectArray = new Object[]{"FileTransferClient", exception};
            Tr.service(tc, "ADFS0101", objectArray);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deactivateFileTransferMBean");
            }
        }
    }

    public static ObjectName getFileTransferObjectName() {
        return fileTransferObjectName;
    }

    public static FileTransferConfig getFileTransferServiceConfig() {
        return ftsConfig;
    }

    public static Properties getFileTransferProperties() {
        return ftsConfig.getProperties();
    }
}

