/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.filetransfer.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.filetransfer.server.FileTransferServer;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import java.util.Properties;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class FileTransferServerImpl
implements FileTransferServer {
    private static TraceComponent tc = Tr.register(FileTransferServerImpl.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static FileTransferServerImpl ftServer = null;
    private FileTransferConfig ftsConfig = null;
    private VariableMap vmap = null;
    public static final String REPROOT = "${REPROOT}";

    public FileTransferServerImpl() {
        ftServer = this;
    }

    public void startServer(FileTransferConfig fileTransferConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer", fileTransferConfig);
        }
        this.ftsConfig = fileTransferConfig;
        if (fileTransferConfig == null) {
            this.ftsConfig = new FileTransferConfigImpl();
            this.ftsConfig.setProperties(new Properties());
        }
        if (fileTransferConfig.getVariableMap() != null) {
            this.vmap = (VariableMap)fileTransferConfig.getVariableMap();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
    }

    public void stopServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopServer");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer");
        }
    }

    public void send(String string, String string2, String string3) throws TransferFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{string, string2, string3});
        }
        Object[] objectArray = new Object[]{string2, new File(REPROOT + File.separator + string3)};
        String[] stringArray = new String[]{"java.lang.String", "java.io.File"};
        this.send(string, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    public void send(String string, String string2, String string3, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{string, string2, string3, fileTransferOptions});
        }
        Object[] objectArray = new Object[]{string2, new File(REPROOT + File.separator + string3), fileTransferOptions};
        String[] stringArray = new String[]{"java.lang.String", "java.io.File", "com.ibm.websphere.management.filetransfer.client.FileTransferOptions"};
        this.send(string, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    public void send(String string, String string2, String string3, long l) throws TransferFailedException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{string, string2, string3, new Long(l)});
        }
        Object[] objectArray = new Object[]{string2, new File(REPROOT + File.separator + string3), new Long(l)};
        String[] stringArray = new String[]{"java.lang.String", "java.io.File", "long"};
        this.send(string, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    public void send(String string, String string2, String string3, long l, long l2) throws TransferFailedException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{string, string2, string3, new Long(l), new Long(l2)});
        }
        Object[] objectArray = new Object[]{string2, new File(REPROOT + File.separator + string3), new Long(l), new Long(l2)};
        String[] stringArray = new String[]{"java.lang.String", "java.io.File", "long", "long"};
        this.send(string, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    public void send(String string, String string2, String string3, long l, FileTransferOptions fileTransferOptions) throws TransferFailedException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{string, string2, string3, new Long(l), fileTransferOptions});
        }
        Object[] objectArray = new Object[]{string2, new File(REPROOT + File.separator + string3), new Long(l), fileTransferOptions};
        String[] stringArray = new String[]{"java.lang.String", "java.io.File", "long", "com.ibm.websphere.management.filetransfer.client.FileTransferOptions"};
        this.send(string, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    public void send(String string, String string2, String string3, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send", new Object[]{string, string2, string3, new Long(l), new Long(l2), fileTransferOptions});
        }
        Object[] objectArray = new Object[]{string2, new File(REPROOT + File.separator + string3), new Long(l), new Long(l2), fileTransferOptions};
        String[] stringArray = new String[]{"java.lang.String", "java.io.File", "long", "long", "com.ibm.websphere.management.filetransfer.client.FileTransferOptions"};
        this.send(string, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    private void send(String string, Object[] objectArray, String[] stringArray) throws TransferFailedException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send");
        }
        String string2 = (String)objectArray[0];
        ObjectName objectName = null;
        if (!this.checkAccess(string2)) {
            throw new TransferFailedException("Access denied");
        }
        try {
            ObjectName objectName2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(AdminServiceFactory.getAdminService().getDomainName());
            stringBuffer.append(":");
            stringBuffer.append("name=FileTransferClient");
            stringBuffer.append(",type=FileTransferClient");
            stringBuffer.append(",node=");
            stringBuffer.append(string);
            stringBuffer.append(",*");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "FileTransferClient MBean name: " + stringBuffer.toString());
            }
            if ((objectName2 = this.getMBeanReference(objectName = new ObjectName(stringBuffer.toString()))) != null) {
                AdminServiceFactory.getAdminService().invoke(objectName2, "downloadFile", objectArray, stringArray);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Tr.service(tc, "ADFS0122", new Object[]{objectName, malformedObjectNameException});
            throw new TransferFailedException("Bad object name: " + objectName, malformedObjectNameException);
        }
        catch (JMException jMException) {
            Tr.service(tc, "ADFS0123", new Object[]{string, jMException});
            throw new TransferFailedException("File Transfer Failed.", jMException);
        }
        catch (Exception exception) {
            Tr.service(tc, "ADFS0123", new Object[]{string, exception});
            throw new TransferFailedException("File Transfer Failed.", exception);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "send");
            }
        }
    }

    public void setServerConfig(FileTransferConfig fileTransferConfig) {
        this.ftsConfig = fileTransferConfig;
    }

    public FileTransferConfig getServerConfig() {
        return this.ftsConfig;
    }

    public static FileTransferServerImpl getInstance() {
        if (ftServer == null) {
            FileTransferServerImpl.createSingleton();
        }
        return ftServer;
    }

    private static synchronized FileTransferServerImpl createSingleton() {
        if (ftServer == null) {
            ftServer = new FileTransferServerImpl();
        }
        return ftServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName getMBeanReference(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanReference");
        }
        ObjectName objectName2 = null;
        try {
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            if (set == null || set.size() == 0) {
                Tr.service(tc, "ADFS0120", new Object[]{objectName});
            } else {
                objectName2 = (ObjectName)set.iterator().next();
                if (set.size() > 0 && tc.isDebugEnabled()) {
                    Tr.debug(tc, "More than one MBean is found for name=" + objectName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found an mbean " + objectName2);
                }
            }
        }
        catch (Exception exception) {
            Tr.service(tc, "ADFS0121", new Object[]{objectName, exception});
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMBeanReference");
            }
        }
        return objectName2;
    }

    private String mapVariables(String string) {
        if (this.vmap != null && string != null) {
            string = this.vmap.expand(string);
        }
        return string;
    }

    private File fixDestFile(String string) {
        if (!string.startsWith("$")) {
            string = REPROOT + File.separator + string;
        }
        return new File(string);
    }

    public String getName() {
        return "FileTransferServer";
    }

    private boolean checkAccess(String string) {
        String string2 = "monitor";
        AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (adminAuthorizer != null) {
            return adminAuthorizer.checkAccess(string, string2);
        }
        return true;
    }
}

