/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.launcher.LaunchPlatformHelper;
import com.ibm.ws.management.tools.LaunchUtils;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultLaunchPlatformHelper
implements LaunchPlatformHelper {
    private static TraceComponent tc = Tr.register(DefaultLaunchPlatformHelper.class, "Launcher", "com.ibm.ws.management.resources.launcher");
    private Properties defaultSettings = null;
    private static final String[] KEYS = new String[]{"com.ibm.websphere.management.launcher.defaultExecutableName", "com.ibm.websphere.management.launcher.defaultMinHeapSize", "com.ibm.websphere.management.launcher.defaultMaxHeapSize", "com.ibm.websphere.management.launcher.developmentMode"};

    public DefaultLaunchPlatformHelper() throws Exception {
        try {
            String string;
            String string2;
            this.defaultSettings = new Properties();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = DefaultLaunchPlatformHelper.class.getClassLoader();
            }
            if ((string2 = System.getProperty("os.name").toLowerCase()).startsWith("hp")) {
                string2 = string2.substring(0, 2);
                string = System.getProperty("os.arch");
                if (string.startsWith("IA64")) {
                    string2 = string2 + "IA64";
                }
            } else if (string2.startsWith("sun")) {
                string2 = string2.substring(0, 3);
                string = System.getProperty("os.arch");
                if (string.startsWith("x86") || string.startsWith("amd64")) {
                    string2 = string2 + "x64";
                } else if (string.startsWith("sparcv9")) {
                    string2 = string2 + "sparc64";
                }
            } else if (string2.equalsIgnoreCase("OS/400")) {
                string2 = System.getProperty("os400.use.j9", "false").equals("true") ? "os400j9" : "os400";
            } else if (string2.startsWith("lin")) {
                string2 = System.getProperty("linux.use.wrt", "false").equals("true") ? "linwrt" : "lin";
            } else if (string2.length() > 3) {
                string2 = string2.substring(0, 3);
            }
            string = "properties/systemlaunch.properties";
            String string3 = "properties/" + string2 + ".systemlaunch.properties";
            InputStream inputStream = classLoader.getResourceAsStream(string);
            this.defaultSettings.load(inputStream);
            inputStream = classLoader.getResourceAsStream(string3);
            if (inputStream != null) {
                this.defaultSettings.load(inputStream);
            }
            for (int i = 0; i < KEYS.length; ++i) {
                if (this.defaultSettings.getProperty(KEYS[i]) == null) continue;
                System.setProperty(KEYS[i], this.defaultSettings.getProperty(KEYS[i]));
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADML3000E", throwable);
        }
    }

    public Vector getDefaultBootclasspath(boolean bl) throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = null;
        if (bl) {
            string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.debugJar");
            if (string != null) {
                vector.add(string);
            } else {
                Tr.info(tc, "ADML3001W", new Object[]{"debugJar"});
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"debugJar"}, null));
            }
        }
        if ((string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.orbBootstrapJar")) == null) {
            Tr.info(tc, "ADML3001W", new Object[]{"orbBootstrapJar"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"orbBootstrapJar"}, null));
        }
        vector.add(string);
        string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.extBootstrapJar");
        if (string == null) {
            Tr.info(tc, "ADML3001W", new Object[]{"extBootstrapJar"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"extBootstrapJar"}, null));
        }
        vector.add(string);
        return vector;
    }

    public Vector getDefaultClasspath() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultClasspath");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreElements()) {
                vector.add(stringTokenizer.nextToken());
            }
        } else {
            Tr.info(tc, "ADML3001W", new Object[]{"defaultClasspath"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"defaultClasspath"}, null));
        }
        return vector;
    }

    public Properties getDefaultEnvironment() throws Exception {
        Properties properties = new Properties();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultEnvironment");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.substring(0, string2.indexOf("="));
                String string4 = string2.substring(string2.indexOf("=") + 1, string2.length());
                properties.put(string3, string4);
            }
        } else {
            Tr.info(tc, "ADML3001W", new Object[]{"defaultEnvironment"});
        }
        return properties;
    }

    public Vector getDisableJitc(boolean bl, String string) {
        Vector<String> vector = new Vector<String>();
        vector.add("-Djava.compiler=NONE");
        if (string.equals("HOTSPOT")) {
            if (!bl && System.getProperty("os.name").toLowerCase().startsWith("sun")) {
                vector.add("-Xint");
            }
        } else if (System.getProperty("os.name").toLowerCase().startsWith("hp")) {
            vector.add("-Xnojit");
        }
        return vector;
    }

    public Properties getDefaultSystemProperties() throws Exception {
        Properties properties = new Properties();
        Enumeration<Object> enumeration = this.defaultSettings.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("com.ibm.websphere.management.launcher.")) continue;
            properties.put(string, this.defaultSettings.getProperty(string));
        }
        return properties;
    }

    public Vector getDefaultWsExtDirs() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultWsExtDirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreElements()) {
                vector.add(stringTokenizer.nextToken());
            }
        } else {
            Tr.info(tc, "ADML3001W", new Object[]{"defaultWsExtDirs"});
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML3001W", new Object[]{"defaultWsExtDirs"}, null));
        }
        return vector;
    }

    public Vector getDefaultJVMOptions() {
        Vector<String> vector = new Vector<String>();
        String string = this.defaultSettings.getProperty("com.ibm.websphere.management.launcher.defaultJvmOptions");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreElements()) {
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }
}

