/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.NoServerDefinedException;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ExecutableTargetKind;
import com.ibm.websphere.models.config.processexec.InternalClassAccessMode;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.processexec.OutputRedirect;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.processexec.ProcessExecution;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.LaunchBinaryScriptWriter;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.management.launcher.LaunchPlatformHelper;
import com.ibm.ws.management.launcher.LaunchScriptWriter;
import com.ibm.ws.management.launcher.ProcessLauncher;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.process.Process;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class LaunchCommand {
    private static TraceComponent tc = Tr.register(LaunchCommand.class, "Launcher", "com.ibm.ws.management.resources.launcher");
    private static boolean debug = false;
    private Repository respository = null;
    private LaunchParams params = null;
    private VariableMap vars = null;
    private ServerIdentifiers serverId = null;
    private LaunchPlatformHelper platform = null;
    private boolean debugMode = false;
    private boolean zOS = false;
    private Vector gatheredClasspath = new Vector();
    private Vector gatheredBootclasspath = new Vector();
    private Vector gatheredWsExtDirs = new Vector();
    private Vector gatheredMiscCommandLineArgs = new Vector();
    private Properties gatheredSecurityProperties = new Properties();
    private Vector gatheredJavaLibPath = new Vector();
    private static final String DEF_EXECNAME_PROP = "com.ibm.websphere.management.launcher.defaultExecutableName";
    private static final String DEF_MINHEAPSIZE_PROP = "com.ibm.websphere.management.launcher.defaultMinHeapSize";
    private static final String DEF_MAXHEAPSIZE_PROP = "com.ibm.websphere.management.launcher.defaultMaxHeapSize";
    private static final String JAVA2_SECURITY_PROP = "enableJava2Security";
    private static final String SECURITY_POLICY_PROP = "java.security.policy";
    private static final String SECURITY_AUTH_LOGIN_PROP = "java.security.auth.login.config";
    private static final String WSLAUNCHER_CLASS = "com.ibm.ws.bootstrap.WSLauncher";
    private static final String WSSERVER_CLASS = "com.ibm.ws.runtime.WsServer";
    private boolean devOption = false;
    protected static final String DEF_DEVELOPMENT_MODE = "com.ibm.websphere.management.launcher.developmentMode";
    private boolean developmentMode = false;
    private HashMap cleanedArguments = new HashMap(10);

    public LaunchCommand(Repository repository2, VariableMap variableMap, ServerIdentifiers serverIdentifiers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        ProcessDef processDef = null;
        this.respository = repository2;
        this.serverId = serverIdentifiers;
        this.vars = variableMap;
        try {
            this.platform = (LaunchPlatformHelper)ImplFactory.loadImplFromKey("com.ibm.ws.management.launcher.LaunchPlatformHelper");
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable);
        }
        Resource resource = null;
        try {
            resource = repository2.getConfigRoot().getResource(4, "server.xml");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NoServerDefinedException(serverIdentifiers.getServerName());
        }
        Server server2 = this.getServer(resource);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server2);
        }
        if (!server2.getName().equals(serverIdentifiers.getServerName())) {
            throw new NoServerDefinedException(serverIdentifiers.getServerName());
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zOS = true;
        }
        EList eList = server2.getProcessDefinitions();
        int n = eList.size();
        String string = null;
        for (int i = 0; i < n; ++i) {
            processDef = (ProcessDef)eList.get(i);
            string = processDef.getProcessType();
            if (this.zOS ? string != null && string.equalsIgnoreCase("Control") : string != null && string.equalsIgnoreCase("Distributed")) break;
        }
        if (processDef == null) {
            processDef = server2.getProcessDefinition();
        }
        if (processDef == null) {
            throw new AdminException("new message: config bad - invalid process data");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ProcessDef: " + processDef);
        }
        this.params = new LaunchParams();
        this.params.setServerIds(this.serverId);
        this.setParamsFromServer(server2);
        this.setParamsFromProcessDef(processDef);
        if (this.zOS) {
            ServerEntry serverEntry = this.getServerEntry(this.respository, serverIdentifiers.getServerName());
            this.processShortNames(server2, serverEntry);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor", this.params);
        }
    }

    public Process launchProcess() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "launching process with parameters: " + this.params.toString());
        }
        ProcessLauncher processLauncher = new ProcessLauncher(this.params);
        Process process = processLauncher.launch();
        return process;
    }

    public Vector getLaunchCommand() throws Exception {
        Vector vector = null;
        vector = this.params.getCommandLineArguments();
        if (this.params.getJvmModeString().length() > 0) {
            vector.add(0, this.params.getJvmModeString());
        }
        vector.add(0, this.params.getExecutableName());
        return (Vector)vector.clone();
    }

    public LaunchParams getLaunchParams() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLaunchParams");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLaunchParams", this.params);
        }
        return this.params;
    }

    public void createLaunchScript(String string, String string2, boolean bl) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writing script with parameters: " + this.params.toString());
        }
        this.params.setDevOption(this.devOption);
        LaunchScriptWriter launchScriptWriter = new LaunchScriptWriter(this.params);
        launchScriptWriter.writeScript(string, string2, bl);
    }

    public void createBinaryData(String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writing script with parameters: " + this.params.toString());
        }
        LaunchBinaryScriptWriter launchBinaryScriptWriter = new LaunchBinaryScriptWriter(this.params);
        launchBinaryScriptWriter.writeScript(string);
    }

    private Server getServer(Resource resource) throws Exception {
        Server server2 = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof Server)) continue;
            server2 = (Server)e2;
        }
        return server2;
    }

    private Cell getCell(Resource resource) throws Exception {
        Cell cell = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof Cell)) continue;
            cell = (Cell)e2;
        }
        return cell;
    }

    private void setParamsFromProcessDef(ProcessDef processDef) throws Exception {
        String string;
        String string2;
        OutputRedirect outputRedirect;
        boolean bl = true;
        boolean bl2 = false;
        if (this.zOS) {
            this.process390Commands(processDef);
        }
        String string3 = System.getProperty(DEF_EXECNAME_PROP);
        String string4 = null;
        if (!this.zOS && processDef.getStartCommand() != null && processDef.getStartCommand().length() > 0) {
            string4 = this.expand(processDef.getStartCommand());
        } else if (processDef.getExecutableName() != null) {
            string4 = this.expand(processDef.getExecutableName());
        }
        if (string4 != null) {
            this.params.setExecutableName(string4);
            if (string4.indexOf("java") < 0) {
                bl = false;
            }
            if (this.isGenericServer(processDef)) {
                bl2 = true;
            }
        } else if (string3 != null) {
            this.params.setExecutableName(this.expand(string3));
        }
        this.params.setCommandLineArguments(new Vector());
        this.params.setEnvironment(this.createEnvironment(processDef));
        this.params.setWorkingDirectory(this.expand(processDef.getWorkingDirectory()));
        ProcessExecution processExecution = processDef.getExecution();
        this.params.setUserId(this.expand(processExecution.getRunAsUser()));
        this.params.setGroupId(this.expand(processExecution.getRunAsGroup()));
        this.params.setProcessPriority(processExecution.getProcessPriority());
        String string5 = processExecution.getUmask();
        if (string5 != null && string5.length() > 0) {
            try {
                int n = Integer.parseInt(string5, 8);
                this.params.setUmask(n);
            }
            catch (NumberFormatException numberFormatException) {
                Tr.service(tc, "ADML0003E", string5);
            }
        }
        if ((outputRedirect = processDef.getIoRedirect()) != null) {
            String string6;
            string2 = outputRedirect.getStdinFilename();
            if (string2 != null) {
                string2 = this.expand(string2);
                this.createParentDir(string2);
            }
            if ((string = outputRedirect.getStderrFilename()) != null) {
                string = this.expand(string);
                this.createParentDir(string);
            }
            if ((string6 = outputRedirect.getStdoutFilename()) != null) {
                string6 = this.expand(string6);
                this.createParentDir(string6);
            }
            this.params.setStdinFileName(string2);
            this.params.setStderrFileName(string);
            this.params.setStdoutFileName(string6);
        }
        string2 = processDef.getMonitoringPolicy();
        if (processDef instanceof JavaProcessDef && bl) {
            string = (JavaProcessDef)processDef;
            if (bl2) {
                this.setGenericServerParamsFromJavaProcessDef((JavaProcessDef)string);
            } else {
                this.setParamsFromJavaProcessDef((JavaProcessDef)string);
            }
        }
        string = null;
        if (!this.zOS) {
            string = processDef.getStartCommandArgs();
        }
        if (string == null || string.size() == 0) {
            string = processDef.getExecutableArguments();
        }
        for (int i = 0; i < string.size(); ++i) {
            this.params.getCommandLineArguments().add(this.expand((String)string.get(i)));
        }
    }

    private boolean isGenericServer(ProcessDef processDef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenericServer");
        }
        boolean bl = false;
        String string = processDef.getExecutableName();
        if (string != null) {
            JavaProcessDef javaProcessDef;
            String string2;
            if ((string = string.trim()).indexOf("java") < 0) {
                return true;
            }
            if (processDef instanceof JavaProcessDef && (string2 = (javaProcessDef = (JavaProcessDef)processDef).getExecutableTarget()) != null && !string2.equals(WSSERVER_CLASS)) {
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGenericServer");
        }
        return bl;
    }

    private void processCommandLineArguments(String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "argsString: " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cltoken: " + string3);
            }
            if (string3.equals(" ")) continue;
            while (string3.startsWith("\"") && (!string3.endsWith("\"") || string3.length() == 1) && stringTokenizer.hasMoreTokens()) {
                string3 = string3 + stringTokenizer.nextToken();
            }
            if (string3.startsWith("\"") && !string3.endsWith("\"")) {
                throw new AdminException("Incomplete genericJvmArgument: need closing quotes in " + string3);
            }
            if (string3.startsWith("\"") && string3.endsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cltoken now: " + string3);
            }
            if (string3.equals("-classpath") || string3.equals("-cp")) {
                string2 = stringTokenizer.nextToken();
                while (string2.equals(" ")) {
                    string2 = stringTokenizer.nextToken();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nxttoken: " + string2);
                }
                this.gatheredClasspath.add(string2);
                continue;
            }
            if (string3.startsWith("-classpath") || string3.startsWith("-cp")) {
                string2 = null;
                string2 = string3.startsWith("-classpath") ? string3.substring("-classpath".length()).trim() : string3.substring("-cp".length()).trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nxttoken: " + string2);
                }
                this.gatheredClasspath.add(string2);
                continue;
            }
            if (string3.startsWith("-Djava.library.path")) {
                this.gatheredJavaLibPath.add(string3.substring(string3.lastIndexOf("=") + 1));
                continue;
            }
            if (string3.startsWith("-Xbootclasspath")) {
                this.gatheredBootclasspath.add(string3.substring(string3.indexOf(":") + 1));
                continue;
            }
            if (string3.startsWith("-Dws.ext.dirs")) {
                this.gatheredWsExtDirs.add(string3.substring(string3.lastIndexOf("=") + 1));
                continue;
            }
            if (string3.startsWith("-DenableJava2Security")) {
                string2 = this.expand(string3.substring(string3.lastIndexOf("=") + 1));
                this.gatheredSecurityProperties.setProperty(JAVA2_SECURITY_PROP, string2);
                continue;
            }
            if (string3.startsWith("-Djava.security.policy")) {
                string2 = this.expand(string3.substring(string3.lastIndexOf("=") + 1));
                this.gatheredSecurityProperties.setProperty(SECURITY_POLICY_PROP, string2);
                continue;
            }
            if (string3.startsWith("-Djava.security.auth.login.config")) {
                string2 = this.expand(string3.substring(string3.lastIndexOf("=") + 1));
                this.gatheredSecurityProperties.setProperty(SECURITY_AUTH_LOGIN_PROP, string2);
                continue;
            }
            if (string3.equals("-server") || string3.equals("-client")) {
                this.params.setJvmMode("HOTSPOT");
                this.params.setJvmModeString(string3);
                this.params.getCommandLineArguments().add(0, string3);
                continue;
            }
            if (string3.equals("-classic")) {
                this.params.setJvmMode("CLASSIC");
                this.params.setJvmModeString(string3);
                this.params.getCommandLineArguments().add(0, string3);
                continue;
            }
            this.gatheredMiscCommandLineArgs.add(this.expand(string3));
        }
    }

    private void processSystemProperty(String string) {
        if (string.startsWith("-Dws.ext.dirs")) {
            this.gatheredWsExtDirs.add(string.substring(string.lastIndexOf("=") + 1));
        } else if (string.startsWith("-DenableJava2Security")) {
            String string2 = this.expand(string.substring(string.lastIndexOf("=") + 1));
            this.gatheredSecurityProperties.setProperty(JAVA2_SECURITY_PROP, string2);
        } else if (string.startsWith("-Djava.security.policy")) {
            String string3 = this.expand(string.substring(string.lastIndexOf("=") + 1));
            this.gatheredSecurityProperties.setProperty(SECURITY_POLICY_PROP, string3);
        } else if (string.startsWith("-Djava.security.auth.login.config")) {
            String string4 = this.expand(string.substring(string.lastIndexOf("=") + 1));
            this.gatheredSecurityProperties.setProperty(SECURITY_AUTH_LOGIN_PROP, string4);
        } else if (string.startsWith("-Djava.library.path")) {
            this.gatheredJavaLibPath.add(string.substring(string.lastIndexOf("=") + 1));
        } else {
            this.gatheredMiscCommandLineArgs.add(this.expand(string));
        }
    }

    private Vector createEnvironment(ProcessDef processDef) throws Exception {
        EList eList;
        Vector<String> vector = new Vector<String>();
        Properties properties = this.platform.getDefaultEnvironment();
        if (properties != null) {
            eList = properties.propertyNames();
            while (eList.hasMoreElements()) {
                String string = (String)eList.nextElement();
                if (string.equals("CLASSPATH")) {
                    this.gatheredClasspath.add(properties.getProperty(string));
                    continue;
                }
                vector.add(this.expand(string + "=" + properties.getProperty(string)));
            }
        }
        eList = processDef.getEnvironment();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            if (property.getName() == null || property.getValue() == null) continue;
            if (property.getName().equals("CLASSPATH")) {
                this.gatheredClasspath.add(property.getValue());
                continue;
            }
            vector.add(this.expand(property.getName() + "=" + property.getValue()));
        }
        return vector;
    }

    private void setParamsFromJavaProcessDef(JavaProcessDef javaProcessDef) throws Exception {
        int n;
        JavaVirtualMachine javaVirtualMachine = null;
        EList eList = javaProcessDef.getJvmEntries();
        String string = System.getProperty("os.name");
        for (n = 0; n < eList.size(); ++n) {
            JavaVirtualMachine javaVirtualMachine2 = (JavaVirtualMachine)eList.get(n);
            if (javaVirtualMachine2.getOsName() == null || !javaVirtualMachine2.getOsName().equalsIgnoreCase(string)) continue;
            javaVirtualMachine = javaVirtualMachine2;
            break;
        }
        if (javaVirtualMachine == null && eList.size() > 0) {
            javaVirtualMachine = (JavaVirtualMachine)eList.get(0);
            javaVirtualMachine.setOsName(string);
        }
        if (javaVirtualMachine != null) {
            this.processCellLevelCustomProp();
            this.processDefaultJvmOptions(javaVirtualMachine);
            this.processSystemProperties(javaVirtualMachine);
            if (javaVirtualMachine.getGenericJvmArguments() != null && javaVirtualMachine.getGenericJvmArguments().length() > 0) {
                this.processCommandLineArguments(javaVirtualMachine.getGenericJvmArguments());
            }
            this.processDebugAndJitSettings(javaVirtualMachine);
            this.processBootstrapClasspathInfo(javaVirtualMachine);
            this.processClasspathInfo(javaVirtualMachine);
            this.processInternalClassAccessMode(javaVirtualMachine);
            this.processMiscJVMSettings(javaVirtualMachine);
            this.processWsExtDirsInfo(javaVirtualMachine);
            this.processJavaLibraryPathInfo();
            if (this.gatheredMiscCommandLineArgs.size() > 0) {
                for (n = 0; n < this.gatheredMiscCommandLineArgs.size(); ++n) {
                    this.handleExtraneousArguments(this.expand((String)this.gatheredMiscCommandLineArgs.get(n)));
                }
            }
            this.processSecurityProperties();
        }
        this.processExecutionTargetInfo(javaProcessDef);
    }

    private void processCellLevelCustomProp() {
        Resource resource = null;
        try {
            resource = this.respository.getConfigRoot().getResource(0, "cell.xml");
            Cell cell = this.getCell(resource);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cell: " + cell);
            }
            if (cell != null) {
                ArrayList arrayList = new ArrayList(cell.getProperties());
                for (int i = 0; i < arrayList.size(); ++i) {
                    Property property = (Property)arrayList.get(i);
                    if (!property.getName().equals("com.ibm.websphere.management.launcher.options") || !property.getValue().equals("displayServerInFront")) continue;
                    String string = "-Dwas.launcher.server=" + this.serverId.getCellName() + ":" + this.serverId.getNodeName() + ":" + this.serverId.getServerName();
                    this.params.getCommandLineArguments().add(0, string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processDefaultJvmOptions(JavaVirtualMachine javaVirtualMachine) {
        Vector vector = this.platform.getDefaultJVMOptions();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.handleExtraneousArguments(this.expand((String)vector.get(i)));
            }
        }
    }

    private void processDebugAndJitSettings(JavaVirtualMachine javaVirtualMachine) {
        Object object;
        if (Boolean.getBoolean("com.ibm.ws.management.launcher.ignoreDebug")) {
            return;
        }
        if (javaVirtualMachine.isDebugMode()) {
            this.debugMode = true;
            this.params.getCommandLineArguments().add("-Dwas.debug.mode=true");
            if (javaVirtualMachine.getDebugArgs() != null && javaVirtualMachine.getDebugArgs().length() > 0) {
                object = new StringTokenizer(javaVirtualMachine.getDebugArgs());
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.params.getCommandLineArguments().add(this.expand(((StringTokenizer)object).nextToken()));
                }
            }
        }
        if (javaVirtualMachine.isDisableJIT() && (object = this.platform.getDisableJitc(this.debugMode, this.params.getJvmMode())) != null && ((Vector)object).size() > 0) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                this.params.getCommandLineArguments().add((String)((Vector)object).get(i));
            }
        }
    }

    private void processSystemProperties(JavaVirtualMachine javaVirtualMachine) throws Exception {
        EList eList;
        Properties properties = this.platform.getDefaultSystemProperties();
        if (properties != null) {
            eList = properties.propertyNames();
            while (eList.hasMoreElements()) {
                String string = (String)eList.nextElement();
                string = string.trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default system property: " + string + "=" + properties.getProperty(string));
                }
                this.processSystemProperty("-D" + string + "=" + properties.getProperty(string).trim());
            }
        }
        eList = javaVirtualMachine.getSystemProperties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            if (property.getName() == null || property.getValue() == null) continue;
            this.processSystemProperty("-D" + property.getName() + "=" + property.getValue());
        }
    }

    private void processClasspathInfo(JavaVirtualMachine javaVirtualMachine) throws Exception {
        int n;
        Vector vector = this.platform.getDefaultClasspath();
        String string = null;
        EList eList = javaVirtualMachine.getClasspath();
        for (n = 0; n < eList.size(); ++n) {
            string = (String)eList.get(n);
            if (string == null || string.length() <= 0) continue;
            vector.add(string);
        }
        if (this.gatheredClasspath.size() > 0) {
            for (n = 0; n < this.gatheredClasspath.size(); ++n) {
                vector.add((String)this.gatheredClasspath.get(n));
            }
        }
        if (vector.size() > 0) {
            string = (String)vector.get(0);
            for (n = 1; n < vector.size(); ++n) {
                string = string + File.pathSeparator + (String)vector.get(n);
            }
        }
        if (string != null) {
            this.params.getCommandLineArguments().add("-classpath");
            this.params.getCommandLineArguments().add(this.expand(string));
        }
    }

    private void processJavaLibraryPathInfo() throws Exception {
        String string = System.getProperty("java.library.path");
        if (this.gatheredJavaLibPath.size() > 0) {
            for (int i = 0; i < this.gatheredJavaLibPath.size(); ++i) {
                string = string + File.pathSeparator + (String)this.gatheredJavaLibPath.get(i);
            }
            string = "-Djava.library.path=" + string;
            this.gatheredMiscCommandLineArgs.add(this.expand(string));
        }
    }

    private void processBootstrapClasspathInfo(JavaVirtualMachine javaVirtualMachine) throws Exception {
        int n;
        Vector vector = this.platform.getDefaultBootclasspath(this.debugMode);
        String string = null;
        EList eList = javaVirtualMachine.getBootClasspath();
        for (n = 0; n < eList.size(); ++n) {
            string = (String)eList.get(n);
            if (string == null || string.length() <= 0) continue;
            vector.add(string);
        }
        if (this.gatheredBootclasspath.size() > 0) {
            for (n = 0; n < this.gatheredBootclasspath.size(); ++n) {
                vector.add((String)this.gatheredBootclasspath.get(n));
            }
        }
        if (vector.size() > 0) {
            string = (String)vector.get(0);
            for (n = 1; n < vector.size(); ++n) {
                string = string + File.pathSeparator + (String)vector.get(n);
            }
        }
        if (string != null) {
            this.params.getCommandLineArguments().add("-Xbootclasspath/p:" + this.expand(string));
        }
    }

    private void processWsExtDirsInfo(JavaVirtualMachine javaVirtualMachine) throws Exception {
        int n;
        Vector vector = this.platform.getDefaultWsExtDirs();
        String string = null;
        if (this.gatheredWsExtDirs.size() > 0) {
            for (n = 0; n < this.gatheredWsExtDirs.size(); ++n) {
                try {
                    this.vars.expand((String)this.gatheredWsExtDirs.get(n));
                    vector.addElement((String)this.gatheredWsExtDirs.get(n));
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Warning: Invalid ws.ext.dir value " + this.gatheredWsExtDirs.get(n) + " found and will not be used to start this server. Correct this value and restart the server. Could not expand variable specified.");
                    Tr.audit(tc, "Cannot expand variable in " + this.gatheredWsExtDirs.get(n) + " skipping this part of ws.ext.dirs");
                }
            }
        }
        if (vector.size() > 0) {
            string = (String)vector.get(0);
            for (n = 1; n < vector.size(); ++n) {
                string = string + File.pathSeparator + (String)vector.get(n);
            }
        }
        if (string != null) {
            this.params.getCommandLineArguments().add("-Dws.ext.dirs=" + this.expand(string));
        }
    }

    private void processExecutionTargetInfo(JavaProcessDef javaProcessDef) throws Exception {
        ExecutableTargetKind executableTargetKind;
        String string = javaProcessDef.getExecutableTarget();
        if (string == null || string.length() < 1) {
            string = WSSERVER_CLASS;
        }
        if ((executableTargetKind = javaProcessDef.getExecutableTargetKind()) == null) {
            executableTargetKind = ExecutableTargetKind.JAVA_CLASS_LITERAL;
        }
        if (executableTargetKind.getValue() == 0) {
            if (string.equals(WSSERVER_CLASS)) {
                this.params.getCommandLineArguments().add("com.ibm.wsspi.bootstrap.WSPreLauncher");
                this.params.getCommandLineArguments().add("-nosplash");
                if (Boolean.getBoolean("ws.ext.debug")) {
                    this.params.getCommandLineArguments().add("-debug");
                }
                this.params.getCommandLineArguments().add("-application");
                this.params.getCommandLineArguments().add(WSLAUNCHER_CLASS);
                this.params.getCommandLineArguments().add(WSSERVER_CLASS);
            } else {
                this.params.getCommandLineArguments().add(this.expand(string));
            }
        } else if (executableTargetKind.getValue() == 1) {
            this.params.getCommandLineArguments().add("-jar");
            this.params.getCommandLineArguments().add(this.expand(string));
        } else {
            throw new AdminException(LaunchUtils.getFormattedMessage("ADML0031E", new Object[]{executableTargetKind}, null));
        }
        if (this.serverId != null && string.equals(WSSERVER_CLASS)) {
            this.params.getCommandLineArguments().add(this.serverId.getConfigRoot());
            this.params.getCommandLineArguments().add(this.serverId.getCellName());
            this.params.getCommandLineArguments().add(this.serverId.getNodeName());
            this.params.getCommandLineArguments().add(this.serverId.getServerName());
        }
    }

    private void processSecurityProperties() throws Exception {
        Enumeration<?> enumeration = this.gatheredSecurityProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security property: " + string + "=" + this.gatheredSecurityProperties.getProperty(string));
            }
            this.params.addCommandLineArgument("-D" + string + "=" + this.gatheredSecurityProperties.getProperty(string));
        }
    }

    private void processInternalClassAccessMode(JavaVirtualMachine javaVirtualMachine) {
        if (javaVirtualMachine.getInternalClassAccessMode() == InternalClassAccessMode.RESTRICT_LITERAL) {
            this.params.getCommandLineArguments().add("-Dibm.websphere.internalClassAccessMode=restrict");
        } else if (javaVirtualMachine.getInternalClassAccessMode() == InternalClassAccessMode.ALLOW_LITERAL) {
            this.params.getCommandLineArguments().add("-Dibm.websphere.internalClassAccessMode=allow");
        }
    }

    private void processMiscJVMSettings(JavaVirtualMachine javaVirtualMachine) {
        String string;
        if (javaVirtualMachine.isVerboseModeJNI()) {
            this.params.getCommandLineArguments().add("-verbose:jni");
        }
        if (javaVirtualMachine.isVerboseModeGarbageCollection()) {
            this.params.getCommandLineArguments().add("-verbose:gc");
        }
        if (javaVirtualMachine.isVerboseModeClass()) {
            this.params.getCommandLineArguments().add("-verbose:class");
        }
        String string2 = System.getProperty(DEF_MINHEAPSIZE_PROP);
        if (javaVirtualMachine.getInitialHeapSize() > 0) {
            this.handleExtraneousArguments("-Xms" + javaVirtualMachine.getInitialHeapSize() + "m");
        } else if (string2 != null) {
            this.handleExtraneousArguments(string2);
        }
        String string3 = System.getProperty(DEF_MAXHEAPSIZE_PROP);
        if (javaVirtualMachine.getMaximumHeapSize() > 0) {
            this.handleExtraneousArguments("-Xmx" + javaVirtualMachine.getMaximumHeapSize() + "m");
        } else if (string3 != null) {
            this.handleExtraneousArguments(string3);
        }
        if (javaVirtualMachine.isRunHProf() && javaVirtualMachine.getHprofArguments() != null && javaVirtualMachine.getHprofArguments().length() > 0) {
            this.params.getCommandLineArguments().add("-Xrunhprof:" + this.expand(javaVirtualMachine.getHprofArguments()));
        }
        if (this.developmentMode && !this.zOS && !PlatformHelperFactory.getPlatformHelper().isOS400() && (string = System.getProperty(DEF_DEVELOPMENT_MODE)) != null && string.length() != 0) {
            String[] stringArray = string.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.params.getCommandLineArguments().add(stringArray[i].trim());
            }
        }
    }

    public void setStatusSocketPort(Integer n) {
        if (n != null) {
            if (this.zOS) {
                String string = "-Dwas.status.socket=" + n.toString();
                this.params.setStatusSocketPort(string);
            } else {
                String string = "-Dwas.status.socket=" + n.toString();
                this.params.getCommandLineArguments().add(1, string);
            }
        }
    }

    public void addSystemProperty(String string) {
        if (string != null) {
            if (string.startsWith("-Ddb2j.system.home")) {
                Vector vector = this.params.getCommandLineArguments();
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.get(i);
                    if (!string2.startsWith("-Ddb2j.system.home")) continue;
                    vector.remove(i);
                }
            }
            this.params.getCommandLineArguments().add(1, string);
            if (string.equals("-Dcom.ibm.ws.server.mode=recovery") && this.zOS) {
                this.params.setServerMode("REC=Y");
            }
        }
    }

    private String expand(String string) {
        String string2;
        block3: {
            string2 = string;
            String string3 = this.varExpand(string);
            try {
                string2 = this.vars.expand(string3);
            }
            catch (Throwable throwable) {
                Tr.service(tc, "ADML0004E", new Object[]{string, throwable});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "exception expanding " + string, throwable);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exit expand" + string, string2);
        }
        return string2;
    }

    private String varExpand(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        if (string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '$') continue;
            if (i < n - 1) {
                c = string.charAt(i + 1);
                if (c == '(' || c == '{') continue;
                stringBuffer.append('$');
                continue;
            }
            stringBuffer.append('$');
        }
        try {
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Variable expansion attempt was failed by :" + exception + " the original value will be used:" + string);
            }
            return string;
        }
    }

    private boolean createParentDir(String string) {
        File file;
        File file2 = null;
        boolean bl = false;
        if (string != null && (file2 = (file = new File(string)).getParentFile()) != null) {
            bl = file2.mkdirs();
        }
        return bl;
    }

    public void processShortNames(Server server2, ServerEntry serverEntry) {
        Component component2;
        ApplicationServer applicationServer = null;
        String string = "";
        String string2 = "";
        EList eList = server2.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            component2 = (Component)iterator.next();
            if (!(component2 instanceof ApplicationServer)) continue;
            applicationServer = (ApplicationServer)component2;
            break;
        }
        if (applicationServer != null) {
            component2 = applicationServer.getProperties();
            int n = component2.size();
            for (int i = 0; i < n; ++i) {
                Property property = (Property)component2.get(i);
                if (property.getName() == null || property.getValue() == null || !property.getName().equals("ClusterTransitionName")) continue;
                string = property.getValue();
                this.params.setClusterShortName(string);
                break;
            }
        }
        if (string.equals("")) {
            string = serverEntry.getGenericShortName();
            this.params.setClusterShortName(string);
        }
        if ((string2 = server2.getShortName()) != null && !string2.equals("")) {
            this.params.setServerShortName(string2);
        } else {
            string2 = serverEntry.getServerShortName();
            if (string2 != null && !string2.equals("")) {
                this.params.setServerShortName(string2);
            }
        }
    }

    public void process390Commands(ProcessDef processDef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process390Commands", processDef);
        }
        this.params.setStartCommand(processDef.getStartCommand());
        EList eList = processDef.getStartCommandArgs();
        int n = eList.size();
        String string = null;
        for (int i = 0; i < n; ++i) {
            String string2 = (String)eList.get(i);
            string = this.expand(string2);
            this.params.getStartCommandArgs().add(string);
        }
        this.params.setStopCommand(processDef.getStopCommand());
        EList eList2 = processDef.getStopCommandArgs();
        int n2 = eList2.size();
        string = null;
        for (int i = 0; i < n2; ++i) {
            String string3 = (String)eList2.get(i);
            string = this.expand(string3);
            this.params.getStopCommandArgs().add(string);
        }
        this.params.setTerminateCommand(processDef.getTerminateCommand());
        EList eList3 = processDef.getTerminateCommandArgs();
        int n3 = eList3.size();
        string = null;
        for (int i = 0; i < n3; ++i) {
            String string4 = (String)eList3.get(i);
            string = this.expand(string4);
            this.params.getTerminateCommandArgs().add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process390Commands", processDef);
        }
    }

    private ServerEntry getServerEntry(Repository repository2, String string) throws Exception {
        ServerEntry serverEntry = null;
        Resource resource = null;
        String string2 = null;
        try {
            resource = repository2.getConfigRoot().getResource(3, "serverindex.xml");
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size() && !(string2 = (serverEntry = (ServerEntry)eList.get(i)).getServerName()).equals(string); ++i) {
        }
        return serverEntry;
    }

    public void setDevOption(boolean bl) {
        this.devOption = bl;
    }

    public boolean getDevOption() {
        return this.devOption;
    }

    public void setParamsFromServer(Server server2) {
        this.developmentMode = server2.isSetDevelopmentMode() && server2.isDevelopmentMode();
    }

    private void setGenericServerParamsFromJavaProcessDef(JavaProcessDef javaProcessDef) throws Exception {
        Object object;
        JavaVirtualMachine javaVirtualMachine = null;
        EList eList = javaProcessDef.getJvmEntries();
        String string = System.getProperty("os.name");
        for (int i = 0; i < eList.size(); ++i) {
            object = (JavaVirtualMachine)eList.get(i);
            if (object.getOsName() == null || !object.getOsName().equalsIgnoreCase(string)) continue;
            javaVirtualMachine = object;
            break;
        }
        if (javaVirtualMachine == null && eList.size() > 0) {
            javaVirtualMachine = (JavaVirtualMachine)eList.get(0);
            javaVirtualMachine.setOsName(string);
        }
        if (javaVirtualMachine != null) {
            int n;
            int n2;
            int n3;
            Object object2;
            Properties properties = new Properties();
            if (properties != null) {
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    string2 = string2.trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Default system property: " + string2 + "=" + properties.getProperty(string2));
                    }
                    this.processSystemProperty("-D" + string2 + "=" + properties.getProperty(string2).trim());
                }
            }
            object = javaVirtualMachine.getSystemProperties();
            for (int i = 0; i < object.size(); ++i) {
                object2 = (Property)object.get(i);
                if (object2.getName() == null || object2.getValue() == null) continue;
                this.processSystemProperty("-D" + object2.getName() + "=" + object2.getValue());
            }
            if (javaVirtualMachine.getGenericJvmArguments() != null && javaVirtualMachine.getGenericJvmArguments().length() > 0) {
                this.processCommandLineArguments(javaVirtualMachine.getGenericJvmArguments());
            }
            Vector<Object> vector = new Vector<Object>();
            object2 = null;
            EList eList2 = javaVirtualMachine.getBootClasspath();
            for (n3 = 0; n3 < eList2.size(); ++n3) {
                object2 = (String)eList2.get(n3);
                if (object2 == null || ((String)object2).length() <= 0) continue;
                vector.add(object2);
            }
            if (this.gatheredBootclasspath.size() > 0) {
                for (n3 = 0; n3 < this.gatheredBootclasspath.size(); ++n3) {
                    vector.add((String)this.gatheredBootclasspath.get(n3));
                }
            }
            if (vector.size() > 0) {
                object2 = (String)vector.get(0);
                for (n3 = 1; n3 < vector.size(); ++n3) {
                    object2 = (String)object2 + File.pathSeparator + (String)vector.get(n3);
                }
            }
            if (object2 != null) {
                this.params.getCommandLineArguments().add("-Xbootclasspath/p:" + this.expand((String)object2));
            }
            Vector<String> vector2 = new Vector<String>();
            String string3 = null;
            eList2 = javaVirtualMachine.getClasspath();
            for (n2 = 0; n2 < eList2.size(); ++n2) {
                string3 = (String)eList2.get(n2);
                if (string3 == null || string3.length() <= 0) continue;
                vector2.add(string3);
            }
            if (this.gatheredClasspath.size() > 0) {
                for (n2 = 0; n2 < this.gatheredClasspath.size(); ++n2) {
                    vector2.add((String)this.gatheredClasspath.get(n2));
                }
            }
            if (vector2.size() > 0) {
                string3 = (String)vector2.get(0);
                for (n2 = 1; n2 < vector2.size(); ++n2) {
                    string3 = string3 + File.pathSeparator + (String)vector2.get(n2);
                }
            }
            if (string3 != null) {
                this.params.getCommandLineArguments().add("-classpath");
                this.params.getCommandLineArguments().add(this.expand(string3));
            }
            if (javaVirtualMachine.isVerboseModeJNI()) {
                this.params.getCommandLineArguments().add("-verbose:jni");
            }
            if (javaVirtualMachine.isVerboseModeGarbageCollection()) {
                this.params.getCommandLineArguments().add("-verbose:gc");
            }
            if (javaVirtualMachine.isVerboseModeClass()) {
                this.params.getCommandLineArguments().add("-verbose:class");
            }
            if (javaVirtualMachine.getInitialHeapSize() > 0) {
                this.params.getCommandLineArguments().add("-Xms" + javaVirtualMachine.getInitialHeapSize() + "m");
            }
            if (javaVirtualMachine.getMaximumHeapSize() > 0) {
                this.params.getCommandLineArguments().add("-Xmx" + javaVirtualMachine.getMaximumHeapSize() + "m");
            }
            if (javaVirtualMachine.isRunHProf() && javaVirtualMachine.getHprofArguments() != null && javaVirtualMachine.getHprofArguments().length() > 0) {
                this.params.getCommandLineArguments().add("-Xrunhprof:" + this.expand(javaVirtualMachine.getHprofArguments()));
            }
            Vector<String> vector3 = new Vector<String>();
            String string4 = null;
            if (this.gatheredWsExtDirs.size() > 0) {
                for (n = 0; n < this.gatheredWsExtDirs.size(); ++n) {
                    vector3.addElement((String)this.gatheredWsExtDirs.get(n));
                }
            }
            if (vector3.size() > 0) {
                string4 = (String)vector3.get(0);
                for (n = 1; n < vector3.size(); ++n) {
                    string4 = string4 + File.pathSeparator + (String)vector3.get(n);
                }
            }
            if (string4 != null) {
                this.params.getCommandLineArguments().add("-Dws.ext.dirs=" + this.expand(string4));
            }
            this.processJavaLibraryPathInfo();
            if (this.gatheredMiscCommandLineArgs.size() > 0) {
                for (n = 0; n < this.gatheredMiscCommandLineArgs.size(); ++n) {
                    this.params.getCommandLineArguments().add(this.expand((String)this.gatheredMiscCommandLineArgs.get(n)));
                }
            }
            this.processSecurityProperties();
        }
        this.processExecutionTargetInfo(javaProcessDef);
    }

    private void handleExtraneousArguments(String string) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(61);
        boolean bl3 = this.isHPUX_XX(string);
        if (n == -1) {
            if (n2 == -1) {
                boolean bl4 = false;
                int n3 = string.length();
                int n4 = 0;
                while (!bl4) {
                    char c = string.charAt(n4);
                    if (c >= '0' && c <= '9') {
                        string2 = string.substring(0, n4);
                        string3 = string.substring(n4);
                        bl4 = true;
                        bl = true;
                        continue;
                    }
                    if (++n4 != n3) continue;
                    bl4 = true;
                }
                if (n4 == n3) {
                    string2 = new String(string);
                }
            } else {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
                bl2 = true;
            }
        } else if (bl3) {
            string2 = this.parseHPUX_XX(string);
        } else if (n2 == -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else if (n < n2) {
            if (string.startsWith("-XX:")) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
        } else {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        if (this.cleanedArguments.containsKey(string2)) {
            if (!bl3) {
                if (bl) {
                    String string4 = (String)this.cleanedArguments.get(string2);
                    this.cleanedArguments.remove(string2);
                    this.cleanedArguments.put(string2, string3);
                    this.params.getCommandLineArguments().remove(string2 + string4);
                    this.params.getCommandLineArguments().add(string);
                } else if (string.startsWith("-D") || string.startsWith("-XX:")) {
                    if (this.cleanedArguments.containsKey(string2)) {
                        String string5 = (String)this.cleanedArguments.get(string2);
                        String string6 = (String)this.cleanedArguments.get(string2 + string5);
                        this.cleanedArguments.remove(string2);
                        this.cleanedArguments.remove(string2 + string5);
                        this.cleanedArguments.put(string2, string3);
                        this.cleanedArguments.put(string2 + string3, string);
                        this.params.getCommandLineArguments().remove(string6);
                        this.params.getCommandLineArguments().add(string);
                    }
                } else if (!this.cleanedArguments.containsKey(string)) {
                    this.cleanedArguments.put(string, null);
                    this.params.getCommandLineArguments().add(string);
                }
            }
        } else {
            if (bl3) {
                this.cleanedArguments.put(string2, null);
            } else if (bl) {
                this.cleanedArguments.put(string2, string3);
            } else if (string.startsWith("-D") || string.startsWith("-XX:")) {
                this.cleanedArguments.put(string2, string3);
                this.cleanedArguments.put(string2 + string3, string);
            } else {
                this.cleanedArguments.put(string2, null);
                this.cleanedArguments.put(string, null);
            }
            this.params.getCommandLineArguments().add(string);
        }
    }

    private boolean isHPUX_XX(String string) {
        if (string.startsWith("-XX:+")) {
            return true;
        }
        if (string.startsWith("-XX:-")) {
            return true;
        }
        return string.startsWith("-XX:OnError");
    }

    private String parseHPUX_XX(String string) {
        if (string.startsWith("-XX:+")) {
            return string;
        }
        if (string.startsWith("-XX:-")) {
            return string;
        }
        if (string.startsWith("-XX:OnError")) {
            return string;
        }
        return null;
    }
}

