/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.launcher.UnixLaunchScriptCollaborator;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;

public class LaunchScriptWriter {
    private static TraceComponent tc = Tr.register(LaunchScriptWriter.class, "Launcher", "com.ibm.ws.management.resources.launcher");
    private LaunchParams params = null;
    private static final String ARCFLOW = "arcflow";
    private static final String PURIFY = "purify";
    private static final String QUANTIFY = "quantify";
    private static final String PURIFY_OPT = "IBM_JAVA_OPTIONS=-XrunPureJVMPI:purify";
    private static final String QUANTIFY_OPT = "IBM_JAVA_OPTIONS=-XrunPureJVMPI:quantify";
    private static final String ARCFLOW_OPT1 = "PERFORMANCE_OPTION=-Xrunjprof32:generic,";
    private static final String ARCFLOW_OPT2 = ",socket,+PTT_INSTS";
    private static final String ARCFLOW_COMMENT = " For running with arcflow";
    private static final String PURIFY_COMMENT = " For running with Rational purify";
    private static final String QUANTIFY_COMMENT = " For running with Rational quantify";

    public LaunchScriptWriter(LaunchParams launchParams) {
        this.params = launchParams;
    }

    public void writeScript(String string, String string2, boolean bl) throws Exception {
        String string3 = string.toLowerCase();
        LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LaunchScriptCollaborator: " + launchScriptPlatformCollaborator.getClass());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing a launch script file: " + string2);
        }
        String string4 = this.buildLaunchString(launchScriptPlatformCollaborator);
        if (bl) {
            string4 = launchScriptPlatformCollaborator.addBackgroundCommand(string4);
        }
        if (string4 != null) {
            File file = new File(string2);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(launchScriptPlatformCollaborator.buildScriptHeader(string2));
            fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
            boolean bl2 = this.params.getDevOption();
            if (bl2) {
                String string5 = null;
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformComment());
                fileWriter.write(" Start developer performance monitoring options. Only uncomment ONE option at a time.");
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
                String string6 = this.calculateVarOpt(launchScriptPlatformCollaborator);
                string5 = ARCFLOW_OPT1 + string6 + ARCFLOW_OPT2;
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformComment());
                fileWriter.write(ARCFLOW_COMMENT);
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
                fileWriter.write(launchScriptPlatformCollaborator.buildDevOptions(string5));
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformComment());
                fileWriter.write(PURIFY_COMMENT);
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
                fileWriter.write(launchScriptPlatformCollaborator.buildDevOptions(PURIFY_OPT));
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformComment());
                fileWriter.write(QUANTIFY_COMMENT);
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
                fileWriter.write(launchScriptPlatformCollaborator.buildDevOptions(QUANTIFY_OPT));
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformComment());
                fileWriter.write(" End developer performance monitoring options.");
                fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
            }
            fileWriter.write(launchScriptPlatformCollaborator.buildEnvSettings(this.params.getEnvironment()));
            fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
            fileWriter.write(launchScriptPlatformCollaborator.getPlatformComment() + " Launch Command");
            fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
            fileWriter.write(string4);
            fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
            fileWriter.write(launchScriptPlatformCollaborator.getPlatformLineEnd());
            fileWriter.write(launchScriptPlatformCollaborator.getPlatformEndLocal());
            fileWriter.close();
        }
    }

    private String buildLaunchString(LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator) {
        StringBuffer stringBuffer = new StringBuffer();
        if (launchScriptPlatformCollaborator instanceof UnixLaunchScriptCollaborator) {
            stringBuffer.append("exec ");
        }
        stringBuffer.append("\"");
        stringBuffer.append(this.params.getExecutableName());
        stringBuffer.append("\"");
        stringBuffer.append(" ");
        stringBuffer.append(this.params.getJvmModeString());
        stringBuffer.append(" ");
        stringBuffer.append(launchScriptPlatformCollaborator.getPlatformVarBegin());
        stringBuffer.append("DEBUG");
        stringBuffer.append(launchScriptPlatformCollaborator.getPlatformVarEnd());
        boolean bl = this.params.getDevOption();
        if (bl) {
            stringBuffer.append(" ");
            stringBuffer.append(launchScriptPlatformCollaborator.getPlatformVarBegin());
            stringBuffer.append("PERFORMANCE_OPTION");
            stringBuffer.append(launchScriptPlatformCollaborator.getPlatformVarEnd());
        }
        Vector vector = this.params.getCommandLineArguments();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            if (string.equals("-server") || string.equals("-client") || string.equals("-classic")) continue;
            if (string.startsWith("\"") && string.endsWith("\"")) {
                stringBuffer.append(" " + (String)vector.get(i));
                continue;
            }
            stringBuffer.append(" \"" + (String)vector.get(i) + "\"");
        }
        return stringBuffer.toString();
    }

    private String calculateVarOpt(LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FNM=");
        stringBuffer.append(launchScriptPlatformCollaborator.getPlatformVarBegin());
        stringBuffer.append("WAS_PATH");
        stringBuffer.append(launchScriptPlatformCollaborator.getPlatformVarEnd());
        stringBuffer.append(launchScriptPlatformCollaborator.getPlatformFileDelim());
        stringBuffer.append("logs");
        stringBuffer.append(launchScriptPlatformCollaborator.getPlatformFileDelim());
        stringBuffer.append("log");
        return stringBuffer.toString();
    }
}

