/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import java.io.PrintStream;
import java.util.Vector;

public class ProcessLauncher {
    private static TraceComponent tc = Tr.register(ProcessLauncher.class, "Launcher");
    private static boolean debug = false;
    private static PrintStream out = System.out;
    private CreationParams params;
    private String parms = ",PARMS='";
    private String separator = ",";

    public ProcessLauncher(LaunchParams launchParams) {
        this.params = this.setCreationParams(launchParams);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process CreationParams: " + this.params.toString());
        }
    }

    public Process launch() throws Exception {
        Process process = ProcessFactory.create(this.params);
        return process;
    }

    private CreationParams setCreationParams(LaunchParams launchParams) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCreationParams", launchParams);
        }
        CreationParams creationParams = new CreationParams();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.processFor_zOS(launchParams, creationParams);
        } else {
            this.processForDistributed(launchParams, creationParams);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCreationParams", creationParams);
        }
        return creationParams;
    }

    private void processForDistributed(LaunchParams launchParams, CreationParams creationParams) {
        boolean bl = true;
        String string = launchParams.getStartCommand();
        if (string == null || string.length() == 0) {
            bl = false;
            string = launchParams.getExecutableName();
            if (string == null || string.length() == 0) {
                try {
                    throw new AdminException("Name of executable not found!");
                }
                catch (AdminException adminException) {
                    adminException.printStackTrace();
                }
            }
            bl = false;
        }
        if (bl) {
            creationParams.setExecutable(launchParams.getStartCommand());
        } else {
            creationParams.setExecutable(launchParams.getExecutableName());
        }
        creationParams.setProcessName(launchParams.getServerIds().getServerName());
        creationParams.setWorkingDirectory(launchParams.getWorkingDirectory());
        String string2 = launchParams.getStdoutFileName();
        creationParams.setStdFileName(0, launchParams.getStdinFileName());
        creationParams.setStdFileName(1, launchParams.getStdoutFileName());
        creationParams.setStdFileName(2, launchParams.getStderrFileName());
        if (string2 == null || string2.equals("") || string2.equals("stdout") || string2.equals("console")) {
            creationParams.setInheritParentStreams(true);
        }
        creationParams.setUserId(launchParams.getUserId());
        creationParams.setGroupId(launchParams.getGroupId());
        creationParams.setProcessGroupId(launchParams.getProcessGroupId());
        creationParams.setProcessPriority(launchParams.getProcessPriority());
        creationParams.setUmask(launchParams.getUmask());
        Vector vector = launchParams.getCommandLineArguments();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        creationParams.setCommandLineArgs((String[])objectArray);
        vector = launchParams.getEnvironment();
        Object[] objectArray2 = new String[vector.size()];
        vector.copyInto(objectArray2);
        creationParams.setEnvironment((String[])objectArray2);
    }

    private void processFor_zOS(LaunchParams launchParams, CreationParams creationParams) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processFor_zOS", creationParams);
        }
        creationParams.setClusterName(launchParams.getClusterShortName());
        creationParams.setExecutable(launchParams.getStartCommand());
        creationParams.setProcessName(launchParams.getServerShortName());
        Vector vector = launchParams.getStartCommandArgs();
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null) {
            String string;
            String string2;
            if (vector.size() > 0) {
                stringBuffer.append((String)vector.get(0));
            }
            if ((string2 = launchParams.getStatusSocketPort()) != null && string2.length() > 0) {
                stringBuffer.append(this.parms);
                stringBuffer.append(string2);
                stringBuffer.append("'");
            }
            if ((string = launchParams.getServerMode()) != null && string.length() > 0) {
                stringBuffer.append(this.separator);
                stringBuffer.append(string);
            }
        }
        creationParams.setCommandLineArgs(new String[]{stringBuffer.toString()});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processFor_zOS", stringBuffer);
        }
    }
}

