/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.NoServerDefinedException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ProcessStopper {
    private static TraceComponent tc = Tr.register(ProcessStopper.class, "ProcessStopper");
    private StopParams stopParams = new StopParams();
    private boolean stopImmediate = false;
    private ProcessDef processDef = null;

    public ProcessStopper(ServerIdentifiers serverIdentifiers, boolean bl) throws NoServerDefinedException, AdminException {
        Resource resource;
        Server server2 = null;
        this.stopImmediate = bl;
        Repository repository2 = RepositoryFactory.createRepository("ws-server", serverIdentifiers.getConfigRoot(), serverIdentifiers.getCellName(), serverIdentifiers.getNodeName(), serverIdentifiers.getServerName());
        try {
            resource = repository2.getConfigRoot().getResource(4, "server.xml");
            EList eList = resource.getContents();
            for (int i = 0; i < eList.size(); ++i) {
                Object e2 = eList.get(i);
                if (!(e2 instanceof Server)) continue;
                server2 = (Server)e2;
                break;
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        if (!server2.getName().equals(serverIdentifiers.getServerName())) {
            throw new NoServerDefinedException(serverIdentifiers.getServerName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server2);
        }
        resource = server2.getProcessDefinitions();
        int n = resource.size();
        String string = null;
        for (int i = 0; i < n; ++i) {
            this.processDef = (ProcessDef)resource.get(i);
            string = this.processDef.getProcessType();
            if (string != null && string.equalsIgnoreCase("Control")) break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ProcessDef: " + this.processDef);
        }
        this.stopParams = this.setStopParams(this.processDef);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process StopParams: " + this.stopParams.toString());
        }
    }

    public void setStopImmediate(boolean bl) {
        if (bl != this.stopImmediate) {
            this.stopImmediate = bl;
            this.stopParams = this.setStopParams(this.processDef);
        }
    }

    public void stop() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop process");
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String string = this.stopParams.getZOSCommand();
            if (string != null && string.trim().length() != 0) {
                ProcessFactory.terminate(this.stopParams);
            }
        } else {
            ProcessFactory.terminate(this.stopParams);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop process");
        }
    }

    private StopParams setStopParams(ProcessDef processDef) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStopParams");
        }
        String string = "";
        String string2 = "";
        Object object2 = "";
        String string3 = "";
        if (processDef != null) {
            object = null;
            object = processDef.getStopCommand();
            if (object != null) {
                object2 = object;
            }
        }
        if (((StringTokenizer)(object = new StringTokenizer((String)object2, ";"))).countTokens() == 2) {
            string = ((StringTokenizer)object).nextToken().trim();
            string2 = ((StringTokenizer)object).nextToken().trim();
        }
        if (this.stopImmediate) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            if (stringTokenizer.countTokens() == 2) {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            this.stopParams.setProcessID(string3);
            this.stopParams.setZOSCommand(string2);
            this.stopParams.setStopMode(2);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() == 2) {
                string = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
            }
            this.stopParams.setProcessID(string3);
            this.stopParams.setStopMode(0);
            this.stopParams.setZOSCommand(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStopParams", this.stopParams);
        }
        return this.stopParams;
    }
}

