/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.launcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.NoServerDefinedException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ProcessTerminator {
    private static TraceComponent tc = Tr.register(ProcessTerminator.class, "Terminator");
    private StopParams stopParams = null;
    private ProcessDef processDef = null;

    public ProcessTerminator(ServerIdentifiers serverIdentifiers) throws Exception {
        Resource resource;
        Server server2 = null;
        this.stopParams = new StopParams();
        Repository repository2 = RepositoryFactory.createRepository("ws-server", serverIdentifiers.getConfigRoot(), serverIdentifiers.getCellName(), serverIdentifiers.getNodeName(), serverIdentifiers.getServerName());
        try {
            resource = repository2.getConfigRoot().getResource(4, "server.xml");
            EList eList = resource.getContents();
            for (int i = 0; i < eList.size(); ++i) {
                Object e2 = eList.get(i);
                if (!(e2 instanceof Server)) continue;
                server2 = (Server)e2;
                break;
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception);
        }
        if (!server2.getName().equals(serverIdentifiers.getServerName())) {
            throw new NoServerDefinedException(serverIdentifiers.getServerName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + server2);
        }
        resource = server2.getProcessDefinitions();
        int n = resource.size();
        String string = null;
        for (int i = 0; i < n; ++i) {
            this.processDef = (ProcessDef)resource.get(i);
            string = this.processDef.getProcessType();
            if (string != null && string.equalsIgnoreCase("Control")) break;
        }
        if (GenericServerProcHelper.isServerAWebServer(serverIdentifiers)) {
            this.setWebserverStopParams(serverIdentifiers, repository2);
        } else {
            this.setStopParams();
        }
    }

    public void setStopMode(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStopMode", new Boolean(bl));
        }
        if (bl) {
            this.setImmediateStopParams();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStopMode");
        }
    }

    public void setForceMode(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setForceMode", new Boolean(bl));
        }
        if (bl) {
            this.setForceParams();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setForceMode");
        }
    }

    public void terminate() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminate");
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String string = this.stopParams.getZOSCommand();
            if (string != null && string.trim().length() != 0) {
                ProcessFactory.terminate(this.stopParams);
            }
        } else {
            ProcessFactory.terminate(this.stopParams);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate");
        }
    }

    private void setStopParams() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStopParams");
        }
        Object object2 = "";
        Object object3 = null;
        String string = null;
        String string2 = null;
        if (this.processDef != null) {
            object = null;
            object = this.processDef.getStopCommand();
            if (object != null && ((String)object).length() > 0) {
                object2 = object;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStopParams", object2);
        }
        if (((StringTokenizer)(object = new StringTokenizer((String)object2, ";"))).countTokens() == 2) {
            object3 = ((StringTokenizer)object).nextToken().trim();
            string = ((StringTokenizer)object).nextToken().trim();
        } else {
            object3 = object2;
        }
        if (object3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object3, " ");
            if (stringTokenizer.countTokens() == 2) {
                object3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            this.stopParams.setProcessID(string2);
            this.stopParams.setStopMode(0);
            this.stopParams.setZOSCommand((String)object3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStopParams", object3);
        }
    }

    private void setWebserverStopParams(ServerIdentifiers serverIdentifiers, Repository repository2) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWebserverStopParams");
        }
        String string2 = "";
        String string3 = null;
        Object var5_5 = null;
        String string4 = null;
        if (this.processDef != null) {
            string = null;
            string = this.processDef.getStopCommand();
            if (string != null && string.length() > 0) {
                string2 = string;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setWebserverstopParams", string2);
        }
        if ((string3 = string2) != null) {
            Object object;
            block12: {
                string = this.processDef.getStopCommandArgs();
                for (int i = 0; i < string.size(); ++i) {
                    String string5 = (String)string.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setWebserverstopParams stringCmdArg ", string5);
                    }
                    string5 = "," + string5;
                    string3 = string3.concat(string5);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "setWebserverstopParams stopCommandArg ", string3);
                }
                try {
                    object = string3;
                    string3 = this.expand((String)object, serverIdentifiers, repository2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setWebserverStopParams", string3);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "ProcessTerminator  stopWebserverStopParms exception on expanding " + string3);
                }
            }
            object = new StringTokenizer(string3, " ");
            if (((StringTokenizer)object).countTokens() == 2) {
                string3 = ((StringTokenizer)object).nextToken();
                string4 = ((StringTokenizer)object).nextToken();
            }
            this.stopParams.setProcessID(string4);
            this.stopParams.setStopMode(0);
            this.stopParams.setZOSCommand(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWebserverStopParams");
        }
    }

    private void setForceParams() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setForceParams");
        }
        String string = null;
        String string2 = null;
        if (this.processDef != null) {
            String string3 = this.processDef.getTerminateCommand();
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                if (stringTokenizer.countTokens() == 2) {
                    string = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                }
                this.stopParams.setProcessID(string2);
                this.stopParams.setStopMode(1);
                this.stopParams.setZOSCommand(string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setForceParams", this.stopParams);
            }
        }
    }

    private void setImmediateStopParams() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setImmediateStopParams");
        }
        Object object2 = "";
        String string = null;
        Object object3 = null;
        String string2 = null;
        if (this.processDef != null) {
            object = null;
            object = this.processDef.getStopCommand();
            if (object != null && ((String)object).length() > 0) {
                object2 = object;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setImmediateStopParams", object2);
        }
        if (((StringTokenizer)(object = new StringTokenizer((String)object2, ";"))).countTokens() == 2) {
            string = ((StringTokenizer)object).nextToken().trim();
            object3 = ((StringTokenizer)object).nextToken().trim();
        } else {
            object3 = object2;
        }
        if (object3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object3, " ");
            if (stringTokenizer.countTokens() == 2) {
                object3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            this.stopParams.setProcessID(string2);
            this.stopParams.setStopMode(2);
            this.stopParams.setZOSCommand((String)object3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setImmediateStopParams");
        }
    }

    private VariableMap getVariableMap(ServerIdentifiers serverIdentifiers, Repository repository2) throws AdminException {
        VariableMap variableMap = VariableMapFactory.createVariableMap(repository2);
        try {
            variableMap.initialize(null);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getVariableMap " + serverIdentifiers.getServerName(), throwable);
            }
            throw new AdminException(serverIdentifiers.getServerName());
        }
        return variableMap;
    }

    private String expand(String string, ServerIdentifiers serverIdentifiers, Repository repository2) throws AdminException {
        VariableMap variableMap = null;
        String string2 = string;
        try {
            variableMap = this.getVariableMap(serverIdentifiers, repository2);
            string2 = variableMap.expand(string);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in stopArgs expand " + string, throwable);
            }
            throw new AdminException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ProcessTerminator expand exit", string2);
        }
        return string2;
    }
}

