/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class ManagedObjectMetadataAccessorImpl
implements ManagedObjectMetadataAccessor,
ConfigRepositoryListener {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataAccessorImpl.class, "Admin", null);
    private static final String INSTALL_ROOT_PROPERTY_NAME = "was.install.root";
    private boolean _isServerProcess;
    private String _serverCellName;
    private String _repoRoot;
    private String _cellName;
    private String _cellConfigPath;
    private HashMap _cache;

    public ManagedObjectMetadataAccessorImpl(Properties properties) throws AdminException {
        block16: {
            AdminService adminService;
            this._isServerProcess = false;
            this._repoRoot = null;
            this._cache = new HashMap();
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "ManagedObjectMetadataAccessorImpl", "Accessor props: " + properties);
            }
            if ((adminService = AdminServiceFactory.getAdminService()) != null) {
                this._isServerProcess = true;
            }
            this._repoRoot = properties.getProperty("was.repository.root");
            if (!(this._isServerProcess || this._repoRoot != null && this._repoRoot.length() != 0)) {
                AdminException adminException = new AdminException("Property \"was.repository.root\" not defined or has a zero-length value.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "ManagedObjectMetadataAccessorImpl: Exception", adminException);
                }
                throw adminException;
            }
            this._cellName = properties.getProperty("local.cell");
            if (this._cellName == null || this._cellName.length() == 0) {
                if (this._isServerProcess) {
                    this._cellName = adminService.getCellName();
                } else {
                    AdminException adminException = new AdminException("Property \"local.cell\" not defined or has a zero-length value.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "ManagedObjectMetadataAccessorImpl: Exception", adminException);
                    }
                    throw adminException;
                }
            }
            if (this._isServerProcess) {
                this._serverCellName = adminService.getCellName();
                if (this._cellName.equals(this._serverCellName)) {
                    try {
                        Properties properties2 = new Properties();
                        properties2.setProperty("location", "local");
                        ConfigRepository configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties2);
                        configRepository.addListener(this);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Added as a config repository listener.");
                        }
                        break block16;
                    }
                    catch (AdminException adminException) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Could not get ConfigRepository reference.  Not added as a listener.", adminException);
                        }
                        break block16;
                    }
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Specified cell name \"" + this._cellName + "\" does not match this server's cell name, \"" + this._serverCellName + "\".");
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataAccessorImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMetadataProperties(String string) throws AdminException {
        Properties properties;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperties", "nodeName=" + string);
        }
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            properties = (Properties)this._cache.get(string);
        }
        if (properties == null) {
            properties = this.extractMetadata(string);
            hashMap = this._cache;
            synchronized (hashMap) {
                this._cache.put(string, properties);
            }
        }
        properties = (Properties)properties.clone();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperties", "props=" + properties);
        }
        return properties;
    }

    public String getMetadataProperty(String string, String string2) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperty", new String[]{"nodeName=" + string, "propName=" + string2});
        }
        Properties properties = this.getMetadataProperties(string);
        String string3 = properties.getProperty(string2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperty", string2 + "=" + string3);
        }
        return string3;
    }

    private Properties extractMetadata(String string) throws AdminException {
        ConfigRepository configRepository;
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractMetadata", "nodeName=" + string);
        }
        try {
            string2 = ConfigStructureHelper.getURI(this._cellName, string, "", "node-metadata.properties");
            properties = new Properties();
            properties.setProperty("location", "local");
            properties.setProperty("com.ibm.ws.management.standalone", "true");
            if (this._repoRoot != null) {
                properties.setProperty("was.repository.root", this._repoRoot);
            }
            if ((configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties)) == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "extractMetadata: Null ConfigRepository returned.");
                }
                MetadataNotAvailableException metadataNotAvailableException = new MetadataNotAvailableException("Could not obtain a reference to the Config Repository.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "extractMetadata: No Config Repository: ", metadataNotAvailableException);
                }
                throw metadataNotAvailableException;
            }
        }
        catch (MetadataNotAvailableException metadataNotAvailableException) {
            throw metadataNotAvailableException;
        }
        catch (Throwable throwable) {
            MetadataNotAvailableException metadataNotAvailableException = new MetadataNotAvailableException(throwable, "Unexpected exception received while obtaining a reference to the Config Repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: Unexpected exception: ", metadataNotAvailableException);
            }
            throw metadataNotAvailableException;
        }
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "extractMetadata: Extracting " + string2);
            }
            DocumentContentSource documentContentSource = configRepository.extract(string2);
            InputStream inputStream = documentContentSource.getSource();
            properties = new Properties();
            properties.load(inputStream);
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.metadata.ManagedObjectMetadataAccessorImpl.extractMetadata", "257", this);
            }
        }
        catch (RepositoryException repositoryException) {
            MetadataNotAvailableException metadataNotAvailableException = new MetadataNotAvailableException(repositoryException, "Could not obtain managed object metadata from Config Repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: RepositoryException: ", metadataNotAvailableException);
            }
            throw metadataNotAvailableException;
        }
        catch (Throwable throwable) {
            MetadataNotAvailableException metadataNotAvailableException = new MetadataNotAvailableException(throwable, "Unexpected exception received while extracting metadata from the Config Repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: Unexpected exception: ", metadataNotAvailableException);
            }
            throw metadataNotAvailableException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractMetadata");
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(String string) {
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removing from cache: nodeName=" + string);
            }
            this._cache.remove(string);
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "onChangeCompletion");
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        ArrayList arrayList = new ArrayList();
        String string = "/node-metadata.properties";
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            String string2 = configChangeNotifierArray[i].getUri();
            if (!string2.toLowerCase().endsWith("/node-metadata.properties")) continue;
            String string3 = ConfigStructureHelper.nodeNameForDoc(string2);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Metadata file has changed: ", "URI=" + string2 + ", nodeName=" + string3);
            }
            this.removeFromCache(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRepositoryEpochRefresh() {
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Epoch refresh.  Clearing cache.");
            }
            this._cache.clear();
        }
    }
}

