/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ManagedObjectMetadataCollectorImpl
implements ManagedObjectMetadataCollector {
    static final String ACTION_PARAM_PROFILE_TYPE = "Base Profile Type";
    static final String BASE_EXTENSION_ID = "base";
    static final String PROFILE_TYPE_DMGR = "dmgr";
    static final String PROFILE_TYPE_MANAGED = "managed";
    static final String PROFILE_TYPE_DEFAULT = "default";
    static final String[] PROFILE_TYPES = new String[]{"dmgr", "managed", "default"};
    static final String[][] EXPECTED_PRODUCT_IDS = new String[][]{{"BASE", "Base"}, {"ND", "ND"}, {"EXPRESS", "Express"}, {"embeddedEXPRESS", "Express"}};
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCollector.class, "Admin", null);
    private static final String[] STANDALONE_CELL_FEATURE_FILTERS = new String[]{"com.ibm.ws.base_", "com.ibm.ws.express_", "com.ibm.ws.j2ee_", "com.ibm.ws.uddi_", "com.ibm.ws.wsgateway_"};
    private static final String[] DMGR_FEATURE_FILTERS = new String[]{"com.ibm.ws.base_", "com.ibm.ws.express_", "com.ibm.ws.j2ee_", "com.ibm.ws.nd_", "com.ibm.ws.uddi_", "com.ibm.ws.wsgateway_"};
    private static final String[] MANAGED_FEATURE_FILTERS = DMGR_FEATURE_FILTERS;
    private Properties _inputProps;
    private Properties _metadata;
    private Exception _e = null;

    public ManagedObjectMetadataCollectorImpl(Properties properties) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ManagedObjectMetadataCollectorImpl(Properties)", "Input props: " + DebugUtils.createPropertiesMaskPlainTextPassword(properties));
        }
        this._inputProps = properties;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataCollectorImpl(Properties)");
        }
    }

    public void updateMetadata(String string, Hashtable hashtable, Properties properties) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateMetadata", new String[]{"action=" + string, "actionParams=" + hashtable, "metadata(in)=" + properties});
        }
        try {
            if (string == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateMetadata: Null action.  No action taken.");
                }
            } else if (string.equals("Collect Metadata")) {
                this.collectMetadata(properties);
            } else if (string.equals("Add Extension")) {
                String string2 = (String)hashtable.get("param.action.extension.id");
                if (string2 != null && string2.equals(BASE_EXTENSION_ID)) {
                    String string3 = (String)hashtable.get(ACTION_PARAM_PROFILE_TYPE);
                    this.appendBaseFeatures(properties, string3);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "updateMetadata: Extension ID not recognized or not present.  No action taken.");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateMetadata: Action not recognized.  No action taken.");
            }
        }
        catch (Exception exception) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Exception: " + exception);
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateMetadata", new String[]{"metadata(out)=" + properties});
        }
    }

    private void collectMetadata(Properties properties) throws AdminException {
        Properties properties2 = new Properties();
        this.collectVersionInfo(properties2);
        String string = System.getProperty("os.name");
        string = ManagedObjectMetadataUtilities.normalizeOSName(string);
        if (string != null) {
            String string2;
            properties2.setProperty("com.ibm.websphere.nodeOperatingSystem", string);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "MetadataCollector:", "osName=" + string);
            }
            if (string.equals("os390") && (string2 = AdminHelper.getPlatformHelper().getSysplexName()) != null && string2.length() > 0) {
                properties2.setProperty("com.ibm.websphere.nodeSysplexName", string2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "MetadataCollector:", "sysplex=" + string2);
                }
            }
        } else {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Could not obtain operating system name.");
            }
            throw new AdminException("Could not obtain operating system name.");
        }
        properties.putAll((Map<?, ?>)properties2);
    }

    private void collectVersionInfo(Properties properties) throws AdminException {
        String string = null;
        try {
            WASProduct wASProduct = new WASProduct(this._inputProps.getProperty("was.install.root"));
            for (int i = 0; i < EXPECTED_PRODUCT_IDS.length; ++i) {
                product product2;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "collectVersionInfo: Collecting version info for " + EXPECTED_PRODUCT_IDS[i][0] + ".");
                }
                if ((product2 = wASProduct.getProductById(EXPECTED_PRODUCT_IDS[i][0])) == null || (string = product2.getVersion()) == null) continue;
                properties.setProperty("com.ibm.websphere.baseProductVersion", string);
                properties.setProperty("com.ibm.websphere.baseProductShortName", EXPECTED_PRODUCT_IDS[i][1]);
                break;
            }
        }
        catch (Exception exception) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Caught exception.", exception);
            }
            throw new AdminException(exception, "Could not obtain product version.");
        }
        if (string == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "collectVersionInfo: Could not obtain product version.");
            }
            throw new AdminException("Could not obtain product version.");
        }
    }

    private void appendBaseFeatures(Properties properties, String string) throws Exception {
        block13: {
            String string2 = this._inputProps.getProperty("was.install.root");
            if (string2 == null) {
                AdminException adminException = new AdminException("No install root path provided.");
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl.appendBaseFeatures", "205", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "appendBaseFeatures: No install root path.", adminException);
                }
                throw adminException;
            }
            String string3 = string2 + File.separator + "features";
            File file = new File(string3);
            if (!file.exists()) {
                AdminException adminException = new AdminException("No \"features\" directory found under the install root directory, " + string2 + ".");
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl.appendBaseFeatures", "217", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "appendBaseFeatures: No features directory.", adminException);
                }
                throw adminException;
            }
            if (!file.isDirectory()) {
                AdminException adminException = new AdminException("The path \"" + string3 + "\" does not resolve to a directory.");
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl.appendBaseFeatures", "225", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "appendBaseFeatures: Name \"features\" not a directory.", adminException);
                }
                throw adminException;
            }
            try {
                String string4;
                StringBuffer stringBuffer;
                String string5 = properties.getProperty("com.ibm.websphere.deployed.features");
                Set set = this.parseFeaturesProp(string5);
                String[] stringArray = file.list(new FeatureFileFilter(string));
                if (string5 == null) {
                    stringBuffer = new StringBuffer();
                    string4 = "";
                } else {
                    stringBuffer = new StringBuffer(string5);
                    string4 = ",";
                }
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string6 = stringArray[i];
                    if (set.contains(string6)) continue;
                    stringBuffer.append(string4);
                    stringBuffer.append(string6);
                    ++n;
                    string4 = ",";
                }
                if (n > 0) {
                    string5 = stringBuffer.toString();
                    Tr.debug(_tc, "appendBaseFeatures: setting featuures list:", "featuresProp=" + string5);
                    properties.setProperty("com.ibm.websphere.deployed.features", string5);
                } else {
                    Tr.debug(_tc, "appendBaseFeatures: No features added.");
                }
            }
            catch (Exception exception) {
                if (!_tc.isEventEnabled()) break block13;
                Tr.event(_tc, "appendBaseFeatures: Exception received:", exception);
            }
        }
    }

    private Set parseFeaturesProp(String string) {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null || string.length() == 0) {
            return hashSet;
        }
        int n = 0;
        int n2 = string.indexOf(44);
        while (n2 != -1) {
            string2 = string.substring(n, n2).trim();
            if (string2.length() > 0) {
                hashSet.add(string2);
            }
            n = n2 + 1;
            n2 = string.indexOf(44, n);
        }
        string2 = string.substring(n).trim();
        if (string2.length() > 0) {
            hashSet.add(string2);
        }
        return hashSet;
    }

    private class FeatureFileFilter
    implements FilenameFilter {
        private String _profileType;
        private String[] _featureFilters;

        public FeatureFileFilter(String string) {
            this._profileType = string;
            if (string.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_DMGR)) {
                this._featureFilters = DMGR_FEATURE_FILTERS;
            } else if (string.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_MANAGED)) {
                this._featureFilters = MANAGED_FEATURE_FILTERS;
            } else if (string.equals(ManagedObjectMetadataCollectorImpl.PROFILE_TYPE_DEFAULT)) {
                this._featureFilters = STANDALONE_CELL_FEATURE_FILTERS;
            } else {
                FFDCFilter.processException((Throwable)new AdminException("No feature filters for profile type " + string), "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl.FilenameFilter.FeatureFileFilter", "362", this);
                this._featureFilters = null;
            }
        }

        public boolean accept(File file, String string) {
            if (this._featureFilters == null) {
                return false;
            }
            for (int i = 0; i < this._featureFilters.length; ++i) {
                if (!string.startsWith(this._featureFilters[i])) continue;
                File file2 = new File(file.getAbsolutePath() + File.separator + string);
                return file2.isDirectory();
            }
            return false;
        }
    }
}

