/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.CellPackage;
import com.ibm.websphere.models.config.topology.cell.CellType;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollector;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorImpl;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ManagedObjectMetadataCollectorManagerImpl
implements com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager,
ManagedObjectMetadataCollectorManager {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCollectorManagerImpl.class, "Admin", null);
    private static final String[][] EXPECTED_PRODUCT_IDS = ManagedObjectMetadataCollectorImpl.EXPECTED_PRODUCT_IDS;
    private static final String BOOTSTRAP_ADDR = "BOOTSTRAP_ADDRESS";
    private static final String SOAP_CONNECTOR_ADDRESS = "SOAP_CONNECTOR_ADDRESS";
    private static final int DOC_CHANGED_RETRY_COUNT = 2;
    private static ArrayList _collectors = null;
    private AdminClient _adminClient = null;
    private String _repositoryRoot = null;
    private Properties _inputProps;
    private String _cellName;
    private String _nodeName;
    private boolean _localOnly;
    static /* synthetic */ Class class$java$util$Properties;

    public ManagedObjectMetadataCollectorManagerImpl(Properties properties, AdminClient adminClient) throws AdminException {
        this(properties, adminClient, false);
    }

    public ManagedObjectMetadataCollectorManagerImpl(Properties properties) throws AdminException {
        this(properties, null, true);
    }

    private ManagedObjectMetadataCollectorManagerImpl(Properties properties, AdminClient adminClient, boolean bl) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ManagedObjectMetadataCollectorManagerImpl(String, Properties, boolean)", new String[]{"Input props: " + DebugUtils.createPropertiesMaskPlainTextPassword(properties), "localOnly=" + bl});
        }
        if (adminClient == null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "ManagedObjectMetadataCollectorManagerImpl: Null AdminClient");
        }
        this._localOnly = bl;
        this._adminClient = adminClient;
        this.getInputProps(properties);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ManagedObjectMetadataCollectorManagerImpl(String, Properties, boolean)");
        }
    }

    private void getInputProps(Properties properties) throws AdminException {
        AdminService adminService;
        if (properties == null) {
            AdminException adminException = new AdminException("Null Properties argument.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ManagedObjectMetadataCollectorManagerImpl: Null Properties", adminException);
            }
            throw adminException;
        }
        this._inputProps = properties;
        this._repositoryRoot = properties.getProperty("was.repository.root");
        if ((this._repositoryRoot == null || this._repositoryRoot.length() == 0) && (adminService = AdminServiceFactory.getAdminService()) == null) {
            AdminException adminException = new AdminException("Property \"was.repository.root\" not defined or has a zero-length value.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ManagedObjectMetadataCollectorManagerImpl: Exception", adminException);
            }
            throw adminException;
        }
        this._cellName = properties.getProperty("local.cell");
        this._nodeName = properties.getProperty("local.node");
    }

    public Properties updateMetadata() throws AdminException {
        return this.updateMetadata("Collect Metadata", null);
    }

    public Properties updateMetadata(String string, Hashtable hashtable) throws AdminException {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateMetadata");
        }
        if (string == null) {
            serializable2 = new AdminException("The Managed Object Metadata Collector Manager was invoked with a null action.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Null action.", serializable2);
            }
        }
        serializable2 = null;
        ArrayList arrayList = new ArrayList();
        try {
            this.getCollectors(arrayList);
            if (_tc.isEventEnabled() && arrayList.size() == 0) {
                Tr.event(_tc, "No managed object metadata collectors found.");
            }
        }
        catch (AdminException adminException) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Received exception: " + adminException);
            }
            throw adminException;
        }
        int n = 2;
        DocumentChangedException documentChangedException = null;
        do {
            try {
                serializable = new Properties();
                object = this.readMetadataFromConfig((Properties)serializable);
                serializable2 = (Properties)((Properties)serializable).clone();
                int n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    Object e2 = arrayList.get(i);
                    this.invokeCollector(e2, string, hashtable, (Properties)serializable2);
                }
                this.writeMetadataToConfig((DocumentContentSource)object, (Properties)serializable, (Properties)serializable2);
                n = -99;
            }
            catch (DocumentChangedException documentChangedException2) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateMetadataForNode: DocumentChangedException.", new Object[]{"retryCount=" + n, documentChangedException2});
                }
                --n;
                documentChangedException = documentChangedException2;
            }
            catch (AdminException adminException) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateMetadata: AdminException: ", adminException);
                }
                throw adminException;
            }
            catch (Exception exception) {
                object = new AdminException(exception, "Could not complete metadata update.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateMetadata: Received exception: ", exception);
                }
                throw object;
            }
        } while (n >= 0);
        if (n == -1) {
            serializable = new AdminException(documentChangedException, "Could not store metadata to the config repository after 2 retries.");
            Tr.exit(_tc, "invokeConfigRepository: Exhausted retry count.", serializable);
            throw serializable;
        }
        try {
            if (this._adminClient == null && !this._localOnly) {
                this._adminClient = this.createAdminClient();
            }
            if (this._adminClient != null) {
                serializable = this._adminClient.getServerMBean();
                object = ((ObjectName)serializable).getKeyProperty("node");
                String string2 = ((ObjectName)serializable).getKeyProperty("process");
                this.invokeAdminOpsMBean((Properties)serializable2, (String)object, string2);
            }
        }
        catch (AdminException adminException) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Attempt to send metadata to Deployment Manager failed: " + adminException);
            }
            throw adminException;
        }
        catch (Exception exception) {
            object = new AdminException(exception, "Could not complete metadata update.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "updateMetadata: Attempt to send metadata to Deployment Manager failed: ", exception);
            }
            throw object;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateMetadata", "updatedMetadata=" + serializable2);
        }
        return serializable2;
    }

    public Properties updateVersion5Metadata(ObjectName objectName) throws AdminException {
        Serializable serializable;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateVersion5Metadata", "v5ServerMBeanObjectName=" + objectName);
        }
        Properties properties = null;
        int n = 2;
        DocumentChangedException documentChangedException = null;
        do {
            Serializable serializable2;
            try {
                String string;
                serializable = new Properties();
                serializable2 = this.readMetadataFromConfig((Properties)serializable);
                properties = (Properties)serializable.clone();
                OneNodeAccessor oneNodeAccessor = new OneNodeAccessor(this._nodeName, properties);
                ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(oneNodeAccessor);
                String string2 = managedObjectMetadataHelper.getNodeMajorVersion(this._nodeName);
                if (!string2.equals("5")) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getMetadataForVersion5Node: Not a v5 node.", "majorVersion=" + string2);
                    }
                    return null;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMetadataForVersion5Node: Collecting v5 metadata.");
                }
                boolean bl = this.invokeServerMBean(objectName, properties);
                String string3 = objectName.getKeyProperty("node");
                if (bl |= this.invokeJVMMBean(string3, string = objectName.getKeyProperty("process"), properties)) {
                    this.writeMetadataToConfig((DocumentContentSource)serializable2, (Properties)serializable, properties);
                }
                n = -99;
            }
            catch (DocumentChangedException documentChangedException2) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "updateVersion5Metadata: DocumentChangedException.", new Object[]{"retryCount=" + n, documentChangedException2});
                }
                --n;
                documentChangedException = documentChangedException2;
            }
            catch (MetadataNotAvailableException metadataNotAvailableException) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateVersion5Metadata: Expected metadata missing.", metadataNotAvailableException);
                }
                throw metadataNotAvailableException;
            }
            catch (AdminException adminException) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateVersion5Metadata: AdminException: ", adminException);
                }
                throw adminException;
            }
            catch (Exception exception) {
                serializable2 = new AdminException(exception, "Encountered error while attempting to collect v5 metadata.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "updateVersion5Metadata: Error occurred.", serializable2);
                }
                throw serializable2;
            }
        } while (n >= 0);
        if (n == -1) {
            serializable = new AdminException(documentChangedException, "Could not store metadata to the config repository after 2 retries.");
            Tr.exit(_tc, "invokeConfigRepository: Exhausted retry count.", serializable);
            throw serializable;
        }
        return properties;
    }

    private void getCollectors(ArrayList arrayList) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCollectors");
        }
        ArrayList arrayList2 = ManagedObjectMetadataCollectorManagerImpl.getCollectorInfo();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Serializable serializable;
            String string = ((CollectorInfo)arrayList2.get((int)i)).className;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                serializable = classLoader.loadClass(string);
                Constructor<?> constructor = serializable.getConstructor(class$java$util$Properties == null ? ManagedObjectMetadataCollectorManagerImpl.class$("java.util.Properties") : class$java$util$Properties);
                Properties properties = (Properties)this._inputProps.clone();
                Object obj = constructor.newInstance(properties);
                if (obj instanceof ManagedObjectMetadataCollector || obj instanceof com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector) {
                    arrayList.add(obj);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "getCollectors: Collector " + string + " instantiated and added to list of collectors.");
                    continue;
                }
                FFDCFilter.processException((Throwable)new AdminException("getCollectors: Collector class " + string + " does not implement expected interface.  Collector ignored."), "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.getCollectors", "529", this);
                if (!_tc.isEventEnabled()) continue;
                Tr.event(_tc, "getCollectors: Collector class " + string + " does not implement expected interface.  Collector ignored.");
                continue;
            }
            catch (Exception exception) {
                serializable = new AdminException(exception, "Could not instantiate ManagedObjectMetadataCollector implementation class \"" + string + "\".");
                FFDCFilter.processException(serializable, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.getCollectors", "542", this);
                if (!_tc.isEntryEnabled()) continue;
                Tr.exit(_tc, "Could not instantiate ManagedObjectMetadataCollector implementation class \"" + string + "\".", serializable);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCollectors", "numCollectors=" + arrayList.size());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList getCollectorInfo() throws AdminException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ArrayList<CollectorInfo> arrayList;
        block39: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getCollectorInfo");
            }
            arrayList = new ArrayList<CollectorInfo>();
            IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            if (iExtensionRegistry != null) {
                object5 = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".managed-object-metadata-collector";
                object4 = iExtensionRegistry.getExtensionPoint((String)object5);
                if (object4 != null) {
                    if (_tc.isInfoEnabled()) {
                        Tr.info(_tc, "Processing extension point " + (String)object5);
                    }
                    object3 = object4.getExtensions();
                    break block39;
                } else {
                    AdminException adminException = new AdminException("Unable to get extension point - " + (String)object5);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getCollectorInfo: AdminException", adminException);
                    }
                    throw adminException;
                }
            }
            AdminException adminException = new AdminException("Unable to get eclipse extension registry.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCollectorInfo: AdminException", adminException);
            }
            throw adminException;
        }
        for (int i = 0; i < ((IExtension[])object3).length; ++i) {
            object2 = object3[i];
            object = object2.getConfigurationElements();
            if (((IConfigurationElement[])object).length != 1) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Invalid number of metadata-collector elements - " + ((IConfigurationElement[])object).length);
                continue;
            }
            IConfigurationElement iConfigurationElement = object[0];
            if (!iConfigurationElement.getName().equals("metadata-collector")) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Invalid element name - expecting <metadata-collector>, got <" + iConfigurationElement.getName() + ">");
                continue;
            }
            IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
            if (iConfigurationElementArray.length != 1) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Invalid number of collector-class elements - " + iConfigurationElementArray.length);
                continue;
            }
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[0];
            if (!iConfigurationElement2.getName().equals("collector-class")) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Invalid element name - expecting <collector-class>, got <" + iConfigurationElement2.getName() + ">");
                continue;
            }
            CollectorInfo collectorInfo = new CollectorInfo();
            collectorInfo.className = iConfigurationElement2.getValue();
            arrayList.add(collectorInfo);
        }
        try {
            object5 = null;
            try {
                object4 = Thread.currentThread().getContextClassLoader();
                object5 = ((ClassLoader)object4).getResources("META-INF/managed-object-metadata-collector.xml");
            }
            catch (IOException iOException) {
                object3 = new AdminException(iOException, "Exception loading collector XML file.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getCollectorInfo: AdminException", object3);
                }
                throw object3;
            }
            object4 = SAXParserFactory.newInstance();
            try {
                object3 = ((SAXParserFactory)object4).newSAXParser();
            }
            catch (SAXException sAXException) {
                object2 = new AdminException(sAXException, "Exception parsing collector XML file.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getCollectorInfo: AdminException", object2);
                }
                throw object2;
            }
            CollectorHandler collectorHandler = new CollectorHandler();
            object2 = null;
            while (object5.hasMoreElements()) {
                object = (URL)object5.nextElement();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Next collector XML: " + ((URL)object).toString());
                }
                try {
                    object2 = ((URL)object).openStream();
                }
                catch (IOException iOException) {
                    AdminException adminException = new AdminException(iOException, "Error opening stream for: " + object);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getCollectorInfo: AdminException", adminException);
                    }
                    throw adminException;
                }
                try {
                    collectorHandler.setURL((URL)object);
                    ((SAXParser)object3).parse((InputStream)object2, (DefaultHandler)collectorHandler);
                    arrayList.addAll(collectorHandler.getCollectors());
                }
                catch (SAXParseException sAXParseException) {
                    AdminException adminException = new AdminException(sAXParseException, "Error occurred while parsing file " + ((URL)object).getFile() + " at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber());
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getCollectorInfo: AdminException", adminException);
                    }
                    throw adminException;
                }
                catch (Throwable throwable) {
                    AdminException adminException = new AdminException(throwable, "Error parsing metadata collector XML doc: " + object);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getCollectorInfo: AdminException", adminException);
                    }
                    throw adminException;
                }
                finally {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        Tr.event(_tc, "Could not close metadata collector XML input stream.", iOException);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            object4 = new AdminException(throwable, "Unexpected exception getting metadata collectors.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCollectorInfo: AdminException", throwable);
            }
            throw object4;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCollectorInfo", "listSize=" + arrayList.size());
        }
        return arrayList;
    }

    private void invokeCollector(Object object, String string, Hashtable hashtable, Properties properties) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeCollector", new String[]{"action=" + string});
        }
        try {
            if (object instanceof com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector) {
                com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector managedObjectMetadataCollector = (com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollector)object;
                managedObjectMetadataCollector.updateMetadata(string, hashtable, properties);
            } else if (string.equals("Collect Metadata")) {
                ManagedObjectMetadataCollector managedObjectMetadataCollector = (ManagedObjectMetadataCollector)object;
                properties.putAll((Map<?, ?>)managedObjectMetadataCollector.collectMetadata());
            } else if (_tc.isEventEnabled()) {
                Tr.event(_tc, "invokeCollector: Cannot invoke action on legacy collector.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.invokeCollector", "737", this);
            String string2 = "Metadata collection failed.  Received exception from collector " + object.getClass().getName() + ".";
            AdminException adminException = new AdminException(exception, string2);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "invokeCollector: " + string2, adminException);
            }
            throw adminException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeCollector");
        }
    }

    private void invokeAdminOpsMBean(Properties properties, String string, String string2) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeAdminOpsMBean");
        }
        try {
            Set set;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._adminClient.getDomainName());
            stringBuffer.append(":");
            stringBuffer.append("name");
            stringBuffer.append("=");
            stringBuffer.append("AdminOperations");
            stringBuffer.append(",");
            stringBuffer.append("node");
            stringBuffer.append("=");
            stringBuffer.append(string);
            stringBuffer.append(",");
            stringBuffer.append("process");
            stringBuffer.append("=");
            stringBuffer.append(string2);
            stringBuffer.append(",*");
            ObjectName objectName = new ObjectName(stringBuffer.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "invokeAdminOpsMBean", "query ObjectName=" + objectName.toString());
            }
            try {
                set = this._adminClient.queryNames(objectName, null);
                if (set == null) {
                    Tr.exit(_tc, "invokeAdminOpsMBean: Received null set from queryNames.");
                    return;
                }
                int n = set.size();
                if (n == 0) {
                    Tr.exit(_tc, "invokeAdminOpsMBean: Received empty set from queryNames.");
                    return;
                }
                if (n > 1) {
                    Tr.event(_tc, "invokeAdminOpsMBean: Received set size greater than 1. Using only the first entry.", "querySetSize=" + n);
                }
            }
            catch (Throwable throwable) {
                Tr.debug(_tc, "invokeAdminOpsMBean: Received exception from queryNames.", throwable);
                throw throwable;
            }
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                this._adminClient.invoke(objectName2, "updateMetadataForNode", new Object[]{this._nodeName, properties}, new String[]{"java.lang.String", "java.util.Properties"});
            }
        }
        catch (AdminException adminException) {
            Tr.exit(_tc, "invokeAdminOpsMBean: AdminException: ", adminException);
            throw adminException;
        }
        catch (Throwable throwable) {
            AdminException adminException = new AdminException(throwable, "Could not send metadata to administrative server.");
            Tr.exit(_tc, "invokeAdminOpsMBean: Received exception: ", throwable);
            throw adminException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeAdminOpsMBean");
        }
    }

    private boolean invokeServerMBean(ObjectName objectName, Properties properties) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeServerMBean", "v5ServerMBeanObjectName=" + objectName.toString());
        }
        boolean bl = false;
        try {
            String string = null;
            for (int i = 0; i < EXPECTED_PRODUCT_IDS.length; ++i) {
                String string2;
                Object object;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "invokeServerMBean: Collecting version info for " + EXPECTED_PRODUCT_IDS[i][0] + ".");
                }
                if ((string = this.parseV5ProductVersionXML(object = this._adminClient.invoke(objectName, "getProductVersion", new Object[]{EXPECTED_PRODUCT_IDS[i][0]}, new String[]{"java.lang.String"}))) == null || string.length() == 0) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "invokeServerMBean: Have version info for " + EXPECTED_PRODUCT_IDS[i][0] + ": " + string);
                }
                if ((string2 = properties.getProperty("com.ibm.websphere.baseProductVersion")) == null || !string2.equals(string)) {
                    properties.setProperty("com.ibm.websphere.baseProductVersion", string);
                    bl = true;
                    if (!_tc.isDebugEnabled()) break;
                    Tr.debug(_tc, "invokeServerMBean: Updating v5 version info.");
                    break;
                }
                Tr.debug(_tc, "invokeServerMBean: No change in v5 version.");
                break;
            }
            if (string == null && _tc.isEventEnabled()) {
                Tr.event(_tc, "invokeServerMBean: Could not obtain product version for version 5 node.");
            }
        }
        catch (Throwable throwable) {
            AdminException adminException = new AdminException(throwable, "Could not obtain metadata from version 5 node \"" + this._nodeName + "\".");
            Tr.exit(_tc, "invokeServerMBean: Received exception: ", throwable);
            throw adminException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeServerMBean", "propertyChanged=" + bl);
        }
        return bl;
    }

    private boolean invokeJVMMBean(String string, String string2, Properties properties) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invokeJVMMBean", new String[]{"nodeName=" + string, "serverName=" + string2});
        }
        boolean bl = false;
        try {
            Iterator iterator;
            Set set;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._adminClient.getDomainName());
            stringBuffer.append(":");
            stringBuffer.append("name");
            stringBuffer.append("=");
            stringBuffer.append("JVM");
            stringBuffer.append(",");
            stringBuffer.append("node");
            stringBuffer.append("=");
            stringBuffer.append(string);
            stringBuffer.append(",");
            stringBuffer.append("process");
            stringBuffer.append("=");
            stringBuffer.append(string2);
            stringBuffer.append(",*");
            ObjectName objectName = new ObjectName(stringBuffer.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "invokeJVMMBean: querySpec: " + objectName);
            }
            if ((set = this._adminClient.queryNames(objectName, null)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "invokeJVMMBean: No JVM MBeans returned from query.");
                }
                return false;
            }
            int n = set.size();
            if (n == 0) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "invokeJVMMBean: Empty set returned from JVM MBean query.");
                }
                return false;
            }
            if (n > 1 && _tc.isEventEnabled()) {
                Tr.event(_tc, "invokeJVMMBean: More than one qualifying JVM MBean.");
            }
            if ((iterator = set.iterator()).hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                String string3 = (String)this._adminClient.invoke(objectName2, "getProperty", new Object[]{"os.name"}, new String[]{"java.lang.String"});
                if (string3 == null) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "invokeJVMMBean: Null os.name value returned from JVM MBean.");
                    }
                    return false;
                }
                if ((string3 = ManagedObjectMetadataUtilities.normalizeOSName(string3)) == null) {
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "invokeJVMMBean: os.name value of \"" + string3 + "\" could not be normalized.");
                    }
                    return false;
                }
                String string4 = properties.getProperty("com.ibm.websphere.nodeOperatingSystem");
                if (string4 == null || !string4.equals(string3)) {
                    properties.setProperty("com.ibm.websphere.nodeOperatingSystem", string3);
                    bl = true;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "invokeJVMMBean: Updating v5 node OS to \"" + string3 + "\".");
                    }
                } else {
                    Tr.debug(_tc, "invokeJVMMBean: No change in v5 node OS.");
                }
            }
        }
        catch (Throwable throwable) {
            AdminException adminException = new AdminException(throwable, "Could not OS name from version 5 node \"" + this._nodeName + "\".");
            Tr.exit(_tc, "invokeJVMMBean: Received exception: ", throwable);
            throw adminException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "invokeJVMMBean", "propertyChanged=" + bl);
        }
        return bl;
    }

    private String parseV5ProductVersionXML(Object object) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseV5ProductVersionXML", "xml=" + object);
        }
        if (object == null || !(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        int n = string.indexOf("<version>");
        if (n < 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseV5ProductVersionXML: No <version> tag found. Returning null.");
            }
            return null;
        }
        int n2 = string.indexOf("</version>", n);
        if (n2 < 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseV5ProductVersionXML: No </version> tag found. Returning null.");
            }
            return null;
        }
        String string2 = string.substring(n + 9, n2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseV5ProductVersionXML", "v5ProdVer=" + string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentContentSource readMetadataFromConfig(Properties properties) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readMetadataFromConfig");
        }
        DocumentContentSource documentContentSource = null;
        try {
            ConfigRepository configRepository;
            String string = ConfigStructureHelper.getURI(this._cellName, this._nodeName, "", "node-metadata.properties");
            Properties properties2 = new Properties();
            properties2.setProperty("location", "local");
            properties2.setProperty("com.ibm.ws.management.standalone", "true");
            if (this._repositoryRoot != null) {
                properties2.setProperty("was.repository.root", this._repositoryRoot);
            }
            if ((configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties2)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "readMetadataFromConfig: Null ConfigRepository.");
                }
                throw new AdminException("ManagedObjectMetadataCollectorManagerImpl.readMetadataFromConfig: Null ConfigRepository.");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readMetadataFromConfig: Extracting " + string);
            }
            documentContentSource = configRepository.extract(string);
            InputStream inputStream = documentContentSource.getSource();
            try {
                properties.load(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Tr.event(_tc, "Could not close node metadata properties file input stream.", iOException);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.readMetadataFromConfig", "1129", this);
            AdminException adminException = new AdminException(exception, "Error occurred attempting to read metadata from the config repository.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "readMetadataFromConfig: Received unexpected exception.", adminException);
            }
            throw adminException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readMetadataFromConfig");
        }
        return documentContentSource;
    }

    private void writeMetadataToConfig(DocumentContentSource documentContentSource, Properties properties, Properties properties2) throws DocumentChangedException, AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeMetadataToConfig");
        }
        if (properties.equals(properties2)) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "writeMetadataToConfig: No changes.  File not updated.");
            }
            return;
        }
        try {
            ConfigRepository configRepository;
            Properties properties3 = new Properties();
            properties3.setProperty("location", "local");
            properties3.setProperty("com.ibm.ws.management.standalone", "true");
            if (this._repositoryRoot != null) {
                properties3.setProperty("was.repository.root", this._repositoryRoot);
            }
            if ((configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties3)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "writeMetadataToConfig: Null ConfigRepository.");
                }
                return;
            }
            String string = ConfigStructureHelper.getURI(this._cellName, this._nodeName, "", "node-metadata.properties");
            Document document = new Document(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties2.store(byteArrayOutputStream, null);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "writeMetadataToConfig: Modifying " + string);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                if (documentContentSource != null) {
                    documentContentSource.setSource(byteArrayInputStream);
                } else {
                    documentContentSource = new DocumentContentSource(document, byteArrayInputStream);
                }
                DocumentDigest documentDigest = configRepository.modify(documentContentSource);
            }
            catch (DocumentNotFoundException documentNotFoundException) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "writeMetadataToConfig: Creating " + string);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                documentContentSource.setSource(byteArrayInputStream);
                DocumentDigest documentDigest = configRepository.create(documentContentSource);
            }
        }
        catch (DocumentChangedException documentChangedException) {
            if (_tc.isEventEnabled()) {
                Tr.exit(_tc, "writeMetadataToConfig: DocumentChangedException.", documentChangedException);
            }
            throw documentChangedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.writeMetadataToConfig", "1223", this);
            AdminException adminException = new AdminException(exception, "Error occurred attempting to store metadata to the config repository.");
            Tr.exit(_tc, "writeMetadataToConfig: Received unexpected exception.", exception);
            throw adminException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeMetadataToConfig");
        }
    }

    private AdminClient createAdminClient() {
        EndPoint[] endPointArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createAdminClient");
        }
        if ((endPointArray = this.getDMgrEndpoints()) == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createAdminClient", "AdminClient not created");
            }
            return null;
        }
        AdminClient adminClient = null;
        for (int i = 0; i < 2; ++i) {
            String string = i == 0 ? "SOAP" : "RMI";
            String string2 = this._inputProps.getProperty("type");
            if (string2 != null && !string2.equals(string)) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Caller specified connector type " + string2 + ".  Skipping connector type " + string);
                continue;
            }
            String string3 = this._inputProps.getProperty("host");
            String string4 = this._inputProps.getProperty("port");
            if (endPointArray[i] == null && (string3 == null || string4 == null)) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Incomplete or no endpoint data for connector type " + string);
                continue;
            }
            Properties properties = new Properties();
            if (string3 == null) {
                string3 = endPointArray[i].getHost();
            }
            if (string4 == null) {
                string4 = new Integer(endPointArray[i].getPort()).toString();
            }
            properties.setProperty("type", string);
            properties.setProperty("host", string3);
            properties.setProperty("port", string4);
            properties.putAll((Map<?, ?>)this._inputProps);
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Creating AdminClient", new String[]{"host=" + string3, "port=" + string4});
                }
                adminClient = AdminClientFactory.createAdminClient(properties);
                break;
            }
            catch (Exception exception) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Could not create AdminClient: connType=" + string, exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createAdminClient", adminClient == null ? "AdminClient not created" : "AdminClient created.");
        }
        return adminClient;
    }

    private EndPoint[] getDMgrEndpoints() {
        EndPoint[] endPointArray;
        block13: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getDMgrEndpoints");
            }
            endPointArray = new EndPoint[2];
            try {
                Properties properties = new Properties();
                properties.setProperty("location", "local");
                ConfigRepository configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
                ConfigInit.init();
                ServerindexPackage serverindexPackage = ServerindexPackage.eINSTANCE;
                CellPackage cellPackage = CellPackage.eINSTANCE;
                ResourcesPackage resourcesPackage = ResourcesPackage.eINSTANCE;
                String string = ConfigStructureHelper.getURI(this._cellName, "", "", "cell.xml");
                DocumentContentSource documentContentSource = configRepository.extract(string);
                WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                Resource resource = wASResourceSetImpl.createResource(uRI);
                resource.load(documentContentSource.getSource(), new HashMap());
                Cell cell = (Cell)resource.getContents().get(0);
                CellType cellType = cell.getCellType();
                if (cell.getCellType().equals(CellType.DISTRIBUTED_LITERAL)) {
                    String string2 = ConfigStructureHelper.getURI(this._cellName, "", "", "nodes");
                    String[] stringArray = configRepository.listResourceNames(string2, 2, 1);
                    boolean bl = false;
                    block2: for (int i = 0; i < stringArray.length && !bl; ++i) {
                        String string3 = stringArray[i] + "/serverindex.xml";
                        DocumentContentSource documentContentSource2 = configRepository.extract(string3);
                        WASResourceSetImpl wASResourceSetImpl2 = new WASResourceSetImpl();
                        URI uRI2 = URI.createFileURI((String)documentContentSource2.getDocument().getURI());
                        Resource resource2 = wASResourceSetImpl2.createResource(uRI2);
                        resource2.load(documentContentSource2.getSource(), new HashMap());
                        ServerIndex serverIndex = (ServerIndex)resource2.getContents().get(0);
                        String string4 = stringArray[i].substring(stringArray[i].lastIndexOf(47) + 1);
                        EList eList = serverIndex.getServerEntries();
                        for (int j = 0; j < eList.size(); ++j) {
                            ServerEntry serverEntry = (ServerEntry)eList.get(j);
                            String string5 = serverEntry.getServerType();
                            if (string5 == null || !string5.equals("DEPLOYMENT_MANAGER")) continue;
                            bl = true;
                            if (string4.equals(this._nodeName)) {
                                if (_tc.isEntryEnabled()) {
                                    Tr.exit(_tc, "getDMgrEndpoints: Local node is dmgr node.");
                                }
                                return null;
                            }
                            EList eList2 = serverEntry.getSpecialEndpoints();
                            int n = 0;
                            for (int k = 0; k < eList2.size() && n < 2; ++k) {
                                EndPoint endPoint;
                                NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(k);
                                if (namedEndPoint.getEndPointName().equals(SOAP_CONNECTOR_ADDRESS)) {
                                    endPoint = namedEndPoint.getEndPoint();
                                    if (endPoint == null) continue;
                                    endPointArray[0] = endPoint;
                                    ++n;
                                    continue;
                                }
                                if (!namedEndPoint.getEndPointName().equals(BOOTSTRAP_ADDR) || (endPoint = namedEndPoint.getEndPoint()) == null) continue;
                                endPointArray[1] = endPoint;
                                ++n;
                            }
                            continue block2;
                        }
                    }
                    break block13;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.exit(_tc, "getDMgrEndpoints: Cell is not distributed.");
                }
                return null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.getDMgrEndpoints", "1357", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getDMgrEndpoints: Could not read configuration.", exception);
                }
                return null;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getDMgrEndpoints: Returning endpoints:", endPointArray);
        }
        return endPointArray;
    }

    private static class OneNodeAccessor
    implements ManagedObjectMetadataAccessor {
        private String _accessedNode;
        private Properties _metadata;

        public OneNodeAccessor(String string, Properties properties) {
            this._accessedNode = string;
            this._metadata = properties;
        }

        public Properties getMetadataProperties(String string) throws AdminException {
            if (string.equals(this._accessedNode)) {
                return this._metadata;
            }
            AdminException adminException = new AdminException("Invalid node name \"" + string + "\"specified. Expected \"" + this._accessedNode + "\".");
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl.OneNodeAccessor.getMetadataProperties", "1531", this);
            throw adminException;
        }

        public String getMetadataProperty(String string, String string2) throws AdminException {
            Properties properties = this.getMetadataProperties(string);
            return properties.getProperty(string2);
        }
    }

    private static class CollectorInfo {
        public String className;

        private CollectorInfo() {
        }

        public String toString() {
            return "CollectorInfo{collector-class=" + this.className + "}";
        }
    }

    private static class CollectorHandler
    extends DefaultHandler {
        Locator _locator;
        ArrayList _collectors = new ArrayList();
        CollectorInfo _currentCollector;
        URL _currentURL;
        StringBuffer value = new StringBuffer();

        public void setURL(URL uRL) {
            this._currentURL = uRL;
        }

        public ArrayList getCollectors() {
            return this._collectors;
        }

        public void startDocument() throws SAXException {
            this._collectors.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
            this.value.setLength(0);
            if (string3.equals("metadata-collector")) {
                this._currentCollector = new CollectorInfo();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this._currentCollector == null) {
                return;
            }
            if (string3.equals("metadata-collector")) {
                if (this._currentCollector.className == null) {
                    throw new SAXException("Missing name in " + this._currentURL + " at line " + this._locator.getLineNumber());
                }
                Tr.debug(_tc, "XML parse results: " + this._currentCollector);
                this._collectors.add(this._currentCollector);
                this._currentCollector = null;
            } else {
                if (!string3.equals("collector-class")) throw new SAXParseException("Invalid tag: " + string3, this._locator);
                if (this._currentCollector.className != null) throw new SAXParseException("Multiple classes defined", this._locator);
                this._currentCollector.className = this.value.toString();
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this._currentCollector = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this._currentCollector = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this._collectors.clear();
            this._currentCollector = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }
    }
}

