/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.websphere.models.config.processexec.MonitoringPolicy;

class MonitorConfig {
    String pid = null;
    int pingInterval = 60;
    int pingTimeout = 300;
    int maximumStartupAttempts = 3;
    boolean autoRestart = true;
    int nodeRestartState = 2;
    int previousState = -1;

    MonitorConfig(MonitoringPolicy monitoringPolicy) {
        if (monitoringPolicy != null) {
            this.pingInterval = monitoringPolicy.getPingInterval();
            this.pingTimeout = monitoringPolicy.getPingTimeout();
            this.maximumStartupAttempts = monitoringPolicy.getMaximumStartupAttempts();
            this.nodeRestartState = monitoringPolicy.getNodeRestartState().getValue();
            this.autoRestart = monitoringPolicy.isAutoRestart();
            if (this.autoRestart && this.maximumStartupAttempts < 0) {
                this.maximumStartupAttempts = 1;
            }
        }
    }

    int getMaximumStartupAttempts() {
        return this.maximumStartupAttempts;
    }

    int getPingInterval() {
        return this.pingInterval;
    }

    int getPingTimeout() {
        return this.pingTimeout;
    }

    boolean getAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(boolean bl) {
        this.autoRestart = bl;
    }

    int getNodeRestartState() {
        return this.nodeRestartState;
    }

    public void setNodeRestartState(int n) {
        this.nodeRestartState = n;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(int n) {
        this.previousState = n;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String string) {
        this.pid = string;
    }

    public String toString() {
        return "PingInterval: " + this.pingInterval + "\r\n" + "PingTimeout: " + this.pingTimeout + "\r\n" + "MaximumStartupAttempts: " + this.maximumStartupAttempts + "\r\n" + "NodeRestartState: " + this.nodeRestartState + "\r\n" + "PreviousState: " + this.previousState + "\r\n" + "AutoRestart: " + this.autoRestart + "\r\n";
    }
}

