/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.MonitoringPolicy;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.component.MVSServices;
import com.ibm.ws.management.event.WsStickyListener;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.LaunchParams;
import com.ibm.ws.management.launcher.ProcessTerminator;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.nodeagent.MonitorConfig;
import com.ibm.ws.management.nodeagent.NodeAgentDiagnosticHelper;
import com.ibm.ws.management.nodeagent.PidWaiter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticProvider;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeAgent
extends RuntimeCollaborator
implements NotificationListener,
PropertyChangeListener,
DiagnosticProvider,
WsStickyListener {
    private static final String resBundleName = "com.ibm.ws.management.resources.launcher";
    public static String BUNDLE_NAME = "com.ibm.ws.management.resources.nodeutils";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.launcher");
    private static TraceComponent tc = Tr.register(NodeAgent.class, "Admin", "com.ibm.ws.management.resources.launcher");
    private static final String monitorFile = "${LOG_ROOT}/nodeagent/monitor.state";
    private static final Integer DISCOVERY_LISTENER = new Integer(0);
    private static final Integer STOPPING_LISTENER = new Integer(1);
    private static final String DEFAULT_LAUNCH_TIMEOUT = "1200";
    private static final String DEFAULT_LAUNCH_TIMEOUT_ZOS = "600";
    private static final Integer DEFAULT_LAUNCH_TIMEOUT_INTEGER = new Integer("1200");
    private static final Integer DEFAULT_LAUNCH_TIMEOUT_INTEGER_ZOS = new Integer("600");
    private static Logger nodeAgentLogger = Logger.getLogger(NodeAgent.class.getName(), "com.ibm.ws.management.resources.launcher");
    private static final String WSSERVER_CLASS = "com.ibm.ws.runtime.WsServer";
    private static final String DIAGNOSTIC_BUNDLE = "com.ibm.ws.management.resources.DiagnosticProviderText";
    private static NodeAgent instance;
    private boolean isInitialized;
    private MBeanFactory mbeanFactory;
    private com.ibm.websphere.management.AdminService adminService = null;
    private VariableMap variableMap;
    private Repository repository;
    private String repositoryRootURI;
    private String cellName;
    private String nodeName;
    private long ntfySeqNum = 0L;
    private HashMap adoptedChildren = new HashMap();
    private HashMap launchedChildren = new HashMap();
    private HashMap processHandlers = new HashMap();
    private HashMap monitoringPolicies = new HashMap();
    private boolean isRipple = false;
    private String ownPid = null;
    private boolean ZOS = false;
    private static StatusCache nacache;
    private HashMap serverConnectorType = new HashMap();
    private HashMap pidWaiterHashMap = new HashMap();
    private DiagnosticProviderInfo dpInfo = null;
    public static final String sDPName = "NodeAgentDP";
    private static final Integer SYNC_LISTENER;
    private static boolean isSyncInProgress;
    private boolean isRestartingAllServers = false;
    private boolean isBeingCalledByStopNodeMethod = false;
    private boolean isBeingCalledByRestartMethod = false;

    NodeAgent() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NodeAgent constructor, ZOS = " + AdminHelper.getPlatformHelper().isZOS());
        }
        this.isInitialized = false;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.ZOS = true;
        }
        nacache = StatusCacheFactory.getStatusCache();
    }

    void initialize(Repository repository2, VariableMap variableMap, ThreadPoolMgr threadPoolMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (this.isInitialized) {
            Tr.exit(tc, "initialize - done");
            return;
        }
        this.repository = repository2;
        this.variableMap = variableMap;
        this.repositoryRootURI = repository2.getRootURI();
        this.cellName = AdminServiceFactory.getAdminService().getCellName();
        this.nodeName = AdminServiceFactory.getAdminService().getNodeName();
        this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
        Properties properties = new Properties();
        properties.setProperty("diagnosticProvider", "true");
        try {
            this.mbeanFactory.activateMBean("NodeAgent", this, "NodeAgent", null, properties);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.nodeagent.NodeAgent.initialize", "171", this);
        }
        this.discoveryMBeanListenerRegistration();
        this.listenForJ2EEStateStoppingNotifications();
        this.listenForSyncStartAndCompleteNofications();
        this.loadMonitoringPolicies();
        DiagnosticProviderHelper.registerMBeanWithDiagnosticService(sDPName, this.getObjectName());
        this.isInitialized = true;
        instance = this;
        if (this.ZOS) {
            this.createMVSServicesMBean();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public static NodeAgent getInstance() {
        return instance;
    }

    protected String getNodeName() {
        return this.nodeName;
    }

    private String getPid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPid", string);
        }
        String string2 = "<null>";
        String string3 = this.getAdoptedChildPid(string);
        if (string3 == null) {
            string3 = this.getLaunchedChildPid(string);
            if (string3 == null) {
                string3 = this.getFilePid(string);
                if (string3 != null) {
                    string2 = "file";
                }
            } else {
                string2 = "launched";
            }
        } else {
            string2 = "adopted";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPid", new String[]{"pid=" + string3, "pidType=" + string2});
        }
        return string3;
    }

    public boolean terminate(String string) throws AdminException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminate", string);
        }
        try {
            if (this.getProcessStatus(string).equals("STOPPED")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminate", "true");
                }
                this.sendNotification("websphere.process.stopped", string);
                return true;
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Threw exception " + throwable.getMessage());
            }
            throw Utils.makeAdminException(throwable);
        }
        Process process = null;
        boolean bl = false;
        String string2 = string;
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(string2);
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        PidWaiter pidWaiter = null;
        if (this.pidWaiterHashMap.containsKey(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + string + " in pidWaiterHashMap");
            }
            pidWaiter = (PidWaiter)this.pidWaiterHashMap.get(string);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Did NOT find " + string + " in pidWaiterHashMap");
        }
        boolean bl2 = false;
        String string3 = this.getPid(string2);
        if (string3 != null && (object = this.getLaunchedChildPid(string2)) != null) {
            bl2 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pid in launched set is " + string3);
            }
        }
        if (this.ZOS) {
            object = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "terminating ZOS process: " + serverIdentifiers.getServerName());
            }
            try {
                String string4;
                boolean bl3;
                block63: {
                    if (pidWaiter != null) {
                        pidWaiter.setProcessIsTerminated(true);
                        this.pidWaiterHashMap.remove(string);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removed " + string + " from pidWaiterHashMap");
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "issuing stopImmediate first");
                    }
                    ProcessTerminator processTerminator = new ProcessTerminator(serverIdentifiers);
                    processTerminator.setStopMode(true);
                    processTerminator.terminate();
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        Tr.debug(tc, "ThreadInterrupted Exception ", exception);
                    }
                    bl3 = false;
                    boolean bl4 = false;
                    string4 = null;
                    if (string3 != null) {
                        block61: {
                            try {
                                object = ProcessFactory.bindTo(string3);
                            }
                            catch (ProcessOpException processOpException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Could not bind to Process, so stopImmediate succeeded.");
                                }
                                if (pidWaiter != null) break block61;
                                bl3 = true;
                                string4 = new String("websphere.process.stopped");
                            }
                        }
                        if (object != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Bound to Process, so stopImmediate failed.");
                            }
                            bl4 = true;
                            if (pidWaiter == null) {
                                bl3 = true;
                                string4 = new String("websphere.process.not.monitored");
                            }
                        }
                    } else {
                        bl4 = true;
                        bl3 = true;
                        string4 = new String("websphere.process.not.monitored");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "sending NOT_MONITORED");
                        }
                    }
                    if (bl4) {
                        block62: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "issuing force");
                            }
                            processTerminator.setStopMode(false);
                            processTerminator.setForceMode(true);
                            try {
                                processTerminator.terminate();
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) break block62;
                                Tr.debug(tc, "terminate failed but is ignored");
                            }
                        }
                        if (object != null) {
                            try {
                                object.waitForTermination(20);
                            }
                            catch (ProcessStillActiveException processStillActiveException) {
                                if (!tc.isDebugEnabled()) break block63;
                                Tr.debug(tc, "waitForTermination failed but is ignored");
                            }
                        }
                    }
                }
                if (bl3) {
                    this.sendNotification(string4, string2);
                }
                if (nacache != null) {
                    nacache.removeFromCache(0, string2);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminate", "true");
                }
                return true;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminate", "false");
                }
                throw new AdminException(exception, "Process " + string2 + " failed to terminate");
            }
        }
        try {
            block65: {
                block64: {
                    if (string3 == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "terminate", "false");
                        }
                        return false;
                    }
                    process = ProcessFactory.bindTo(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "send stopping notification for server " + string + "for pid: " + string3);
                    }
                    this.sendNotification("websphere.process.stopping", string);
                    if (pidWaiter != null) {
                        pidWaiter.setProcessIsTerminated(true);
                        this.pidWaiterHashMap.remove(string);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removed " + string + " from pidWaiterHashMap");
                        }
                    }
                    object = new StopParams();
                    ((StopParams)object).setProcessID(string3);
                    ((StopParams)object).setStopMode(1);
                    try {
                        ProcessFactory.terminate((StopParams)object);
                    }
                    catch (ProcessStillActiveException processStillActiveException) {
                        if (!tc.isDebugEnabled()) break block64;
                        Tr.debug(tc, "ProcessFactory.terminate failed but is ignored");
                    }
                }
                try {
                    process.waitForTermination();
                }
                catch (ProcessStillActiveException processStillActiveException) {
                    if (!tc.isDebugEnabled()) break block65;
                    Tr.debug(tc, "ProcessFactory.terminate failed but is ignored");
                }
            }
            if (this.getProcessStatus(string).equals("STOPPED")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "send stopped notification for server " + string + "for pid: " + string3);
                }
                this.removeLaunchedChild(string, string3);
                this.sendNotification("websphere.process.stopped", string);
                if (GenericServerProcHelper.isServerAGenericServer(serverIdentifiers) || GenericServerProcHelper.isServerAnIHSServer(serverIdentifiers)) {
                    GenericServerProcHelper.removeFileContainingPid(serverIdentifiers);
                }
                bl = true;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server " + string + " and pid " + string3 + " did not stop");
                }
                bl = false;
                if (pidWaiter == null) {
                    this.sendNotification("websphere.process.not.monitored", string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sending NOT_MONITORED");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Threw exception " + throwable.getMessage());
            }
            throw Utils.makeAdminException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminate", new Boolean(bl));
        }
        return bl;
    }

    public int stopProcess(String string) throws AdminException {
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(string);
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        if (this.ZOS) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ZOS stopProcess()");
                }
                ProcessTerminator processTerminator = new ProcessTerminator(serverIdentifiers);
                processTerminator.terminate();
                return 0;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.launchProcess", "298", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in NodeAgent.terminate:", exception);
                }
                throw new AdminException("Process failed to terminate: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopProcess", string);
        }
        try {
            if (!GenericServerProcHelper.isServerAnIHSServer(serverIdentifiers) && this.getProcessStatus(string).equals("STOPPED")) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        boolean bl = false;
        int n = GenericServerProcHelper.stopArbitraryServerProcess(serverIdentifiers);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopProcess");
        }
        return n;
    }

    private boolean isServerRunning(Repository repository2, String string) throws Exception {
        boolean bl;
        block20: {
            Object object;
            Object object2;
            Object object3;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isServerRunning", string);
            }
            bl = false;
            Object object4 = null;
            Resource resource = null;
            Resource resource2 = repository2.getConfigRoot().getResource(3, "serverindex.xml");
            ServerIndex serverIndex = (ServerIndex)resource2.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerIndex ", serverIndex);
            }
            EList eList = serverIndex.getServerEntries();
            ConfigRoot configRoot = repository2.getConfigRoot();
            resource = configRoot.getResource(4, "server.xml");
            Server server2 = this.getServer(resource);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server", server2);
            }
            this.retrieveConnectorType(string, server2);
            String string2 = this.getServerConnectorType(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorType: " + string2);
            }
            if (string2 != null) {
                String string3 = null;
                if (string2.equals("SOAP")) {
                    string3 = "SOAP_CONNECTOR_ADDRESS";
                } else if (string2.equals("RMI")) {
                    string3 = "BOOTSTRAP_ADDRESS";
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected endpoint", string2);
                }
                if (string3 != null) {
                    for (int i = 0; i < eList.size(); ++i) {
                        object3 = (ServerEntry)eList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ServerEntry", object3);
                        }
                        if (!object3.getServerName().equals(string)) continue;
                        object2 = object3.getSpecialEndpoints();
                        for (int j = 0; j < object2.size(); ++j) {
                            object = (NamedEndPoint)object2.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "NamedEndPoint", object);
                            }
                            if (!object.getEndPointName().equals(string3) || object4 != null) continue;
                            object4 = object;
                        }
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverNamedEndPoint: " + object4);
            }
            if (object4 != null) {
                int n = object4.getEndPoint().getPort();
                String string4 = object4.getEndPoint().getHost();
                try {
                    object3 = string4.equals("*") ? new Socket((String)null, n) : new Socket(string4, n);
                    bl = true;
                    ((Socket)object3).close();
                    object2 = new Integer(n).toString();
                    String string5 = TraceNLS.getStringFromBundle(BUNDLE_NAME, "ADMU3028I", (String)null);
                    object = TraceNLS.getFormattedMessageFromLocalizedMessage(string5, new Object[]{object2, string}, true);
                    Tr.warning(tc, (String)object);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.isServerRunning", "842", this);
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "Exception occured while opening a socket");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerRunning", new Boolean(bl));
        }
        return bl;
    }

    public boolean launchProcess(String string) throws AdminException {
        Integer n = null;
        String string2 = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout");
        if (string2 == null || string2.length() < 0) {
            string2 = AdminHelper.getPlatformHelper().isZOS() ? DEFAULT_LAUNCH_TIMEOUT_ZOS : DEFAULT_LAUNCH_TIMEOUT;
        }
        try {
            n = new Integer(string2);
        }
        catch (Throwable throwable) {
            n = this.ZOS ? DEFAULT_LAUNCH_TIMEOUT_INTEGER_ZOS : DEFAULT_LAUNCH_TIMEOUT_INTEGER;
        }
        return this.launchProcess(string, n);
    }

    public boolean launchProcess(String string, Integer n) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "launchProcess", string);
        }
        int n2 = n;
        boolean bl = false;
        Integer n3 = null;
        boolean bl2 = true;
        String string2 = null;
        String string3 = this.repositoryRootURI;
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(string);
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        this.launchProcessPart1(string);
        try {
            if (GenericServerProcHelper.isServerAGenericServer(serverIdentifiers) && this.getProcessStatus(string).equals("RUNNING")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        String string4 = System.getProperty("disableCheckForServerReady");
        boolean bl3 = !"true".equals(string4);
        int n4 = 1;
        if (bl3) {
            Tr.debug(tc, "waiting for app-bin expansion feature is ENABLED");
        } else {
            Tr.debug(tc, "waiting for app-bin expansion feature is DISABLED");
        }
        while (isSyncInProgress && bl3) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " launchProcess: wait for " + n4 + " time");
                }
                Thread.sleep(500L);
                ++n4;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "launchProcess: isSyncInProgress " + isSyncInProgress);
        }
        if (bl3) {
            CommonAppUtils.waitForAppExpansion(string, this.nodeName, this.cellName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "launchProcess: After calling waitForAppExpansion");
        }
        ConfigRoot configRoot = this.repository.getConfigRoot();
        String string5 = configRoot.setValue(4, string);
        Resource resource = null;
        try {
            int n5;
            resource = configRoot.getResource(4, "server.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess  resource :" + resource);
            }
            Server server2 = this.getServer(resource);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess  server :" + server2);
            }
            String string6 = server2.getClusterName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess Cluster  :" + string6);
            }
            if (string6 == null || string6.length() > 0) {
                // empty if block
            }
            Repository repository2 = RepositoryFactory.createRepository("ws-server", serverIdentifiers.getConfigRoot(), serverIdentifiers.getCellName(), serverIdentifiers.getNodeName(), serverIdentifiers.getServerName(), string6);
            VariableMap variableMap = VariableMapFactory.createVariableMap(repository2);
            variableMap.initialize(null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sid = " + serverIdentifiers.toString());
            }
            LaunchCommand launchCommand = new LaunchCommand(repository2, variableMap, serverIdentifiers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Launching a new server process: " + serverIdentifiers.getServerName());
            }
            this.sendNotification("websphere.process.starting", string);
            ServerSocket serverSocket = null;
            bl2 = true;
            if (GenericServerProcHelper.isServerAGenericServer(serverIdentifiers) || GenericServerProcHelper.isServerAnIHSServer(serverIdentifiers)) {
                bl2 = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wait for server init = " + bl2);
            }
            if (bl2 && (serverSocket = this.getFreePort(n2 * 1000)) != null) {
                n3 = new Integer(serverSocket.getLocalPort());
                launchCommand.setStatusSocketPort(n3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "status socket = " + n3.toString());
                }
            }
            if (this.isServerRunning(this.repository, serverIdentifiers.getServerName())) {
                throw new AdminException(NodeAgent.getFormattedMessage("ADMU3027E", null, null));
            }
            Process process = launchCommand.launchProcess();
            string2 = process.id();
            GenericServerProcHelper.savePidToFile(string2, serverIdentifiers);
            string2 = string2.toUpperCase();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Launched process pid: " + string2);
            }
            this.addLaunchedChild(string, string2);
            int n6 = 1;
            if (bl2) {
                n6 = serverSocket.getLocalPort();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Local port = " + n6);
                }
            } else {
                int n7 = 5;
                for (n5 = 0; this.getProcessStatus(string).equals("STOPPED") && n5 < n7; ++n5) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Generic Server " + string + " not yet started, wait(ms): " + n2);
                    }
                    Thread.sleep(n2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing as generic server. ");
                }
            }
            new ProcessWatcher(process, n6, n2);
            n5 = -2;
            if (serverSocket != null) {
                n5 = this.waitForServerInit(serverSocket);
            } else if (this.getProcessStatus(string).equals("RUNNING") && !bl2) {
                this.sendNotification("websphere.process.running", string);
                this.setFilePid(string, string2);
                n5 = 0;
            } else if (this.getProcessStatus(string).equals("STOPPED") && !bl2) {
                this.sendNotification("websphere.process.stopped", string);
            }
            if (n5 == 0) {
                if (nacache != null) {
                    nacache.addToCache(0, string, "j2ee.state.running");
                }
                Tr.audit(tc, "ADML0000I", new Object[]{string2});
                bl = true;
            } else {
                if (n5 == -1) {
                    this.sendNotification("websphere.process.failed", string);
                    Tr.warning(tc, "ADML0011E");
                    throw new AdminException(NodeAgent.getFormattedMessage("ADML0011E", null, null));
                }
                if (n5 == 0) {
                    Tr.warning(tc, "ADML0011E");
                    throw new AdminException(NodeAgent.getFormattedMessage("ADML0011E", null, null));
                }
                String string7 = new Integer(n2).toString();
                Tr.warning(tc, "ADML0040E", new Object[]{string, string7});
            }
            if (bl) {
                this.addProcessHandler(string, string2, process);
            } else {
                this.removeLaunchedChild(string, string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processName = " + string + " pid = " + string2 + " status = " + n5 + " - started = " + bl + " wait = " + bl2);
            }
        }
        catch (Exception exception) {
            if (string2 != null) {
                this.removeLaunchedChild(string, string2);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.launchProcess", "298", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in LaunchCommand.launchProcess():", exception);
            }
            throw new AdminException("Process failed to launch: " + string);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "launchProcess", new Boolean(bl));
            }
        }
        return bl;
    }

    private void launchProcessPart1(String string) throws AdminException {
        AdminHelper.getInstance().audit("ADMN1000I", "ADMN1001I", new Object[]{string, this.nodeName, null});
        if (!this.serverExists(this.cellName, this.nodeName, string)) {
            throw new AdminException("Server, " + string + ", not found.");
        }
        boolean bl = false;
        try {
            bl = NodeSync.getNodeSync().syncForServerStartup();
        }
        catch (Exception exception) {
            Tr.error(tc, exception.getMessage());
        }
        if (!bl) {
            Tr.warning(tc, "ADML0065W");
        }
    }

    public String getProcessStatus(String string) throws IllegalArgumentException, AdminException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessStatus", string);
        }
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(string);
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        String string2 = GenericServerProcHelper.getStatusUsingPidFile(serverIdentifiers);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessStatus", string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFilePid(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilePid", string2);
        }
        String string3 = this.variableMap.expand("${LOG_ROOT}/" + string + "/" + string + ".pid");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid = " + string2 + " to be saved in " + string3);
        }
        if (string2 != null) {
            File file = new File(string3);
            file.getParentFile().mkdirs();
            OutputStream outputStream = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                outputStream = new FileOutputStream(file);
                ((FileOutputStream)outputStream).write(string2.getBytes());
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.writeFile", "732", this);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).close();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.writeFile", "744", this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilePid");
        }
    }

    String getFilePid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFilePid", string);
        }
        String string2 = this.getCurrentPid(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid from file found: " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFilePid", string2);
        }
        return string2;
    }

    private boolean isGenericServer(ProcessDef processDef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGenericServer");
        }
        boolean bl = false;
        String string = processDef.getExecutableName();
        if (string != null) {
            JavaProcessDef javaProcessDef;
            if ((string = string.trim()).indexOf("java") < 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGenericServer");
                }
                return true;
            }
            if (processDef instanceof JavaProcessDef && (javaProcessDef = (JavaProcessDef)processDef).getExecutableTarget() != null && !javaProcessDef.getExecutableTarget().equals(WSSERVER_CLASS)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGenericServer");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGenericServer");
        }
        return bl;
    }

    private boolean serverExists(String string, String string2, String string3) throws AdminException {
        String string4;
        ConfigRepository configRepository = this.getLocalRepository();
        String[] stringArray = configRepository.listResourceNames(string4 = ConfigStructureHelper.getURI(string, string2, string3, "server.xml"), 1, 0);
        return stringArray.length != 0;
    }

    private synchronized ConfigRepository getLocalRepository() throws AdminException {
        ConfigRepository configRepository;
        Properties properties = new Properties();
        properties.setProperty("location", "local");
        try {
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.getLocalRepository", "427", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in ConfigRepositoryClientFactory.getConfigRepositoryClient():", exception);
            }
            throw new AdminException(exception, "Unable to create repository client: " + exception);
        }
        return configRepository;
    }

    private Notification createNotification(String string, String string2) {
        Notification notification = new Notification(string, this.getObjectName(), this.ntfySeqNum++);
        Properties properties = new Properties();
        properties.setProperty("processName", string2);
        notification.setUserData(properties);
        return notification;
    }

    public void bindMBean(ModelMBeanInfo modelMBeanInfo, ModelMBean modelMBean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMBean");
        }
        super.bindMBean(modelMBeanInfo, modelMBean);
        if (modelMBeanInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "info:", modelMBeanInfo);
            }
            Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mBeanDescriptor", descriptor);
            }
            String string = "NodeAgent";
            descriptor.setField("displayName", string);
            String string2 = (String)descriptor.getFieldValue("type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type:" + string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindMBean");
        }
    }

    private ServerSocket getFreePort(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            serverSocket.setSoTimeout(n);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.getFreePort", "349", this);
            Tr.error(tc, "ADML0012E", iOException);
        }
        return serverSocket;
    }

    private int waitForServerInit(ServerSocket serverSocket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForServerInit");
        }
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                FFDCFilter.processException((Throwable)interruptedIOException, "com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", "368", this);
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.waitForServerInit", "374", this);
                Tr.error(tc, "ADML0009E", iOException);
                socket = null;
                bl = true;
                n = -1;
            }
            if (socket == null || (n = this.getStatus(socket)) != 0 && n != 0 && n != -1) continue;
            bl = true;
        }
        if (!bl) {
            n = -2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForServerInit");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStatus(Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus");
        }
        int n = -1;
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = socket.getInputStream();
            filterInputStream = new DataInputStream(inputStream);
            n = ((DataInputStream)filterInputStream).readInt();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.getStatus", "414", this);
            Tr.error(tc, "ADML0009E", iOException);
            int n2 = -1;
            return n2;
        }
        finally {
            try {
                filterInputStream.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.getStatus", "425", this);
                Tr.error(tc, "ADML0009E", iOException);
            }
            filterInputStream = null;
            inputStream = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus");
        }
        return n;
    }

    private static String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = nls.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException(nullPointerException, "com.ibm.ws.management.nodeagent.NodeAgent.getFormattedMessage", "449");
            return string2;
        }
    }

    public void stopNode() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNode");
        }
        AdminHelper.getInstance().audit("ADMN1002I", "ADMN1003I", new Object[]{this.nodeName, null});
        boolean bl = true;
        Object var2_2 = null;
        Vector vector = null;
        try {
            vector = this.getServers();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.stopNode", "471", this);
            throw new AdminException(exception, "An problem occurred during stopNode processing: ");
        }
        this.saveNodeState(false, false);
        this.isBeingCalledByStopNodeMethod = true;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                this.sendStop(string, false);
            }
        }
        this.sendStop(AdminHelper.getInstance().getNodeAgentName(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNode");
        }
    }

    private boolean sendStop(String string, boolean bl) {
        boolean bl2;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendStop", string);
            }
            bl2 = true;
            try {
                ObjectName objectName = this.getServerObjectName(string);
                if (objectName == null) break block11;
                if (bl && objectName.getKeyProperty("processType").equalsIgnoreCase("NodeAgent") || !bl && !objectName.getKeyProperty("processType").equalsIgnoreCase("NodeAgent")) {
                    String string2 = "stop";
                    try {
                        Object[] objectArray = null;
                        String[] stringArray = null;
                        int n = 600;
                        ServerSocket serverSocket = this.getFreePort(n * 1000);
                        Integer n2 = null;
                        if (serverSocket != null) {
                            if (!bl) {
                                n2 = new Integer(serverSocket.getLocalPort());
                            }
                            objectArray = new Object[]{Boolean.TRUE, n2};
                            stringArray = new String[]{"java.lang.Boolean", "java.lang.Integer"};
                        }
                        Object object = this.getAdminService().invoke(objectName, string2, objectArray, stringArray);
                        if (bl) break block11;
                        int n3 = -2;
                        if (serverSocket != null) {
                            n3 = this.waitForServerInit(serverSocket);
                        }
                        if (n3 != 0) {
                            Tr.warning(tc, "ADML0111E");
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        Tr.error(tc, "ADML0019E", exception);
                    }
                    break block11;
                }
                bl2 = false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.sendStop", "557", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendStop", string);
        }
        return bl2;
    }

    private ObjectName getServerObjectName(String string) {
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        try {
            objectName2 = new ObjectName("WebSphere:*,type=Server,process=" + string + ",node=" + this.nodeName);
            Set set = this.getAdminService().queryNames(objectName2, null);
            if (set.size() != 1 && tc.isDebugEnabled()) {
                Tr.debug(tc, "There are " + set.size() + " Servers! queryName=" + objectName2);
            }
            if (set.size() > 0) {
                Object[] objectArray = set.toArray();
                objectName = (ObjectName)objectArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server handle is ==> " + objectName.getCanonicalName());
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.getServerObjectName", "593", this);
            Tr.error(tc, "ADML0523E", new Object[]{objectName2, exception});
        }
        return objectName;
    }

    private Vector getServers() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.repositoryRootURI + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            String string2 = fileArray[i].getName();
            vector.add(string2);
        }
        return vector;
    }

    private com.ibm.websphere.management.AdminService getAdminService() {
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
        }
        return this.adminService;
    }

    private void discoveryMBeanListenerRegistration() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "discoveryMBeanListenerRegistration");
            }
            try {
                String string = "WebSphere:type=Discovery,process=" + this.getAdminService().getProcessName() + ",*";
                ObjectName objectName = new ObjectName(string);
                Set set = this.adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
                this.adminService.addNotificationListener(objectName, this, null, (Object)DISCOVERY_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.nodeagent.NodeAgent.registerToDiscoveryMBean", "646", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "can not register as a listener to DiscoveryMBean", jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discoveryMBeanListenerRegistration");
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        try {
            com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = new ObjectName("WebSphere:*,type=Server,processType=ManagedProcess");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.stopping");
            adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, STOPPING_LISTENER);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.nodeagent.NodeAgent.listenForJ2EEStateStoppingNotifications", "666", this);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        String string = notification.getType();
        if (object.equals(DISCOVERY_LISTENER)) {
            if (string.equals("websphere.discovery.process.found")) {
                Properties properties = (Properties)notification.getUserData();
                String string2 = properties.getProperty("processName");
                String string3 = properties.getProperty("processId");
                boolean bl = this.containLaunchedChild(string2, string3);
                try {
                    this.monitorProcess(string2, string3, !bl);
                }
                catch (ProcessOpException processOpException) {
                    Tr.error(tc, "ADML0056E", new Object[]{string2, string3, processOpException.getMessage()});
                }
            }
        } else if (object.equals(STOPPING_LISTENER)) {
            if (string.equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "j2ee.state.stopping notification received");
                }
                this.sendNotification("websphere.process.stopping", ((ObjectName)notification.getSource()).getKeyProperty("name"));
            }
        } else if (object.equals(SYNC_LISTENER)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess : Sync Event received ");
            }
            if (string.equals("websphere.nodesync.initiated")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess : NodeSync Initiated");
                }
                isSyncInProgress = true;
            }
            if (string.equals("websphere.nodesync.complete")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launchProcess : NodeSync Complete");
                }
                isSyncInProgress = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void adoptChildProcess(String string, String string2) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adoptChildProcess", new Object[]{string, string2});
        }
        if (this.containAdoptedChild(string, string2)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "already adopted", string);
            }
            return;
        }
        Process process = null;
        process = ProcessFactory.bindTo(string2);
        this.addProcessHandler(string, string2, process);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adoptChildProcess", new Object[]{string, string2});
        }
    }

    private void monitorProcess(String string, String string2, boolean bl) throws ProcessOpException {
        Process process;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorProcess", new Object[]{string, string2, new Boolean(bl)});
        }
        if ((process = this.removeProcessHandler(string, string2)) != null) {
            try {
                process.isAlive();
            }
            catch (ProcessOpException processOpException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "process not alive", processOpException);
                }
                process = null;
            }
        }
        if (process == null) {
            try {
                process = ProcessFactory.bindTo(string2);
                bl = true;
            }
            catch (ProcessOpException processOpException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can not bind to process", processOpException);
                }
                if (this.ZOS) {
                    new MonitorProcess(string, string2, bl).start();
                    return;
                }
                throw processOpException;
            }
            if (bl) {
                this.addAdoptedChild(string, string2);
            }
        }
        if (process != null) {
            String string3 = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout");
            if (string3 == null || string3.length() < 0) {
                string3 = this.ZOS ? DEFAULT_LAUNCH_TIMEOUT_ZOS : DEFAULT_LAUNCH_TIMEOUT;
            }
            int n = Integer.parseInt(string3);
            PidWaiter pidWaiter = new PidWaiter(this, process, string2, this.variableMap, string, n, bl);
            if (this.ZOS) {
                Thread thread = new Thread(pidWaiter);
                thread.setDaemon(true);
                thread.start();
            } else {
                new Thread(pidWaiter).start();
            }
            this.pidWaiterHashMap.put(string, pidWaiter);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Added " + string + " to pidWaiterHashMap");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorProcess");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProcessHandler(String string, String string2, Process process) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "addProcessHandler", new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        HashMap hashMap = this.processHandlers;
        synchronized (hashMap) {
            this.processHandlers.put(string3, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process removeProcessHandler(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "removeProcessHandler", new Object[]{string, string2});
        }
        String string3 = string + ":" + string2;
        Process process = null;
        HashMap hashMap = this.processHandlers;
        synchronized (hashMap) {
            process = (Process)this.processHandlers.remove(string3);
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLaunchedChild(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "addLaunchedChild", new Object[]{"serverName=" + string, "pid=" + string2});
        }
        boolean bl = false;
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            String string3 = (String)this.launchedChildren.get(string);
            if (string3 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replacing old launched child: " + string + ":" + string3);
                }
                bl = true;
            }
            this.launchedChildren.put(string, string2);
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAdoptedChild(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "addAdoptedChild", new Object[]{"serverName=" + string, "pid=" + string2});
        }
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            String string3 = (String)this.adoptedChildren.get(string);
            if (string3 != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing old adopted child: " + string + ": " + string3);
            }
            this.adoptedChildren.put(string, string2);
        }
        if (nacache != null) {
            nacache.addToCache(0, string, "j2ee.state.running");
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLaunchedChild(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeLaunchedChild", new Object[]{string, string2});
        }
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            String string3 = (String)this.launchedChildren.remove(string);
            if (string3 != null) {
                if (string3.equals(string2)) {
                    this.launchedChildren.remove(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removeLaunchedChild", "Entry deleted.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeLaunchedChild", "Entry not deleted--pid mismatch. entryPid=" + string3);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeLaunchedChild", "Entry not found.");
            }
        }
        if (nacache != null) {
            nacache.removeFromCache(0, string);
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAdoptedChild(String string, String string2) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "removeAdoptedChild", new Object[]{"serverName=" + string, "pid=" + string2});
        }
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            String string3 = (String)this.adoptedChildren.remove(string);
            if (string3 != null) {
                if (string3.equals(string2)) {
                    this.adoptedChildren.remove(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "removeAdoptedChild", "Entry deleted.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeAdoptedChild", "Entry not deleted--pid mismatch. entryPid=" + string3);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeAdoptedChild", "Entry not found.");
            }
        }
        if (nacache != null) {
            nacache.removeFromCache(0, string);
        }
        this.saveNodeState(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLaunchedChildPid(String string) {
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            return (String)this.launchedChildren.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAdoptedChildPid(String string) {
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            return (String)this.adoptedChildren.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containAdoptedChild(String string, String string2) {
        String string3;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "containAdoptedChild", new Object[]{"serverName=" + string, "pid=" + string2});
        }
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            string3 = (String)this.adoptedChildren.get(string);
        }
        return string3 != null && string3.equals(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containLaunchedChild(String string, String string2) {
        String string3;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "containLaunchedChild", new Object[]{string, string2});
        }
        HashMap hashMap = this.launchedChildren;
        synchronized (hashMap) {
            string3 = (String)this.launchedChildren.get(string);
        }
        return string3 != null && string3.equals(string2);
    }

    private void loadMonitoringPolicies() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMonitoringPolicies");
        }
        Vector vector = null;
        MonitorConfig monitorConfig = null;
        try {
            vector = this.getServers();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", "838", this);
        }
        if (vector == null) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(AdminHelper.getInstance().getNodeAgentName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "load monitoring policy for server:", string);
            }
            if (this.ZOS) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "load390MonitoringPolicies");
                }
                monitorConfig = this.load390ServerMonitoringPolicy(string);
            } else {
                monitorConfig = this.loadServerMonitoringPolicy(string);
            }
            if (monitorConfig == null) continue;
            this.monitoringPolicies.put(string, monitorConfig);
        }
        this.loadNodeState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMonitoringPolicies");
        }
    }

    HashMap getMonitoringPolicies() {
        return this.monitoringPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MonitorConfig loadServerMonitoringPolicy(String string) {
        Resource resource = null;
        MonitorConfig monitorConfig = null;
        ConfigRoot configRoot = this.repository.getConfigRoot();
        String string2 = configRoot.setValue(4, string);
        try {
            resource = configRoot.getResource(4, "server.xml");
            Server server2 = this.getServer(resource);
            this.retrieveConnectorType(string, server2);
            ProcessDef processDef = null;
            EList eList = server2.getProcessDefinitions();
            int n = eList.size();
            String string3 = null;
            for (int i = 0; !(i >= n || (string3 = (processDef = (ProcessDef)eList.get(i)).getProcessType()) != null && (this.ZOS ? string3.equalsIgnoreCase("Control") : string3.equalsIgnoreCase("Single"))); ++i) {
            }
            if (processDef == null) {
                processDef = server2.getProcessDefinition();
            }
            if (processDef == null) {
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML0065E", null, null));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeAgent: ProcessDef: " + processDef);
            }
            MonitoringPolicy monitoringPolicy = processDef.getMonitoringPolicy();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MonitoringPolicy: " + monitoringPolicy);
            }
            monitorConfig = new MonitorConfig(monitoringPolicy);
            ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
            serverIdentifiers.setConfigRoot(this.repositoryRootURI);
            serverIdentifiers.setServerName(string);
            serverIdentifiers.setNodeName(this.nodeName);
            serverIdentifiers.setCellName(this.cellName);
            if (GenericServerProcHelper.isServerAGenericServer(serverIdentifiers) || GenericServerProcHelper.isServerAWebServer(serverIdentifiers) || this.isGenericServer(processDef)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " is a generic or web server; setting state to STOPPED");
                }
                monitorConfig.setNodeRestartState(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", "896", this);
            Tr.service(tc, "ADML0062W", string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", "901", this);
        }
        finally {
            if (resource != null) {
                configRoot.remove(resource);
            }
            configRoot.setValue(4, string2);
        }
        return monitorConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MonitorConfig load390ServerMonitoringPolicy(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load390ServerMonitoringPolicy", string);
        }
        Resource resource = null;
        MonitorConfig monitorConfig = null;
        ProcessDef processDef = null;
        ConfigRoot configRoot = this.repository.getConfigRoot();
        String string2 = configRoot.setValue(4, string);
        try {
            resource = configRoot.getResource(4, "server.xml");
            Server server2 = this.getServer(resource);
            this.retrieveConnectorType(string, server2);
            EList eList = server2.getProcessDefinitions();
            int n = eList.size();
            String string3 = null;
            for (int i = 0; !(i >= n || (string3 = (processDef = (ProcessDef)eList.get(i)).getProcessType()) != null && string3.equalsIgnoreCase("Control")); ++i) {
            }
            if (processDef == null) {
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML0065E", null, null));
            }
            MonitoringPolicy monitoringPolicy = processDef.getMonitoringPolicy();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MonitoringPolicy: " + monitoringPolicy);
            }
            monitorConfig = new MonitorConfig(monitoringPolicy);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", "896", this);
            Tr.service(tc, "ADML0062W", string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", "901", this);
        }
        finally {
            if (resource != null) {
                configRoot.remove(resource);
            }
            configRoot.setValue(4, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load390ServerMonitoringPolicy", monitorConfig);
        }
        return monitorConfig;
    }

    private Server getServer(Resource resource) throws Exception {
        Server server2 = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof Server)) continue;
            server2 = (Server)e2;
        }
        return server2;
    }

    private void retrieveConnectorType(String string, Server server2) {
        EList eList = server2.getServices();
        String string2 = "SOAP";
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof AdminService)) continue;
            AdminService adminService = (AdminService)e2;
            JMXConnector jMXConnector = adminService.getPreferredConnector();
            if (jMXConnector instanceof SOAPConnector) {
                string2 = "SOAP";
                break;
            }
            if (!(jMXConnector instanceof SOAPConnector)) break;
            string2 = "RMI";
            break;
        }
        this.serverConnectorType.put(string, string2);
    }

    String getServerConnectorType(String string) {
        return (String)this.serverConnectorType.get(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "propertyChange currentState = " + string + " isRipple = " + this.isRipple);
        }
        if (string.equals("STARTED")) {
            this.bootstrapNode();
        } else if (string.equals("DESTROYED")) {
            if (this.isRipple) {
                try {
                    this.reLaunchSelf();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.loadServerMonitoringPolicy", "944", this);
                    Tr.error(tc, "ADML0059E", exception.getMessage());
                }
            } else {
                this.saveNodeState(false, false);
            }
        }
    }

    public void stopServers() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopServers");
        }
        boolean bl = true;
        Object var2_2 = null;
        Vector vector = null;
        try {
            vector = this.getServers();
        }
        catch (Exception exception) {
            Tr.debug(tc, "Error occured during stopServer", exception);
            throw new AdminException(exception, "An problem occurred during stopNode processing: ");
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                this.sendStop(string, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startServers() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServers");
        }
        Vector vector = null;
        HashMap hashMap = this.adoptedChildren;
        synchronized (hashMap) {
            this.adoptedChildren.clear();
        }
        hashMap = this.launchedChildren;
        synchronized (hashMap) {
            this.launchedChildren.clear();
        }
        this.processHandlers.clear();
        try {
            vector = this.getServers();
        }
        catch (Exception exception) {
            throw new AdminException(exception, "An problem occurred during start Server processes: ");
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "starting Server : serverName");
                }
                if (string.equals(AdminHelper.getInstance().getNodeAgentName())) continue;
                this.launchProcess(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServers");
        }
    }

    public void restart(Boolean bl, Boolean bl2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restart", new Object[]{bl, bl2});
        }
        this.isBeingCalledByRestartMethod = true;
        AdminHelper.getInstance().audit("ADMN1004I", "ADMN1005I", new Object[]{this.nodeName, null});
        this.isRipple = true;
        this.saveNodeState(bl2, true);
        if (bl.booleanValue()) {
            Boolean bl3;
            try {
                bl3 = NodeSync.getNodeSync().sync();
            }
            catch (Throwable throwable) {
                this.isRipple = false;
                this.saveNodeState(false, true);
                if (throwable instanceof AdminException) {
                    throw (AdminException)throwable;
                }
                throw new AdminException(throwable, nls.getString("ADML0057E"));
            }
            if (bl3 == null || !bl3.booleanValue()) {
                this.saveNodeState(false, true);
                this.isRipple = false;
                throw new AdminException(nls.getString("ADML0057E"));
            }
        }
        try {
            if (bl2.booleanValue()) {
                this.stopNode();
            } else {
                this.sendStop(AdminHelper.getInstance().getNodeAgentName(), true);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.nodeagent.NodeAgent.restart", "1002", this);
            Tr.error(tc, "ADML0058E");
            this.isRipple = false;
            this.saveNodeState(false, true);
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, nls.getString("ADML0058E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restart");
        }
    }

    private void listenForSyncStartAndCompleteNofications() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForSyncStartAndCompleteNofications");
        }
        try {
            com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = new ObjectName("WebSphere:type=NodeSync,*");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("websphere.nodesync.initiated");
            notificationFilterSupport.enableType("websphere.nodesync.complete");
            adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, SYNC_LISTENER);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.nodeagent.NodeAgent.listenForSyncStartAndCompleteNofications", "2461", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForSyncStartAndCompleteNofications");
        }
    }

    private void reLaunchSelf() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reLaunchSelf");
        }
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.repositoryRootURI);
        serverIdentifiers.setServerName(AdminHelper.getInstance().getNodeAgentName());
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setCellName(this.cellName);
        LaunchCommand launchCommand = new LaunchCommand(this.repository, this.variableMap, serverIdentifiers);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ZOS " + this.ZOS);
        }
        if (!this.ZOS) {
            launchCommand.launchProcess();
        } else {
            LaunchParams launchParams = launchCommand.getLaunchParams();
            String string = launchParams.getStartCommand();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Command", string);
            }
            String string2 = "";
            Vector vector = launchParams.getStartCommandArgs();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append((String)vector.get(i));
            }
            string2 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Start Command Args", string2);
            }
            if (string != null && string.trim().length() > 0) {
                PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "platformutil: " + platformUtils);
                }
                if (platformUtils != null) {
                    platformUtils.setenv("control_region_start_cmd", string + "," + string2);
                    String string3 = platformUtils.getenv("control_region_start_cmd");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "after getenv: " + string3);
                    }
                }
            }
            AdminHelper.getPlatformHelper().setRestartFlag();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reLaunchSelf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNodeState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadNodeState");
        }
        String string = this.variableMap.expand(monitorFile);
        BufferedReader bufferedReader = null;
        try {
            File file = new File(string);
            if (file.exists()) {
                String string2;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    int n = string2.indexOf(58);
                    int n2 = string2.lastIndexOf(58);
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1, n2);
                    String string5 = string2.substring(n2 + 1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pName pid force = " + string3 + " " + string4 + " " + string5);
                    }
                    this.isRestartingAllServers = Boolean.valueOf(string5);
                    MonitorConfig monitorConfig = (MonitorConfig)this.monitoringPolicies.get(string3);
                    if (monitorConfig == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "this pid is set to running");
                    }
                    monitorConfig.setPreviousState(1);
                    monitorConfig.setPid(string4);
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", "1058", this);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.loadMonitoringPolicies", "1065", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadNodeState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveNodeState(boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveNodeState");
        }
        if (this.isBeingCalledByRestartMethod && !bl2 || this.isBeingCalledByStopNodeMethod) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "saveNodeState -- no update");
            }
            return;
        }
        String string = this.variableMap.expand(monitorFile);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "restartServers = " + bl + " monitorFile = " + string);
        }
        BufferedWriter bufferedWriter = null;
        try {
            Map.Entry entry;
            Iterator iterator;
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(AdminHelper.getInstance().getNodeAgentName() + ":" + this.getOwnPid());
            if (bl) {
                bufferedWriter.write(":true");
            } else {
                bufferedWriter.write(":false");
            }
            bufferedWriter.newLine();
            HashMap hashMap = this.launchedChildren;
            synchronized (hashMap) {
                iterator = this.launchedChildren.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    bufferedWriter.write(entry.getKey() + ":" + entry.getValue());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "launchedChildren " + entry.getValue());
                    }
                    if (bl) {
                        bufferedWriter.write(":true");
                    } else {
                        bufferedWriter.write(":false");
                    }
                    bufferedWriter.newLine();
                }
            }
            hashMap = this.adoptedChildren;
            synchronized (hashMap) {
                iterator = this.adoptedChildren.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    bufferedWriter.write(entry.getKey() + ":" + entry.getValue());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adoptedChildren " + entry.getValue());
                    }
                    if (bl) {
                        bufferedWriter.write(":true");
                    } else {
                        bufferedWriter.write(":false");
                    }
                    bufferedWriter.newLine();
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.propertyChange", "1109", this);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.propertyChange", "1119", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveNodeState");
        }
    }

    private String getSavedPid(String string) {
        MonitorConfig monitorConfig = (MonitorConfig)this.monitoringPolicies.get(string);
        if (monitorConfig != null) {
            return monitorConfig.getPid();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentPid(String string) {
        String string2 = null;
        String string3 = this.variableMap.expand("${LOG_ROOT}/" + string + "/" + string + ".pid");
        File file = new File(string3);
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", "1155", this);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.NodeAgent.getCurrentPid", "1162", this);
                }
            }
        }
        return string2;
    }

    private void bootstrapNode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bootstrapNode");
        }
        NodeSync.getNodeSync().isConnected(120000L);
        Set set = this.monitoringPolicies.entrySet();
        ThreadPool threadPool = null;
        String string = System.getProperty("threadpool.maxsize");
        if (string != null) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Tr.audit(tc, "Invalid value entered for JVM custom property 'threadpool.maxsize'. All eligible application servers will be started in parallel.");
                n = -1;
            }
            if (n > 0) {
                Tr.debug(tc, "System property 'threadpool.maxsize' was found with value " + string);
                threadPool = new ThreadPool(null, 1, n);
            }
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            MonitorConfig monitorConfig = (MonitorConfig)entry.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "process monitor policy: ", new Object[]{string2, monitorConfig});
            }
            String string3 = this.getCurrentPid(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pName = " + string2 + " currentPid = " + string3);
            }
            if (string3 != null && !string3.equals(this.getOwnPid())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is already running");
                }
                try {
                    this.adoptChildProcess(string2, string3);
                }
                catch (ProcessOpException processOpException) {
                    string3 = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string2 + " must be dead");
                    }
                }
            } else {
                string3 = null;
            }
            if (string3 != null) continue;
            if (!this.ZOS) {
                String string4 = this.getSavedPid(string2);
                if (string4 != null && !string4.equals(this.getOwnPid())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "going to adopt child process");
                    }
                    try {
                        this.adoptChildProcess(string2, string4);
                    }
                    catch (ProcessOpException processOpException) {
                        string4 = null;
                    }
                } else {
                    string4 = null;
                }
                if (string4 != null) continue;
            }
            boolean bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isRestartingAllServers = " + this.isRestartingAllServers);
            }
            if (this.isRestartingAllServers) {
                if (monitorConfig.getPreviousState() == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "previousState was running");
                    }
                    bl = true;
                }
            } else {
                int n = monitorConfig.getNodeRestartState();
                switch (n) {
                    case 1: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "restartState = RUNNING");
                        }
                        bl = true;
                        break;
                    }
                    case 0: {
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "restartState = STOPPED");
                        break;
                    }
                    case 2: {
                        int n2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "restartState = PREVIOUS");
                        }
                        if ((n2 = monitorConfig.getPreviousState()) != 1) break;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "previousState = RUNNING");
                        }
                        bl = true;
                    }
                }
            }
            if (!bl) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "launching " + string2);
                }
                if (threadPool == null) {
                    Thread thread = new Thread(new ProcessLauncher(string2));
                    thread.setDaemon(true);
                    thread.start();
                    continue;
                }
                threadPool.execute(new ProcessLauncher(string2));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.nodeRestart", "2677", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "bootstrapNode: Unexpected error occured", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bootstrapNode");
        }
    }

    private String getOwnPid() {
        if (this.ownPid == null) {
            try {
                Process process = ProcessFactory.createSelf();
                String string = process.id();
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.management.nodeagent.NodeAgent.getownPid", "1269", this);
            }
        }
        return this.ownPid;
    }

    public void emitTryingToStopProcessNotification(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitTryingToStopProcessNotification", string);
        }
        try {
            ObjectName objectName = null;
            String string2 = "WebSphere:type=NodeAgent,node=" + this.nodeName + ",*";
            ObjectName objectName2 = new ObjectName(string2);
            Set set = this.adminService.queryNames(objectName2, null);
            if (set.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node agent MBean is not found");
                }
                return;
            }
            objectName = (ObjectName)set.iterator().next();
            Notification notification = new Notification("websphere.process.initiatedStopping", objectName, this.ntfySeqNum++);
            Properties properties = new Properties();
            properties.setProperty("nodeName", this.nodeName);
            properties.setProperty("processName", string);
            notification.setUserData(properties);
            this.sendNotification(notification);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception, Node agent MBean was not found");
            }
            exception.printStackTrace();
        }
    }

    void sendNotification(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendNotification", new Object[]{string, string2});
        }
        try {
            this.sendNotification(this.createNotification(string, string2));
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.nodeagent.sendNotification", "1284", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendNotification");
        }
    }

    private void createMVSServicesMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMVSServicesMBean");
        }
        boolean bl = false;
        Resource resource = null;
        Server server2 = null;
        try {
            resource = this.repository.getConfigRoot().getResource(4, "server.xml");
            server2 = this.getServer(resource);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.NodeAgent.createMVSServicesMBean", "3063", this);
        }
        if (server2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMVSServicesMBean", "Failed to file NodeAgent server object");
            }
            return;
        }
        Service service = null;
        List list = null;
        EList eList = server2.getServices();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            service = (Service)iterator.next();
            if (!(service instanceof AdminService)) continue;
            list = service.getProperties();
            break;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            if (!"com.ibm.websphere.zos.mvsservices.enable".equals(string) || !"true".equalsIgnoreCase(property.getValue())) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to activate MVSServices MBean");
            }
            try {
                this.mbeanFactory.activateMBean("MVSServices", new MVSServices(), "MVSServices", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Activated MVSServices MBean");
                }
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.component.NodeAgent.createMVSServicesMBean", "3111", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMVSServicesMBean", "enable = " + bl);
        }
    }

    protected String getRepositoryRootURI() {
        return this.repositoryRootURI;
    }

    public String getDiagnosticProviderName() {
        return sDPName;
    }

    public String getDiagnosticProviderId() {
        return this.getObjectName().toString();
    }

    public DiagnosticProviderInfo getRegisteredDiagnostics() {
        if (this.dpInfo == null) {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/ws/management/nodeagent/NodeAgentDiagnosticProvider.xml");
            this.dpInfo = DiagnosticProviderHelper.loadRegistry(inputStream, null);
        }
        return this.dpInfo;
    }

    public DiagnosticEvent[] configDump(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{string, new Boolean(bl)});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        DiagnosticTypedValue diagnosticTypedValue = new DiagnosticTypedValue(System.getProperty("os.name"), "os.name.key");
        hashMap.put(NodeAgentDiagnosticHelper.NODEAGENT_PLATFORM, diagnosticTypedValue);
        diagnosticTypedValue = new DiagnosticTypedValue(this.ZOS ? DEFAULT_LAUNCH_TIMEOUT_ZOS : DEFAULT_LAUNCH_TIMEOUT, "Launch.timeout.key");
        hashMap.put(NodeAgentDiagnosticHelper.NODEAGENT_LAUNCHTIMEOUT, diagnosticTypedValue);
        try {
            DiagnosticTypedValue.addCollectionToHashMap(hashMap, NodeAgentDiagnosticHelper.NODEAGENT_SERVERS, this.getServers(), "Nodeagent.servers.key");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception getting servers", exception);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.configDump", "2019", this);
            hashMap.put(NodeAgentDiagnosticHelper.NODEAGENT_SERVERS, exception.getMessage());
        }
        DiagnosticEvent diagnosticEvent = DiagnosticEventFactory.createConfigDump(this.getObjectName().toString(), NodeAgent.class.getName(), "configDump", hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configDump", diagnosticEvent);
        }
        return new DiagnosticEvent[]{diagnosticEvent};
    }

    public DiagnosticEvent[] stateDump(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{string, new Boolean(bl)});
        }
        HashMap hashMap = null;
        hashMap = new HashMap(2);
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.adoptedChildren.keySet());
        hashSet.addAll(this.launchedChildren.keySet());
        DiagnosticTypedValue.addCollectionToHashMap(hashMap, NodeAgentDiagnosticHelper.NODEAGENT_DISCOVERED_SERVERS, hashSet, "Nodeagent.discovered.servers.key");
        DiagnosticEvent diagnosticEvent = DiagnosticEventFactory.createStateDump(this.getObjectName().toString(), NodeAgent.class.getName(), "stateDump", hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateDump", diagnosticEvent);
        }
        return new DiagnosticEvent[]{diagnosticEvent};
    }

    public DiagnosticEvent[] selfDiagnostic(String string, boolean bl) {
        HashSet<Object> hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfDiagnostic", new Object[]{string});
        }
        HashMap<String, Object> hashMap = null;
        if (string != null && string.startsWith(NodeAgentDiagnosticHelper.NODEAGENT_PING_SERVER)) {
            Object object;
            hashMap = new HashMap<String, Object>();
            hashSet = null;
            int n = string.lastIndexOf(46);
            if (n > -1) {
                object = string.substring(n + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server", object);
                }
                if ("*".equals(object)) {
                    try {
                        hashSet = new HashSet(this.getServers());
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exception getting servers", exception);
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.selfDiagnostic", "3069", this);
                    }
                } else {
                    hashSet = new HashSet<Object>(1);
                    hashSet.add(object);
                }
            }
            object = hashSet.iterator();
            String string2 = null;
            String string3 = "j2ee.state.stopped";
            while (object.hasNext()) {
                Object object2;
                string2 = (String)object.next();
                string3 = "j2ee.state.stopped";
                try {
                    object2 = RoutingTable.getInstance().getAdminClient(string2);
                    if (object2 != null && object2.isAlive() != null) {
                        string3 = "j2ee.state.running";
                    }
                }
                catch (ConnectorException connectorException) {
                    Tr.debug(tc, "ConnectorException checking AdminClient.isAlive", connectorException);
                }
                object2 = new DiagnosticTypedValue(string3, "Nodeagent.server.state");
                hashMap.put(NodeAgentDiagnosticHelper.NODEAGENT_PING_SERVER + "." + string2, object2);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalid local id", string);
        }
        hashSet = DiagnosticEventFactory.createDiagnosticEvent(this.getObjectName().toString(), "selfDiagnostic", 10, NodeAgent.class.getName(), "selfDiagnostic", null, null, null, hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfDiagnostic", hashSet);
        }
        return new DiagnosticEvent[]{hashSet};
    }

    public String[] localize(String[] stringArray, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(DIAGNOSTIC_BUNDLE, locale);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = resourceBundle.getString(stringArray[i]);
        }
        return stringArray2;
    }

    public boolean checkNotification(Notification notification) {
        boolean bl = false;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNotification", notification);
        }
        if ((string = notification.getType()).startsWith("websphere.discovery") || string.startsWith("websphere.process")) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNotification", bl);
        }
        return bl;
    }

    static {
        nacache = null;
        SYNC_LISTENER = new Integer(2);
        isSyncInProgress = false;
    }

    class MonitorProcess
    extends Thread {
        String pName;
        String pid;
        boolean adoption;

        public MonitorProcess(String string, String string2, boolean bl) {
            this.pName = string;
            this.pid = string2;
            this.adoption = bl;
        }

        public void bindTo() throws ProcessOpException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Process Monitor run");
            }
            Process process = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    break;
                }
                try {
                    process = ProcessFactory.bindTo(this.pid);
                    this.adoption = true;
                    break;
                }
                catch (ProcessOpException processOpException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "failed to bind to process", processOpException);
                    continue;
                }
            }
            if (process != null) {
                String string;
                if (this.adoption) {
                    NodeAgent.this.addAdoptedChild(this.pName, this.pid);
                }
                if ((string = System.getProperty("com.ibm.websphere.management.nodeAgentLaunchTimeout")) == null || string.length() < 0) {
                    string = AdminHelper.getPlatformHelper().isZOS() ? NodeAgent.DEFAULT_LAUNCH_TIMEOUT_ZOS : NodeAgent.DEFAULT_LAUNCH_TIMEOUT;
                }
                int n = Integer.parseInt(string);
                Thread thread = new Thread(new PidWaiter(NodeAgent.this, process, this.pid, NodeAgent.this.variableMap, this.pName, n, this.adoption));
                thread.setDaemon(true);
                thread.start();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Process Monitor exit");
            }
        }

        public void run() {
            try {
                this.bindTo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ProcessLauncher
    extends Thread {
        private String serverName = null;

        public ProcessLauncher(String string) {
            this.serverName = string;
        }

        public void run() {
            block4: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "Process Launcher run");
                }
                try {
                    NodeAgent.this.launchProcess(this.serverName);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "Error during starting server", this.serverName);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ProcessLauncher run");
            }
        }
    }

    class ProcessWatcher
    extends Thread {
        Process process;
        int statusSocketPort;
        int timeout;

        public ProcessWatcher(Process process, int n, int n2) {
            this.process = process;
            this.statusSocketPort = n;
            this.timeout = n2;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            block25: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "timeout in run = " + this.timeout);
                }
                try {
                    if (this.process.isAlive()) {
                        block24: {
                            try {
                                this.process.waitForTermination(this.timeout);
                            }
                            catch (ProcessStillActiveException processStillActiveException) {
                                if (!tc.isDebugEnabled()) break block24;
                                Tr.debug(tc, "process " + this.process.id() + " is still running", processStillActiveException);
                            }
                        }
                        if (!this.process.isAlive()) {
                            bl = true;
                        }
                        break block25;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block25;
                    Tr.debug(tc, "can not determine whether process is alive", exception);
                }
            }
            if (bl) {
                FilterOutputStream filterOutputStream = null;
                Socket socket = null;
                try {
                    socket = new Socket("localhost", this.statusSocketPort);
                    filterOutputStream = new DataOutputStream(socket.getOutputStream());
                    ((DataOutputStream)filterOutputStream).writeInt(-1);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "failed to write back INIT_FAILED", exception);
                    }
                }
                finally {
                    try {
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }
}

