/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.nodeagent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.nodeagent.MonitorConfig;
import com.ibm.ws.management.nodeagent.NodeAgent;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.exception.ProcessStillActiveException;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

class PidWaiter
implements Runnable,
NotificationListener,
AlarmListener {
    private static final String resBundleName = "com.ibm.ws.management.resources.launcher";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.launcher");
    private static TraceComponent tc = Tr.register(PidWaiter.class, "Admin", "com.ibm.ws.management.resources.launcher");
    private Process p = null;
    private String pid;
    private String processName = null;
    private String processNameIntiatedForStop = null;
    private int timeout = 0;
    private NodeAgent agent;
    private HashMap monitoringPolicies;
    private static VariableMap variableMap;
    private MonitorConfig cfg;
    private boolean processStopping = false;
    private Session session;
    private int processAliveTimeout = 20;
    private boolean zos = false;
    private boolean processIsTerminated = false;
    private ObjectName serverON = null;
    private Alarm contactAlarm = null;
    private static Integer CONTACT_ALARM_CONTEXT;
    private static String CONTACT_ALARM_TIMEOUT_PROP;
    private int pingInterval = 0;

    PidWaiter(NodeAgent nodeAgent, Process process, String string, VariableMap variableMap, String string2, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PidWaiter", string);
        }
        this.agent = nodeAgent;
        this.p = process;
        this.pid = string;
        PidWaiter.variableMap = variableMap;
        this.processName = string2;
        this.timeout = n;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
        StatusCache statusCache = StatusCacheFactory.getStatusCache();
        Integer n2 = Integer.getInteger("com.ibm.websphere.management.timeout.processAlive");
        if (n2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + string + ": processAlive Timeout " + n2);
            }
            this.processAliveTimeout = n2;
        }
        this.monitoringPolicies = nodeAgent.getMonitoringPolicies();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + string + ": adopted Child " + string2);
            }
            nodeAgent.addAdoptedChild(string2, string);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + string + ": launched Child " + string2 + ":pid: " + string);
            }
            nodeAgent.addLaunchedChild(string2, string);
            if (statusCache != null) {
                statusCache.addToCache(0, string2, "j2ee.state.running");
            }
        }
        this.listenForInitiatedStoppingNotifications();
        this.listenForJ2EEStateStoppingNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PidWaiter", string);
        }
    }

    private void listenForInitiatedStoppingNotifications() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForInitiatedStoppingNotifications" + this.pid);
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = null;
            objectName = new ObjectName("WebSphere:type=NodeAgent,node=" + this.agent.getNodeName() + ",*");
            adminService.addNotificationListenerExtended(objectName, this, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForInitiatedStoppingNotifications", this.pid);
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForJ2EEStateStoppingNotifications", this.pid);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("j2ee.state.stopping");
        adminService.addNotificationListenerExtended(this.createServerObjectName(), this, notificationFilterSupport, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForJ2EEStateStoppingNotifications", this.pid);
        }
    }

    private void removeJ2EEStateStoppingListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeJ2EEStateStoppingListener", this.pid);
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            adminService.removeNotificationListenerExtended(this.createServerObjectName(), this);
        }
        catch (JMException jMException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + this.pid + ": JMException occured ", jMException);
            }
            FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.nodeagent.PidWaiter.removeJ2EEStateStoppingListener", "116", this);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid " + this.pid + ": In removeJ2EEStateStoppingListener, Throwable = " + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.nodeagent.PidWaiter.removeJ2EEStateStoppingListener", "120", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeJ2EEStateStoppingListener", this.pid);
        }
    }

    private ObjectName createServerObjectName() {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:*,type=Server,processType=ManagedProcess,name=" + this.processName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return objectName;
    }

    public void handleNotification(Notification notification, Object object) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", notification.getType());
        }
        if ((string = notification.getType()).equals("j2ee.state.stopping")) {
            this.processStopping();
        }
        if (string.equals("websphere.process.initiatedStopping")) {
            Properties properties = (Properties)notification.getUserData();
            String string2 = properties.getProperty("nodeName");
            String string3 = properties.getProperty("processName");
            if (this.processName.equals(string3)) {
                this.processNameIntiatedForStop = string3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification", this.pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block52: {
            if (PidWaiter.tc.isEntryEnabled()) {
                Tr.entry(PidWaiter.tc, "run", this.pid);
            }
            this.agent.sendNotification("websphere.process.running", this.processName);
            this.cfg = (MonitorConfig)this.monitoringPolicies.get(this.processName);
            if (this.cfg == null) {
                if (this.zos) {
                    this.cfg = this.agent.load390ServerMonitoringPolicy(this.processName);
                    if (PidWaiter.tc.isDebugEnabled()) {
                        Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": loaded390ServerMonitoringPolicy cfg = " + this.cfg);
                    }
                } else {
                    this.cfg = this.agent.loadServerMonitoringPolicy(this.processName);
                }
                if (this.cfg != null) {
                    this.monitoringPolicies.put(this.processName, this.cfg);
                }
            }
            if (this.cfg != null) {
                this.cfg.setPid(this.pid);
                if (PidWaiter.tc.isDebugEnabled()) {
                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": " + this.processName + " cfg = " + this.cfg);
                }
            } else {
                if (PidWaiter.tc.isEntryEnabled()) {
                    Tr.exit(PidWaiter.tc, "run - no monitoring policy set, quit");
                }
                return;
            }
            this.pingInterval = this.cfg.getPingInterval();
            if (this.pingInterval < 5 && this.pingInterval != 0) {
                Tr.debug(PidWaiter.tc, "PingInterval " + this.pingInterval + "too small , Setting PingInterval to 5");
                this.pingInterval = 5;
            } else if (this.pingInterval == 0) {
                Tr.exit(PidWaiter.tc, "PingInterval set to 0,disable monitoring");
                return;
            }
            this.session = RoutingTable.getInstance().getSession(this.processName);
            var1_1 = false;
            if (PidWaiter.tc.isDebugEnabled()) {
                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": At loop top in " + this.processName);
            }
            var2_2 = true;
            var3_3 = false;
            try {
                this.p.waitForTermination(this.pingInterval);
                if (PidWaiter.tc.isDebugEnabled()) {
                    Tr.debug(PidWaiter.tc, "Pidwaiter returned from waitForTermination.");
                }
            }
            catch (ProcessStillActiveException var4_4) {
                block60: {
                    block58: {
                        block57: {
                            block56: {
                                block59: {
                                    block54: {
                                        block53: {
                                            var2_2 = this.contact();
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": For " + this.processName + ", bContact = " + var2_2 + " isProcessStopping = " + this.isProcessStopping());
                                            }
                                            if (var2_2 || this.isProcessStopping()) break block54;
                                            try {
                                                if (!this.cfg.getAutoRestart()) break block53;
                                                Tr.warning(PidWaiter.tc, "ADML0063W", this.processName);
                                                if (PidWaiter.tc.isDebugEnabled()) {
                                                    Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Stopping server with pid " + this.pid + " because auto reset is true");
                                                }
                                                this.p.stop();
                                                var1_1 = true;
                                                RoutingTable.getInstance().removeChild(this.processName);
                                                while (true) {
                                                    try {
                                                        if (PidWaiter.tc.isDebugEnabled()) {
                                                            Tr.debug(PidWaiter.tc, "Pidwaiter secondary waitForTermination.");
                                                        }
                                                        this.p.waitForTermination(this.pingInterval);
                                                        if (!PidWaiter.tc.isDebugEnabled()) break;
                                                        Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Broke out of secondary waitForTermination.");
                                                    }
                                                    catch (ProcessStillActiveException var5_6) {
                                                        if (PidWaiter.tc.isDebugEnabled()) {
                                                            Tr.debug(PidWaiter.tc, "Pidwaiter got StillActiveException after p.stop.");
                                                        }
                                                        if ((var6_9 = System.getProperty("com.ibm.server.allow.sigkill")) != null && var6_9.equals("true")) {
                                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                                Tr.debug(PidWaiter.tc, " sigkill property is set to true");
                                                            }
                                                            if (!this.forceKillPID(this.pid)) continue;
                                                        }
                                                        if (!PidWaiter.tc.isDebugEnabled()) continue;
                                                        Tr.debug(PidWaiter.tc, "sigkill property is not set");
                                                        continue;
                                                    }
                                                    break;
                                                }
                                                {
                                                }
                                            }
                                            catch (ProcessOpException var5_7) {
                                                FFDCFilter.processException((Throwable)var5_7, "com.ibm.ws.management.nodeagent.PidWaiter.run", "124", this);
                                            }
                                        }
                                        Tr.warning(PidWaiter.tc, "ADML0060W", this.processName);
                                        if (PidWaiter.tc.isDebugEnabled()) {
                                            Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": Not stopping " + this.processName + " because autoRestart = false");
                                        }
                                        ** break block55
                                    }
                                    if (var2_2) break block56;
                                    if (!this.isProcessStopping()) break block57;
                                    if (PidWaiter.tc.isDebugEnabled()) {
                                        Tr.debug(PidWaiter.tc, "bContact==false && isProcessStopping == true for process: " + this.processName + ". Checking for termination.");
                                    }
                                    var5_8 = 1;
                                    while (var5_8 <= 5) {
                                        try {
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Waiting " + this.pingInterval + " seconds for termination.");
                                            }
                                            this.p.waitForTermination(this.pingInterval);
                                            var3_3 = true;
                                            if (!PidWaiter.tc.isDebugEnabled()) break;
                                            Tr.debug(PidWaiter.tc, "Woke up from waitForTermination during stop.");
                                            break;
                                        }
                                        catch (ProcessStillActiveException var6_10) {
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pidwaiter got ProcessStillActiveException while stopping.");
                                            }
                                            ++var5_8;
                                            if (!PidWaiter.tc.isDebugEnabled()) continue;
                                            Tr.debug(PidWaiter.tc, "Retry counter: " + var5_8);
                                        }
                                        catch (ProcessOpException var6_11) {
                                            if (PidWaiter.tc.isDebugEnabled()) {
                                                Tr.debug(PidWaiter.tc, "Pidwaiter got ProcessOpException while stopping: " + var6_11);
                                            }
                                            ++var5_8;
                                            if (!PidWaiter.tc.isDebugEnabled()) continue;
                                            Tr.debug(PidWaiter.tc, "Retry counter: " + var5_8);
                                        }
                                    }
                                    if (var3_3) break block58;
                                    if (PidWaiter.tc.isDebugEnabled()) {
                                        Tr.debug(PidWaiter.tc, "For process- " + this.processName + ", force to kill the PID" + this.pid);
                                    }
                                    if ((var6_9 = System.getProperty("com.ibm.server.allow.sigkill")) == null || !var6_9.equals("true")) break block59;
                                    if (PidWaiter.tc.isDebugEnabled()) {
                                        Tr.debug(PidWaiter.tc, " Sigkill property is set to true. So nodeagent forcibly kills & restarts the appserver process.");
                                    }
                                    if (this.forceKillPID(this.pid)) {
                                    }
                                    break block60;
                                }
                                if (PidWaiter.tc.isDebugEnabled()) {
                                    Tr.debug(PidWaiter.tc, " Sigkill property is not set to true.");
                                }
                                break;
                            }
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                }
            }
            catch (ProcessOpException var4_5) {
                FFDCFilter.processException((Throwable)var4_5, "com.ibm.ws.management.nodeagent.PidWaiter.run", "132", this);
                if (PidWaiter.tc.isDebugEnabled()) {
                    Tr.debug(PidWaiter.tc, "Pidwaiter caught ProcessOpException2: " + var4_5);
                }
            }
            finally {
                if (PidWaiter.tc.isDebugEnabled()) {
                    Tr.debug(PidWaiter.tc, "Pidwaiter in Finally clause.");
                }
                if ((var2_2 || this.isProcessStopping()) && !var3_3 || !PidWaiter.tc.isDebugEnabled()) break block52;
                Tr.debug(PidWaiter.tc, "Pid " + this.pid + ": leaving while(true) loop");
            }
        }
        this.finishRunProcessing(false, var1_1);
        if (PidWaiter.tc.isEntryEnabled()) {
            Tr.exit(PidWaiter.tc, "run", this.pid);
        }
    }

    private boolean forceKillPID(String string) {
        StopParams stopParams = new StopParams();
        stopParams.setProcessID(string);
        stopParams.setStopMode(1);
        try {
            ProcessFactory.terminate(stopParams);
            return true;
        }
        catch (ProcessOpException processOpException) {
            processOpException.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", new Object[]{this.pid, object});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ContactThread alarm popped.");
        }
        if (CONTACT_ALARM_CONTEXT.equals(object)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PidWaiter disableChild: processName: " + this.processName + ", PID: " + this.pid);
            }
            RoutingTable.getInstance().disableChild(this.processName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm", this.pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRunProcessing(boolean bl, boolean bl2) {
        block121: {
            Object object;
            int n;
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "finishRunProcessing", this.pid + ": " + bl);
            }
            if ((string = RoutingTable.getInstance().getPid(this.processName)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid " + this.pid + ": rtpid = " + string + ", pid = " + this.pid);
                }
                if (string.equals(this.pid)) {
                    n = 1;
                    if (this.session != null && (object = RoutingTable.getInstance().getSession(this.processName)) != null && !((Session)object).equals(this.session)) {
                        n = 0;
                    }
                    if (n != 0) {
                        RoutingTable.getInstance().removeChild(this.processName);
                    }
                }
            }
            this.removeJ2EEStateStoppingListener();
            if (this.agent.containAdoptedChild(this.processName, this.pid)) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Pid " + this.pid + ": adopted Child stopped " + this.processName);
                }
                try {
                    this.p.release();
                }
                catch (ProcessOpException processOpException) {
                    FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.management.nodeagent.PidWaiter.run", "148", this);
                    Tr.debug(tc, "Pid " + this.pid + ": Exception during releasing adopted process " + this.processName);
                }
                this.agent.removeAdoptedChild(this.processName, this.pid);
                String string2 = variableMap.expand("${LOG_ROOT}/" + this.processName);
                object = this.processName + ".pid";
                File file = new File(string2, (String)object);
                boolean bl3 = this.isProcessStopping();
                if (file.exists()) {
                    if (this.zos) {
                        this.agent.sendNotification("websphere.process.stopped", this.processName);
                    }
                    this.agent.sendNotification("websphere.process.failed", this.processName);
                    BufferedReader bufferedReader = null;
                    boolean bl4 = true;
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        String string3 = bufferedReader.readLine();
                        if (string3 != null && !string3.equals(this.pid)) {
                            bl4 = false;
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.nodeagent.PidWaiter.run", "176", this);
                    }
                    finally {
                        block120: {
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (IOException iOException) {
                                    if (!tc.isDebugEnabled()) break block120;
                                    Tr.debug(tc, "Pid " + this.pid + ": failed to close pid file", iOException);
                                }
                            }
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Pid " + this.pid + ": pidMatched = " + bl4);
                    }
                    if (bl4) {
                        try {
                            if (this.zos) {
                                file.delete();
                            }
                            if (this.cfg != null && this.cfg.getAutoRestart()) {
                                if (!this.zos) {
                                    file.delete();
                                }
                                if (!(this.processIsTerminated || bl3 || this.processName.equals(this.processNameIntiatedForStop))) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pid " + this.pid + ": Process is being relaunched");
                                    }
                                    this.reLaunchProcess();
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pid " + this.pid + ": process is NOT being relaunched");
                                    }
                                    this.setProcessIsTerminated(false);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Pid " + this.pid + ": reLaunchProcess1");
                                }
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.PidWaiter.run", "200", this);
                        }
                    }
                } else if (bl2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pid file not found, but PidWaiter stopped process");
                    }
                    if (this.zos) {
                        this.agent.sendNotification("websphere.process.stopped", this.processName);
                    }
                    this.agent.sendNotification("websphere.process.failed", this.processName);
                    try {
                        if (this.cfg == null || !this.cfg.getAutoRestart()) break block121;
                        if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Pid " + this.pid + ": Process is being relaunched");
                            }
                            this.reLaunchProcess();
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Pid " + this.pid + ": process is NOT being relaunched");
                            }
                            this.setProcessIsTerminated(false);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pid " + this.pid + ": reLaunchProcess1");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.PidWaiter.run", "200", this);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Pid " + this.pid + ": pid file not found");
                    }
                    this.agent.sendNotification("websphere.process.stopped", this.processName);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid " + this.pid + ": process doesn't contain adopted child");
                }
                if (this.zos) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Pid " + this.pid + ": launched Child stopped" + this.processName + ":pid: " + this.pid);
                    }
                    try {
                        this.p.release();
                    }
                    catch (ProcessOpException processOpException) {
                        Tr.debug(tc, "Pid " + this.pid + ": Exception during releasing launched process " + this.processName);
                    }
                    this.agent.removeLaunchedChild(this.processName, this.pid);
                    String string4 = variableMap.expand("${LOG_ROOT}/" + this.processName);
                    object = this.processName + ".pid";
                    File file = new File(string4, (String)object);
                    if (file.exists()) {
                        this.agent.sendNotification("websphere.process.stopped", this.processName);
                        this.agent.sendNotification("websphere.process.failed", this.processName);
                        BufferedReader bufferedReader = null;
                        boolean bl5 = true;
                        try {
                            bufferedReader = new BufferedReader(new FileReader(file));
                            String string5 = bufferedReader.readLine();
                            if (string5 != null && !string5.equals(this.pid)) {
                                bl5 = false;
                            }
                        }
                        catch (IOException iOException) {
                            Tr.debug(tc, "Pid " + this.pid + ": IO Exception during reading pid file", iOException);
                        }
                        finally {
                            block123: {
                                if (bufferedReader != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (IOException iOException) {
                                        if (!tc.isDebugEnabled()) break block123;
                                        Tr.debug(tc, "Pid " + this.pid + ": failed to close pid file", iOException);
                                    }
                                }
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pid " + this.pid + ": " + "pidMatched = " + bl5);
                        }
                        if (bl5) {
                            try {
                                file.delete();
                                if (this.cfg != null && this.cfg.getAutoRestart()) {
                                    if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Pid " + this.pid + ": Process is being relaunched");
                                        }
                                        this.reLaunchProcess();
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Pid " + this.pid + ": Process is NOT being relaunched");
                                        }
                                        this.setProcessIsTerminated(false);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pid " + this.pid + ": reLaunchProcess2");
                                    }
                                }
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Pid " + this.pid + ": Error at reLaunchProcess ", exception);
                                }
                            }
                        }
                    } else {
                        if (bl2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "pid file not found, but PidWaiter stopped process");
                            }
                            this.agent.sendNotification("websphere.process.stopped", this.processName);
                            this.agent.sendNotification("websphere.process.failed", this.processName);
                            try {
                                if (this.cfg == null || !this.cfg.getAutoRestart()) break block121;
                                if (!this.processIsTerminated && !this.processName.equals(this.processNameIntiatedForStop)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pid " + this.pid + ": Process is being relaunched" + this.processName);
                                    }
                                    this.reLaunchProcess();
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pid " + this.pid + ": Process is NOT being relaunched- " + this.processName);
                                    }
                                    this.setProcessIsTerminated(false);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Pid " + this.pid + ": reLaunchProcess2");
                                }
                                break block121;
                            }
                            catch (Exception exception) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Pid " + this.pid + ": Error at reLaunchProcess ", exception);
                                }
                                break block121;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pid " + this.pid + ": pid file not found");
                        }
                        this.agent.sendNotification("websphere.process.stopped", this.processName);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Pid " + this.pid + ": " + "getting exitcode");
                    }
                    n = Integer.MIN_VALUE;
                    try {
                        n = this.p.getExitCode();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pid " + this.pid + ": exit code: " + n);
                        }
                    }
                    catch (ProcessOpException processOpException) {
                        FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.management.nodeagent.PidWaiter.run", "712", this);
                    }
                    finally {
                        try {
                            this.p.release();
                        }
                        catch (ProcessOpException processOpException) {
                            FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.management.nodeagent.PidWaiter.run", "229", this);
                        }
                    }
                    this.agent.removeLaunchedChild(this.processName, this.pid);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Pid " + this.pid + ": " + "exitcode = " + n);
                    }
                    if (n == 0) {
                        this.agent.sendNotification("websphere.process.stopped", this.processName);
                    } else {
                        this.agent.sendNotification("websphere.process.failed", this.processName);
                        try {
                            if (this.cfg != null && this.cfg.getAutoRestart()) {
                                if (!this.processIsTerminated & !this.processName.equals(this.processNameIntiatedForStop)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pid " + this.pid + ": Process is being relaunched: " + this.processName);
                                    }
                                    this.reLaunchProcess();
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pid " + this.pid + ": Process is NOT being relaunched: " + this.processName);
                                    }
                                    this.setProcessIsTerminated(false);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Pid " + this.pid + ": reLaunchProcess3");
                                }
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.PidWaiter.run", "250", this);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRunProcessing", this.pid);
        }
    }

    private boolean contact() {
        Subject subject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contact", this.pid);
        }
        if ((subject = SecurityHelper.getOwnedSubject()) != null) {
            SecurityHelper.pushInvocationSubject(subject);
        }
        boolean bl = true;
        int n = 2;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PidWaiter contact() in loop " + i + ", processName: " + this.processName + ", PID: " + this.pid);
                }
            }
            long l = System.currentTimeMillis();
            bl = true;
            long l2 = Long.getLong(CONTACT_ALARM_TIMEOUT_PROP, 60L);
            this.contactAlarm = AlarmManager.create(l2 * 1000L, this, CONTACT_ALARM_CONTEXT);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Creating Alarm", this.contactAlarm);
            }
            ContactThread contactThread = new ContactThread();
            if (i > 0 && tc.isDebugEnabled()) {
                Tr.debug(tc, "PidWaiter contact() in loop " + i + ", contactThread: " + contactThread + ", processName: " + this.processName + ", PID: " + this.pid);
            }
            int n2 = this.cfg.getPingInterval();
            int n3 = 300000;
            if (this.cfg.getPingTimeout() != 0) {
                n3 = this.cfg.getPingTimeout() * 1000;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Contact Thread", contactThread);
            }
            contactThread.start();
            contactThread.waitForStart();
            contactThread.waitForReturn(n3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Returned from nap");
            }
            boolean bl3 = contactThread.hasReturned();
            boolean bl4 = false;
            if (this.contactAlarm != null) {
                this.contactAlarm.cancel();
                this.contactAlarm = null;
            }
            if (bl3) {
                bl4 = contactThread.hasContacted();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Has Contacted: " + this.processName, new Boolean(bl4));
                }
                if (bl4 && RoutingTable.getInstance().isChildDisabled(this.processName)) {
                    RoutingTable.getInstance().enableChild(this.processName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "PidWaiter enableChild, processName: " + this.processName + ", PID: " + this.pid);
                    }
                }
                bl = !bl4;
            } else {
                bl = true;
            }
            if (bl) {
                long l3 = System.currentTimeMillis();
                long l4 = l3 - l;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PidWaiter Contact Thread failed to make contact in " + l4 + " millisconds, processName: " + this.processName + ", PID: " + this.pid);
                }
            }
            if (!bl || this.isProcessStopping() || i + 1 >= n) break;
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Tr.debug(tc, "Pid " + this.pid + ": ThreadInterrupted Exception", interruptedException);
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.nodeagent.PidWaiter.contact", "309", this);
            }
        }
        if (bl2 && tc.isDebugEnabled()) {
            Tr.debug(tc, "PidWaiter contact() exiting after retry, processName:" + this.processName + ", PID: " + this.pid + ", failed: " + bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contact", new Boolean(!bl));
        }
        return !bl;
    }

    private void reLaunchProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reLaunchProcess", this.pid);
        }
        boolean bl = false;
        int n = this.cfg.getMaximumStartupAttempts();
        while (!bl && n > 0) {
            --n;
            try {
                Tr.audit(tc, "ADML0064I", this.processName);
                bl = this.agent.launchProcess(this.processName, new Integer(this.timeout));
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.nodeagent.PidWaiter.reLaunchProcess", "334", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reLaunchProcess", this.pid);
        }
    }

    synchronized void processStopping() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid " + this.pid + ": " + "processStopping = true");
        }
        this.processStopping = true;
    }

    synchronized boolean isProcessStopping() {
        return this.processStopping;
    }

    public static String getServerPidFile(String string) {
        String string2 = variableMap.expand("${LOG_ROOT}");
        String string3 = string2 + "/" + string + "/" + string + ".pid";
        return string3;
    }

    public void setProcessIsTerminated(boolean bl) {
        this.processIsTerminated = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid " + this.pid + ": Setting processIsTerminated to " + bl);
        }
    }

    private ObjectName queryServerObjectName(String string) {
        ObjectName objectName;
        block6: {
            String string2 = "WebSphere:*,type=Server,process=" + string;
            objectName = null;
            try {
                Set set = AdminServiceFactory.getAdminService().queryNames(new ObjectName(string2), null);
                Iterator iterator = set.iterator();
                objectName = iterator.hasNext() ? iterator.next() : null;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.nodeagent.PidWaiter.contact", "284", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid " + this.pid + ": wrong object name format", malformedObjectNameException);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                FFDCFilter.processException((Throwable)outOfMemoryError, "com.ibm.ws.management.nodeagent.PidWaiter.run", "395", this);
                Tr.fatal(tc, "An OutOfMemoryError occured on process " + string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid " + this.pid + ": An OutOfMemoryError occured on process " + string, outOfMemoryError);
                }
                Tr.exit(tc, "contact failed");
                return null;
            }
            catch (Error error) {
                FFDCFilter.processException((Throwable)error, "com.ibm.ws.management.nodeagent.PidWaiter.run", "395", this);
                Tr.error(tc, "An Java Error occured on process " + string);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Pid " + this.pid + ": An Java Error occured on process " + string, error);
            }
        }
        return objectName;
    }

    static {
        CONTACT_ALARM_CONTEXT = new Integer(1);
        CONTACT_ALARM_TIMEOUT_PROP = "com.ibm.websphere.management.pidwaiter.contact.timeout";
    }

    class ContactThread
    extends Thread {
        boolean started = false;
        boolean pidWaiterWaitingForStart = false;
        boolean returned = false;
        boolean contact = false;
        private boolean pidWaiterWaiting = false;

        ContactThread() {
        }

        synchronized void waitForStart() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForStart");
            }
            if (!this.started) {
                block6: {
                    this.pidWaiterWaitingForStart = true;
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "waitForStart: wait");
                    }
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, "waitForStart got exception: " + exception);
                    }
                }
                this.pidWaiterWaitingForStart = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForStart");
            }
        }

        private synchronized void started() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "started");
            }
            this.started = true;
            if (this.pidWaiterWaitingForStart) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "started: notify PidWaite");
                }
                this.notify();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "started");
            }
        }

        synchronized void waitForReturn(long l) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForReturn:" + l);
            }
            if (l <= 0L) {
                l = 1L;
            }
            if (!this.returned) {
                block6: {
                    this.pidWaiterWaiting = true;
                    try {
                        this.wait(l);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug(tc, "waitForReturn got exception: " + exception);
                    }
                }
                this.pidWaiterWaiting = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForReturn:" + l);
            }
        }

        private synchronized void completed() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "completed");
            }
            this.returned = true;
            if (this.pidWaiterWaiting) {
                this.notify();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ContactThread.run()");
            }
            this.started();
            try {
                Subject subject = SecurityHelper.getOwnedSubject();
                if (subject != null) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
                AdminClient adminClient = null;
                this.contact = false;
                adminClient = RoutingTable.getInstance().isChildDisabled(PidWaiter.this.processName) ? RoutingTable.getInstance().getDisabledAdminClient(PidWaiter.this.processName) : RoutingTable.getInstance().getAdminClient(PidWaiter.this.processName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " checking whether the process is alive ");
                }
                adminClient.isAlive();
                this.contact = true;
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.nodeagent.PidWaiter.ContactThread", "1039", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ContactThread Exception for processName: " + PidWaiter.this.processName + ", PID: " + PidWaiter.this.pid + " recevied ConnectorException: " + connectorException);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                FFDCFilter.processException((Throwable)outOfMemoryError, "com.ibm.ws.management.nodeagent.PidWaiter.ContactThread", "1098", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ContactThread Exception for processName: " + PidWaiter.this.processName + ", PID: " + PidWaiter.this.pid + " recevied OutOfMemoryError: " + outOfMemoryError);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.nodeagent.PidWaiter.ContactThread", "1104", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ContactThread Exception for processName: " + PidWaiter.this.processName + ", PID: " + PidWaiter.this.pid + " recevied Throwable: " + throwable);
                }
            }
            finally {
                this.completed();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ContactThread.run()");
            }
        }

        synchronized boolean hasReturned() {
            return this.returned;
        }

        boolean hasContacted() {
            return this.contact;
        }
    }
}

