/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.remote;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.remote.AdminServiceForwarder;
import com.ibm.ws.orb.GlobalORBFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class RMIServer {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RMIServer.class, "Admin", "com.ibm.ws.management.resources.connector");
    private JMXConnectorServer jmxConnectorServer = null;
    private AdminServiceForwarder adminService = null;
    private boolean jmxConnectorEnabled = false;
    Properties props = null;
    private String jndiPath = "/jndi/JMXConnector";

    public void initialize(Properties properties) throws ConnectorException, IOException, MalformedURLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", properties);
        }
        this.props = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.props);
        }
    }

    public void start() throws IOException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if ((string = this.props.getProperty("host")).equals("*")) {
            string = null;
        }
        int n = Integer.parseInt(this.props.getProperty("port"));
        MBeanServer mBeanServer = AdminServiceFactory.getMBeanFactory().getMBeanServer();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ORB oRB = GlobalORBFactory.globalORB();
        hashMap.put("java.naming.corba.orb", oRB);
        hashMap.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
        hashMap.put("jmx.remote.x.server.connection.timeout", new Long(Long.MAX_VALUE));
        hashMap.put("jmx.remote.jndi.rebind", "true");
        JMXServiceURL jMXServiceURL = new JMXServiceURL("iiop", string, n, this.jndiPath);
        this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jMXServiceURL, hashMap, mBeanServer);
        this.adminService = new AdminServiceForwarder();
        this.jmxConnectorServer.setMBeanServerForwarder(this.adminService);
        this.jmxConnectorServer.start();
        this.jmxConnectorEnabled = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMX Connector is available at serviceURL address", jMXServiceURL);
        }
    }

    public void stop() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this.jmxConnectorServer != null && this.jmxConnectorEnabled) {
            this.jmxConnectorServer.stop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }
}

