/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileRepository;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class FileDocument {
    private static String repositoryRoot;
    private static String repositoryTemp;
    private static String repositoryBackup;
    private static String downloadDir;
    private static FileTransferConfig repositoryFTConfig;
    private static FileTransferOptions repositoryFTOptions;
    private static HashMap locks;
    private static Integer mkdirsLock;
    private static TraceComponent tc;
    private static HashMap references;

    protected static Object getDirLock() {
        return mkdirsLock;
    }

    protected static void setRepository(FileRepository fileRepository) {
        repositoryRoot = fileRepository.getRepositoryDir();
        repositoryTemp = fileRepository.getTempDir();
        repositoryBackup = fileRepository.getBackupDir();
        repositoryFTOptions = fileRepository.getFileTransferOptions();
        repositoryFTConfig = fileRepository.getFileTransferConfig();
        downloadDir = repositoryTemp + "/download/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DocumentDigest create(DocumentContentSource documentContentSource) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl = null;
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating " + documentContentSource.getDocument().getURI());
        }
        try {
            FileDocument.lockForWriting(documentContentSource.getDocument().getURI());
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "lock acquired");
            }
            File file = FileDocument.getFileForURI(documentContentSource.getDocument().getURI());
            Object object = mkdirsLock;
            synchronized (object) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            object = new FileOutputStream(file);
            documentDigestImpl = FileDocument.copyDocument(documentContentSource.getSource(), (OutputStream)object, true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.create", "88", FileDocument.class);
            Tr.error(tc, "ADMR0100E", new Object[]{documentContentSource.getDocument().getURI(), exception});
            throw FileDocument.getDocumentIOException(exception, documentContentSource.getDocument().getURI());
        }
        finally {
            if (bl) {
                FileDocument.unlockForWriting(documentContentSource.getDocument().getURI());
            }
        }
        return documentDigestImpl;
    }

    protected static void delete(String string) throws DocumentIOException {
        FileDocument.delete(string, false);
    }

    private static void delete(String string, boolean bl) throws DocumentIOException {
        Object object;
        boolean bl2 = false;
        if (!bl) {
            object = string + ".digest";
            File file = FileDocument.getFileForURI((String)object);
            try {
                FileDocument.lockForWriting((String)object);
                bl2 = true;
                if (file.exists() && !file.delete()) {
                    throw new DocumentIOException((String)object);
                }
            }
            catch (Throwable throwable) {
                Tr.error(tc, "ADMR0111E", object);
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileDocument.delete", "139", FileDocument.class);
                throw FileDocument.getDocumentIOException(throwable, "");
            }
            finally {
                if (bl2) {
                    FileDocument.unlockForWriting((String)object);
                }
            }
        }
        object = FileDocument.getFileForURI(string);
        bl2 = false;
        try {
            FileDocument.lockForWriting(string);
            bl2 = true;
            if (((File)object).exists() && !((File)object).delete()) {
                throw new DocumentIOException(string);
            }
            FileDocument.deleteEmptyParents((File)object, repositoryRoot);
        }
        catch (Throwable throwable) {
            Tr.error(tc, "ADMR0111E", string);
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileDocument.delete", "159", FileDocument.class);
            throw FileDocument.getDocumentIOException(throwable, "");
        }
        finally {
            if (bl2) {
                FileDocument.unlockForWriting(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteEmptyParents(File file, String string) {
        File file2 = file.getParentFile();
        Integer n = mkdirsLock;
        synchronized (n) {
            if (file2.getPath().length() > string.length() && file2.delete()) {
                FileDocument.deleteEmptyParents(file2, string);
            }
        }
    }

    protected static DocumentDigestImpl getDigest(String string) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl = null;
        File file = FileDocument.getFileForURI(string + ".digest");
        documentDigestImpl = file.exists() ? FileDocument.readDigest(string + ".digest", file) : FileDocument.calcDigest(string);
        return documentDigestImpl;
    }

    protected static DocumentDigestImpl calcDigest(String string) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "calcDigest: " + string);
        }
        File file = FileDocument.getFileForURI(string);
        boolean bl = false;
        try {
            documentDigestImpl = new DocumentDigestImpl();
            FileDocument.lockForReading(string);
            bl = true;
            documentDigestImpl.calc(new FileInputStream(file));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.getDigest", "146", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, iOException});
            throw new DocumentIOException(iOException, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.getDigest", "152", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, exception});
            throw FileDocument.getDocumentIOException(exception, string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForReading(string);
            }
        }
        return documentDigestImpl;
    }

    /*
     * Loose catch block
     */
    private static DocumentDigestImpl readDigest(String string, File file) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl;
        block17: {
            boolean bl;
            ObjectInputStream objectInputStream;
            FileInputStream fileInputStream;
            block14: {
                IOException iOException2222;
                block13: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "readDigest: " + string);
                    }
                    documentDigestImpl = null;
                    fileInputStream = null;
                    objectInputStream = null;
                    bl = true;
                    FileDocument.lockForReading(string);
                    bl = true;
                    fileInputStream = new FileInputStream(repositoryRoot + File.separator + string);
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    documentDigestImpl = (DocumentDigestImpl)objectInputStream.readObject();
                    Object var8_6 = null;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.management.repository.FileDocument.readDigest", "214", null);
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Error while closing object stream: " + iOException2222);
                    }
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2222) {
                    FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.management.repository.FileDocument.readDigest", "223", null);
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Error while closing file input stream: " + iOException2222);
                }
            }
            if (bl) {
                FileDocument.unlockForReading(string);
            }
            break block17;
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileDocument.getDigest", "152", FileDocument.class);
                    Tr.error(tc, "ADMR0104E", new Object[]{string, throwable});
                    throw FileDocument.getDocumentIOException(throwable, string);
                }
            }
            catch (Throwable throwable) {
                block16: {
                    IOException iOException3222;
                    block15: {
                        Object var8_7 = null;
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException3222) {
                            FFDCFilter.processException((Throwable)iOException3222, "com.ibm.ws.management.repository.FileDocument.readDigest", "214", null);
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug(tc, "Error while closing object stream: " + iOException3222);
                        }
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException3222) {
                        FFDCFilter.processException((Throwable)iOException3222, "com.ibm.ws.management.repository.FileDocument.readDigest", "223", null);
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Error while closing file input stream: " + iOException3222);
                    }
                }
                if (bl) {
                    FileDocument.unlockForReading(string);
                }
                throw throwable;
            }
        }
        return documentDigestImpl;
    }

    protected static DocumentDigestImpl write(DocumentContentSource documentContentSource) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl = null;
        String string = documentContentSource.getDocument().getURI();
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writing " + string);
        }
        try {
            File file = FileDocument.getFileForURI(string);
            FileDocument.lockForWriting(string);
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "lock acquired");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            documentDigestImpl = FileDocument.copyDocument(documentContentSource.getSource(), fileOutputStream, true);
            long l = documentContentSource.getLastModified();
            if (l > 0L && !AdminHelper.getPlatformHelper().isZOS()) {
                file.setLastModified(l);
            }
            FileDocument.writeDigest(string, documentDigestImpl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.write", "175", FileDocument.class);
            Tr.error(tc, "ADMR0105E", new Object[]{documentContentSource.getDocument().getURI(), exception});
            throw FileDocument.getDocumentIOException(exception, documentContentSource.getDocument().getURI());
        }
        finally {
            if (bl) {
                FileDocument.unlockForWriting(string);
            }
        }
        return documentDigestImpl;
    }

    protected static void backup(String string) throws DocumentIOException {
        String string2;
        File file;
        boolean bl = false;
        File file2 = FileDocument.getFileForURI(string);
        if (file2.exists()) {
            FileDocument.backup(string, file2);
            bl = true;
        }
        if ((file = FileDocument.getFileForURI(string2 = string + ".digest")).exists()) {
            FileDocument.backup(string2, file);
            bl = true;
        }
        if (!bl) {
            DocumentIOException documentIOException = new DocumentIOException("Document does not exist: " + string);
            Tr.error(tc, "ADMR0108E", new Object[]{string, documentIOException});
            throw documentIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backup(String string, File file) throws DocumentIOException {
        boolean bl = false;
        try {
            File file2 = new File(repositoryBackup + File.separator + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "backupFile: " + file2.getPath());
            }
            Integer n = mkdirsLock;
            synchronized (n) {
                file2.getParentFile().mkdirs();
                FileDocument.lockForReading(string);
                bl = true;
                FileDocument.copyDocument(new FileInputStream(file), new FileOutputStream(file2), false);
            }
            file2.setLastModified(file.lastModified());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ws.management.repository.FileDocument.backup", "211", FileDocument.class);
            Tr.error(tc, "ADMR0108E", new Object[]{string, fileNotFoundException});
            throw new DocumentIOException(fileNotFoundException, "Unable to backup document: " + string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.backup", "212", FileDocument.class);
            Tr.error(tc, "ADMR0108E", new Object[]{string, exception});
            throw FileDocument.getDocumentIOException(exception, "Unable to backup document: " + string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForReading(string);
            }
        }
    }

    protected static void removeBackup(String string) {
        File file = new File(repositoryBackup + File.separator + string);
        if (!file.delete() && file.exists()) {
            Tr.warning(tc, "ADMR0110W", new Object[]{string, ""});
        }
        if ((file = new File(repositoryBackup + File.separator + string + ".digest")).exists() && !file.delete()) {
            Tr.warning(tc, "ADMR0110W", new Object[]{string + ".digest", ""});
        }
        FileDocument.deleteEmptyParents(file, repositoryBackup);
    }

    protected static void restore(String string) throws DocumentIOException {
        boolean bl = false;
        File file = new File(repositoryBackup + File.separator + string);
        if (file.exists()) {
            FileDocument.restore(string, file);
            bl = true;
        }
        String string2 = string + ".digest";
        file = new File(repositoryBackup + File.separator + string2);
        if (file.exists()) {
            FileDocument.restore(string2, file);
            bl = true;
        }
        if (!bl) {
            DocumentIOException documentIOException = new DocumentIOException("Document backup does not exist: " + string);
            Tr.error(tc, "ADMR0109E", new Object[]{string, documentIOException});
            throw documentIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restore(String string, File file) throws DocumentIOException {
        boolean bl = false;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "restoring " + string);
            }
            File file2 = FileDocument.getFileForURI(string);
            FileDocument.lockForWriting(string);
            bl = true;
            FileOutputStream fileOutputStream = null;
            if (!file2.getParentFile().exists()) {
                Integer n = mkdirsLock;
                synchronized (n) {
                    file2.getParentFile().mkdirs();
                    fileOutputStream = new FileOutputStream(file2);
                }
            } else {
                fileOutputStream = new FileOutputStream(file2);
            }
            FileDocument.copyDocument(new FileInputStream(file), fileOutputStream, false);
            file2.setLastModified(file.lastModified());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileDocument.restore", "251", FileDocument.class);
            Tr.error(tc, "ADMR0109E", new Object[]{string, throwable});
            throw FileDocument.getDocumentIOException(throwable, "Unable to restore document from backup: " + string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForWriting(string);
            }
        }
    }

    private static DocumentDigestImpl copyDocument(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDocument");
        }
        InputStream inputStream2 = null;
        DocumentDigestImpl documentDigestImpl = null;
        if (bl) {
            documentDigestImpl = new DocumentDigestImpl();
            inputStream2 = documentDigestImpl.startInputFilter(inputStream);
        } else {
            inputStream2 = inputStream;
        }
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream2.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream2.read(byArray);
            }
            if (bl) {
                documentDigestImpl.stopInputFilter();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.copyDocument", "851", FileDocument.class);
            throw iOException;
        }
        finally {
            block21: {
                block20: {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.copyDocument", "866", null);
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "Error while closing to stream: " + exception);
                    }
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.copyDocument", "866", null);
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Error while closing from stream: " + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDocument");
        }
        return documentDigestImpl;
    }

    protected static DocumentContentSource read(String string) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading " + string);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileDownloadInputStream fileDownloadInputStream = null;
        DocumentDigestImpl documentDigestImpl = null;
        File file = FileDocument.getFileForURI(string);
        File file2 = FileDocument.createTempFile(string);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.read", "351", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, iOException});
            throw new DocumentIOException(iOException, "Unable to create input stream on document file: " + string);
        }
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.read", "363", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, iOException});
            throw new DocumentIOException(iOException, "Unable to create output stream on temp file: " + file2.getPath());
        }
        long l = 0L;
        boolean bl = false;
        try {
            FileDocument.lockForReading(string);
            bl = true;
            documentDigestImpl = FileDocument.copyDocument(fileInputStream, fileOutputStream, true);
            l = file.lastModified();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.read", "375", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, exception});
            throw FileDocument.getDocumentIOException(exception, "Unable to copy document to temp file: " + string);
        }
        finally {
            if (bl) {
                FileDocument.unlockForReading(string);
            }
        }
        fileDownloadInputStream = new FileDownloadInputStream(file2);
        fileDownloadInputStream.setFileTransferConfig(repositoryFTConfig);
        fileDownloadInputStream.setOptions(repositoryFTOptions);
        fileDownloadInputStream.setSrcPath(file2.getAbsolutePath().substring(repositoryTemp.length()));
        Document document = new Document(string, documentDigestImpl);
        DocumentContentSource documentContentSource = new DocumentContentSource(document, fileDownloadInputStream);
        documentContentSource.setLastModified(l);
        return documentContentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempFile(String string) throws DocumentIOException {
        File file = new File(downloadDir + string);
        String string2 = file.getName().replace('%', '_');
        if (string2.length() < 3) {
            string2 = new String(string2 + "__");
        }
        File file2 = file.getParentFile();
        File file3 = null;
        try {
            Integer n = mkdirsLock;
            synchronized (n) {
                file2.mkdirs();
                file3 = File.createTempFile(string2, null, file2);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileDocument.createTempFile", "404", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, throwable});
            throw new DocumentIOException(throwable, "Unable to create temp file for document: " + string);
        }
        return file3;
    }

    private static void lockForReading(String string) throws DocumentIOException {
        try {
            FileDocument.getLock(string, true).startReading();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.repository.FileDocument.lockForWriting", "640", FileDocument.class);
            throw new DocumentIOException(interruptedException, "Unable to get read lock for document " + string);
        }
    }

    private static void unlockForReading(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = FileDocument.getLock(string, false);
        writerPriorityReadersWriterLock.stopReading();
        FileDocument.releaseLock(string, writerPriorityReadersWriterLock);
    }

    private static void lockForWriting(String string) throws DocumentIOException {
        try {
            FileDocument.getLock(string, true).startWriting();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.repository.FileDocument.lockForWriting", "640", FileDocument.class);
            throw new DocumentIOException(interruptedException, "Unable to get write lock for document " + string);
        }
    }

    private static void unlockForWriting(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = FileDocument.getLock(string, false);
        writerPriorityReadersWriterLock.stopWriting();
        FileDocument.releaseLock(string, writerPriorityReadersWriterLock);
    }

    private static synchronized WriterPriorityReadersWriterLock getLock(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = (WriterPriorityReadersWriterLock)locks.get(string);
        if (writerPriorityReadersWriterLock == null) {
            writerPriorityReadersWriterLock = new WriterPriorityReadersWriterLock();
            locks.put(string, writerPriorityReadersWriterLock);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New lock is " + writerPriorityReadersWriterLock);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Lock already exists " + writerPriorityReadersWriterLock);
        }
        return writerPriorityReadersWriterLock;
    }

    private static synchronized WriterPriorityReadersWriterLock getLock(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLock " + bl);
        }
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = FileDocument.getLock(string);
        if (bl) {
            Object v = references.get(writerPriorityReadersWriterLock);
            if (v == null) {
                references.put(writerPriorityReadersWriterLock, new Integer(1));
            } else {
                int n = (Integer)v;
                references.put(writerPriorityReadersWriterLock, new Integer(++n));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLock " + bl);
        }
        return writerPriorityReadersWriterLock;
    }

    private static synchronized void releaseLock(String string, WriterPriorityReadersWriterLock writerPriorityReadersWriterLock) {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseLock ");
        }
        if ((v = references.get(writerPriorityReadersWriterLock)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is a bug " + writerPriorityReadersWriterLock);
            }
            return;
        }
        int n = (Integer)v;
        --n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reference count " + n);
        }
        if (n == 0) {
            references.remove(writerPriorityReadersWriterLock);
            locks.remove(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lock removed " + writerPriorityReadersWriterLock);
            }
        } else {
            references.put(writerPriorityReadersWriterLock, new Integer(n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseLock ");
        }
    }

    protected static void createDigestFile(String string, boolean bl) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating digest file for " + string + "; deleteDoc = " + bl);
        }
        DocumentDigestImpl documentDigestImpl = FileDocument.getDigest(string);
        File file = FileDocument.getFileForURI(string + ".digest");
        try {
            file.createNewFile();
            FileDocument.writeDigest(string, documentDigestImpl);
            if (bl) {
                FileDocument.delete(string, true);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.createDigestFile", "524", FileDocument.class);
            throw new DocumentIOException(iOException, "Unable to create digest file for document " + string);
        }
    }

    /*
     * Loose catch block
     */
    protected static void writeDigest(String string, DocumentDigestImpl documentDigestImpl) throws DocumentIOException {
        block18: {
            String string2 = string + ".digest";
            File file = FileDocument.getFileForURI(string2);
            if (file.exists()) {
                boolean bl;
                ObjectOutputStream objectOutputStream;
                FileOutputStream fileOutputStream;
                block15: {
                    IOException iOException2222;
                    block14: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Updating digest file for " + string);
                        }
                        fileOutputStream = null;
                        objectOutputStream = null;
                        bl = false;
                        FileDocument.lockForWriting(string2);
                        bl = true;
                        fileOutputStream = new FileOutputStream(file);
                        objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        objectOutputStream.writeObject(documentDigestImpl);
                        Object var9_7 = null;
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException iOException2222) {
                            FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.management.repository.FileDocument.writeDigest", "605", null);
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug(tc, "Error while closing object stream: " + iOException2222);
                        }
                    }
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2222) {
                        FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.management.repository.FileDocument.writeDigest", "615", null);
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "Error while closing file output stream: " + iOException2222);
                    }
                }
                if (bl) {
                    FileDocument.unlockForWriting(string2);
                }
                break block18;
                {
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.writeDigest", "478", FileDocument.class);
                        throw FileDocument.getDocumentIOException(exception, "Unable to write digest file for document " + string);
                    }
                }
                catch (Throwable throwable) {
                    block17: {
                        IOException iOException3222;
                        block16: {
                            Object var9_8 = null;
                            try {
                                objectOutputStream.close();
                            }
                            catch (IOException iOException3222) {
                                FFDCFilter.processException((Throwable)iOException3222, "com.ibm.ws.management.repository.FileDocument.writeDigest", "605", null);
                                if (!tc.isDebugEnabled()) break block16;
                                Tr.debug(tc, "Error while closing object stream: " + iOException3222);
                            }
                        }
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException3222) {
                            FFDCFilter.processException((Throwable)iOException3222, "com.ibm.ws.management.repository.FileDocument.writeDigest", "615", null);
                            if (!tc.isDebugEnabled()) break block17;
                            Tr.debug(tc, "Error while closing file output stream: " + iOException3222);
                        }
                    }
                    if (bl) {
                        FileDocument.unlockForWriting(string2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static File getFileForURI(String string) {
        return new File(repositoryRoot + File.separator + string);
    }

    private static DocumentIOException getDocumentIOException(Throwable throwable, String string) {
        if (throwable instanceof DocumentIOException) {
            return (DocumentIOException)throwable;
        }
        return new DocumentIOException(throwable, string);
    }

    static {
        locks = new HashMap();
        mkdirsLock = new Integer(0);
        tc = Tr.register(FileDocument.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");
        references = new HashMap();
    }
}

