/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentAlreadyExistsException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.exception.DocumentLockedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.DocumentUnavailableException;
import com.ibm.websphere.management.exception.InvalidDocumentURIException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.exception.RepositoryLockedException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileDocument;
import com.ibm.ws.management.repository.RepositoryLock;
import com.ibm.ws.management.repository.RepositoryLockFactory;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.ws.management.sync.EpochFileHelper;
import com.ibm.ws.management.sync.J2CRAProcessor;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.workspace.impl.SystemModifiedFiles;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;

public class FileRepository
extends RuntimeCollaborator
implements ConfigRepository,
ResourceNameFilter,
ConfigRepositoryListener {
    private static FileRepository repository = new FileRepository();
    private Class digestImplClass;
    private String repositoryDir;
    private String backupDir;
    private File backupDirectory;
    private String tempDir;
    private File tempDirectory;
    private HashSet locks;
    private boolean initialized = false;
    private String processType = null;
    private boolean inServer = false;
    private RepositoryLock repositoryLock = null;
    private ConfigEpoch repositoryEpoch;
    private boolean auditingEnabled = true;
    private ArrayList listeners;
    private boolean listenersUpdated;
    private Object[] listenersCopy;
    private boolean allowOverwrites = false;
    private static TraceComponent tc = Tr.register(FileRepository.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");
    private FileTransferOptions ftOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
    private FileTransferConfig ftConfig = null;
    private Properties configProperties = null;
    private static final int AVAILABLE = 0;
    private static final int UNAVAILABLE = 1;
    private static final int INVALID = 2;
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final String HOT_RESTART_SYNC = "hotRestartSync";
    private boolean hotRestartSync = false;
    private final String CELL_EPOCH_FILE_NAME = "fileRepositoryCellLevel.epoch";

    private FileRepository() {
    }

    public static FileRepository getRepository() {
        return repository;
    }

    public synchronized void initialize(Properties properties) throws AdminException {
        Object object;
        Constable constable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (this.initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Config repository already initialized");
            }
            return;
        }
        String string = System.getProperty("com.ibm.ws.management.standalone");
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Standalone system property set.");
            }
            this.processType = "UnManagedProcess";
            this.inServer = false;
        } else {
            try {
                AdminServiceFactory.getMBeanFactory().activateMBean("ConfigRepository", this, "repository", null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.repository.FileRepository.initialize", "149", this);
                Tr.error(tc, "ADMR0006E", adminException);
                throw adminException;
            }
            this.processType = AdminServiceFactory.getAdminService().getProcessType();
            this.inServer = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processType = " + this.processType);
        }
        this.processProps(properties);
        if (this.tempDir != null && new File(this.tempDir).exists() && this.inServer) {
            new TrashSweepTask(this.tempDir).triggerSweep();
        }
        this.initialized = true;
        if (this.hotRestartSync) {
            this.repositoryEpoch = this.loadCellEpochFromFile();
            if (this.repositoryEpoch == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No persisted epoch file found. Initialize the epoch for the repository now");
                }
                this.repositoryEpoch = new ConfigEpoch();
            }
        } else {
            this.repositoryEpoch = new ConfigEpoch();
        }
        this.listeners = new ArrayList();
        this.listenersUpdated = true;
        this.addListener(this);
        try {
            constable = Class.forName("com.ibm.ws.management.application.sync.AppBinaryProcessor");
            object = constable.getConstructor(Boolean.class, ConfigRepository.class);
            Boolean bl = new Boolean(string != null);
            Object t = ((Constructor)object).newInstance(bl, this);
            this.addListener((ConfigRepositoryListener)t);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.initialize", "225", this);
            Tr.error(tc, "ADMR0118E", throwable);
        }
        try {
            constable = new Boolean(string != null);
            object = new J2CRAProcessor((Boolean)constable, this);
            this.addListener((ConfigRepositoryListener)object);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.initialize", "249", this);
            Tr.error(tc, "ADMR0118E", throwable);
        }
        this.locks = new HashSet();
        FileDocument.setRepository(this);
        this.repositoryLock = RepositoryLockFactory.createRepositoryLock();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Properties getConfig() {
        return (Properties)this.configProperties.clone();
    }

    private void processProps(Properties properties) throws AdminException {
        String string;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processProps");
        }
        properties = properties == null ? new Properties() : (Properties)properties.clone();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "repository props:", properties);
        }
        this.configProperties = properties;
        this.repositoryDir = System.getProperty("was.repository.root");
        if (this.repositoryDir == null) {
            this.repositoryDir = properties.getProperty("was.repository.root");
            if (this.repositoryDir == null) {
                object = System.getProperty("user.install.root");
                if (object != null && !((String)object).equals("")) {
                    this.repositoryDir = (String)object + File.separator + "config";
                } else {
                    object = properties.getProperty("user.install.root");
                    if (object != null && !((String)object).equals("")) {
                        this.repositoryDir = (String)object + File.separator + "config";
                    }
                }
                if (this.repositoryDir == null) {
                    object = System.getProperty("was.install.root");
                    if (object != null && !((String)object).equals("")) {
                        this.repositoryDir = (String)object + File.separator + "config";
                    } else {
                        object = properties.getProperty("was.install.root");
                        if (object != null && !((String)object).equals("")) {
                            this.repositoryDir = (String)object + File.separator + "config";
                        }
                    }
                }
            }
        }
        if (this.repositoryDir == null) {
            Tr.error(tc, "ADMR0001E");
            throw new AdminException("Neither was.repository.root nor was.install.root are set");
        }
        object = new File(this.repositoryDir);
        if (!((File)object).isDirectory()) {
            Tr.error(tc, "ADMR0001E");
            throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
        }
        try {
            this.repositoryDir = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            Tr.error(tc, "ADMR0001E");
            throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
        }
        String string2 = System.getProperty("was.repository.temp");
        if (string2 == null) {
            string2 = properties.getProperty("was.repository.temp");
        }
        if (string2 != null) {
            object = new File(string2);
            try {
                string = ((File)object).getCanonicalPath();
                if (string.startsWith(this.repositoryDir + File.separator) && !string.equals(this.repositoryDir + File.separator + "temp")) {
                    Tr.warning(tc, "ADMR0014W", string2);
                    string2 = null;
                }
            }
            catch (IOException iOException) {
                Tr.warning(tc, "ADMR0014W", string2);
                string2 = null;
            }
        }
        this.tempDir = string2 != null ? string2 : this.repositoryDir + File.separator + "temp";
        object = new File(this.tempDir);
        if (((File)object).exists()) {
            if (!((File)object).isDirectory()) {
                Tr.warning(tc, "ADMR0014W", this.tempDir);
                this.tempDir = this.repositoryDir + File.separator + "temp";
            }
        } else if (!((File)object).mkdirs()) {
            Tr.warning(tc, "ADMR0014W", this.tempDir);
            this.tempDir = this.repositoryDir + File.separator + "temp";
        }
        try {
            object = new File(this.tempDir);
            this.tempDir = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.tempDir = this.repositoryDir + File.separator + "temp";
        }
        string = System.getProperty("was.repository.backup");
        if (string == null) {
            string = properties.getProperty("was.repository.backup");
        }
        if (string != null) {
            object = new File(string);
            try {
                String string3 = ((File)object).getCanonicalPath();
                if (string3.startsWith(this.repositoryDir + File.separator) && !string3.equals(this.repositoryDir + File.separator + "backup")) {
                    Tr.warning(tc, "ADMR0013W", string);
                    string = null;
                }
            }
            catch (IOException iOException) {
                Tr.warning(tc, "ADMR0013W", string);
                string = null;
            }
        }
        this.backupDir = string != null ? string : this.repositoryDir + File.separator + "backup";
        object = new File(this.backupDir);
        if (((File)object).exists()) {
            if (!((File)object).isDirectory()) {
                this.backupDir = this.repositoryDir + File.separator + "backup";
            }
        } else if (!((File)object).mkdirs()) {
            this.backupDir = this.repositoryDir + File.separator + "backup";
        }
        try {
            object = new File(this.backupDir);
            this.backupDir = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.backupDir = this.repositoryDir + File.separator + "backup";
        }
        this.tempDirectory = new File(this.tempDir);
        this.backupDirectory = new File(this.backupDir);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "repositoryDir = " + this.repositoryDir);
            Tr.debug(tc, "tempDir = " + this.tempDir);
            Tr.debug(tc, "backupDir = " + this.backupDir);
        }
        this.tempDir = this.tempDir + File.separator;
        System.setProperty("was.repository.temp", this.tempDir);
        this.configProperties.setProperty("was.repository.root", this.repositoryDir);
        this.configProperties.setProperty("was.repository.temp", this.tempDir);
        this.configProperties.setProperty("was.repository.backup", this.backupDir);
        if (properties.containsKey("transfer.compression")) {
            boolean bl = false;
            try {
                bl = Boolean.valueOf((String)properties.get("transfer.compression"));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileRepository.initialize", "236", this);
            }
            this.ftOptions.setCompress(bl);
        }
        this.ftOptions.setDeleteSourceOnCompletion(true);
        this.ftOptions.setOverwrite(true);
        try {
            this.ftConfig = (FileTransferConfig)this.configProperties.get("fileTransferConfig");
            if (this.ftConfig == null) {
                this.ftConfig = new FileTransferConfigImpl();
                this.ftConfig.getProperties().setProperty("port", FileTransferConfigImpl.DEFAULT_PORT_STRING_VALUE);
                this.ftConfig.getProperties().setProperty("secure_port", "9043");
                this.ftConfig.setSecurityEnabled(false);
                if (this.inServer) {
                    this.ftConfig.getProperties().setProperty("host", AdminHelper.getInstance().getLocalHost().getHostAddress());
                } else {
                    this.ftConfig.getProperties().setProperty("host", InetAddress.getLocalHost().getHostAddress());
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.management.repository.FileRepository.initialize", "252", this);
            this.ftConfig.getProperties().setProperty("host", "localhost");
        }
        String string4 = properties.getProperty("auditingEnabled");
        if (string4 != null) {
            this.auditingEnabled = string4.equalsIgnoreCase("true");
        }
        this.allowOverwrites = this.processType.equals("NodeAgent") || !this.inServer;
        String string5 = properties.getProperty("allowConfigOverwrites");
        if (string5 != null) {
            if (string5.equals("false")) {
                if (this.processType.equals("DeploymentManager") || this.processType.equals("ManagedProcess")) {
                    this.allowOverwrites = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Overwrites are disabled.");
                    }
                } else {
                    Tr.warning(tc, "ADMR0022W");
                }
            } else if (string5.equals("true")) {
                this.allowOverwrites = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Overwrites are enabled.");
                }
            }
        }
        this.configProperties.setProperty("allowConfigOverwrites", String.valueOf(this.allowOverwrites));
        if (Boolean.getBoolean(HOT_RESTART_SYNC)) {
            this.hotRestartSync = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hot restart sync is enabled for FileRepository.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processProps");
        }
    }

    public FileTransferOptions getFileTransferOptions() {
        return this.ftOptions;
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig fileTransferConfig) {
        this.ftConfig = fileTransferConfig;
        FileDocument.setRepository(this);
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public DocumentDigest create(DocumentContentSource documentContentSource) throws RepositoryException {
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[]{documentContentSource};
        DocumentDigest[] documentDigestArray = this.create(documentContentSourceArray);
        return documentDigestArray[0];
    }

    public DocumentDigest[] create(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        HashMap hashMap = this.update(documentContentSourceArray, null, null);
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            documentDigestArray[i] = (DocumentDigest)hashMap.get(documentContentSourceArray[i].getDocument().getURI());
        }
        return documentDigestArray;
    }

    private synchronized void preCreate(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preCreate", documentContentSourceArray);
        }
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                String string = documentContentSourceArray[n].getDocument().getURI();
                this.checkAccessPermission(string, 1);
                this.lockDocument(string);
                if (this.status(string) == 2) continue;
                this.clearSource(documentContentSourceArray);
                this.unlockDocument(string);
                Tr.service(tc, "ADMR0000E", string);
                throw new DocumentAlreadyExistsException(string);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.preCreate", "536", this);
            for (int i = 0; i < n; ++i) {
                try {
                    this.unlockDocument(documentContentSourceArray[i].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.warning(tc, "ADMR0107E", new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable2});
                }
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preCreate", documentContentSourceArray);
        }
    }

    private DocumentDigest[] createInternal(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInternal");
        }
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                String string = documentContentSourceArray[n].getDocument().getURI();
                documentDigestArray[n] = FileDocument.create(documentContentSourceArray[n]);
            }
        }
        catch (Throwable throwable) {
            int n2;
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.createInternal", "579", this);
            for (n2 = 0; n2 <= n; ++n2) {
                try {
                    FileDocument.delete(documentContentSourceArray[n2].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.warning(tc, "ADMR0113E", new Object[]{documentContentSourceArray[n2].getDocument().getURI(), throwable2});
                }
            }
            while (n2 < documentContentSourceArray.length) {
                this.clearSource(documentContentSourceArray[n2]);
                ++n2;
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInternal");
        }
        return documentDigestArray;
    }

    private void postCreate(DocumentContentSource[] documentContentSourceArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postCreate");
        }
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            String string = documentContentSourceArray[i].getDocument().getURI();
            try {
                this.unlockDocument(string);
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMR0107E", new Object[]{string, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postCreate");
        }
    }

    private void undoCreate(DocumentContentSource[] documentContentSourceArray) {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            try {
                FileDocument.delete(documentContentSourceArray[i].getDocument().getURI());
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMR0113E", new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable});
            }
        }
    }

    public void delete(Document document) throws RepositoryException {
        Document[] documentArray = new Document[]{document};
        this.delete(documentArray);
    }

    public void delete(String string) throws RepositoryException {
        this.delete(new Document(string));
    }

    public void delete(Document[] documentArray) throws RepositoryException {
        this.update(null, null, documentArray);
    }

    public void delete(String[] stringArray) throws RepositoryException {
        Document[] documentArray = new Document[stringArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            documentArray[i] = new Document(stringArray[i]);
        }
        this.delete(documentArray);
    }

    private synchronized void preDelete(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preDelete");
        }
        int n = 0;
        try {
            for (n = 0; n < documentArray.length; ++n) {
                this.checkAccessPermission(documentArray[n].getURI(), 1);
                this.lockDocument(documentArray[n].getURI());
                int n2 = this.status(documentArray[n].getURI());
                if (n2 == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "invalid URI " + documentArray[n].getURI());
                    }
                    this.unlockDocument(documentArray[n].getURI());
                    throw new DocumentNotFoundException(documentArray[n].getURI());
                }
                try {
                    FileDocument.backup(documentArray[n].getURI());
                    continue;
                }
                catch (Throwable throwable) {
                    this.unlockDocument(documentArray[n].getURI());
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.preDelete", "711", this);
            for (int i = 0; i < n; ++i) {
                try {
                    FileDocument.removeBackup(documentArray[i].getURI());
                }
                catch (Throwable throwable2) {
                    Tr.warning(tc, "ADMR0110W", new Object[]{documentArray[i].getURI(), throwable2});
                }
                try {
                    this.unlockDocument(documentArray[i].getURI());
                    continue;
                }
                catch (Throwable throwable3) {
                    Tr.warning(tc, "ADMR0107E", new Object[]{documentArray[i].getURI(), throwable3});
                }
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkExistenceAndLock");
        }
    }

    private void deleteInternal(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteInternal");
        }
        int n = 0;
        try {
            for (n = 0; n < documentArray.length; ++n) {
                FileDocument.delete(documentArray[n].getURI());
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.deleteInternal", "852", this);
            for (int i = 0; i <= n; ++i) {
                try {
                    FileDocument.restore(documentArray[i].getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.error(tc, "ADMR0109E", new Object[]{documentArray[i].getURI(), throwable2});
                }
            }
            Tr.error(tc, "ADMR0111E", documentArray[n].getURI());
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteInternal");
        }
    }

    private void postDelete(Document[] documentArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postDelete");
        }
        for (int i = 0; i < documentArray.length; ++i) {
            try {
                FileDocument.removeBackup(documentArray[i].getURI());
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMR0110W", new Object[]{documentArray[i].getURI(), throwable});
            }
            try {
                this.unlockDocument(documentArray[i].getURI());
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMR0107E", new Object[]{documentArray[i].getURI(), throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postDelete");
        }
    }

    public void rename(String string, String string2) throws RepositoryException {
        this.rename(new Document(string), new Document(string2));
    }

    public void rename(Document document, Document document2) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rename");
        }
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[]{this.extract(document)};
        documentContentSourceArray[0].getDocument().setURI(document2.getURI());
        Document[] documentArray = new Document[]{document};
        this.update(documentContentSourceArray, null, documentArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rename");
        }
    }

    public DocumentContentSource extract(String string) throws RepositoryException {
        return this.extract(new Document(string));
    }

    public DocumentContentSource extract(Document document) throws RepositoryException {
        Document[] documentArray = new Document[]{document};
        DocumentContentSource[] documentContentSourceArray = this.extract(documentArray);
        return documentContentSourceArray[0];
    }

    public DocumentContentSource[] extract(String[] stringArray) throws RepositoryException {
        Document[] documentArray = new Document[stringArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            documentArray[i] = new Document(stringArray[i]);
        }
        return this.extract(documentArray);
    }

    public DocumentContentSource[] extract(Document[] documentArray) throws RepositoryException {
        DocumentContentSource[] documentContentSourceArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract[]");
        }
        if (documentArray == null) {
            return new DocumentContentSource[0];
        }
        this.fixURIs(documentArray);
        ArrayList<Document> arrayList = new ArrayList<Document>();
        for (int i = 0; i < documentArray.length; ++i) {
            documentContentSourceArray = documentArray[i].getURI();
            if (!this.checkInvocationPermission((String)documentContentSourceArray, 0)) continue;
            arrayList.add(documentArray[i]);
        }
        Document[] documentArray2 = arrayList.toArray(new Document[0]);
        documentContentSourceArray = this.extractInternal(documentArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract[]");
        }
        return documentContentSourceArray;
    }

    private DocumentContentSource[] extractInternal(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractInternal");
        }
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[documentArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            this.checkAccessPermission(documentArray[i].getURI(), 0);
            int n = this.status(documentArray[i].getURI());
            if (n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: invalid URI; " + documentArray[i].getURI());
                }
                throw new DocumentNotFoundException(documentArray[i].getURI());
            }
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: unavailable URI; " + documentArray[i].getURI());
                }
                throw new DocumentUnavailableException(documentArray[i].getURI());
            }
            documentContentSourceArray[i] = FileDocument.read(documentArray[i].getURI());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Extracted " + documentArray[i].getURI() + "; digest is " + documentContentSourceArray[i].getDocument().getDigest());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractInternal");
        }
        return documentContentSourceArray;
    }

    public DocumentContentSource extract(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public DocumentContentSource[] extract(String[] stringArray, String[] stringArray2) {
        throw new UnsupportedOperationException();
    }

    public DocumentDigest modify(DocumentContentSource documentContentSource) throws RepositoryException {
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[]{documentContentSource};
        DocumentDigest[] documentDigestArray = this.modify(documentContentSourceArray);
        return documentDigestArray[0];
    }

    public DocumentDigest[] modify(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        HashMap hashMap = this.update(null, documentContentSourceArray, null);
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            documentDigestArray[i] = (DocumentDigest)hashMap.get(documentContentSourceArray[i].getDocument().getURI());
        }
        return documentDigestArray;
    }

    private synchronized void preModify(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preModify");
        }
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                Document document = documentContentSourceArray[n].getDocument();
                this.checkAccessPermission(document.getURI(), 1);
                this.lockDocument(document.getURI());
                int n2 = this.status(document.getURI());
                if (n2 == 2) {
                    this.clearSource(documentContentSourceArray);
                    this.unlockDocument(document.getURI());
                    throw new DocumentNotFoundException(document.getURI());
                }
                try {
                    this.checkDigest(document);
                    FileDocument.backup(document.getURI());
                    continue;
                }
                catch (Throwable throwable) {
                    this.unlockDocument(document.getURI());
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.preModify", "1009", this);
            for (int i = 0; i < n; ++i) {
                try {
                    FileDocument.removeBackup(documentContentSourceArray[i].getDocument().getURI());
                }
                catch (Throwable throwable2) {
                    Tr.warning(tc, "ADMR0110W", new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable2});
                }
                try {
                    this.unlockDocument(documentContentSourceArray[i].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable3) {
                    Tr.warning(tc, "ADMR0107E", new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable3});
                }
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preModify");
        }
    }

    private DocumentDigest[] modifyInternal(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyInternal");
        }
        DocumentDigest[] documentDigestArray = new DocumentDigest[documentContentSourceArray.length];
        int n = 0;
        try {
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                documentDigestArray[n] = FileDocument.write(documentContentSourceArray[n]);
            }
        }
        catch (Throwable throwable) {
            int n2;
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.modifyInternal", "1061", this);
            for (n2 = 0; n2 <= n; ++n2) {
                try {
                    FileDocument.restore(documentContentSourceArray[n2].getDocument().getURI());
                    continue;
                }
                catch (Throwable throwable2) {
                    Tr.error(tc, "ADMR0109E", new Object[]{documentContentSourceArray[n2].getDocument().getURI(), throwable2});
                }
            }
            while (n2 < documentContentSourceArray.length) {
                this.clearSource(documentContentSourceArray[n2]);
                ++n2;
            }
            throw this.getRepositoryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyInternal");
        }
        return documentDigestArray;
    }

    private void postModify(DocumentContentSource[] documentContentSourceArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postModify");
        }
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            String string = documentContentSourceArray[i].getDocument().getURI();
            try {
                FileDocument.removeBackup(string);
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMR0110W", new Object[]{string, throwable});
            }
            try {
                this.unlockDocument(string);
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMR0107E", new Object[]{string, throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postModify");
        }
    }

    private void undoModify(DocumentContentSource[] documentContentSourceArray) {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            try {
                FileDocument.restore(documentContentSourceArray[i].getDocument().getURI());
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMR0109E", new Object[]{documentContentSourceArray[i].getDocument().getURI(), throwable});
            }
        }
    }

    public HashMap update(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        Object object;
        HashMap hashMap;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update");
            }
            if (documentContentSourceArray == null) {
                documentContentSourceArray = new DocumentContentSource[]{};
            }
            if (documentContentSourceArray2 == null) {
                documentContentSourceArray2 = new DocumentContentSource[]{};
            }
            if (documentArray == null) {
                documentArray = new Document[]{};
            }
            this.fixURIs(documentContentSourceArray);
            this.fixURIs(documentContentSourceArray2);
            this.fixURIs(documentArray);
            hashMap = null;
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            for (int i = 0; i < documentContentSourceArray.length; ++i) {
                String string = documentContentSourceArray[i].getDocument().getURI();
                if (!this.checkInvocationPermission(string, 1)) continue;
                arrayList.add(documentContentSourceArray[i]);
            }
            DocumentContentSource[] documentContentSourceArray3 = arrayList.toArray(new DocumentContentSource[0]);
            arrayList = new ArrayList();
            for (int i = 0; i < documentArray.length; ++i) {
                String string = documentArray[i].getURI();
                if (!this.checkInvocationPermission(string, 1)) continue;
                arrayList.add(documentArray[i]);
            }
            Document[] documentArray2 = arrayList.toArray(new Document[0]);
            arrayList = new ArrayList();
            for (int i = 0; i < documentContentSourceArray2.length; ++i) {
                object = documentContentSourceArray2[i].getDocument().getURI();
                if (!this.checkInvocationPermission((String)object, 1)) continue;
                arrayList.add(documentContentSourceArray2[i]);
            }
            DocumentContentSource[] documentContentSourceArray4 = arrayList.toArray(new DocumentContentSource[0]);
            this.preUpdate(documentContentSourceArray3, documentContentSourceArray4, documentArray2);
            object = this.preNotify(documentContentSourceArray3, documentContentSourceArray4, documentArray2);
            try {
                hashMap = this.updateInternal(documentContentSourceArray3, documentContentSourceArray4, documentArray2);
                this.postUpdate(documentContentSourceArray3, documentContentSourceArray4, documentArray2);
                if (hashMap == null) break block15;
                this.updateRepositoryEpoch();
            }
            catch (RepositoryException repositoryException) {
                try {
                    throw repositoryException;
                }
                catch (Throwable throwable) {
                    this.postUpdate(documentContentSourceArray3, documentContentSourceArray4, documentArray2);
                    if (hashMap != null) {
                        this.updateRepositoryEpoch();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Repository epoch updated");
                        }
                    }
                    this.postNotify((ConfigRepositoryEvent)object, hashMap != null);
                    throw throwable;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Repository epoch updated");
            }
        }
        this.postNotify((ConfigRepositoryEvent)object, hashMap != null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update", hashMap);
        }
        return hashMap;
    }

    private synchronized void preUpdate(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preUpdate");
        }
        this.preCreate(documentContentSourceArray);
        try {
            this.preModify(documentContentSourceArray2);
            try {
                this.preDelete(documentArray);
            }
            catch (RepositoryException repositoryException) {
                this.postModify(documentContentSourceArray2);
                throw repositoryException;
            }
        }
        catch (RepositoryException repositoryException) {
            this.postCreate(documentContentSourceArray);
            throw repositoryException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preUpdate");
        }
    }

    private HashMap updateInternal(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        HashMap<String, DocumentDigest> hashMap = null;
        DocumentDigest[] documentDigestArray = null;
        DocumentDigest[] documentDigestArray2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n;
            documentDigestArray = this.createInternal(documentContentSourceArray);
            bl = true;
            documentDigestArray2 = this.modifyInternal(documentContentSourceArray2);
            bl2 = true;
            this.deleteInternal(documentArray);
            hashMap = new HashMap<String, DocumentDigest>();
            for (n = 0; n < documentContentSourceArray.length; ++n) {
                hashMap.put(documentContentSourceArray[n].getDocument().getURI(), documentDigestArray[n]);
            }
            for (n = 0; n < documentContentSourceArray2.length; ++n) {
                hashMap.put(documentContentSourceArray2[n].getDocument().getURI(), documentDigestArray2[n]);
            }
        }
        catch (RepositoryException repositoryException) {
            if (bl) {
                this.undoCreate(documentContentSourceArray);
            }
            if (bl2) {
                this.undoModify(documentContentSourceArray2);
            }
            throw repositoryException;
        }
        return hashMap;
    }

    private void postUpdate(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) {
        this.postCreate(documentContentSourceArray);
        this.postModify(documentContentSourceArray2);
        this.postDelete(documentArray);
    }

    public DocumentDigest getDigest(String string) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest: " + string);
        }
        if (this.status(string) == 2) {
            throw new DocumentNotFoundException(string);
        }
        DocumentDigestImpl documentDigestImpl = FileDocument.getDigest(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest");
        }
        return documentDigestImpl;
    }

    public DocumentDigest[] getDigest(String[] stringArray) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest[]");
        }
        DocumentDigest[] documentDigestArray = new DocumentDigest[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            documentDigestArray[i] = this.getDigest(stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest[]");
        }
        return documentDigestArray;
    }

    public Boolean lockRepository(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lockRepository");
        }
        if (this.repositoryLock.isRepositoryLocked()) {
            return Boolean.FALSE;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < 20; ++i) {
            bl = this.lockRepository();
            if (bl) continue;
            this.sleep(500L);
        }
        if (bl) {
            Tr.service(tc, "ADMR0007I", string);
            Object[] objectArray = this.getListenersCopy();
            for (int i = 0; i < objectArray.length; ++i) {
                ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)objectArray[i];
                try {
                    configRepositoryListener.onRepositoryLock();
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.lockRepository", "1519", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lockRepository", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockRepository() {
        boolean bl = false;
        HashSet hashSet = this.locks;
        synchronized (hashSet) {
            if (this.locks.isEmpty() && !this.repositoryLock.isRepositoryLocked() && this.repositoryLock.lockRepository()) {
                bl = true;
            }
        }
        return bl;
    }

    private void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean unlockRepository(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unlockRepository");
        }
        boolean bl = false;
        Object[] objectArray = this.locks;
        synchronized (this.locks) {
            if (this.repositoryLock.isRepositoryLocked() && this.repositoryLock.unlockRepository()) {
                bl = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                Tr.service(tc, "ADMR0008I", string);
                objectArray = this.getListenersCopy();
                for (int i = 0; i < objectArray.length; ++i) {
                    ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)objectArray[i];
                    try {
                        configRepositoryListener.onRepositoryUnlock();
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.unlockRepository", "1594", this);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "unlockRepository", bl ? Boolean.TRUE : Boolean.FALSE);
            }
            return bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    private boolean exists(String string) {
        File file = new File(this.getRepositoryDir() + "/" + string.replace('\\', '/'));
        return file.exists();
    }

    private int status(String string) {
        int n = 2;
        if (this.exists(string)) {
            n = 0;
        } else if (this.exists(string + ".digest")) {
            n = 1;
        }
        return n;
    }

    private void clearSource(DocumentContentSource documentContentSource) {
        block3: {
            try {
                if (documentContentSource != null && documentContentSource.getSource() != null) {
                    documentContentSource.getSource().close();
                    documentContentSource.setSource((InputStream)null);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "clearSource error " + throwable.getMessage());
            }
        }
    }

    private void clearSource(DocumentContentSource[] documentContentSourceArray) {
        if (documentContentSourceArray != null) {
            for (int i = 0; i < documentContentSourceArray.length; ++i) {
                this.clearSource(documentContentSourceArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDocument(String string) throws DocumentLockedException, RepositoryLockedException {
        if (this.repositoryLock.isRepositoryLocked() && !this.repositoryLock.isLockOwner()) {
            throw new RepositoryLockedException();
        }
        boolean bl = false;
        for (int i = 0; !bl && i < 20; ++i) {
            HashSet hashSet = this.locks;
            synchronized (hashSet) {
                bl = this.locks.add(string);
            }
            if (bl) continue;
            this.sleep(500L);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Locked " + string);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " already locked");
            }
            throw new DocumentLockedException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockDocument(String string) {
        boolean bl;
        HashSet hashSet = this.locks;
        synchronized (hashSet) {
            bl = this.locks.remove(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unlocked " + string + "; " + bl);
        }
    }

    private void unlockDocument(Document document) {
        this.unlockDocument(document.getURI());
    }

    private void checkDigest(Document document) throws DocumentIOException, DocumentChangedException {
        DocumentDigestImpl documentDigestImpl = FileDocument.getDigest(document.getURI());
        if (!((Object)documentDigestImpl).equals(document.getDigest())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Digest check failed.  Given digest is " + document.getDigest() + "; current digest is " + documentDigestImpl);
            }
            if (!this.allowOverwrites || !document.getOverwrite()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modify " + document.getURI() + "; digest check");
                }
                throw new DocumentChangedException(document.getURI());
            }
            if (!this.processType.equals("NodeAgent")) {
                Tr.warning(tc, "ADMR0114W", document.getURI());
            }
        }
    }

    private RepositoryException getRepositoryException(Throwable throwable) {
        RepositoryException repositoryException = null;
        repositoryException = throwable instanceof RepositoryException ? (RepositoryException)throwable : new RepositoryException(throwable);
        return repositoryException;
    }

    private void fixURIs(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            String string = documentContentSourceArray[i].getDocument().getURI().replace('\\', '/');
            if (string.indexOf("../") > -1) {
                throw new InvalidDocumentURIException("Document URI uses relative path name: " + string);
            }
            documentContentSourceArray[i].getDocument().setURI(string);
        }
    }

    private void fixURIs(Document[] documentArray) throws RepositoryException {
        for (int i = 0; i < documentArray.length; ++i) {
            String string = documentArray[i].getURI().replace('\\', '/');
            if (string.indexOf("../") > -1) {
                throw new InvalidDocumentURIException("Document URI uses relative path name: " + string);
            }
            documentArray[i].setURI(string);
        }
    }

    private void audit(ConfigRepositoryEvent configRepositoryEvent) {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (this.auditingEnabled) {
            string2 = SecurityHelper.getAuditUserName();
            ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
            for (int i = 0; i < configChangeNotifierArray.length; ++i) {
                string = configChangeNotifierArray[i].getChangeType() == 0 ? (string2 == null ? "ADMR0009I" : "ADMR0015I") : (configChangeNotifierArray[i].getChangeType() == 2 ? (string2 == null ? "ADMR0010I" : "ADMR0016I") : (string2 == null ? "ADMR0011I" : "ADMR0017I"));
                objectArray = string2 == null ? new Object[]{configChangeNotifierArray[i].getUri()} : new Object[]{configChangeNotifierArray[i].getUri(), string2};
                Tr.audit(tc, string, objectArray);
            }
        }
    }

    private ConfigRepositoryEvent preNotify(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) {
        int n;
        ConfigChangeNotifier[] configChangeNotifierArray = new ConfigChangeNotifier[documentContentSourceArray.length + documentContentSourceArray2.length + documentArray.length];
        int n2 = 0;
        for (n = 0; n < documentContentSourceArray.length; ++n) {
            configChangeNotifierArray[n2++] = new ConfigChangeNotifier(documentContentSourceArray[n].getDocument().getURI(), 0);
        }
        for (n = 0; n < documentContentSourceArray2.length; ++n) {
            configChangeNotifierArray[n2++] = new ConfigChangeNotifier(documentContentSourceArray2[n].getDocument().getURI(), 2);
        }
        for (n = 0; n < documentArray.length; ++n) {
            configChangeNotifierArray[n2++] = new ConfigChangeNotifier(documentArray[n].getURI(), 1);
        }
        ConfigRepositoryEvent configRepositoryEvent = new ConfigRepositoryEvent(this, ConfigRepositoryEvent.generateId(), configChangeNotifierArray);
        Object[] objectArray = this.getListenersCopy();
        for (int i = 0; i < objectArray.length; ++i) {
            ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)objectArray[i];
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling listener onChangeStart: " + configRepositoryListener);
                }
                configRepositoryListener.onChangeStart(configRepositoryEvent);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Back from listener onChangeStart: " + configRepositoryListener);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.preNotify", "1836", this);
            }
        }
        return configRepositoryEvent;
    }

    private void postNotify(ConfigRepositoryEvent configRepositoryEvent, boolean bl) {
        Object object;
        Object[] objectArray;
        if (!bl) {
            objectArray = new ConfigChangeNotifier[]{};
            object = new ConfigRepositoryEvent(this, configRepositoryEvent.getId(), (ConfigChangeNotifier[])objectArray);
            configRepositoryEvent = object;
        }
        objectArray = this.getListenersCopy();
        object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)objectArray[i];
            try {
                if (!configRepositoryListener.equals(this)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling listener onChangeCompletion: " + configRepositoryListener);
                    }
                    configRepositoryListener.onChangeCompletion(configRepositoryEvent);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from listener onChangeCompletion: " + configRepositoryListener);
                    continue;
                }
                object = configRepositoryListener;
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.postNotify", "1870", this);
            }
        }
        if (object != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling JMX listener onChangeCompletion: " + object);
                }
                object.onChangeCompletion(configRepositoryEvent);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Back from JMX listener onChangeCompletion: " + object);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.postNotify", "1926", this);
            }
        }
    }

    public String[] listResourceNames(String string, int n, int n2, ResourceNameFilter resourceNameFilter) {
        ResourceNameFilter resourceNameFilter2 = resourceNameFilter;
        if (resourceNameFilter2 == null) {
            resourceNameFilter2 = this;
        }
        File file = new File(this.getRepositoryDir() + "/" + string);
        if (this.status(string) == 2) {
            return new String[0];
        }
        if (n2 == 0) {
            if (resourceNameFilter2 == this) {
                if (resourceNameFilter2.accept(string, "") && this.isMatchingType(file, n)) {
                    return new String[]{string};
                }
                return new String[0];
            }
            if (this.accept(string, "") && resourceNameFilter2.accept(string, "") && this.isMatchingType(file, n)) {
                return new String[]{string};
            }
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        if (file.list() != null) {
            this.addResourceNames(arrayList, file, n, n2 - 1, resourceNameFilter2);
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    private boolean eliminateEmptyFolders(ArrayList arrayList, File file) {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length && (bl = fileArray[i].isDirectory() ? this.eliminateEmptyFolders(arrayList, fileArray[i]) : false); ++i) {
            }
        } else {
            this.removeEmptyFolder(arrayList, file);
        }
        return bl;
    }

    protected void addResourceNames(ArrayList arrayList, File file, int n, int n2, ResourceNameFilter resourceNameFilter) {
        File[] fileArray = this.getFiles(file);
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (resourceNameFilter == this) {
                    if (resourceNameFilter.accept(this.getUri(file), fileArray[i].getName()) && this.isMatchingType(fileArray[i], n)) {
                        arrayList.add(this.getUri(fileArray[i]));
                    }
                } else if (this.accept(this.getUri(file), fileArray[i].getName()) && resourceNameFilter.accept(this.getUri(file), fileArray[i].getName()) && this.isMatchingType(fileArray[i], n)) {
                    arrayList.add(this.getUri(fileArray[i]));
                }
                if (!fileArray[i].isDirectory()) continue;
                if (n2 > 0) {
                    this.addResourceNames(arrayList, fileArray[i], n, n2 - 1, resourceNameFilter);
                    continue;
                }
                this.eliminateEmptyFolders(arrayList, fileArray[i]);
            }
        } else {
            this.removeEmptyFolder(arrayList, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEmptyFolder(ArrayList arrayList, File file) {
        if (!file.equals(this.tempDirectory) && !file.equals(this.backupDirectory)) {
            if (arrayList.contains(this.getUri(file))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing " + this.getUri(file));
                }
                arrayList.remove(this.getUri(file));
            }
            Object object = FileDocument.getDirLock();
            synchronized (object) {
                if (file.delete()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deleted " + this.getUri(file));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to delete " + this.getUri(file));
                }
            }
            object = file.getParentFile();
            File[] fileArray = ((File)object).listFiles();
            if (fileArray != null && fileArray.length < 1) {
                this.removeEmptyFolder(arrayList, (File)object);
            }
        }
    }

    private File[] getFiles(File file) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFiles");
        }
        File[] fileArray = file.listFiles();
        HashMap<Object, File> hashMap = new HashMap<Object, File>();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (string.endsWith(".digest")) {
                    object = string.substring(0, string.lastIndexOf(".digest"));
                    hashMap.put(object, new File(file, (String)object));
                    continue;
                }
                hashMap.put(string, fileArray[i]);
            }
        }
        File[] fileArray2 = new File[hashMap.size()];
        int n = 0;
        if (hashMap.size() > 0) {
            object = hashMap.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                fileArray2[n++] = (File)entry.getValue();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFiles");
        }
        return fileArray2;
    }

    public String[] listResourceNames(String string, int n, int n2) {
        return this.listResourceNames(string, n, n2, this);
    }

    protected int getType(File file) {
        if (file.isDirectory()) {
            return 2;
        }
        return 1;
    }

    protected boolean isMatchingType(int n, int n2) {
        return (n & n2) != 0;
    }

    protected boolean isMatchingType(File file, int n) {
        int n2 = this.getType(file);
        return (n2 & n) != 0;
    }

    protected String getUri(File file) {
        String string = file.getAbsolutePath();
        if (string.length() <= this.getRepositoryDir().length()) {
            return "/";
        }
        return string.substring(this.getRepositoryDir().length() + 1).replace('\\', '/');
    }

    public boolean accept(String string, String string2) {
        boolean bl = true;
        if (string.equals("/")) {
            bl = !string2.equals("backup") && !string2.equals("temp");
        } else if (string.equals("backup") || string.startsWith("backup/") || string.equals("temp") || string.startsWith("temp/")) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigRepositoryListener configRepositoryListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding listener: " + configRepositoryListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (configRepositoryListener != null && !this.listeners.contains(configRepositoryListener)) {
                if (configRepositoryListener instanceof CellSync) {
                    this.listeners.add(0, configRepositoryListener);
                } else {
                    this.listeners.add(configRepositoryListener);
                }
                this.listenersUpdated = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigRepositoryListener configRepositoryListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removing listener: " + configRepositoryListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(configRepositoryListener);
            this.listenersUpdated = true;
        }
    }

    public ConfigEpoch getRepositoryEpoch() {
        return this.repositoryEpoch;
    }

    public ConfigEpoch refreshRepositoryEpoch() {
        this.repositoryEpoch.refresh();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Refreshed repository epoch: " + this.repositoryEpoch);
        }
        Object[] objectArray = this.getListenersCopy();
        for (int i = 0; i < objectArray.length; ++i) {
            ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)objectArray[i];
            try {
                configRepositoryListener.onRepositoryEpochRefresh();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.refreshRepositoryEpoch", "2091", this);
            }
        }
        return this.repositoryEpoch;
    }

    private void updateRepositoryEpoch() {
        this.repositoryEpoch.update();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updated repository epoch: " + this.repositoryEpoch);
        }
    }

    public void createDigestFile(String string, boolean bl) throws RepositoryException {
        string = string.replace('\\', '/');
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createDigestFile: " + string);
        }
        this.lockDocument(string);
        String string2 = string + ".digest";
        try {
            this.lockDocument(string2);
        }
        catch (DocumentLockedException documentLockedException) {
            this.unlockDocument(string);
            throw documentLockedException;
        }
        try {
            int n = this.status(string);
            if (n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDigestFile: invalid URI " + string);
                }
                throw new DocumentNotFoundException(string);
            }
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createDigestFile: unavailable URI; " + string);
                }
                throw new DocumentUnavailableException(string);
            }
            FileDocument.createDigestFile(string, bl);
        }
        catch (RepositoryException repositoryException) {
            throw repositoryException;
        }
        finally {
            this.unlockDocument(string2);
            this.unlockDocument(string);
        }
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.change", this.getObjectName(), System.currentTimeMillis());
                notification.setUserData(configRepositoryEvent);
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.onChangeCompletion", "1705", this);
            }
        }
        this.audit(configRepositoryEvent);
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onRepositoryLock() {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.lock", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.onRepositoryLock", "1742", this);
            }
        }
    }

    public void onRepositoryUnlock() {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.unlock", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.onRepositoryUnlock", "1762", this);
            }
        }
    }

    public void onRepositoryEpochRefresh() {
        if (this.inServer) {
            try {
                Notification notification = new Notification("websphere.repository.epoch.refresh", this.getObjectName(), System.currentTimeMillis());
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.onRepositoryEpochRefresh", "1954", this);
            }
        }
        Tr.audit(tc, "ADMR0012I");
    }

    private void checkAccessPermission(String string, int n) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccessPermission (docURI=" + string + ", accessType=" + n + ")");
        }
        boolean bl = n == 0 ? !RestrictedAccess.isReadable(string) : RestrictedAccess.isRestricted(string);
        if (this.inServer && bl) {
            RoleBasedAuthorizer roleBasedAuthorizer = this.getAuthorizer();
            if (string.endsWith("admin-authz.xml") && roleBasedAuthorizer.isCallerInRole("adminsecuritymanager")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminsecuritymanager allowed access to admin-authz.xml");
                }
            } else {
                ThreadLocal threadLocal = SystemModifiedFiles.getThreadLocalFileSet();
                Set set = null;
                if (threadLocal != null) {
                    set = (Set)threadLocal.get();
                }
                if (n == 1 && set != null && set.contains(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "File (" + string + ") modified while running as System could be modified");
                    }
                } else if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                    Tr.audit(tc, "ADMR0021E", new Object[]{SecurityHelper.getUserName(), string});
                    throw new RepositoryException("Caller is not in the required role to access restricted document: " + string);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccessPermission");
            }
        }
    }

    private boolean checkInvocationPermission(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkInvocationPermission (docURI=" + string + ", accessType=" + n);
        }
        if (this.inServer && SecurityHelper.getHelper().isSecurityEnabled()) {
            String string2 = n == 0 ? "monitor" : "configurator";
            AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
            if (adminAuthorizer != null && !adminAuthorizer.checkAccess(string, string2)) {
                ThreadLocal threadLocal = SystemModifiedFiles.getThreadLocalFileSet();
                Set set = null;
                if (threadLocal != null) {
                    set = (Set)threadLocal.get();
                }
                if (set != null && !set.contains(string)) {
                    String string3 = SecurityHelper.getUserName() + " is not in required role to ";
                    string3 = n == 0 ? string3 + "read configuration data" : string3 + "update configuration data";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Access Check failed for " + string + " " + string3);
                    }
                    return false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkInvocationPermission: true");
        }
        return true;
    }

    private RoleBasedAuthorizer getAuthorizer() throws RepositoryException {
        RoleBasedAuthorizer roleBasedAuthorizer = null;
        try {
            roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.getAuthorizer", "2200", this);
            throw new RepositoryException(throwable, "Unable to get caller's security role");
        }
        return roleBasedAuthorizer;
    }

    private synchronized Object[] getListenersCopy() {
        if (this.listenersUpdated) {
            this.listenersCopy = this.listeners.toArray();
            this.listenersUpdated = false;
        }
        return this.listenersCopy;
    }

    private ConfigEpoch loadCellEpochFromFile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCellEpochFromFile");
        }
        ConfigEpoch configEpoch = null;
        String string = AdminServiceFactory.getAdminService().getProcessName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AdminServiceFactory.getAdminService().getProcessName() = " + string);
        }
        if (!"dmgr".equalsIgnoreCase(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadCellEpochFromFile", "Not dmgr - No epoch persistence");
            }
            return configEpoch;
        }
        String string2 = this.getEpochFileName();
        Vector vector = EpochFileHelper.loadEpochFromFile(string2);
        if (!vector.isEmpty()) {
            configEpoch = new ConfigEpoch((String)vector.firstElement());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCellEpochFromFile");
        }
        return configEpoch;
    }

    public String getEpochFileName() {
        String string = null;
        String string2 = System.getProperty("user.install.root");
        if (string2 != null && !string2.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "System property user.intsall.root = " + string2);
            }
            String string3 = AdminServiceFactory.getAdminService().getProcessName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminServiceFactory.getAdminService().getProcessName() = " + string3);
            }
            string = string2 + File.separator + "logs" + File.separator + string3 + File.separator + "fileRepositoryCellLevel.epoch";
        }
        return string;
    }

    class TrashSweepTask
    implements Runnable,
    AlarmListener {
        private static final long MILLIS_PER_MINUTE = 60000L;
        private static final String SWEEP_INTERVAL_PROP = "com.ibm.ws.management.repository.tempFileSweepIntervalMinutes";
        private static final long DEFAULT_SWEEP_MINUTES = 720L;
        private static final long MIN_SWEEP_MINUTES = 0L;
        private static final String KEEPTIME_PROP = "com.ibm.ws.management.repository.tempFileKeepTimeMinutes";
        private static final long DEFAULT_KEEP_MINUTES = 1440L;
        private static final long MIN_KEEP_MINUTES = 60L;
        private static final int MAX_PATHLIST_LEN = 2048;
        private final long sweepIntervalMinutes;
        private final long keepTimeMinutes;
        private File tmpRoot;
        private boolean alarmSet = false;

        public TrashSweepTask(String string) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TrashSweepTask created with root tmpdir " + string);
            }
            this.tmpRoot = new File(string);
            this.sweepIntervalMinutes = this.getLongSystemProperty(SWEEP_INTERVAL_PROP, 0L, 720L);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sweepIntervalMinutes = " + this.sweepIntervalMinutes);
            }
            this.keepTimeMinutes = this.getLongSystemProperty(KEEPTIME_PROP, 60L, 1440L);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keepTimeMinutes = " + this.keepTimeMinutes);
            }
        }

        private long getLongSystemProperty(String string, long l, long l2) {
            boolean bl;
            long l3;
            block8: {
                l3 = -9999L;
                bl = false;
                String string2 = System.getProperty(string);
                if (string2 != null) {
                    try {
                        l3 = Long.parseLong(string2);
                        if (l3 >= l) {
                            bl = true;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid value '" + l3 + "' for system property " + string + "; must have a value of " + l + " or greater. Using default value.");
                        }
                        break block8;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid value '" + string2 + "' for system property " + string + "; this value must be a long integer with value " + l + " or greater. Using default value.");
                        }
                        break block8;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "System property " + string + " not set; using default value.");
                }
            }
            return bl ? l3 : l2;
        }

        public void alarm(Object object) {
            this.alarmSet = false;
            this.triggerSweep();
        }

        public void triggerSweep() {
            if (this.sweepIntervalMinutes == 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trash sweeper is NOT triggered, because sweepInterval = 0");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trash sweeper is triggered, sweepInterval = " + this.sweepIntervalMinutes + " minutes, keepTime = " + this.keepTimeMinutes + " minutes.");
            }
            try {
                Thread thread = new Thread(this);
                thread.setDaemon(true);
                thread.start();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileRepository.TrashSweepTask.triggerSweep", "2230", this);
            }
            if (!this.alarmSet) {
                AlarmManager.createNonDeferrable(this.sweepIntervalMinutes * 60000L, this);
                this.alarmSet = true;
            }
        }

        public void run() {
            if (this.sweepIntervalMinutes > 0L) {
                this.sweep(this.tmpRoot);
            }
        }

        private void sweep(File file) {
            long l = this.keepTimeMinutes * 60000L;
            StringBuffer stringBuffer = new StringBuffer();
            LinkedList<File> linkedList = new LinkedList<File>();
            linkedList.addFirst(file);
            while (!linkedList.isEmpty()) {
                File file2 = (File)linkedList.removeLast();
                File[] fileArray = file2.listFiles();
                if (fileArray == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Clean up tmpfile was unsuccessful");
                    Tr.debug(tc, file2.getPath() + " does not denote a directory, or an I/O error occured.");
                    Tr.debug(tc, "isReadable: " + file2.canRead());
                    continue;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].exists()) continue;
                    if (fileArray[i].isDirectory()) {
                        linkedList.addFirst(fileArray[i]);
                        continue;
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = fileArray[i].lastModified();
                    long l4 = l2 - l3;
                    if (l3 == 0L) {
                        Tr.debug(tc, "File shows last modified time of 0, will not be deleted: " + fileArray[i].getPath());
                        continue;
                    }
                    if (l4 <= l) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Clean up tmpfile " + fileArray[i].getPath() + ", age is " + l4 / 60000L + " minutes (" + l4 + " millis).");
                        Tr.debug(tc, "Last modified time of tmpfile is " + new Date(l3) + " or " + l3);
                        Tr.debug(tc, "now is " + new Date(l2) + " or " + l2);
                        Tr.debug(tc, "keep is " + l);
                    }
                    String string = fileArray[i].getAbsolutePath();
                    boolean bl = fileArray[i].delete();
                    if (!bl) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "FAILED to delete file " + string);
                        continue;
                    }
                    if (stringBuffer.length() + string.length() + 1 > 2048) {
                        this.outputMessage(stringBuffer);
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append('\n');
                    stringBuffer.append(string);
                }
            }
            this.outputMessage(stringBuffer);
        }

        private void outputMessage(StringBuffer stringBuffer) {
            if (stringBuffer.length() > 0) {
                Tr.info(tc, "ADMR0025I", new Object[]{String.valueOf(this.keepTimeMinutes), stringBuffer.toString()});
            }
        }
    }
}

