/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.AppInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

class NodeAppInfo {
    private static TraceComponent tc = Tr.register(NodeAppInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private String name;
    private String serverIndexURI;
    private String cellName;
    private ConfigRepository repository = null;
    private DocumentDigest prevDigest = null;
    private List applications = new ArrayList();
    private static HashMap appInfo;

    NodeAppInfo(String string, String string2) {
        this.cellName = string;
        this.name = string2;
        this.serverIndexURI = "cells/" + string + "/nodes/" + string2 + "/serverindex.xml";
        appInfo = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() {
        InputStream inputStream = null;
        ServerIndex serverIndex = null;
        try {
            String string;
            DocumentDigest documentDigest;
            if (this.repository == null) {
                this.repository = ConfigRepositoryFactory.getConfigRepository();
            }
            if (!((Object)(documentDigest = this.repository.getDigest(this.serverIndexURI))).equals(this.prevDigest)) {
                DocumentContentSource documentContentSource = this.repository.extract(this.serverIndexURI);
                inputStream = documentContentSource.getSource();
                serverIndex = this.loadServerIndex(inputStream);
                string = serverIndex.getServerEntries();
                this.applications = new ArrayList();
                for (int i = 0; i < string.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)string.get(i);
                    EList eList = serverEntry.getDeployedApplications();
                    for (int j = 0; j < eList.size(); ++j) {
                        if (this.applications.contains(eList.get(j))) continue;
                        this.applications.add(eList.get(j));
                    }
                }
                this.prevDigest = documentContentSource.getDocument().getDigest();
            }
            for (int i = 0; i < this.applications.size(); ++i) {
                AppInfo appInfo;
                string = (String)this.applications.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating app: " + string);
                }
                if ((appInfo = (AppInfo)NodeAppInfo.appInfo.get(string)) == null) {
                    appInfo = new AppInfo(this.cellName, string);
                    NodeAppInfo.appInfo.put(string, appInfo);
                }
                appInfo.update();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "109", this);
        }
        finally {
            if (serverIndex != null) {
                Resource resource = serverIndex.eResource();
                ResourceSet resourceSet = resource.getResourceSet();
                EList eList = resourceSet.getResources();
                eList.remove((Object)resource);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "135", this);
            }
        }
    }

    public List getAppList() {
        return this.applications;
    }

    public AppInfo getAppInfo(String string) {
        return (AppInfo)appInfo.get(string);
    }

    private ServerIndex loadServerIndex(InputStream inputStream) {
        ServerIndex serverIndex = null;
        try {
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = wASResourceSetImpl.createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(inputStream, hashMap);
            serverIndex = (ServerIndex)resource.getContents().get(0);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.NodeAppInfo.loadServerIndex", "164", this);
        }
        return serverIndex;
    }
}

