/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileDocument;
import com.ibm.ws.management.repository.ServantFileRepository;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ServantFileDocument {
    private static String repositoryRoot;
    private static String repositoryTemp;
    private static String repositoryBackup;
    private static FileTransferConfig repositoryFTConfig;
    private static FileTransferOptions repositoryFTOptions;
    private static HashMap locks;
    private static Integer mkdirsLock;
    private static TraceComponent tc;

    protected static Object getDirLock() {
        return mkdirsLock;
    }

    protected static synchronized void setRepository(ServantFileRepository servantFileRepository) {
        repositoryRoot = servantFileRepository.getRepositoryDir();
        repositoryTemp = servantFileRepository.getTempDir();
        repositoryBackup = servantFileRepository.getBackupDir();
        repositoryFTOptions = servantFileRepository.getFileTransferOptions();
        repositoryFTConfig = servantFileRepository.getFileTransferConfig();
    }

    protected static DocumentDigestImpl getDigest(String string) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl = null;
        File file = ServantFileDocument.getFileForURI(string + ".digest");
        documentDigestImpl = file.exists() ? ServantFileDocument.readDigest(string + ".digest", file) : ServantFileDocument.calcDigest(string);
        return documentDigestImpl;
    }

    protected static DocumentDigestImpl calcDigest(String string) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "calcDigest: " + string);
        }
        File file = ServantFileDocument.getFileForURI(string);
        boolean bl = false;
        try {
            documentDigestImpl = new DocumentDigestImpl();
            ServantFileDocument.lockForReading(string);
            bl = true;
            documentDigestImpl.calc(new FileInputStream(file));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.getDigest", "146", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, iOException});
            throw new DocumentIOException(iOException, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.getDigest", "152", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, exception});
            throw ServantFileDocument.getDocumentIOException(exception, string);
        }
        finally {
            if (bl) {
                ServantFileDocument.unlockForReading(string);
            }
        }
        return documentDigestImpl;
    }

    /*
     * Loose catch block
     */
    private static DocumentDigestImpl readDigest(String string, File file) throws DocumentIOException {
        DocumentDigestImpl documentDigestImpl;
        block17: {
            boolean bl;
            ObjectInputStream objectInputStream;
            FileInputStream fileInputStream;
            block14: {
                IOException iOException2222;
                block13: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "readDigest: " + string);
                    }
                    documentDigestImpl = null;
                    fileInputStream = null;
                    objectInputStream = null;
                    bl = true;
                    ServantFileDocument.lockForReading(string);
                    bl = true;
                    fileInputStream = new FileInputStream(repositoryRoot + File.separator + string);
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    documentDigestImpl = (DocumentDigestImpl)objectInputStream.readObject();
                    Object var8_6 = null;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.management.repository.FileDocument.readDigest", "214", null);
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Error while closing object stream: " + iOException2222);
                    }
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2222) {
                    FFDCFilter.processException((Throwable)iOException2222, "com.ibm.ws.management.repository.FileDocument.readDigest", "223", null);
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Error while closing file input stream: " + iOException2222);
                }
            }
            if (bl) {
                ServantFileDocument.unlockForReading(string);
            }
            break block17;
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileDocument.getDigest", "152", FileDocument.class);
                    Tr.error(tc, "ADMR0104E", new Object[]{string, throwable});
                    throw ServantFileDocument.getDocumentIOException(throwable, string);
                }
            }
            catch (Throwable throwable) {
                block16: {
                    IOException iOException3222;
                    block15: {
                        Object var8_7 = null;
                        try {
                            objectInputStream.close();
                        }
                        catch (IOException iOException3222) {
                            FFDCFilter.processException((Throwable)iOException3222, "com.ibm.ws.management.repository.FileDocument.readDigest", "214", null);
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug(tc, "Error while closing object stream: " + iOException3222);
                        }
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException3222) {
                        FFDCFilter.processException((Throwable)iOException3222, "com.ibm.ws.management.repository.FileDocument.readDigest", "223", null);
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Error while closing file input stream: " + iOException3222);
                    }
                }
                if (bl) {
                    ServantFileDocument.unlockForReading(string);
                }
                throw throwable;
            }
        }
        return documentDigestImpl;
    }

    private static DocumentDigestImpl copyDocument(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDocument");
        }
        InputStream inputStream2 = null;
        DocumentDigestImpl documentDigestImpl = null;
        if (bl) {
            documentDigestImpl = new DocumentDigestImpl();
            inputStream2 = documentDigestImpl.startInputFilter(inputStream);
        } else {
            inputStream2 = inputStream;
        }
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream2.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream2.read(byArray);
            }
            if (bl) {
                documentDigestImpl.stopInputFilter();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.copyDocument", "851", FileDocument.class);
            throw iOException;
        }
        finally {
            block21: {
                block20: {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.copyDocument", "866", null);
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "Error while closing to stream: " + exception);
                    }
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.copyDocument", "866", null);
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Error while closing from stream: " + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDocument");
        }
        return documentDigestImpl;
    }

    protected static DocumentContentSource read(String string) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading " + string);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileDownloadInputStream fileDownloadInputStream = null;
        DocumentDigestImpl documentDigestImpl = null;
        File file = ServantFileDocument.getFileForURI(string);
        File file2 = ServantFileDocument.createTempFile(string);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.read", "351", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, iOException});
            throw new DocumentIOException(iOException, "Unable to create input stream on document file: " + string);
        }
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.FileDocument.read", "363", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, iOException});
            throw new DocumentIOException(iOException, "Unable to create output stream on temp file: " + file2.getPath());
        }
        long l = 0L;
        boolean bl = false;
        try {
            ServantFileDocument.lockForReading(string);
            bl = true;
            documentDigestImpl = ServantFileDocument.copyDocument(fileInputStream, fileOutputStream, true);
            l = file.lastModified();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.FileDocument.read", "375", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, exception});
            throw ServantFileDocument.getDocumentIOException(exception, "Unable to copy document to temp file: " + string);
        }
        finally {
            if (bl) {
                ServantFileDocument.unlockForReading(string);
            }
        }
        fileDownloadInputStream = new FileDownloadInputStream(file2);
        fileDownloadInputStream.setFileTransferConfig(repositoryFTConfig);
        fileDownloadInputStream.setOptions(repositoryFTOptions);
        fileDownloadInputStream.setSrcPath(file2.getAbsolutePath().substring(repositoryTemp.length()));
        Document document = new Document(string, documentDigestImpl);
        DocumentContentSource documentContentSource = new DocumentContentSource(document, fileDownloadInputStream);
        documentContentSource.setLastModified(l);
        return documentContentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempFile(String string) throws DocumentIOException {
        File file = new File(repositoryTemp + string);
        String string2 = file.getName().replace('%', '_');
        if (string2.length() < 3) {
            string2 = new String(string2 + "__");
        }
        File file2 = file.getParentFile();
        File file3 = null;
        try {
            Integer n = mkdirsLock;
            synchronized (n) {
                file2.mkdirs();
                file3 = File.createTempFile(string2, null, file2);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.FileDocument.createTempFile", "404", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{string, throwable});
            throw new DocumentIOException(throwable, "Unable to create temp file for document: " + string);
        }
        return file3;
    }

    private static void lockForReading(String string) throws DocumentIOException {
        try {
            ServantFileDocument.getLock(string).startReading();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.repository.FileDocument.lockForWriting", "640", FileDocument.class);
            throw new DocumentIOException(interruptedException, "Unable to get read lock for document " + string);
        }
    }

    private static void unlockForReading(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = ServantFileDocument.getLock(string);
        writerPriorityReadersWriterLock.stopReading();
        ServantFileDocument.releaseLock(string, writerPriorityReadersWriterLock);
    }

    private static synchronized WriterPriorityReadersWriterLock getLock(String string) {
        WriterPriorityReadersWriterLock writerPriorityReadersWriterLock = (WriterPriorityReadersWriterLock)locks.get(string);
        if (writerPriorityReadersWriterLock == null) {
            writerPriorityReadersWriterLock = new WriterPriorityReadersWriterLock();
            locks.put(string, writerPriorityReadersWriterLock);
        }
        return writerPriorityReadersWriterLock;
    }

    private static synchronized void releaseLock(String string, WriterPriorityReadersWriterLock writerPriorityReadersWriterLock) {
        if (!writerPriorityReadersWriterLock.hasReaderOrWriter()) {
            locks.remove(string);
        }
    }

    private static File getFileForURI(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFileForURI", new Object[]{repositoryRoot, string});
        }
        return new File(repositoryRoot + File.separator + string);
    }

    private static DocumentIOException getDocumentIOException(Throwable throwable, String string) {
        if (throwable instanceof DocumentIOException) {
            return (DocumentIOException)throwable;
        }
        return new DocumentIOException(throwable, string);
    }

    static {
        locks = new HashMap();
        mkdirsLock = new Integer(0);
        tc = Tr.register(ServantFileDocument.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");
    }
}

