/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.DocumentUnavailableException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.FileUploadInputStream;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.ServantFileDocument;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class ServantFileRepository
implements ConfigRepository,
ResourceNameFilter,
NotificationListener {
    private static TraceComponent tc = Tr.register(ServantFileRepository.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private Properties configProperties = null;
    private AdminService adminService = null;
    private ObjectName repositoryObjectName = null;
    private String repositoryDir;
    private String backupDir;
    private String tempDir;
    private static final int AVAILABLE = 0;
    private static final int UNAVAILABLE = 1;
    private static final int INVALID = 2;
    private File backupDirectory;
    private File tempDirectory;
    private FileTransferOptions ftOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
    private FileTransferConfig ftConfig = null;
    private ArrayList listeners;
    private Object[] listenersCopy;
    private boolean listenersUpdated = false;
    private static ServantFileRepository repository = new ServantFileRepository();

    private ServantFileRepository() {
    }

    public static ServantFileRepository getRepository() {
        return repository;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    private boolean exists(String string) {
        File file = new File(this.getRepositoryDir() + "/" + string.replace('\\', '/'));
        return file.exists();
    }

    private void fixURIs(DocumentContentSource[] documentContentSourceArray) {
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            documentContentSourceArray[i].getDocument().setURI(documentContentSourceArray[i].getDocument().getURI().replace('\\', '/'));
        }
    }

    private void fixURIs(Document[] documentArray) {
        for (int i = 0; i < documentArray.length; ++i) {
            documentArray[i].setURI(documentArray[i].getURI().replace('\\', '/'));
        }
    }

    private int status(String string) {
        int n = 2;
        if (this.exists(string)) {
            n = 0;
        } else if (this.exists(string + ".digest")) {
            n = 1;
        }
        return n;
    }

    public DocumentContentSource extract(String string) throws RepositoryException {
        return this.extract(new Document(string));
    }

    public DocumentContentSource extract(Document document) throws RepositoryException {
        Document[] documentArray = new Document[]{document};
        DocumentContentSource[] documentContentSourceArray = this.extract(documentArray);
        return documentContentSourceArray[0];
    }

    public DocumentContentSource[] extract(String[] stringArray) throws RepositoryException {
        Document[] documentArray = new Document[stringArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            documentArray[i] = new Document(stringArray[i]);
        }
        return this.extract(documentArray);
    }

    public DocumentContentSource[] extract(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract[]");
        }
        if (documentArray == null) {
            return new DocumentContentSource[0];
        }
        this.fixURIs(documentArray);
        DocumentContentSource[] documentContentSourceArray = this.extractInternal(documentArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract[]");
        }
        return documentContentSourceArray;
    }

    private DocumentContentSource[] extractInternal(Document[] documentArray) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractInternal");
        }
        DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[documentArray.length];
        for (int i = 0; i < documentArray.length; ++i) {
            int n = this.status(documentArray[i].getURI());
            if (n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: invalid URI; " + documentArray[i].getURI());
                }
                throw new DocumentNotFoundException(documentArray[i].getURI());
            }
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: unavailable URI; " + documentArray[i].getURI());
                }
                throw new DocumentUnavailableException(documentArray[i].getURI());
            }
            documentContentSourceArray[i] = ServantFileDocument.read(documentArray[i].getURI());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractInternal");
        }
        return documentContentSourceArray;
    }

    public String[] listResourceNames(String string, int n, int n2, ResourceNameFilter resourceNameFilter) {
        ResourceNameFilter resourceNameFilter2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "listResourceNames", string);
        }
        if ((resourceNameFilter2 = resourceNameFilter) == null) {
            resourceNameFilter2 = this;
        }
        File file = new File(this.getRepositoryDir() + "/" + string);
        if (this.status(string) == 2) {
            return new String[0];
        }
        if (n2 == 0) {
            if (resourceNameFilter2 == this) {
                if (resourceNameFilter2.accept(string, "") && this.isMatchingType(file, n)) {
                    return new String[]{string};
                }
                return new String[0];
            }
            if (this.accept(string, "") && resourceNameFilter2.accept(string, "") && this.isMatchingType(file, n)) {
                return new String[]{string};
            }
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        if (file.list() != null) {
            this.addResourceNames(arrayList, file, n, n2 - 1, resourceNameFilter2);
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    public DocumentDigest getDigest(String string) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest: " + string);
        }
        if (this.status(string) == 2) {
            throw new DocumentNotFoundException(string);
        }
        DocumentDigestImpl documentDigestImpl = ServantFileDocument.getDigest(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest");
        }
        return documentDigestImpl;
    }

    public DocumentDigest[] getDigest(String[] stringArray) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest[]");
        }
        DocumentDigest[] documentDigestArray = new DocumentDigest[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            documentDigestArray[i] = this.getDigest(stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest[]");
        }
        return documentDigestArray;
    }

    private void addResourceNames(ArrayList arrayList, File file, int n, int n2, ResourceNameFilter resourceNameFilter) {
        File[] fileArray = this.getFiles(file);
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (resourceNameFilter == this) {
                    if (resourceNameFilter.accept(this.getUri(file), fileArray[i].getName()) && this.isMatchingType(fileArray[i], n)) {
                        arrayList.add(this.getUri(fileArray[i]));
                    }
                } else if (this.accept(this.getUri(file), fileArray[i].getName()) && resourceNameFilter.accept(this.getUri(file), fileArray[i].getName()) && this.isMatchingType(fileArray[i], n)) {
                    arrayList.add(this.getUri(fileArray[i]));
                }
                if (n2 <= 0 || !fileArray[i].isDirectory()) continue;
                this.addResourceNames(arrayList, fileArray[i], n, n2 - 1, resourceNameFilter);
            }
        }
    }

    private File[] getFiles(File file) {
        Object object;
        File[] fileArray = file.listFiles();
        HashMap<Object, File> hashMap = new HashMap<Object, File>();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            if (string.endsWith(".digest")) {
                object = string.substring(0, string.lastIndexOf(".digest"));
                hashMap.put(object, new File(file, (String)object));
                continue;
            }
            hashMap.put(string, fileArray[i]);
        }
        File[] fileArray2 = new File[hashMap.size()];
        int n = 0;
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            fileArray2[n++] = (File)entry.getValue();
        }
        return fileArray2;
    }

    public String[] listResourceNames(String string, int n, int n2) {
        return this.listResourceNames(string, n, n2, this);
    }

    protected int getType(File file) {
        if (file.isDirectory()) {
            return 2;
        }
        return 1;
    }

    protected boolean isMatchingType(int n, int n2) {
        return (n & n2) != 0;
    }

    protected boolean isMatchingType(File file, int n) {
        int n2 = this.getType(file);
        return (n2 & n) != 0;
    }

    protected String getUri(File file) {
        String string = file.getAbsolutePath();
        if (string.length() <= this.getRepositoryDir().length()) {
            return "/";
        }
        return string.substring(this.getRepositoryDir().length() + 1).replace('\\', '/');
    }

    public boolean accept(String string, String string2) {
        boolean bl = true;
        if (string.equals("/")) {
            bl = !string2.equals("backup") && !string2.equals("temp");
        } else if (string.equals("backup") || string.startsWith("backup/") || string.equals("temp") || string.startsWith("temp/")) {
            bl = false;
        }
        return bl;
    }

    protected Object invoke(String string, String[] stringArray, Object[] objectArray) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "invoke");
        }
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
        }
        try {
            if (this.repositoryObjectName == null) {
                this.repositoryObjectName = this.getRepositoryName();
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.repository.ServantFileRepository.invoke", "414", this);
            Tr.debug(tc, "MalformedObjectName Exception", malformedObjectNameException);
            throw new RepositoryException(malformedObjectNameException);
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.repository.ServantFileRepository.invoke", "417", this);
            Tr.debug(tc, "Connector Error ", connectorException);
            throw new RepositoryException(connectorException);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.repository.ServantFileRepository.invoke", "420", this);
            Tr.debug(tc, "Admin Error", adminException);
            throw new RepositoryException(adminException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invoke: repositoryObjectName= " + this.repositoryObjectName);
        }
        return this.invokeMBean(this.repositoryObjectName, string, stringArray, objectArray);
    }

    protected Object invokeMBean(ObjectName objectName, String string, String[] stringArray, Object[] objectArray) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " invokeMBean:" + string + ",objectName= " + objectName);
        }
        Subject subject = null;
        Subject subject2 = null;
        subject = SecurityHelper.getInvocationSubject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "InvocationSubject: ", subject);
        }
        subject2 = SecurityHelper.getReceivedSubject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ReceivedSubject: ", subject2);
        }
        if (subject == null) {
            subject = SecurityHelper.getReceivedSubject();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Subject", subject);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Audit Username: " + SecurityHelper.getAuditUserName());
        }
        if (subject != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Running with security Subject.");
            }
            final ObjectName objectName2 = objectName;
            final String string2 = string;
            final Object[] objectArray2 = objectArray;
            final String[] stringArray2 = stringArray;
            try {
                return ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "AFTER runAs - Audit Username: " + SecurityHelper.getAuditUserName());
                            }
                            return ServantFileRepository.this.adminService.invoke(objectName2, string2, objectArray2, stringArray2);
                        }
                        catch (InstanceNotFoundException instanceNotFoundException) {
                            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", "474", this);
                            throw new RepositoryException(instanceNotFoundException);
                        }
                        catch (MBeanException mBeanException) {
                            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", "477", this);
                            Exception exception = mBeanException.getTargetException();
                            if (exception instanceof RepositoryException) {
                                throw (RepositoryException)exception;
                            }
                            throw new RepositoryException(mBeanException);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", "484", this);
                            throw new RepositoryException(exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new RepositoryException(exception);
            }
        }
        try {
            return this.adminService.invoke(objectName, string, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", "499", this);
            throw new RepositoryException(instanceNotFoundException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", "502", this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)exception;
            }
            throw new RepositoryException(mBeanException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", "509", this);
            throw new RepositoryException(exception);
        }
    }

    public void initialize(Properties properties) throws AdminException {
        block41: {
            String string;
            String string2;
            Object object;
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "initialize()", properties);
            }
            properties = properties == null ? new Properties() : (Properties)properties.clone();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository props:", properties);
            }
            this.configProperties = properties;
            this.listeners = new ArrayList();
            this.listenersUpdated = true;
            this.repositoryDir = System.getProperty("was.repository.root");
            if (this.repositoryDir == null) {
                this.repositoryDir = properties.getProperty("was.repository.root");
                if (this.repositoryDir == null) {
                    object = System.getProperty("user.install.root");
                    if (object != null && !((String)object).equals("")) {
                        this.repositoryDir = (String)object + File.separator + "config";
                    } else {
                        object = properties.getProperty("user.install.root");
                        if (object != null && !((String)object).equals("")) {
                            this.repositoryDir = (String)object + File.separator + "config";
                        }
                    }
                    if (this.repositoryDir == null) {
                        object = System.getProperty("was.install.root");
                        if (object != null && !((String)object).equals("")) {
                            this.repositoryDir = (String)object + File.separator + "config";
                        } else {
                            object = properties.getProperty("was.install.root");
                            if (object != null && !((String)object).equals("")) {
                                this.repositoryDir = (String)object + File.separator + "config";
                            }
                        }
                    }
                }
            }
            if (this.repositoryDir == null) {
                Tr.error(tc, "ADMR0001E");
                throw new AdminException("Neither was.repository.root nor was.install.root are set");
            }
            object = new File(this.repositoryDir);
            if (!((File)object).isDirectory()) {
                Tr.error(tc, "ADMR0001E");
                throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
            }
            try {
                this.repositoryDir = ((File)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.ServantFileRepository.initialize", "538", this);
                Tr.error(tc, "ADMR0001E");
                throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
            }
            String string3 = System.getProperty("was.repository.temp");
            if (string3 == null) {
                string3 = properties.getProperty("was.repository.temp");
            }
            if (string3 != null) {
                object = new File(string3);
                try {
                    string2 = ((File)object).getCanonicalPath();
                    if (string2.startsWith(this.repositoryDir + File.separator) && !string2.equals(this.repositoryDir + File.separator + "temp")) {
                        Tr.warning(tc, "ADMR0014W", string3);
                        string3 = null;
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.ServantFileRepository.initialize", "560", this);
                    Tr.warning(tc, "ADMR0014W", string3);
                    string3 = null;
                }
            }
            this.tempDir = string3 != null ? string3 : this.repositoryDir + File.separator + "temp";
            object = new File(this.tempDir);
            if (((File)object).exists()) {
                if (!((File)object).isDirectory()) {
                    Tr.warning(tc, "ADMR0014W", this.tempDir);
                    this.tempDir = this.repositoryDir + File.separator + "temp";
                }
            } else if (!((File)object).mkdirs()) {
                Tr.warning(tc, "ADMR0014W", this.tempDir);
                this.tempDir = this.repositoryDir + File.separator + "temp";
            }
            try {
                object = new File(this.tempDir);
                this.tempDir = ((File)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.ServantFileRepository.initialize", "594", this);
                this.tempDir = this.repositoryDir + File.separator + "temp";
            }
            string2 = System.getProperty("was.repository.backup");
            if (string2 == null) {
                string2 = properties.getProperty("was.repository.backup");
            }
            if (string2 != null) {
                object = new File(string2);
                try {
                    string = ((File)object).getCanonicalPath();
                    if (string.startsWith(this.repositoryDir + File.separator) && !string.equals(this.repositoryDir + File.separator + "backup")) {
                        Tr.warning(tc, "ADMR0013W", string2);
                        string2 = null;
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.ServantFileRepository.initialize", "615", this);
                    Tr.warning(tc, "ADMR0013W", string2);
                    string2 = null;
                }
            }
            this.backupDir = string2 != null ? string2 : this.repositoryDir + File.separator + "backup";
            object = new File(this.backupDir);
            if (((File)object).exists()) {
                if (!((File)object).isDirectory()) {
                    this.backupDir = this.repositoryDir + File.separator + "backup";
                }
            } else if (!((File)object).mkdirs()) {
                this.backupDir = this.repositoryDir + File.separator + "backup";
            }
            try {
                object = new File(this.backupDir);
                this.backupDir = ((File)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.ServantFileRepository.initialize", "649", this);
                this.backupDir = this.repositoryDir + File.separator + "backup";
            }
            this.tempDirectory = new File(this.tempDir);
            this.backupDirectory = new File(this.backupDir);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repositoryDir = " + this.repositoryDir);
                Tr.debug(tc, "tempDir = " + this.tempDir);
                Tr.debug(tc, "backupDir = " + this.backupDir);
            }
            this.tempDir = this.tempDir + File.separator;
            System.setProperty("was.repository.temp", this.tempDir);
            this.configProperties.setProperty("was.repository.root", this.repositoryDir);
            this.configProperties.setProperty("was.repository.temp", this.tempDir);
            this.configProperties.setProperty("was.repository.backup", this.backupDir);
            this.ftOptions.setDeleteSourceOnCompletion(true);
            this.ftOptions.setOverwrite(true);
            this.ftConfig = new FileTransferConfigImpl();
            this.ftConfig.setSecurityEnabled(false);
            ServantFileDocument.setRepository(this);
            try {
                this.adminService = AdminServiceFactory.getAdminService();
                string = this.adminService.getCellName();
                String string4 = this.adminService.getNodeName();
                String string5 = this.adminService.getProcessName();
                String string6 = "WebSphere:process=" + string5 + ",type=" + "ConfigRepository" + ",cell=" + string + ",node=" + string4 + ",*";
                ObjectName objectName = new ObjectName(string6);
                this.adminService.addNotificationListenerExtended(objectName, this, null, null);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.repository.ServantFileRepository.initialize", "687", this);
                if (!tc.isDebugEnabled()) break block41;
                Tr.debug(tc, "MalformedObjectName Error", malformedObjectNameException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public FileTransferOptions getFileTransferOptions() {
        return this.ftOptions;
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public DocumentDigest create(DocumentContentSource documentContentSource) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " create()", documentContentSource);
        }
        this.fixContentForTransport(documentContentSource);
        String string = "create";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] objectArray = new Object[]{documentContentSource};
        return (DocumentDigest)this.invoke(string, stringArray, objectArray);
    }

    public DocumentDigest[] create(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "create()", documentContentSourceArray);
        }
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            this.fixContentForTransport(documentContentSourceArray[i]);
        }
        String string = "create";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] objectArray = new Object[]{documentContentSourceArray};
        return (DocumentDigest[])this.invoke(string, stringArray, objectArray);
    }

    public void delete(String string) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", string);
        }
        String string2 = "delete";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(string2, stringArray, objectArray);
    }

    public void delete(Document document) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", document);
        }
        String string = "delete";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.Document"};
        Object[] objectArray = new Object[]{document};
        this.invoke(string, stringArray, objectArray);
    }

    public void delete(String[] stringArray) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", stringArray);
        }
        String string = "delete";
        String[] stringArray2 = new String[]{"[Ljava.lang.String;"};
        Object[] objectArray = new Object[]{stringArray};
        this.invoke(string, stringArray2, objectArray);
    }

    public void delete(Document[] documentArray) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", documentArray);
        }
        String string = "delete";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] objectArray = new Object[]{documentArray};
        this.invoke(string, stringArray, objectArray);
    }

    public void rename(String string, String string2) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "rename()", string2);
        }
        String string3 = "rename";
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invoke(string3, stringArray, objectArray);
    }

    public void rename(Document document, Document document2) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "rename()", document2);
        }
        String string = "rename";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource", "com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] objectArray = new Object[]{document, document2};
        this.invoke(string, stringArray, objectArray);
    }

    public DocumentDigest modify(DocumentContentSource documentContentSource) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "modify()");
        }
        this.fixContentForTransport(documentContentSource);
        String string = "modify";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] objectArray = new Object[]{documentContentSource};
        return (DocumentDigest)this.invoke(string, stringArray, objectArray);
    }

    public DocumentDigest[] modify(DocumentContentSource[] documentContentSourceArray) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "modify");
        }
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            this.fixContentForTransport(documentContentSourceArray[i]);
        }
        String string = "modify";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] objectArray = new Object[]{documentContentSourceArray};
        return (DocumentDigest[])this.invoke(string, stringArray, objectArray);
    }

    public HashMap update(DocumentContentSource[] documentContentSourceArray, DocumentContentSource[] documentContentSourceArray2, Document[] documentArray) throws RepositoryException {
        int n;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "update()");
        }
        for (n = 0; n < documentContentSourceArray.length; ++n) {
            this.fixContentForTransport(documentContentSourceArray[n]);
        }
        for (n = 0; n < documentContentSourceArray2.length; ++n) {
            this.fixContentForTransport(documentContentSourceArray2[n]);
        }
        String string = "update";
        String[] stringArray = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] objectArray = new Object[]{documentContentSourceArray, documentContentSourceArray2, documentArray};
        return (HashMap)this.invoke(string, stringArray, objectArray);
    }

    public Boolean lockRepository(String string) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "lockRepository");
        }
        String string2 = "lockRepository";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        return (Boolean)this.invoke(string2, stringArray, objectArray);
    }

    public Boolean unlockRepository(String string) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "unlockRepository");
        }
        String string2 = "unlockRepository";
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        return (Boolean)this.invoke(string2, stringArray, objectArray);
    }

    public Properties getConfig() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " getConfig()");
        }
        return (Properties)this.configProperties.clone();
    }

    private ObjectName getRepositoryName() throws MalformedObjectNameException, ConnectorException, AdminException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " getRepositoryName()");
        }
        String string = AdminServiceFactory.getAdminService().getProcessName();
        String string2 = AdminServiceFactory.getAdminService().getCellName();
        String string3 = AdminServiceFactory.getAdminService().getNodeName();
        String string4 = "WebSphere:process=" + string + ",type=" + "ConfigRepository" + ",cell=" + string2 + ",node=" + string3 + ",*";
        ObjectName objectName = new ObjectName(string4);
        Set set = this.adminService.queryNames(objectName, null);
        if (set.size() != 1) {
            throw new AdminException("There are " + set.size() + " repositories!");
        }
        Object[] objectArray = set.toArray();
        return (ObjectName)objectArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigRepositoryListener configRepositoryListener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding listener: " + configRepositoryListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(configRepositoryListener)) {
                this.listeners.add(configRepositoryListener);
            }
        }
        this.listenersUpdated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigRepositoryListener configRepositoryListener) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "Removing listener: " + configRepositoryListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(configRepositoryListener);
        }
    }

    public ConfigEpoch getRepositoryEpoch() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getRepositoryEpoch()");
        }
        String string = "getRepositoryEpoch";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] objectArray = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(string, stringArray, objectArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.ServantFileRepository.getRepositoryEpoch", "958", this);
            return null;
        }
    }

    public ConfigEpoch refreshRepositoryEpoch() {
        String string = "refreshRepositoryEpoch";
        String[] stringArray = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] objectArray = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(string, stringArray, objectArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.ServantFileRepository.refreshRepositoryEpoch", "971", this);
            return null;
        }
    }

    public void createDigestFile(String string, boolean bl) throws RepositoryException {
        String string2 = "createDigestFile";
        String[] stringArray = new String[]{"java.lang.String", "boolean"};
        Object[] objectArray = new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE};
        this.invoke(string2, stringArray, objectArray);
    }

    public void handleNotification(Notification notification, Object object) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", notification);
        }
        if ((object2 = notification.getUserData()) != null) {
            ConfigRepositoryEvent configRepositoryEvent = (ConfigRepositoryEvent)object2;
            Object[] objectArray = this.getListenersCopy();
            if (notification.getType().equals("websphere.repository.change")) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)objectArray[i];
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling listener onChangeCompletion: " + configRepositoryListener);
                        }
                        configRepositoryListener.onChangeCompletion(configRepositoryEvent);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from listener onChangeCompletion: " + configRepositoryListener);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.ServantFileRepository.handleNotification", "1007", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, " Error occured while calling listener", throwable);
                    }
                }
            } else if (notification.getType().equals("websphere.repository.epoch.refresh")) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)objectArray[i];
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling listener onRepositoryEpochRefresh: " + configRepositoryListener);
                        }
                        configRepositoryListener.onRepositoryEpochRefresh();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from listener onRepositoryEpochRefresh: " + configRepositoryListener);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.ServantFileRepository.handleNotification", "1026", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, " Error occured while calling listener", throwable);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object[] getListenersCopy() {
        if (this.listenersUpdated) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listenersCopy = this.listeners.toArray();
                this.listenersUpdated = false;
            }
        }
        return this.listenersCopy;
    }

    private void fixContentForTransport(DocumentContentSource documentContentSource) throws RepositoryException {
        InputStream inputStream;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "fixContentForTransport", documentContentSource.getDocument().getURI());
        }
        if (!((inputStream = documentContentSource.getSource()) instanceof FileInputStream)) {
            try {
                File file = new File(this.tempDir);
                String string = this.getTempDocName(documentContentSource);
                File file2 = File.createTempFile(string, null, file);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created temp file: " + file2.getName());
                }
                this.writeData(inputStream, file2);
                FileUploadInputStream fileUploadInputStream = new FileUploadInputStream();
                fileUploadInputStream.setDelete(true);
                fileUploadInputStream.setSrcPath(file2.getName());
                documentContentSource.setSource(fileUploadInputStream);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Source was replaced");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.ServantFileRepository.fixContentForTransport", "1061", ServantFileRepository.class);
                throw this.getRepositoryException(throwable);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "fixContentForTransport", documentContentSource.getDocument().getURI());
        }
    }

    private String getTempDocName(DocumentContentSource documentContentSource) {
        String string = documentContentSource.getDocument().getURI();
        String string2 = null;
        if (string.indexOf(47) != -1) {
            int n = string.lastIndexOf(47);
            string2 = string.substring(n + 1);
        } else {
            string2 = string;
        }
        return "sr_" + string2;
    }

    /*
     * Loose catch block
     */
    private void writeData(InputStream inputStream, File file) throws RepositoryException {
        block19: {
            Exception exception2222;
            FileOutputStream fileOutputStream;
            block18: {
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "writeData");
                }
                fileOutputStream = null;
                byte[] byArray = new byte[4096];
                fileOutputStream = new FileOutputStream(file);
                int n = inputStream.read(byArray);
                while (n != -1) {
                    fileOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                Object var7_7 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception2222) {
                    FFDCFilter.processException((Throwable)exception2222, "com.ibm.ws.management.repository.ServantFileRepository.writeData", "1092", ServantFileRepository.class);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Error while closing output stream: " + exception2222);
                }
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block19;
            }
            catch (Exception exception2222) {
                FFDCFilter.processException((Throwable)exception2222, "com.ibm.ws.management.repository.ServantFileRepository.writeData", "1100", ServantFileRepository.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error while closing input stream: " + exception2222);
                }
                break block19;
            }
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.repository.ServantFileRepository.writeData", "1086", ServantFileRepository.class);
                    throw this.getRepositoryException(throwable);
                }
            }
            catch (Throwable throwable) {
                block21: {
                    Exception exception32222;
                    block20: {
                        Object var7_8 = null;
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (Exception exception32222) {
                            FFDCFilter.processException((Throwable)exception32222, "com.ibm.ws.management.repository.ServantFileRepository.writeData", "1092", ServantFileRepository.class);
                            if (!tc.isDebugEnabled()) break block20;
                            Tr.debug(tc, "Error while closing output stream: " + exception32222);
                        }
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception32222) {
                        FFDCFilter.processException((Throwable)exception32222, "com.ibm.ws.management.repository.ServantFileRepository.writeData", "1100", ServantFileRepository.class);
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "Error while closing input stream: " + exception32222);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "writeData");
        }
    }

    private RepositoryException getRepositoryException(Throwable throwable) {
        RepositoryException repositoryException = throwable instanceof RepositoryException ? (RepositoryException)throwable : new RepositoryException(throwable);
        return repositoryException;
    }
}

