/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class TempFileInputStream
extends FileInputStream {
    private static TraceComponent tc = Tr.register(TempFileInputStream.class, "Repository", "com.ibm.ws.management.resources.repository");
    private File f = null;
    boolean readToEOF = false;

    public TempFileInputStream(String string) throws FileNotFoundException {
        super(string);
    }

    public TempFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.f = file;
    }

    public TempFileInputStream(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public int read() throws IOException {
        int n = super.read();
        if (this.f != null && n == -1) {
            this.readToEOF = true;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (this.f != null && n == -1) {
            this.readToEOF = true;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (this.f != null && n3 == -1) {
            this.readToEOF = true;
        }
        return n3;
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close() file=" + (this.f == null ? "null" : this.f.getName()));
        }
        if (this.getFD().valid()) {
            super.close();
            if (this.f != null && this.readToEOF && this.f.delete() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Succesfully deleted file on stream finalize: " + this.f.getPath());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            if (this.f != null && this.readToEOF && this.f.delete() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Succesfully deleted file on stream finalize: " + this.f.getPath());
            }
        }
        finally {
            block9: {
                try {
                    super.finalize();
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "IOException during finalize: " + iOException);
                }
            }
        }
    }

    private void deleteEmptyParents(File file, String string) {
        File file2 = file.getParentFile();
        if (file2.getPath().length() > string.length() && file2.delete()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succesfully deleted directory on stream finalize: " + file2.getPath());
            }
            this.deleteEmptyParents(file2, string);
        }
    }
}

