/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.AsyncListenerWrapper;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public abstract class AbstractStatusCache
extends RuntimeCollaborator
implements NotificationListener,
ConfigRepositoryListener,
RoutingListener,
StatusCache {
    protected static final TraceComponent tc;
    private static String resourceBundleName;
    private TraceNLS nls = TraceNLS.getTraceNLS(resourceBundleName);
    protected String _process_type = "";
    public static String REPORT_TYPE;
    protected String _cellName;
    protected String _nodeName;
    protected String _serverName;
    protected String _serverindexURI;
    protected Set _servers = null;
    protected Set _nodes = null;
    protected Set _clusters = null;
    protected static Set _activeServants;
    protected Map _cluster_xml = null;
    protected Map _serverIndexes = null;
    protected Map _app_state = null;
    protected Map _port_state = Collections.synchronizedMap(new HashMap());
    protected Map _app_deployments = null;
    protected static Repository _repository;
    protected static String _repositoryURI;
    protected long _notif_num = 0L;
    protected boolean _servant_up = false;
    protected boolean _repository_init = false;
    private Object sendLock = new Object();
    private static boolean sendReportSync;
    protected static final Integer LOCAL_APP_LISTENER;
    protected static final Integer CONTROL_ADMIN_LISTENER;
    protected static final Integer NODE_AGENT_LISTENER;
    protected static final Integer STATUS_CACHE_LISTENER;
    protected static final Integer SERVER_LISTENER;
    protected static final Integer CLUSTER_LISTENER;
    protected static final Integer MESSAGE_PORT_LISTENER;

    protected AbstractStatusCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractStatusCache");
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        this._cellName = adminService.getCellName();
        this._nodeName = adminService.getNodeName();
        this._serverName = adminService.getProcessName();
        this._process_type = adminService.getProcessType();
        _repositoryURI = _repository.getRootURI();
        RoutingTable.getInstance().addRoutingListener(this);
        this.registerEvents();
        boolean bl = false;
        Exception exception = null;
        if ("NodeAgent".equals(this._process_type)) {
            try {
                this._servers = this.getServers();
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "264", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of servers", exception2);
                }
                bl = true;
                exception = exception2;
                this._servers = Collections.synchronizedSet(new HashSet());
            }
        }
        if ("DeploymentManager".equals(this._process_type)) {
            try {
                this._nodes = this.getNodes();
            }
            catch (Exception exception3) {
                FFDCFilter.processException((Throwable)exception3, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "279", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of node", exception3);
                }
                bl = true;
                exception = exception3;
                this._nodes = Collections.synchronizedSet(new HashSet());
            }
        }
        if (!this._process_type.equals("UnManagedProcess")) {
            try {
                this._clusters = this.getClusters();
            }
            catch (Exception exception4) {
                FFDCFilter.processException((Throwable)exception4, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "295", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of clusters", exception4);
                }
                bl = true;
                exception = exception4;
                this._clusters = Collections.synchronizedSet(new HashSet());
            }
        }
        if (!"NodeAgent".equals(this._process_type)) {
            try {
                this._app_state = this.getApplications();
            }
            catch (Exception exception5) {
                FFDCFilter.processException((Throwable)exception5, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "312", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of applications / states", exception5);
                }
                bl = true;
                exception = exception5;
                this._app_state = Collections.synchronizedMap(new HashMap());
            }
            try {
                this._app_deployments = this.getDeployments();
            }
            catch (Exception exception6) {
                FFDCFilter.processException((Throwable)exception6, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "328", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of applications / deployments", exception6);
                }
                bl = true;
                exception = exception6;
                this._app_deployments = Collections.synchronizedMap(new HashMap());
            }
        }
        if ("DeploymentManager".equals(this._process_type) && !this._process_type.equals("UnManagedProcess")) {
            try {
                this._cluster_xml = this.getClusterXML();
            }
            catch (Exception exception7) {
                FFDCFilter.processException((Throwable)exception7, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "348", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get Cluster Objects", exception7);
                }
                bl = true;
                exception = exception7;
                this._cluster_xml = Collections.synchronizedMap(new HashMap());
            }
        }
        if ("NodeAgent".equals(this._process_type) || "UnManagedProcess".equals(this._process_type)) {
            try {
                this._serverIndexes = this.getServerIndexes(this._nodeName);
            }
            catch (Exception exception8) {
                FFDCFilter.processException((Throwable)exception8, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "364", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get ServerIndex", exception8);
                }
                bl = true;
                exception = exception8;
                this._serverIndexes = Collections.synchronizedMap(new HashMap());
            }
        }
        if (bl) {
            Tr.warning(tc, this.nls.getFormattedMessage("ADME0005W", new Object[]{exception}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractStatusCache");
        }
    }

    protected String getCacheType() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type: " + this._process_type);
        }
        return this._process_type;
    }

    protected static void setRepository(Repository repository2) {
        _repository = repository2;
    }

    protected void sendReportNotification(Notification notification) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendNotification");
            }
            try {
                super.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.status.AbstractStatusCache.sendReportNotification", "410", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "MBeanException on sendReportNotification - ", mBeanException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendNotification");
        }
    }

    public void sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendReport");
        }
        if ("DeploymentManager".equals(this._process_type)) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.__sendReport(new Boolean(false), new Boolean(false));
            } else {
                StatusCacheRefreshThread statusCacheRefreshThread = new StatusCacheRefreshThread(false, false);
                statusCacheRefreshThread.start();
            }
        } else if ("NodeAgent".equals(this._process_type)) {
            this.__sendReport(new Boolean(false), new Boolean(false));
        } else {
            StatusCacheRefreshThread statusCacheRefreshThread = new StatusCacheRefreshThread(false, false);
            statusCacheRefreshThread.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendReport");
        }
    }

    public void sendReport(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendReport");
        }
        if ("DeploymentManager".equals(this._process_type)) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.__sendReport(bl, new Boolean(false));
            } else {
                StatusCacheRefreshThread statusCacheRefreshThread = new StatusCacheRefreshThread(false, false);
                statusCacheRefreshThread.start();
            }
        } else if ("NodeAgent".equals(this._process_type)) {
            this.__sendReport(bl, new Boolean(false));
        } else {
            StatusCacheRefreshThread statusCacheRefreshThread = new StatusCacheRefreshThread(bl, false);
            statusCacheRefreshThread.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendReport");
        }
    }

    public void sendReport(Boolean bl, Boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendReport");
        }
        if ("DeploymentManager".equals(this._process_type)) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.__sendReport(bl, bl2);
            } else {
                StatusCacheRefreshThread statusCacheRefreshThread = new StatusCacheRefreshThread(false, bl2);
                statusCacheRefreshThread.start();
            }
        } else if ("NodeAgent".equals(this._process_type)) {
            this.__sendReport(bl, bl2);
        } else {
            StatusCacheRefreshThread statusCacheRefreshThread = new StatusCacheRefreshThread(bl, bl2);
            statusCacheRefreshThread.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendReport");
        }
    }

    public abstract void _sendReport();

    public abstract void _sendReport(Boolean var1, Boolean var2);

    public abstract void refreshCache(boolean var1, boolean var2);

    public abstract void requestReport(String var1, Boolean var2);

    public abstract void requestReport(String var1);

    public abstract void requestReport(Boolean var1);

    public abstract String dumpCache();

    public abstract void handleNotification(Notification var1, Object var2);

    public abstract void registerEvents();

    protected abstract void listenForJ2EEStateNotifications();

    protected abstract void listenForCacheReportNotifications();

    protected abstract void listenForLocalApplicationNotifications();

    protected abstract void listenForMessageListenerNotifications();

    public abstract void addToCache(int var1, String var2, String var3);

    public abstract void removeFromCache(int var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws MBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{objectName, string, objectArray, stringArray});
        }
        Subject subject = null;
        Subject subject2 = null;
        subject2 = SecurityHelper.getServerSubject();
        try {
            if (subject2 != null) {
                subject = SecurityHelper.pushInvocationSubject(subject2);
            }
            if (objectName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Can not perform operation invoke on a null object name", string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invoke", null);
                }
                Object var7_7 = null;
                return var7_7;
            }
            Object object = AdminServiceFactory.getAdminService().invoke(objectName, string, objectArray, stringArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke", object);
            }
            Object object2 = object;
            return object2;
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.status.AbstractStatusCache.invoke", "537", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught an mbean exception..printing stacktrace and rethrowing", mBeanException);
            }
            throw mBeanException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache.invoke", "541", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in AbstractStatusCache:" + exception);
            }
        }
        finally {
            if (subject2 != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
        }
        return null;
    }

    public Set getMBeans(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeans", new Object[]{string});
        }
        HashSet hashSet = null;
        try {
            ObjectName objectName = new ObjectName(string);
            hashSet = AdminServiceFactory.getAdminService().queryNames(objectName, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.status.AbstractStatusCache.getMBeans", "574", this);
            Tr.error(tc, "Invalid MBean filter passed to getMBean: " + string);
            hashSet = new HashSet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean", new Object[]{hashSet});
        }
        return hashSet;
    }

    public ObjectName getMBean(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean", new Object[]{string});
        }
        try {
            ObjectName objectName = new ObjectName(string);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                if (iterator.hasNext() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Multiple MBeans found when only one was expected");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean", new Object[]{objectName2});
                }
                return objectName2;
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.status.AbstractStatusCache.getMBean", "611", this);
            Tr.error(tc, "Invalid MBean filter passed to getMBean: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return null;
    }

    protected ServerEntry findServerEntry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findServerEntry");
        }
        ConfigRoot configRoot = _repository.getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string = serverEntry.getServerName();
            if (!this._serverName.equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findServerEntry");
            }
            return serverEntry;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findServerEntry - null");
        }
        return null;
    }

    protected Set buildAppList(ServerEntry serverEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAppList");
        }
        HashSet<String> hashSet = new HashSet<String>();
        EList eList = serverEntry.getDeployedApplications();
        for (int i = 0; i < eList.size(); ++i) {
            String string = (String)eList.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            LinkedList<String> linkedList = new LinkedList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
            }
            String[] stringArray = linkedList.toArray(new String[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding App: " + stringArray[stringArray.length - 1]);
            }
            hashSet.add(stringArray[stringArray.length - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAppList");
        }
        return hashSet;
    }

    public void registerServantStartup() {
        block5: {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = new ObjectName(adminService.getDomainName() + ":" + "type=ControlAdminService,node=" + this._nodeName + ",process=" + this._serverName + ",*");
                MBeanServer mBeanServer = adminService.getMBeanFactory().getMBeanServer();
                Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
                if (set.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ControlAdminService MBean not registered");
                    }
                } else {
                    Iterator<ObjectName> iterator = set.iterator();
                    ObjectName objectName2 = iterator.next();
                    AdminServiceFactory.getAdminService().getMBeanFactory().getMBeanServer().addNotificationListener(objectName2, new AsyncListenerWrapper(this), (NotificationFilter)new ControlAdminServiceFilter(), (Object)CONTROL_ADMIN_LISTENER);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache.registerServantStartup", "720", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception on registerServerStartup ", exception);
            }
        }
    }

    protected Map getApplications() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplications");
        }
        ServerEntry serverEntry = null;
        Map<String, String> map = Collections.synchronizedMap(new HashMap());
        serverEntry = this.findServerEntry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using ServerEntry: " + serverEntry);
        }
        EList eList = null;
        if (serverEntry != null) {
            eList = serverEntry.getDeployedApplications();
        }
        for (int i = 0; i < eList.size(); ++i) {
            String string = (String)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "longName=" + string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            LinkedList<String> linkedList = new LinkedList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
            }
            String[] stringArray = linkedList.toArray(new String[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding App: " + stringArray[stringArray.length - 1] + "  STOPPED");
            }
            map.put(stringArray[stringArray.length - 1], "j2ee.state.stopped");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplications");
        }
        return map;
    }

    protected Set getServers() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServers");
        }
        Set<String> set = Collections.synchronizedSet(new HashSet());
        String string = _repositoryURI + "/cells/" + this._cellName + "/nodes/" + this._nodeName + "/servers";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            String string2 = fileArray[i].getName();
            set.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServers");
        }
        return set;
    }

    protected Set getNodes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodes");
        }
        Set<String> set = Collections.synchronizedSet(new HashSet());
        String string = _repositoryURI + "/cells/" + this._cellName + "/nodes";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            String string2 = fileArray[i].getName();
            set.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodes");
        }
        return set;
    }

    protected Set getClusters() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusters");
        }
        Set<String> set = Collections.synchronizedSet(new HashSet());
        String string = _repositoryURI + "/cells/" + this._cellName + "/clusters";
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                String string2 = fileArray[i].getName();
                set.add(string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusters");
            }
        }
        return set;
    }

    protected Map getDeployments() throws Exception {
        Deployment deployment;
        Resource resource;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeployments");
        }
        Map<String, Deployment> map = Collections.synchronizedMap(new HashMap());
        String string = _repositoryURI + "/cells/" + this._cellName + "/applications";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "App Root Dir: " + string);
        }
        File file2 = new File(string);
        File[] fileArray = file2.listFiles();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "App Root List", fileArray);
        }
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    file = new File(fileArray[i], "deployments");
                    resource = file.listFiles();
                    deployment = null;
                    if (resource == null) continue;
                    for (int j = 0; j < ((File[])resource).length; ++j) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "App Name: " + resource[j].getName());
                        }
                        deployment = this.getDeploymentXML(resource[j] + "/deployment.xml");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deployment.xml: ", deployment);
                        }
                        map.put(resource[j].getName(), deployment);
                    }
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache.getDeployments", "863", this);
                    Tr.debug(tc, "Couldn't find app: ", exception);
                }
            }
        }
        try {
            String string2 = _repositoryURI + "/cells/" + this._cellName + "/nodes/" + this._nodeName + "/systemapps.xml";
            file = new File(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Systemapps.xml exists ? " + file.exists());
            }
            if (file.exists() && (resource = this.getResource(string2, "systemapps.xml")) != null && (deployment = (ServerIndex)resource.getContents().iterator().next()) == null) {
                EList eList = deployment.getServerEntries();
                ServerEntry serverEntry = null;
                Deployment deployment2 = null;
                File file3 = null;
                for (int i = 0; i < eList.size(); ++i) {
                    serverEntry = (ServerEntry)eList.get(i);
                    if (!this._serverName.equals(serverEntry.getServerName())) continue;
                    EList eList2 = serverEntry.getDeployedApplications();
                    String string3 = null;
                    for (int j = 0; j < eList2.size(); ++j) {
                        string3 = (String)eList2.get(j);
                        file3 = new File(string3);
                        string3 = string3 + "/deployment.xml";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "App Name: " + file3.getName());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "App Path: " + string3);
                        }
                        deployment2 = this.getDeploymentXML(string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deployment.xml: ", deployment2);
                        }
                        map.put(file3.getName(), deployment2);
                    }
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getSystemApps: ", exception);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", "943", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployments", map);
        }
        return map;
    }

    private Deployment getDeploymentXML(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentXML", string);
        }
        Resource resource = this.getResource(string, "deployment.xml");
        Deployment deployment = (Deployment)resource.getContents().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentXML", deployment);
        }
        return deployment;
    }

    protected Map getServerIndexes(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndexes", string);
        }
        Map<String, ServerIndex> map = Collections.synchronizedMap(new HashMap());
        String string2 = _repositoryURI + "/cells/" + this._cellName + "/nodes/" + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Root Dir: " + string2);
        }
        ServerIndex serverIndex = null;
        Resource resource = this.getResource(string2 + "/serverindex.xml", "serverindex.xml");
        serverIndex = (ServerIndex)resource.getContents().get(0);
        map.put(string, serverIndex);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndexes", map);
        }
        return map;
    }

    protected Map getClusterXML() throws Exception {
        File file;
        File[] fileArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterXML");
        }
        Map<String, ServerCluster> map = Collections.synchronizedMap(new HashMap());
        String string = _repositoryURI + "/cells/" + this._cellName + "/clusters";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster Root Dir: " + string);
        }
        if ((fileArray = (file = new File(string)).listFiles()) == null) {
            return map;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClusterName: " + fileArray[i]);
            }
            ServerCluster serverCluster = null;
            if (fileArray[i] != null) {
                Resource resource = this.getResource(fileArray[i] + "/cluster.xml", "cluster.xml");
                serverCluster = (ServerCluster)resource.getContents().get(0);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster.xml: " + serverCluster);
            }
            map.put(fileArray[i].getName(), serverCluster);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterXML");
        }
        return map;
    }

    protected Resource getResource(String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "filepath is: " + string);
        }
        ResourceSet resourceSet = this.createResourceSet(_repositoryURI);
        URI uRI = URI.createFileURI((String)string);
        Resource resource = resourceSet.getResource(uRI, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "res for: " + string + " is: " + resource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource");
        }
        return resource;
    }

    protected ResourceSet createResourceSet(final String string) {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(string + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    private String[] tokenizeConfigURI(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = linkedList.toArray(new String[0]);
        return stringArray;
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onRepositoryEpochRefresh() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeCompletion", configRepositoryEvent);
        }
        StatusCacheRefreshThread statusCacheRefreshThread = new StatusCacheRefreshThread(configRepositoryEvent);
        statusCacheRefreshThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onChangeCompletion");
        }
    }

    public void _onChangeCompletion(final ConfigRepositoryEvent configRepositoryEvent) {
        block3: {
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        AbstractStatusCache.this._onChangeCompletion2(configRepositoryEvent);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion", "1020", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause());
                }
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion", "969", this);
                if (privilegedActionException.getCause() == null) break block3;
                privilegedActionException.getCause().printStackTrace();
            }
        }
    }

    public void _onChangeCompletion2(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_onChangeCompletion2", configRepositoryEvent);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            String string;
            String[] stringArray = this.tokenizeConfigURI(configChangeNotifierArray[i].getUri());
            if (stringArray[0].equals("xformed")) {
                if (!tc.isEntryEnabled()) continue;
                Tr.entry(tc, "Skipping because its xformed", stringArray);
                continue;
            }
            if (stringArray[stringArray.length - 1].equals("node.xml")) {
                if (!this._process_type.equals("DeploymentManager")) continue;
                string = stringArray[stringArray.length - 2];
                if (configChangeNotifierArray[i].getChangeType() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node Added to Cell: " + string);
                    }
                    try {
                        this._nodes = this.getNodes();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1050", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unabled to get list of node", exception);
                        }
                        this._nodes = Collections.synchronizedSet(new HashSet());
                    }
                    this.addToCache(1, string, "j2ee.state.stopped");
                    continue;
                }
                if (configChangeNotifierArray[i].getChangeType() != 1) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node Removed from Cell: " + string);
                }
                try {
                    this._nodes = this.getNodes();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1065", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unabled to get list of node", exception);
                    }
                    this._nodes = Collections.synchronizedSet(new HashSet());
                }
                this.removeFromCache(1, string);
                continue;
            }
            if (stringArray[stringArray.length - 1].equals("server.xml")) {
                if (!this._process_type.equals("NodeAgent")) continue;
                string = stringArray[stringArray.length - 2];
                if (configChangeNotifierArray[i].getChangeType() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Added to Node: " + string);
                    }
                    try {
                        this._servers = this.getServers();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1089", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unabled to get list of servers", exception);
                        }
                        this._servers = Collections.synchronizedSet(new HashSet());
                    }
                    this.addToCache(0, string, "j2ee.state.stopped");
                    continue;
                }
                if (configChangeNotifierArray[i].getChangeType() != 1) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Removed from Node: " + string);
                }
                try {
                    this._servers = this.getServers();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1104", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unabled to get list of servers", exception);
                    }
                    this._servers = Collections.synchronizedSet(new HashSet());
                }
                this.removeFromCache(0, string);
                continue;
            }
            if (stringArray[stringArray.length - 1].equals("deployment.xml")) {
                block65: {
                    if (this._process_type.equals("UnManagedProcess") || this._process_type.equals("NodeAgent") || this._process_type.equals("DeploymentManager")) {
                        string = stringArray[stringArray.length - 2];
                        if (configChangeNotifierArray[i].getChangeType() == 0) {
                            block63: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Application Added: " + string);
                                }
                                try {
                                    if (!this._process_type.equals("NodeAgent")) {
                                        this._app_state = this.getApplications();
                                        this._app_deployments = this.getDeployments();
                                    }
                                    this.requestReport(Boolean.TRUE);
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1136", this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Unabled to get list of applications / states", exception);
                                    }
                                    if (this._process_type.equals("NodeAgent")) break block63;
                                    this._app_state = Collections.synchronizedMap(new HashMap());
                                    this._app_deployments = Collections.synchronizedMap(new HashMap());
                                }
                            }
                            if (!this._process_type.equals("NodeAgent")) {
                                this.addToCache(2, string, "j2ee.state.stopped");
                            }
                        } else if (configChangeNotifierArray[i].getChangeType() == 1) {
                            block64: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Application Removed: " + string);
                                }
                                try {
                                    if (!this._process_type.equals("NodeAgent")) {
                                        this._app_state = this.getApplications();
                                        this._app_deployments = this.getDeployments();
                                    }
                                    this.requestReport(Boolean.TRUE);
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1166", this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Unabled to get list of applications / states", exception);
                                    }
                                    if (this._process_type.equals("NodeAgent")) break block64;
                                    this._app_state = Collections.synchronizedMap(new HashMap());
                                    this._app_deployments = Collections.synchronizedMap(new HashMap());
                                }
                            }
                            if (!this._process_type.equals("NodeAgent")) {
                                this.removeFromCache(2, string);
                            }
                        } else if (configChangeNotifierArray[i].getChangeType() == 2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Application Modifed: " + string);
                            }
                            try {
                                if (!this._process_type.equals("NodeAgent")) {
                                    this._app_state = this.getApplications();
                                    this._app_deployments = this.getDeployments();
                                }
                                this.requestReport(Boolean.TRUE);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1192", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Unabled to get list of applications / states", exception);
                                }
                                if (this._process_type.equals("NodeAgent")) break block65;
                                this._app_state = Collections.synchronizedMap(new HashMap());
                                this._app_deployments = Collections.synchronizedMap(new HashMap());
                            }
                        }
                    }
                }
                this.sendReport();
                continue;
            }
            if (stringArray[stringArray.length - 1].equals("serverindex.xml")) {
                if (this._process_type.equals("NodeAgent") && configChangeNotifierArray[i].getChangeType() == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServerIndex Modifed: ");
                    }
                    try {
                        this._app_state = this.getApplications();
                        this._app_deployments = this.getDeployments();
                        this._serverIndexes = this.getServerIndexes(this._nodeName);
                        this.requestReport(Boolean.TRUE);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1223", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unabled to get list of applications / states", exception);
                        }
                        this._app_state = Collections.synchronizedMap(new HashMap());
                        this._app_deployments = Collections.synchronizedMap(new HashMap());
                        this._serverIndexes = Collections.synchronizedMap(new HashMap());
                    }
                }
                this.sendReport();
                continue;
            }
            if (!stringArray[stringArray.length - 1].equals("cluster.xml") || !this._process_type.equals("DeploymentManager")) continue;
            string = stringArray[stringArray.length - 2];
            try {
                this._clusters = this.getClusters();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1246", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of servers", exception);
                }
                this._clusters = Collections.synchronizedSet(new HashSet());
            }
            try {
                this._cluster_xml = this.getClusterXML();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", "1256", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get Cluster Objects", exception);
                }
                this._cluster_xml = Collections.synchronizedMap(new HashMap());
            }
            if (configChangeNotifierArray[i].getChangeType() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster Added to Cell: " + string);
                }
                this.addToCache(3, string, "j2ee.state.stopped");
                continue;
            }
            if (configChangeNotifierArray[i].getChangeType() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster Removed from Cell: " + string);
                }
                this.removeFromCache(3, string);
                continue;
            }
            if (configChangeNotifierArray[i].getChangeType() != 2 || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Cluster Modifed: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map generateServerTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateServerTypes");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map map = this._serverIndexes;
        synchronized (map) {
            ServerIndex serverIndex = (ServerIndex)this._serverIndexes.get(this._nodeName);
            if (serverIndex != null) {
                EList eList = serverIndex.getServerEntries();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry = (ServerEntry)iterator.next();
                    String string = serverEntry.getServerName();
                    String string2 = serverEntry.getServerType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Name - Type", new Object[]{string, string2});
                    }
                    hashMap.put(string, string2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateServerTypes", hashMap);
        }
        return hashMap;
    }

    public void placeReport(StatusReport statusReport) {
    }

    public void childAdded(ServerInfo serverInfo) {
    }

    public void childRemoved(ServerInfo serverInfo) {
    }

    public void parentAdded(ServerInfo serverInfo) {
    }

    public void parentRemoved(ServerInfo serverInfo) {
    }

    public void addServant(Notification notification) {
        String string = this.getServantID(notification.getMessage());
        if (string != null) {
            if (_activeServants == null) {
                _activeServants = Collections.synchronizedSet(new HashSet());
            }
            _activeServants.add(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, new StringBuilder().append("added servant ").append(string).append(" to the cache of active servants, there are now ").append(Integer.toString(_activeServants.size())).append(" servant(s) in the cache:").toString(), _activeServants.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cannot add servant to cache of active servants, notification.getMessage() is: " + notification.getMessage());
        }
    }

    public boolean removeServant(Notification notification) {
        String string = this.getServantID(notification.getMessage());
        boolean bl = false;
        if (_activeServants != null) {
            if (string != null) {
                _activeServants.remove(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, new StringBuilder().append("removed servant ").append(string).append(" from the cache of active servants, there are now ").append(Integer.toString(_activeServants.size())).append(" servant(s) in the cache:").toString(), _activeServants.toString());
                }
                bl = _activeServants.size() > 0;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cannot remove servant from cache of active servants, servant is null, notification.getMessage() is: " + notification.getMessage());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cannot remove servant " + string + " from cache of active servants, cache is null, notification.getMessage() is: " + notification.getMessage());
        }
        return bl;
    }

    private String getServantID(String string) {
        return this.extractToken(string, 2);
    }

    private String extractToken(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = null;
        if (stringTokenizer.countTokens() >= n) {
            for (int i = 1; i <= n; ++i) {
                string2 = stringTokenizer.nextToken();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __sendReport(Boolean bl, Boolean bl2) {
        if (sendReportSync) {
            Object object = this.sendLock;
            synchronized (object) {
                this._sendReport(bl, bl2);
            }
        } else {
            this._sendReport(bl, bl2);
        }
    }

    static {
        block11: {
            tc = Tr.register(AbstractStatusCache.class.getName(), null, null);
            resourceBundleName = "com.ibm.ws.management.resources.event";
            REPORT_TYPE = "websphere.status.report";
            _activeServants = null;
            _repository = null;
            _repositoryURI = null;
            sendReportSync = false;
            LOCAL_APP_LISTENER = new Integer(0);
            CONTROL_ADMIN_LISTENER = new Integer(1);
            NODE_AGENT_LISTENER = new Integer(2);
            STATUS_CACHE_LISTENER = new Integer(3);
            SERVER_LISTENER = new Integer(4);
            CLUSTER_LISTENER = new Integer(5);
            MESSAGE_PORT_LISTENER = new Integer(6);
            String string = "com.ibm.ws.management.status.sendReportSynchronized";
            try {
                String string2 = System.getProperty(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Value for system property '" + string + "' is " + (string2 == null ? "<null>" : "'" + string2 + "'"));
                }
                sendReportSync = false;
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("true")) {
                        sendReportSync = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using value of 'true'");
                        }
                    } else if (string2.equalsIgnoreCase("false")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using value of 'false'");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Ignoring value, defaulting to 'false'");
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Exception getting system property '" + string + "': " + exception, exception);
            }
        }
    }

    private class ControlAdminServiceFilter
    implements NotificationFilter {
        private static final long serialVersionUID = 7189930528471819230L;

        private ControlAdminServiceFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            boolean bl;
            String string = notification.getType();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ControlAdminServiceFilter.isNotificationEnabled", string);
            }
            boolean bl2 = bl = string.equals("websphere.ws390.servant.started") || string.equals("websphere.ws390.servant.terminated");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ControlAdminServiceFilter.isNotificationEnabled", Boolean.toString(bl));
            }
            return bl;
        }
    }

    class StatusCacheRefreshThread
    extends Thread {
        private boolean refresh = false;
        private boolean send = false;
        private String contact = null;
        private ConfigRepositoryEvent event = null;
        private boolean servantRemoved = false;

        public StatusCacheRefreshThread(ConfigRepositoryEvent configRepositoryEvent) {
            Tr.debug(tc, "Creating StatusCacheRefreshThread", configRepositoryEvent);
            this.send = false;
            this.event = configRepositoryEvent;
        }

        public StatusCacheRefreshThread(boolean bl, boolean bl2) {
            Tr.debug(tc, "Creating StatusCacheRefreshThread", new String[]{Boolean.toString(bl), Boolean.toString(bl2)});
            this.refresh = bl;
            this.servantRemoved = bl2;
            this.send = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StatusCacheRefreshThread run");
            }
            if (!AbstractStatusCache.this._repository_init) {
                object = ConfigRepositoryFactory.getConfigRepository();
                if (object != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Repository init init, allow thread to continue");
                    }
                    AbstractStatusCache.this._repository_init = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Repository is not init yet, do not continue thread");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "StatusCacheRefreshThread run");
                    }
                    return;
                }
            }
            object = null;
            Subject subject = null;
            subject = SecurityHelper.getServerSubject();
            try {
                if (subject != null) {
                    object = SecurityHelper.pushInvocationSubject(subject);
                }
                if (this.send) {
                    AbstractStatusCache.this.__sendReport(new Boolean(this.refresh), new Boolean(this.servantRemoved));
                } else {
                    AbstractStatusCache.this._onChangeCompletion(this.event);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AbstractStatusCache.run", "1371", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in AbstractStatusCache:" + exception);
                }
            }
            finally {
                if (subject != null) {
                    SecurityHelper.popInvocationSubject((Subject)object);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatusCacheRefreshThread run");
            }
        }
    }
}

