/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.status.AbstractStatusCache;
import com.ibm.ws.management.status.AppServerStatusReport;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.util.SecurityHelper;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AppServerStatusCache
extends AbstractStatusCache {
    private static final TraceComponent tc = Tr.register(AppServerStatusCache.class, null, null);
    private AdminClient parent_ac = null;
    private String parentNodeName = null;
    private String parentProcessName = null;
    private ObjectName parentStatusCache = null;
    private StatusReport currentReport = null;
    private StatusCacheTimedThread activeThread = null;
    private StatusCacheTimedThread passiveThread = null;

    protected AppServerStatusCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppServerStatusCache");
        }
        this.registerEvents();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppServerStatusCache");
        }
    }

    public void registerEvents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvents");
        }
        this.listenForLocalApplicationNotifications();
        this.listenForMessageListenerNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvents");
        }
    }

    public void _sendReport(Boolean bl, Boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport - force", new Object[]{bl, bl2});
        }
        if (bl.equals(Boolean.TRUE)) {
            this.refreshCache(true, bl2);
        }
        this._sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport - force");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport");
        }
        HashMap hashMap = AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess") ? this.generateServerTypes() : new HashMap();
        AppServerStatusReport appServerStatusReport = new AppServerStatusReport(this._app_state, this._port_state, hashMap);
        appServerStatusReport.setCell(this._cellName);
        appServerStatusReport.setNode(this._nodeName);
        appServerStatusReport.setServer(this._serverName);
        if (AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
            try {
                this._app_deployments = this.getDeployments();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting deployments", exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AppServerStatusCache._sendReport", "121", this);
            }
            appServerStatusReport.setDeployments(this._app_deployments);
            appServerStatusReport.generate();
        }
        this.currentReport = appServerStatusReport;
        if ("UnManagedProcess".equals(this._process_type)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Src: " + this.getObjectName());
            }
            Notification notification = new Notification("websphere.status.report", this.getObjectName(), this._notif_num++);
            notification.setUserData(appServerStatusReport);
            super.sendReportNotification(notification);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_sendReport");
            }
        } else if (this.passiveThread != null) {
            StatusCacheTimedThread statusCacheTimedThread = this.passiveThread;
            synchronized (statusCacheTimedThread) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending Immediately");
                }
                this.passiveThread.setInterrupted();
                this.passiveThread.interrupt();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new report set", this.currentReport);
        }
    }

    public String dumpCache() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Server: ");
        stringBuffer.append(this._serverName);
        stringBuffer.append("\n");
        stringBuffer.append("---------------------\n");
        Set set = this._app_state.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append("App: ");
            stringBuffer.append(object.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(object.getValue());
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        object = this._port_state.entrySet();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            stringBuffer.append("Port: ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        stringBuffer.append("END OF DUMP");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notification, object});
        }
        String string = notification.getType();
        boolean bl = false;
        if (object.equals(CONTROL_ADMIN_LISTENER)) {
            boolean bl2 = false;
            if (string.equals("websphere.ws390.servant.started")) {
                ServantMBeanStatus servantMBeanStatus = (ServantMBeanStatus)notification.getUserData();
                this._servant_up = true;
                bl2 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New Servant, refreshing the cache");
                }
                this.addServant(notification);
            } else if (string.equals("websphere.ws390.servant.terminated") && (bl2 = (bl = this.removeServant(notification))) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Active Servants remain, refreshing the cache");
            }
            if (bl2) {
                this.sendReport(new Boolean(true), new Boolean(bl));
            }
        } else if (object.equals(LOCAL_APP_LISTENER)) {
            Object object2;
            ObjectName objectName = (ObjectName)notification.getSource();
            String string2 = objectName.getKeyProperty("name");
            if (EditionHelper.isEditionSupportEnabled()) {
                string2 = objectName.getKeyProperty("mbeanIdentifier");
                object2 = string2.split("/");
                string2 = object2[5];
                try {
                    string2 = URLDecoder.decode(string2, "UTF-8");
                }
                catch (Exception exception) {
                    Tr.debug(tc, "Error URLDecoding mbean identifier appName: " + string2);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application changed is: " + string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification Type: " + notification.getType());
            }
            if (notification.getType().equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string2 + " is now STOPPED");
                }
                object2 = this._app_state;
                synchronized (object2) {
                    this._app_state.put(string2, "j2ee.state.stopped");
                }
            }
            if (notification.getType().equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string2 + " is now STOPPING");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string2 + " is now STOPPED");
                }
                object2 = this._app_state;
                synchronized (object2) {
                    this._app_state.put(string2, "j2ee.state.stopped");
                }
            }
            if (notification.getType().equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string2 + " is now STARTING");
                }
                object2 = this._app_state;
                synchronized (object2) {
                    this._app_state.put(string2, "j2ee.state.starting");
                }
            }
            if (notification.getType().equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string2 + " is now RUNNING");
                }
                object2 = this._app_state;
                synchronized (object2) {
                    this._app_state.put(string2, "j2ee.state.running");
                }
            }
            if (notification.getType().equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string2 + " is now FAILED");
                }
                object2 = this._app_state;
                synchronized (object2) {
                    this._app_state.put(string2, "j2ee.state.failed");
                }
            }
            this.sendReport();
        } else if (object.equals(MESSAGE_PORT_LISTENER)) {
            ObjectName objectName = (ObjectName)notification.getSource();
            String string3 = objectName.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MessageListener changed is: " + string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification Type: " + notification.getType());
            }
            if (notification.getType().equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + string3 + " is now STOPPED");
                }
                Map map = this._port_state;
                synchronized (map) {
                    this._port_state.put(string3, "j2ee.state.stopped");
                }
            }
            if (notification.getType().equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + string3 + " is now STOPPING");
                }
                Map map = this._port_state;
                synchronized (map) {
                    this._port_state.put(string3, "j2ee.state.stopping");
                }
            }
            if (notification.getType().equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + string3 + " is now STARTING");
                }
                Map map = this._port_state;
                synchronized (map) {
                    this._port_state.put(string3, "j2ee.state.starting");
                }
            }
            if (notification.getType().equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + string3 + " is now RUNNING");
                }
                Map map = this._port_state;
                synchronized (map) {
                    this._port_state.put(string3, "j2ee.state.running");
                }
            }
            if (notification.getType().equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + string3 + " is now FAILED");
                }
                Map map = this._port_state;
                synchronized (map) {
                    this._port_state.put(string3, "j2ee.state.failed");
                }
            }
            this.sendReport();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshCache(boolean bl, boolean bl2) {
        String[] stringArray;
        Object object;
        Comparable<ObjectName> comparable;
        String string;
        Iterator iterator;
        Set set;
        CharSequence charSequence;
        Object object2;
        ServerEntry serverEntry;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshCache");
            }
            serverEntry = null;
            try {
                serverEntry = this.findServerEntry();
            }
            catch (Exception exception) {
                if (!bl2 || !bl) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AppServerStatusCache.refreshCache", "273", this);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when finding Server Entry", exception);
                }
            }
            finally {
                if (serverEntry != null) break block27;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Entry was null, returning");
                }
                return;
            }
        }
        Set set2 = this._app_state.keySet();
        Set set3 = this.buildAppList(serverEntry);
        Iterator iterator2 = set2.iterator();
        while (iterator2.hasNext()) {
            object2 = (String)iterator2.next();
            if (set3.contains(object2)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove App: " + (String)object2 + " from Cache as it is no longer in Server Entry");
            }
            bl = true;
            iterator2.remove();
        }
        object2 = set3.iterator();
        while (object2.hasNext()) {
            charSequence = (String)object2.next();
            if (set2.contains(charSequence)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add App: " + (String)charSequence + " to Cache as it is new in Server Entry");
            }
            bl = true;
            this._app_state.put(charSequence, "j2ee.state.stopped");
        }
        if (bl) {
            charSequence = new StringBuffer("WebSphere:type=Application,node=");
            ((StringBuffer)charSequence).append(this._nodeName);
            ((StringBuffer)charSequence).append(",process=");
            ((StringBuffer)charSequence).append(this._serverName);
            ((StringBuffer)charSequence).append(",*");
            set = this.getMBeans(((StringBuffer)charSequence).toString());
            iterator = set.iterator();
            while (iterator.hasNext()) {
                string = null;
                try {
                    comparable = (ObjectName)iterator.next();
                    object = AdminServiceFactory.getAdminService();
                    string = (String)(object instanceof AdminServiceImpl ? ((AdminServiceImpl)object).getAttribute((ObjectName)comparable, "name", new Boolean(bl2)) : object.getAttribute((ObjectName)comparable, "name"));
                    if (string == null) continue;
                    if (EditionHelper.isEditionSupportEnabled()) {
                        string = ((ObjectName)comparable).getKeyProperty("mbeanIdentifier");
                        stringArray = string.split("/");
                        string = stringArray[5];
                        try {
                            string = URLDecoder.decode(string, "UTF-8");
                        }
                        catch (Exception exception) {
                            Tr.debug(tc, "Error URLDecoding mbean identifier appName: " + string);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding App: " + string + " to Cache as it is running");
                    }
                    this._app_state.put(string, "j2ee.state.running");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AppServerStatusCache.refreshCache", "323", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Caught MBean Exception - refreshCache", exception);
                }
            }
        }
        charSequence = new StringBuffer("WebSphere:type=ListenerPort,node=");
        ((StringBuffer)charSequence).append(this._nodeName);
        ((StringBuffer)charSequence).append(",process=");
        ((StringBuffer)charSequence).append(this._serverName);
        ((StringBuffer)charSequence).append(",*");
        set = this.getMBeans(((StringBuffer)charSequence).toString());
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string = null;
            comparable = null;
            try {
                object = (ObjectName)iterator.next();
                string = ((ObjectName)object).getKeyProperty("name");
                stringArray = AdminServiceFactory.getAdminService();
                comparable = (Boolean)(stringArray instanceof AdminServiceImpl ? ((AdminServiceImpl)stringArray).getAttribute((ObjectName)object, "started", new Boolean(bl2)) : stringArray.getAttribute((ObjectName)object, "started"));
                if (comparable == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Port: " + string + " to Cache Running: " + (Boolean)comparable);
                }
                if (((Boolean)comparable).booleanValue()) {
                    this._port_state.put(string, "j2ee.state.running");
                    continue;
                }
                this._port_state.put(string, "j2ee.state.stopped");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.AppServerStatusCache.refreshCache", "354", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Caught MBean Exception - refreshCache", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    protected void listenForCacheReportNotifications() {
    }

    protected void listenForJ2EEStateNotifications() {
    }

    public void requestReport(String string, Boolean bl) {
        this.sendReport(bl, new Boolean(false));
    }

    public void requestReport(String string) {
        this.sendReport();
    }

    public void requestReport(Boolean bl) {
        this.sendReport(bl, new Boolean(false));
    }

    public synchronized void addToCache(int n, String string, String string2) {
        if (n == 2) {
            this._app_state.put(string, string2);
            this.refreshCache(false, false);
            this.sendReport();
        }
    }

    public synchronized void removeFromCache(int n, String string) {
        if (n == 2) {
            this._app_state.remove(string);
            this.refreshCache(false, false);
            this.sendReport();
        }
    }

    protected void listenForMessageListenerNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForLocalApplicationNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                StringBuffer stringBuffer = new StringBuffer("WebSphere:type=ListenerPort,node=");
                stringBuffer.append(this._nodeName);
                stringBuffer.append(",process=");
                stringBuffer.append(this._serverName);
                stringBuffer.append(",*");
                ObjectName objectName = new ObjectName(stringBuffer.toString());
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("j2ee.state.stopping");
                notificationFilterSupport.enableType("j2ee.state.stopped");
                notificationFilterSupport.enableType("j2ee.state.starting");
                notificationFilterSupport.enableType("j2ee.state.running");
                notificationFilterSupport.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, MESSAGE_PORT_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.AppServerStatusCache.listenForMessageListenerNotifications", "432", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught JMX Exception - listenForLocalApplicationNotifications", jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForLocalApplicationNotifications");
        }
    }

    protected void listenForLocalApplicationNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForLocalApplicationNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Application,node=");
                stringBuffer.append(this._nodeName);
                stringBuffer.append(",process=");
                stringBuffer.append(this._serverName);
                stringBuffer.append(",*");
                ObjectName objectName = new ObjectName(stringBuffer.toString());
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("j2ee.state.stopping");
                notificationFilterSupport.enableType("j2ee.state.stopped");
                notificationFilterSupport.enableType("j2ee.state.starting");
                notificationFilterSupport.enableType("j2ee.state.running");
                notificationFilterSupport.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, LOCAL_APP_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.AppServerStatusCache.listenForLocalApplicationNotifications", "463", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught JMX Exception - listenForLocalApplicationNotifications", jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForLocalApplicationNotifications");
        }
    }

    public void parentAdded(ServerInfo serverInfo) {
        String string = serverInfo.getName();
        if (serverInfo.getNode().equals(this._nodeName) && serverInfo.getCell().equals(this._cellName) && string.equals("nodeagent")) {
            this.sendReport();
        }
        long l = Long.getLong("com.ibm.websphere.status.cache.maxActiveSleepInterval", Long.parseLong("1200000"));
        long l2 = Long.getLong("com.ibm.websphere.status.cache.maxPassiveSleepTime", Long.parseLong("20000"));
        this.activeThread = new StatusCacheTimedThread(this, l, true);
        this.activeThread.setDaemon(true);
        this.activeThread.start();
        this.passiveThread = new StatusCacheTimedThread(this, l2, false);
        this.passiveThread.setDaemon(true);
        this.passiveThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentAdded");
        }
    }

    public void parentRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRemoved");
        }
        if (this.activeThread != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shutting down active thread");
            }
            this.activeThread.shutdown();
            this.activeThread = null;
        }
        if (this.passiveThread != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shutting down passive thread");
            }
            this.passiveThread.shutdown();
            this.passiveThread = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentRemoved");
        }
    }

    class StatusCacheTimedThread
    extends Thread {
        boolean sendData;
        StatusReport lastReport;
        AppServerStatusCache cache;
        long sleep;
        boolean active;
        boolean interrupted;

        public StatusCacheTimedThread(AppServerStatusCache appServerStatusCache2, long l, boolean bl) {
            super("StatusCacheTimedThread:" + bl);
            this.sendData = true;
            this.lastReport = null;
            this.cache = null;
            this.sleep = 120000L;
            this.active = false;
            this.interrupted = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating StatusCacheTimedThread: " + bl);
            }
            this.cache = appServerStatusCache2;
            this.sleep = l;
            this.active = bl;
        }

        public void shutdown() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StatusCacheTimedThread shutdown");
            }
            this.sendData = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatusCacheTimedThread shutdown");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StatusCacheTimedThread run");
            }
            while (this.sendData) {
                Serializable serializable;
                Object object;
                block33: {
                    try {
                        Thread.sleep(this.sleep);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Finished Sleeping");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Interrupted", interruptedException);
                        }
                        if (this.active) {
                            this.sendData = false;
                            break block33;
                        }
                        this.sendData = this.sendData && this.interrupted;
                        object = AppServerStatusCache.this.passiveThread;
                        synchronized (object) {
                            this.interrupted = false;
                        }
                    }
                    finally {
                        Thread.interrupted();
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Active: " + this.active);
                }
                if (this.active) {
                    if (!this.sendData) continue;
                    serializable = null;
                    object = null;
                    object = SecurityHelper.getOwnedSubject();
                    SecurityHelper securityHelper = SecurityHelper.getHelper();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Parent AdminClient: " + AppServerStatusCache.this.parent_ac);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ownSubject ", object);
                        }
                        if (object != null) {
                            serializable = SecurityHelper.pushInvocationSubject((Subject)object);
                        }
                        if (AppServerStatusCache.this.parent_ac == null) {
                            AppServerStatusCache.this.parent_ac = RoutingTable.getInstance().getParent();
                            if (AppServerStatusCache.this.parentStatusCache == null) {
                                ObjectName objectName = AppServerStatusCache.this.parent_ac.getServerMBean();
                                AppServerStatusCache.this.parentNodeName = objectName.getKeyProperty("node");
                                AppServerStatusCache.this.parentProcessName = objectName.getKeyProperty("process");
                                ObjectName objectName2 = new ObjectName("WebSphere:*,type=StatusCache,node=" + AppServerStatusCache.this.parentNodeName + ",process=" + AppServerStatusCache.this.parentProcessName);
                                Set set = AppServerStatusCache.this.parent_ac.queryNames(objectName2, null);
                                AppServerStatusCache.this.parentStatusCache = (ObjectName)set.iterator().next();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Parent StatusCache: " + AppServerStatusCache.this.parentStatusCache);
                                }
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AdminClient / StatusCache ", new Object[]{AppServerStatusCache.this.parent_ac, AppServerStatusCache.this.parentStatusCache});
                        }
                        if (securityHelper.isSecurityServiceStarted() && !securityHelper.isSecurityServiceStopped() && AppServerStatusCache.this.parent_ac != null && AppServerStatusCache.this.parentStatusCache != null) {
                            AppServerStatusCache.this._sendReport();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Invoking placeReport: " + AppServerStatusCache.this.parentStatusCache);
                            }
                            this.lastReport = AppServerStatusCache.this.currentReport;
                            AppServerStatusCache.this.parent_ac.invoke(AppServerStatusCache.this.parentStatusCache, "placeReport", new Object[]{AppServerStatusCache.this.currentReport}, new String[]{"com.ibm.ws.management.status.StatusReport"});
                        }
                        if (object == null) continue;
                    }
                    catch (Exception exception) {
                        try {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.NodeAgentStatusCache$StatusCacheTimedThread.run", "1371", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception in AbstractStatusCache:" + exception);
                            }
                            if (object == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (object != null) {
                                SecurityHelper.popInvocationSubject(serializable);
                            }
                            throw throwable;
                        }
                        SecurityHelper.popInvocationSubject((Subject)serializable);
                        continue;
                    }
                    SecurityHelper.popInvocationSubject((Subject)serializable);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Last / Current ", new Object[]{this.lastReport, AppServerStatusCache.this.currentReport});
                }
                if (this.lastReport == AppServerStatusCache.this.currentReport) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending Notification");
                }
                this.lastReport = AppServerStatusCache.this.currentReport;
                serializable = new Notification("websphere.status.report", AppServerStatusCache.this.getObjectName(), AppServerStatusCache.this._notif_num++);
                ((Notification)serializable).setUserData(AppServerStatusCache.this.currentReport);
                this.cache.sendReportNotification((Notification)serializable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatusCacheTimedThread run");
            }
        }

        public void setInterrupted() {
            this.interrupted = true;
        }
    }
}

