/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.status.AbstractStatusCache;
import com.ibm.ws.management.status.AppServerStatusReport;
import com.ibm.ws.management.status.DeploymentManagerStatusReport;
import com.ibm.ws.management.status.NodeAgentStatusReport;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.status.StatusReport;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class DeploymentManagerStatusCache
extends AbstractStatusCache {
    private static final TraceComponent tc = Tr.register(DeploymentManagerStatusCache.class, null, null);
    private Map _server_reports = Collections.synchronizedMap(new HashMap());
    private Map _server_state = Collections.synchronizedMap(new HashMap());
    private Map nodeagent_state = Collections.synchronizedMap(new HashMap());
    private Map node_reports = Collections.synchronizedMap(new HashMap());
    private Map cluster_state = Collections.synchronizedMap(new HashMap());
    private Set _off_level_nodes = Collections.synchronizedSet(new HashSet());
    private Map server_type = new HashMap(1);

    protected DeploymentManagerStatusCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentManagerStatusCache");
        }
        this.server_type.put(this._serverName, "DEPLOYMENT_MANAGER");
        this.registerEvents();
        this.refreshNodeCache(false, false);
        this.refreshClusterCache(false, false);
        this.constructManagerReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentManagerStatusCache");
        }
    }

    private void constructManagerReport() {
        AppServerStatusReport appServerStatusReport = new AppServerStatusReport(this._app_state);
        appServerStatusReport.setCell(this._cellName);
        appServerStatusReport.setNode(this._nodeName);
        appServerStatusReport.setServer(this._serverName);
        this._server_state.put(this._serverName, "j2ee.state.running");
        this._server_reports.put(this._serverName, appServerStatusReport);
        NodeAgentStatusReport nodeAgentStatusReport = new NodeAgentStatusReport(this._server_state, this._server_reports, this.server_type);
        nodeAgentStatusReport.setCell(this._cellName);
        nodeAgentStatusReport.setNode(this._nodeName);
        this.nodeagent_state.put(this._nodeName, "j2ee.state.running");
        this.node_reports.put(this._nodeName, nodeAgentStatusReport);
    }

    public synchronized void addToCache(int n, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToCache", new Object[]{new Integer(n), string, string2});
        }
        if (n == 1) {
            this.nodeagent_state.put(string, string2);
            this.requestReport(string);
            this.sendReport(new Boolean(true), new Boolean(false));
        } else if (n == 2) {
            this.requestReport(Boolean.TRUE);
        } else if (n == 3) {
            this.cluster_state.put(string, "websphere.cluster.stopped");
            this.sendReport(new Boolean(false), new Boolean(false));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToCache");
        }
    }

    public synchronized void removeFromCache(int n, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromCache", new Object[]{new Integer(n), string});
        }
        if (n == 1) {
            this.nodeagent_state.put(string, "j2ee.state.stopped");
            this.node_reports.remove(string);
            this.sendReport(new Boolean(true), new Boolean(false));
        } else if (n == 2) {
            this.requestReport(Boolean.TRUE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromCache");
        }
    }

    public void requestReport(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WebSphere:type=StatusCache,cell=");
        stringBuffer.append(this._cellName);
        stringBuffer.append(",process=nodeagent");
        stringBuffer.append(",*");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RequestReport: ObjectName " + stringBuffer.toString());
        }
        Set set = super.getMBeans(stringBuffer.toString());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking on" + objectName);
                }
                if (bl.equals(Boolean.TRUE)) {
                    super.invoke(objectName, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
                    continue;
                }
                super.invoke(objectName, "sendReport", null, null);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", "202", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not invoke function sendReport on: " + objectName);
                Tr.debug(tc, "Exception: " + mBeanException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", "209", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception in requestReport " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void requestReport(String string, Boolean bl) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "requestReport");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WebSphere:type=StatusCache,cell=");
            stringBuffer.append(this._cellName);
            stringBuffer.append(",node=");
            stringBuffer.append(string);
            stringBuffer.append(",process=nodeagent");
            stringBuffer.append(",*");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestReport: ObjectName " + stringBuffer.toString());
            }
            ObjectName objectName = super.getMBean(stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequestReport: server " + objectName);
            }
            if (objectName != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invoking on" + objectName.toString());
                    }
                    if (bl.equals(Boolean.TRUE)) {
                        super.invoke(objectName, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
                    } else {
                        super.invoke(objectName, "sendReport", null, null);
                    }
                }
                catch (MBeanException mBeanException) {
                    FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", "247", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not invoke function sendReport on: " + objectName);
                        Tr.debug(tc, "Exception: " + mBeanException);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusCache.requestReport", "253", this);
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Exception in requestReport " + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void requestReport(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport");
        }
        this.requestReport(string, Boolean.FALSE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void registerEvents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvents");
        }
        this.listenForJ2EEStateNotifications();
        this.listenForCacheReportNotifications();
        this.listenForLocalApplicationNotifications();
        this.listenForClusterNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvents");
        }
    }

    public void placeReport(StatusReport statusReport) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "placeReport", new Object[]{statusReport});
        }
        if (statusReport instanceof NodeAgentStatusReport) {
            String string = ((NodeAgentStatusReport)statusReport).getNode();
            String string2 = (String)this.nodeagent_state.get(string);
            if (string2 == null || "j2ee.state.stopped".equals(string2)) {
                boolean bl = RoutingTable.getInstance().isRoutable(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "is the NodeAgent is still routable: " + bl);
                }
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The " + string + " was STOPPED, I recived a report but it wasn't routable, so I'm ignoring it");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "placeReport");
                    }
                    return;
                }
            }
            this.nodeagent_state.put(string, "j2ee.state.running");
            this.node_reports.put(string, statusReport);
            this._sendReport();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "placeReport");
        }
    }

    public void _sendReport(Boolean bl, Boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport - force", new Object[]{bl, bl2});
        }
        if (bl.equals(Boolean.TRUE)) {
            this.refreshClusterCache(true, bl2);
            this.refreshNodeCache(true, bl2);
            this.refreshCache(true, bl2);
            Iterator iterator = this._nodes.iterator();
            while (iterator.hasNext()) {
                this.requestReport((String)iterator.next(), Boolean.TRUE);
            }
        }
        this._sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport - force");
        }
    }

    public void _sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport");
        }
        DeploymentManagerStatusReport deploymentManagerStatusReport = new DeploymentManagerStatusReport(this.nodeagent_state, this.node_reports, this.cluster_state);
        deploymentManagerStatusReport.setCell(this._cellName);
        deploymentManagerStatusReport.setDeployments(this._app_deployments);
        deploymentManagerStatusReport.setClusterInfo(this._cluster_xml);
        deploymentManagerStatusReport.generate();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Src: " + this.getObjectName());
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            Notification notification = new Notification("websphere.status.report", this.getObjectName(), this._notif_num++);
            notification.setUserData(deploymentManagerStatusReport);
            super.sendReportNotification(notification);
        } else {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Going direct");
            }
            StatusCacheFactory.setReport(deploymentManagerStatusReport);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport");
        }
    }

    public String dumpCache() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Deployment Manager: ");
        stringBuffer.append("\n");
        stringBuffer.append("---------------------\n");
        Set set = this._app_state.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append("App: ");
            stringBuffer.append(object.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(object.getValue());
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        object = this.nodeagent_state.entrySet();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            stringBuffer.append("\nNode: ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("\nReport: ");
            stringBuffer.append(this.node_reports.get(entry.getKey()));
            if (this.node_reports.get(entry.getKey()) != null) {
                stringBuffer.append(((StatusReport)this.node_reports.get(entry.getKey())).print());
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        stringBuffer.append("END OF DUMP");
        return stringBuffer.toString();
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notification, object});
        }
        if (object.equals(CONTROL_ADMIN_LISTENER)) {
            boolean bl = false;
            boolean bl2 = false;
            if (notification.getType().equals("websphere.ws390.servant.started")) {
                ServantMBeanStatus servantMBeanStatus = (ServantMBeanStatus)notification.getUserData();
                this._servant_up = true;
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New Servant, refreshing the cache");
                }
                this.addServant(notification);
            } else if (notification.getType().equals("websphere.ws390.servant.terminated") && (bl = (bl2 = this.removeServant(notification))) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Active Servants remain, refreshing the cache");
            }
            if (bl) {
                this.refreshCache(true, bl2);
                this.refreshNodeCache(true, bl2);
                this.refreshClusterCache(true, bl2);
                this.sendReport();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
            return;
        }
        if (object.equals(LOCAL_APP_LISTENER)) {
            ObjectName objectName = (ObjectName)notification.getSource();
            String string = objectName.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application changed is: " + string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification Type: " + notification.getType());
            }
            if (notification.getType().equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string + " is now STOPPED");
                }
                this._app_state.put(string, "j2ee.state.stopped");
            } else if (notification.getType().equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string + " is now STOPPING");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string + " is now STOPPED");
                }
                this._app_state.put(string, "j2ee.state.stopped");
                this.constructManagerReport();
            } else if (notification.getType().equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string + " is now STARTING");
                }
                this._app_state.put(string, "j2ee.state.starting");
            } else if (notification.getType().equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string + " is now RUNNING");
                }
                this._app_state.put(string, "j2ee.state.running");
            } else if (notification.getType().equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + string + " is now FAILED");
                }
                this._app_state.put(string, "j2ee.state.failed");
            }
            this.constructManagerReport();
        } else if (object.equals(NODE_AGENT_LISTENER)) {
            ObjectName objectName = (ObjectName)notification.getSource();
            String string = objectName.getKeyProperty("name");
            String string2 = objectName.getKeyProperty("node");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2);
            }
            if (notification.getType().equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + "is now STOPPING");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + " is now STOPPED");
                }
                this.nodeagent_state.put(string2, "j2ee.state.stopped");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + " is stopped, deleting report");
                }
                this.node_reports.remove(string2);
            } else if (notification.getType().equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + " is now STOPPED");
                }
                this.nodeagent_state.put(string2, "j2ee.state.stopped");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + " is stopped, deleting report");
                }
                this.node_reports.remove(string2);
            } else if (notification.getType().equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + " is now STARTING");
                }
                this.nodeagent_state.put(string2, "j2ee.state.starting");
            } else if (notification.getType().equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + " is now RUNNING");
                }
                this.nodeagent_state.put(string2, "j2ee.state.running");
            } else if (notification.getType().equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgent changed is: " + string + " on " + string2 + " is now FAILED");
                }
                this.nodeagent_state.put(string2, "j2ee.state.failed");
            }
        } else if (object.equals(STATUS_CACHE_LISTENER)) {
            if (notification.getType().equals("websphere.status.report")) {
                ObjectName objectName = (ObjectName)notification.getSource();
                String string = objectName.getKeyProperty("process");
                String string3 = objectName.getKeyProperty("node");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got a Report from node: " + string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got a Report from process: " + string);
                }
                if (string.equals("nodeagent")) {
                    NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)notification.getUserData();
                    String string4 = (String)this.nodeagent_state.get(string3);
                    if (string4 == null || "j2ee.state.stopped".equals(string4)) {
                        boolean bl = RoutingTable.getInstance().isRoutable(string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "is the NodeAgent is still routable: " + bl);
                        }
                        if (!bl) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The " + string3 + " was STOPPED, I recived a report but it wasn't routable, so I'm ignoring it");
                            }
                            return;
                        }
                    }
                    this.nodeagent_state.put(string3, "j2ee.state.running");
                    this.node_reports.put(string3, nodeAgentStatusReport);
                }
            }
        } else if (object.equals(CLUSTER_LISTENER)) {
            ObjectName objectName = (ObjectName)notification.getSource();
            String string = objectName.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster changed is: " + string);
            }
            if (notification.getType().equals("websphere.cluster.partial.start")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + string + " is now TYPE_CLUSTER_PARTIAL_START");
                }
                this.cluster_state.put(string, "websphere.cluster.partial.start");
            } else if (notification.getType().equals("websphere.cluster.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + string + " is now TYPE_CLUSTER_STARTING");
                }
                this.cluster_state.put(string, "websphere.cluster.partial.start");
            } else if (notification.getType().equals("websphere.cluster.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + string + " is now TYPE_CLUSTER_RUNNING");
                }
                this.cluster_state.put(string, "websphere.cluster.running");
            } else if (notification.getType().equals("websphere.cluster.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + string + " is now TYPE_CLUSTER_STOPPING");
                }
                this.cluster_state.put(string, "websphere.cluster.stopping");
            } else if (notification.getType().equals("websphere.cluster.partial.stop")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + string + " is now TYPE_CLUSTER_PARTIAL_STOP");
                }
                this.cluster_state.put(string, "websphere.cluster.partial.stop");
            } else if (notification.getType().equals("websphere.cluster.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster changed is: " + string + " is now TYPE_CLUSTER_STOPPED");
                }
                this.cluster_state.put(string, "websphere.cluster.stopped");
            }
        }
        this.sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void refreshClusterCache(boolean bl, boolean bl2) {
        CharSequence charSequence;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshClusterCache");
        }
        if (this._clusters == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not refreshCache, _clusters was null");
            }
            return;
        }
        Set set = this.cluster_state.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (this._clusters.contains(object)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove Cluster: " + (String)object + " from Cache as it is no longer on the HFS");
            }
            bl = true;
            iterator.remove();
        }
        object = this._clusters.iterator();
        while (object.hasNext()) {
            charSequence = (String)object.next();
            if (set.contains(charSequence)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add Cluster: " + (String)charSequence + " to Cache as it is on the HFS");
            }
            bl = true;
            this.cluster_state.put(charSequence, "j2ee.state.stopped");
        }
        if (bl) {
            charSequence = new StringBuffer("WebSphere:type=Cluster");
            ((StringBuffer)charSequence).append(",process=");
            ((StringBuffer)charSequence).append(this._serverName);
            ((StringBuffer)charSequence).append(",*");
            Set set2 = this.getMBeans(((StringBuffer)charSequence).toString());
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string = null;
                String string2 = null;
                try {
                    Boolean bl3 = new Boolean(bl2);
                    ObjectName objectName = (ObjectName)iterator2.next();
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    string = (String)(adminService instanceof AdminServiceImpl ? ((AdminServiceImpl)adminService).getAttribute(objectName, "clusterName", new Boolean(bl2)) : adminService.getAttribute(objectName, "clusterName"));
                    string2 = (String)(adminService instanceof AdminServiceImpl ? ((AdminServiceImpl)adminService).getAttribute(objectName, "state", new Boolean(bl2)) : adminService.getAttribute(objectName, "state"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding cluster: " + string + " to Cache as it is running " + this.cluster_state);
                    }
                    if (string == null || string2 == null) continue;
                    this.cluster_state.put(string, string2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshClusterCache", "570", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshClusterCache " + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshClusterCache");
        }
    }

    private void refreshNodeCache(boolean bl, boolean bl2) {
        CharSequence charSequence;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshNodeCache");
        }
        Set set = this.nodeagent_state.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (this._nodes.contains(object)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove Node: " + (String)object + " from Cache as it is no longer on the HFS");
            }
            bl = true;
            iterator.remove();
            this.node_reports.remove(object);
        }
        object = this._nodes.iterator();
        while (object.hasNext()) {
            charSequence = (String)object.next();
            if (set.contains(charSequence)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add Node: " + (String)charSequence + " to Cache as it is on the HFS");
            }
            bl = true;
            this.nodeagent_state.put(charSequence, "j2ee.state.stopped");
        }
        if (bl) {
            charSequence = new StringBuffer("WebSphere:type=Server");
            ((StringBuffer)charSequence).append(",process=nodeagent");
            ((StringBuffer)charSequence).append(",*");
            Set set2 = this.getMBeans(((StringBuffer)charSequence).toString());
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string = null;
                try {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    string = (String)(adminService instanceof AdminServiceImpl ? ((AdminServiceImpl)adminService).getAttribute((ObjectName)iterator2.next(), "nodeName", new Boolean(bl2)) : adminService.getAttribute((ObjectName)iterator2.next(), "nodeName"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding node: " + string + " to Cache as it is running");
                    }
                    if (string == null) continue;
                    this.nodeagent_state.put(string, "j2ee.state.running");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshNodeCache", "633", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshNodeCache " + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshCache(boolean bl, boolean bl2) {
        CharSequence charSequence;
        Object object;
        ServerEntry serverEntry;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshCache");
            }
            serverEntry = null;
            try {
                serverEntry = this.findServerEntry();
            }
            catch (Exception exception) {
                if (!bl2 || !bl) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshCache", "652", this);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not find Server Entry", serverEntry);
                }
            }
            finally {
                if (serverEntry != null) break block18;
                return;
            }
        }
        Set set = this._app_state.keySet();
        Set set2 = this.buildAppList(serverEntry);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (set2.contains(object)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove App: " + (String)object + " from Cache as it is no longer in Server Entry");
            }
            bl = true;
            iterator.remove();
        }
        object = set2.iterator();
        while (object.hasNext()) {
            charSequence = (String)object.next();
            if (set.contains(charSequence)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add App: " + (String)charSequence + " to Cache as it is new in Server Entry");
            }
            bl = true;
            this._app_state.put(charSequence, "j2ee.state.stopped");
        }
        if (bl) {
            charSequence = new StringBuffer("WebSphere:type=Application,node=");
            ((StringBuffer)charSequence).append(this._nodeName);
            ((StringBuffer)charSequence).append(",process=");
            ((StringBuffer)charSequence).append(this._serverName);
            ((StringBuffer)charSequence).append(",*");
            Set set3 = this.getMBeans(((StringBuffer)charSequence).toString());
            Iterator iterator2 = set3.iterator();
            while (iterator2.hasNext()) {
                String string = null;
                try {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    string = (String)(adminService instanceof AdminServiceImpl ? ((AdminServiceImpl)adminService).getAttribute((ObjectName)iterator2.next(), "name", new Boolean(bl2)) : adminService.getAttribute((ObjectName)iterator2.next(), "name"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding App: " + string + " to Cache as it is running");
                    }
                    if (string == null) continue;
                    this._app_state.put(string, "j2ee.state.running");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.DeploymentManagerStatusCache.refreshCache", "701", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshCache " + exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    protected void listenForClusterNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForClusterNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Cluster,");
                stringBuffer.append("node=");
                stringBuffer.append(this._nodeName);
                stringBuffer.append(",*");
                ObjectName objectName = new ObjectName(stringBuffer.toString());
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.cluster.partial.start");
                notificationFilterSupport.enableType("websphere.cluster.running");
                notificationFilterSupport.enableType("websphere.cluster.starting");
                notificationFilterSupport.enableType("websphere.cluster.stopping");
                notificationFilterSupport.enableType("websphere.cluster.partial.stop");
                notificationFilterSupport.enableType("websphere.cluster.stopped");
                adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, CLUSTER_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForClusterNotifications", "734", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForClusterNotifications " + jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForClusterNotifications");
        }
    }

    protected void listenForJ2EEStateNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForJ2EEStateNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("j2ee.state.stopping");
                notificationFilterSupport.enableType("j2ee.state.stopped");
                notificationFilterSupport.enableType("j2ee.state.starting");
                notificationFilterSupport.enableType("j2ee.state.running");
                notificationFilterSupport.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, NODE_AGENT_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForJ2EEStateNotifications", "755", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForClusterNotifications " + jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForJ2EEStateNotifications");
        }
    }

    protected void listenForCacheReportNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForCacheReportNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = new ObjectName("WebSphere:*,type=StatusCache,process=nodeagent");
                adminService.addNotificationListenerExtended(objectName, this, null, STATUS_CACHE_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForCacheReportNotifications", "769", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForCacheReportNotifications " + jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForCacheReportNotifications");
        }
    }

    protected void listenForLocalApplicationNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForLocalApplicationNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = adminService.getProcessName();
                StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Application,node=");
                stringBuffer.append(this._nodeName);
                stringBuffer.append(",process=" + string);
                stringBuffer.append(",*");
                ObjectName objectName = new ObjectName(stringBuffer.toString());
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("j2ee.state.stopping");
                notificationFilterSupport.enableType("j2ee.state.stopped");
                notificationFilterSupport.enableType("j2ee.state.starting");
                notificationFilterSupport.enableType("j2ee.state.running");
                notificationFilterSupport.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, LOCAL_APP_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.DeploymentManagerStatusCache.listenForLocalApplicationNotifications", "795", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForLocalApplicationNotifications " + jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForLocalApplicationNotifications");
        }
    }

    protected void listenForMessageListenerNotifications() {
    }

    public void childAdded(ServerInfo serverInfo) {
        this.addToCache(1, serverInfo.getNode(), "j2ee.state.running");
        this.requestReport(serverInfo.getNode());
    }

    public void childRemoved(ServerInfo serverInfo) {
        this.removeFromCache(1, serverInfo.getNode());
        this.sendReport();
    }
}

