/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.component.NodeAgentImpl;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.status.AbstractStatusCache;
import com.ibm.ws.management.status.AppServerStatusReport;
import com.ibm.ws.management.status.NodeAgentStatusReport;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.service.SecurityService;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class NodeAgentStatusCache
extends AbstractStatusCache {
    private static final TraceComponent tc = Tr.register(NodeAgentStatusCache.class, null, null);
    private Map server_state = Collections.synchronizedMap(new HashMap());
    private Map server_reports = Collections.synchronizedMap(new HashMap());
    private AdminClient parent_ac = null;
    private String parentNodeName = null;
    private String parentProcessName = null;
    private ObjectName parentStatusCache = null;
    private StatusReport currentReport = null;
    private SecurityService securityService = null;
    private StatusCacheTimedThread activeThread = null;
    private StatusCacheTimedThread passiveThread = null;

    protected NodeAgentStatusCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NodeAgentStatusCache");
        }
        this.refreshCache(true, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeAgentStatusCache");
        }
    }

    public void requestReport(Boolean bl) {
        Set set;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport - force", new Object[]{bl});
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WebSphere:type=StatusCache,cell=");
        stringBuffer.append(this._cellName);
        stringBuffer.append(",node=");
        stringBuffer.append(this._nodeName);
        stringBuffer.append(",*");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RequestReport: ObjectName " + stringBuffer.toString());
        }
        if ((set = super.getMBeans(stringBuffer.toString())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get mbeans for All Servers");
            }
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            if (objectName == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not get mbeans for Server: " + objectName);
                }
                return;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking on: " + set.toString());
                }
                if (bl.equals(Boolean.TRUE)) {
                    super.invoke(objectName, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
                    continue;
                }
                super.invoke(objectName, "sendReport", null, null);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", "119", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not invoke function sendReport on: " + objectName);
                Tr.debug(tc, "Exception: " + mBeanException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", "126", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception in requestReport " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport - force");
        }
    }

    public void requestReport(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport");
        }
        this.requestReport(string, Boolean.FALSE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void requestReport(String string, Boolean bl) {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport - force", new Object[]{bl});
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WebSphere:type=StatusCache,cell=");
        stringBuffer.append(this._cellName);
        stringBuffer.append(",node=");
        stringBuffer.append(this._nodeName);
        stringBuffer.append(",process=");
        stringBuffer.append(string);
        stringBuffer.append(",*");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RequestReport: ObjectName " + stringBuffer.toString());
        }
        if ((objectName = super.getMBean(stringBuffer.toString())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get mbean for Server: " + string);
            }
            return;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking on: " + objectName.toString());
            }
            if (bl.equals(Boolean.TRUE)) {
                super.invoke(objectName, "sendReport", new Object[]{Boolean.TRUE}, new String[]{"java.lang.Boolean"});
            } else {
                super.invoke(objectName, "sendReport", null, null);
            }
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", "179", this);
            Tr.debug(tc, "Could not invoke function sendReport on: " + objectName);
            Tr.debug(tc, "Exception: " + mBeanException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.NodeAgentStatusCache.requestReport", "183", this);
            Tr.debug(tc, "Exception in reqestReprot: " + exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport - foce");
        }
    }

    public void _sendReport(Boolean bl, Boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport - force", new Object[]{bl, bl2});
        }
        if (bl.equals(Boolean.TRUE)) {
            this.refreshCache(true, false);
        }
        this._sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport");
        }
        Map map = this.generateServerTypes();
        NodeAgentStatusReport nodeAgentStatusReport = new NodeAgentStatusReport(this.server_state, this.server_reports, map);
        nodeAgentStatusReport.setCell(this._cellName);
        nodeAgentStatusReport.setNode(this._nodeName);
        nodeAgentStatusReport.setServer(this._serverName);
        nodeAgentStatusReport.setDeployments(this._app_deployments);
        this.server_state.put(this._serverName, "j2ee.state.running");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Local ObjectName: " + this.getObjectName());
        }
        if (this.getObjectName() == null) {
            return;
        }
        this.currentReport = nodeAgentStatusReport;
        if (this.passiveThread != null) {
            StatusCacheTimedThread statusCacheTimedThread = this.passiveThread;
            synchronized (statusCacheTimedThread) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending Immediately");
                }
                this.passiveThread.interrupt();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport");
        }
    }

    public String dumpCache() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Node: ");
        stringBuffer.append(this._nodeName);
        stringBuffer.append("\n");
        stringBuffer.append("---------------------\n");
        Set set = this.server_state.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("Server: ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("\nReport: ");
            stringBuffer.append(this.server_reports.get(entry.getKey()));
            if (this.server_reports.get(entry.getKey()) != null) {
                stringBuffer.append(((StatusReport)this.server_reports.get(entry.getKey())).print());
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        stringBuffer.append("END OF DUMP");
        return stringBuffer.toString();
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notification, object});
        }
        if (object.equals(STATUS_CACHE_LISTENER)) {
            if (notification.getType().equals("websphere.status.report")) {
                ObjectName objectName = (ObjectName)notification.getSource();
                String string = objectName.getKeyProperty("process");
                if (string.equals("nodeagent")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Received a report from : " + string + "  Ignoring");
                    }
                    this.server_state.put(string, "j2ee.state.running");
                    return;
                }
                AppServerStatusReport appServerStatusReport = (AppServerStatusReport)notification.getUserData();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received a report from : " + string + "  Report: " + appServerStatusReport);
                }
                this.server_state.put(string, "j2ee.state.running");
                this.server_reports.put(string, appServerStatusReport);
                this.sendReport();
                return;
            }
        } else if (object.equals(SERVER_LISTENER)) {
            ObjectName objectName = (ObjectName)notification.getSource();
            String string = objectName.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server changed is: " + string);
            }
            if (notification.getType().equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + string + " is now STOPPING");
                }
                this.server_state.put(string, "j2ee.state.stopping");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server is stopped, deleting report");
                }
                this.server_reports.remove(string);
            } else if (notification.getType().equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + string + " is now STARTING");
                }
                this.server_state.put(string, "j2ee.state.stopped");
            } else if (notification.getType().equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + string + " is now STARTING");
                }
                this.server_state.put(string, "j2ee.state.starting");
            } else if (notification.getType().equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + string + " is now RUNNING");
                }
                this.server_state.put(string, "j2ee.state.running");
            } else if (notification.getType().equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server: " + string + " is now FAILED");
                }
                this.server_state.put(string, "j2ee.state.failed");
            }
            this.sendReport();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache(boolean bl, boolean bl2) {
        CharSequence charSequence;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshCache");
        }
        if (this._servers == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not refreshCache, _servers was null");
            }
            return;
        }
        Set set = this.server_state.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (this._servers.contains(object)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove Server: " + (String)object + " from Cache as it is no longer on the HFS");
            }
            bl = true;
            iterator.remove();
        }
        object = this._servers.iterator();
        while (object.hasNext()) {
            charSequence = (String)object.next();
            if (set.contains(charSequence)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add Server: " + (String)charSequence + " to Cache as it is new on the HFS");
            }
            bl = true;
            this.server_state.put(charSequence, "j2ee.state.stopped");
        }
        if (bl) {
            charSequence = new StringBuffer("WebSphere:type=Server,node=");
            ((StringBuffer)charSequence).append(this._nodeName);
            ((StringBuffer)charSequence).append(",*");
            Set set2 = this.getMBeans(((StringBuffer)charSequence).toString());
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                String string = null;
                String string2 = null;
                try {
                    Subject subject = null;
                    Subject subject2 = null;
                    subject2 = SecurityHelper.getOwnedSubject();
                    try {
                        if (subject2 != null) {
                            subject = SecurityHelper.pushInvocationSubject(subject2);
                        }
                        ObjectName objectName = (ObjectName)iterator2.next();
                        string = objectName.getKeyProperty("process");
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        string2 = (String)(adminService instanceof AdminServiceImpl ? ((AdminServiceImpl)adminService).getAttribute(objectName, "state", new Boolean(bl2)) : adminService.getAttribute(objectName, "state"));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.NodeAgentStatusCache.refreshCache", "385", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception getting mbean attributes", exception);
                        }
                    }
                    finally {
                        if (subject2 != null) {
                            SecurityHelper.popInvocationSubject(subject);
                        }
                    }
                    if (string2 == null) continue;
                    if (string2.equals("STARTED")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding Server: " + string + " to Cache as it is: " + string2);
                        }
                        this.server_state.put(string, "j2ee.state.running");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Server: " + string + " to Cache as it is: " + string2);
                    }
                    this.server_state.put(string, "j2ee.state.stopped");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.NodeAgentStatusCache.refreshCache", "400", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in refreshCache ", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    public void addToCache(int n, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToCache", new Object[]{string, string2});
        }
        if (n == 0) {
            this.server_state.put(string, string2);
            this.requestReport(string);
            this.sendReport(new Boolean(false), new Boolean(false));
        } else if (n == 2) {
            this.refreshCache(true, false);
            this.requestReport(Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToCache");
        }
    }

    public synchronized void removeFromCache(int n, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServer", new Object[]{string});
        }
        if (n == 0) {
            this.server_state.put(string, "j2ee.state.stopped");
            this.server_reports.remove(string);
            this.sendReport(new Boolean(true), new Boolean(false));
        } else if (n == 2) {
            this.refreshCache(true, false);
            this.requestReport(Boolean.TRUE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServer");
        }
    }

    protected void listenForMessageListenerNotifications() {
    }

    protected void listenForLocalApplicationNotifications() {
    }

    protected void listenForJ2EEStateNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForJ2EEStateNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = new ObjectName("WebSphere:*,type=Server,processType=ManagedProcess");
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("j2ee.state.stopping");
                notificationFilterSupport.enableType("j2ee.state.stopped");
                notificationFilterSupport.enableType("j2ee.state.starting");
                notificationFilterSupport.enableType("j2ee.state.running");
                notificationFilterSupport.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, SERVER_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.NodeAgentStatusCache.listenForJ2EEStateNotifications", "470", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForJ2EEStateNotifications ", jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForJ2EEStateNotifications");
        }
    }

    protected void listenForCacheReportNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForCacheReportNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = new ObjectName("WebSphere:*,type=StatusCache,node=" + this._nodeName);
                adminService.addNotificationListenerExtended(objectName, this, null, STATUS_CACHE_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.NodeAgentStatusCache.listenForCacheReportNotifications", "485", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "JMX Exception in listenForCacheReportNotifications ", jMException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForCacheReportNotifications");
        }
    }

    public void registerEvents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvents");
        }
        this.listenForJ2EEStateNotifications();
        this.listenForCacheReportNotifications();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvents");
        }
    }

    public void childAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childAdded");
        }
        this.addToCache(0, serverInfo.getName(), "j2ee.state.running");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childAdded");
        }
    }

    public void childRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childRemoved");
        }
        this.removeFromCache(0, serverInfo.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRemoved");
        }
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentAdded");
        }
        long l = Long.getLong("com.ibm.websphere.status.cache.maxActiveSleepInterval", Long.parseLong("1200000"));
        long l2 = Long.getLong("com.ibm.websphere.status.cache.maxPassiveSleepTime", Long.parseLong("20000"));
        this.activeThread = new StatusCacheTimedThread(this, l, true);
        this.activeThread.setDaemon(true);
        this.activeThread.start();
        this.passiveThread = new StatusCacheTimedThread(this, l2, false);
        this.passiveThread.setDaemon(true);
        this.passiveThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentAdded");
        }
    }

    public void parentRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRemoved");
        }
        if (this.activeThread != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shutting down active thread");
            }
            this.activeThread.shutdown();
            this.activeThread = null;
        }
        if (this.passiveThread != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shutting down passive thread");
            }
            this.passiveThread.shutdown();
            this.passiveThread = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentRemoved");
        }
    }

    class StatusCacheTimedThread
    extends Thread {
        boolean sendData;
        StatusReport lastReport;
        NodeAgentStatusCache cache;
        long sleep;
        boolean active;

        public StatusCacheTimedThread(NodeAgentStatusCache nodeAgentStatusCache2, long l, boolean bl) {
            super("StatusCacheTimedThread:" + bl);
            this.sendData = true;
            this.lastReport = null;
            this.cache = null;
            this.sleep = 120000L;
            this.active = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating StatusCacheTimedThread");
            }
            this.cache = nodeAgentStatusCache2;
            this.sleep = l;
            this.active = bl;
        }

        public void shutdown() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StatusCacheTimedThread shutdown");
            }
            this.sendData = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatusCacheTimedThread shutdown");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StatusCacheTimedThread run");
            }
            while (this.sendData) {
                Serializable serializable;
                try {
                    Thread.sleep(this.sleep);
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = this.sendData = this.sendData && !this.active;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Active: " + this.active);
                }
                if (this.active) {
                    serializable = null;
                    Subject subject = null;
                    subject = SecurityHelper.getOwnedSubject();
                    NodeAgentImpl nodeAgentImpl = new NodeAgentImpl();
                    SecurityHelper securityHelper = SecurityHelper.getHelper();
                    if (securityHelper != null) {
                        NodeAgentStatusCache.this.securityService = nodeAgentImpl.registerSecurityService();
                        if (NodeAgentStatusCache.this.securityService != null) {
                            securityHelper.setSecurityService(NodeAgentStatusCache.this.securityService);
                            NodeAgentStatusCache.this.securityService.addListener(securityHelper);
                        }
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Parent AdminClient: " + NodeAgentStatusCache.this.parent_ac);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ownSubject ", subject);
                        }
                        if (subject != null) {
                            serializable = SecurityHelper.pushInvocationSubject(subject);
                        }
                        if (NodeAgentStatusCache.this.parent_ac == null) {
                            NodeAgentStatusCache.this.parent_ac = RoutingTable.getInstance().getParent();
                            if (NodeAgentStatusCache.this.parentStatusCache == null) {
                                ObjectName objectName = NodeAgentStatusCache.this.parent_ac.getServerMBean();
                                NodeAgentStatusCache.this.parentNodeName = objectName.getKeyProperty("node");
                                NodeAgentStatusCache.this.parentProcessName = objectName.getKeyProperty("process");
                                ObjectName objectName2 = new ObjectName("WebSphere:*,type=StatusCache,node=" + NodeAgentStatusCache.this.parentNodeName + ",process=" + NodeAgentStatusCache.this.parentProcessName);
                                Set set = NodeAgentStatusCache.this.parent_ac.queryNames(objectName2, null);
                                NodeAgentStatusCache.this.parentStatusCache = (ObjectName)set.iterator().next();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Parent StatusCache: " + NodeAgentStatusCache.this.parentStatusCache);
                                }
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AdminClient / StatusCache ", new Object[]{NodeAgentStatusCache.this.parent_ac, NodeAgentStatusCache.this.parentStatusCache});
                        }
                        if (securityHelper.isSecurityServiceStarted() && !securityHelper.isSecurityServiceStopped() && NodeAgentStatusCache.this.parent_ac != null && NodeAgentStatusCache.this.parentStatusCache != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Invoking placeReport: " + NodeAgentStatusCache.this.parentStatusCache);
                            }
                            this.lastReport = NodeAgentStatusCache.this.currentReport;
                            NodeAgentStatusCache.this.parent_ac.invoke(NodeAgentStatusCache.this.parentStatusCache, "placeReport", new Object[]{NodeAgentStatusCache.this.currentReport}, new String[]{"com.ibm.ws.management.status.StatusReport"});
                        }
                        if (subject == null) continue;
                    }
                    catch (Exception exception) {
                        try {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.NodeAgentStatusCache$StatusCacheTimedThread.run", "1371", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception in AbstractStatusCache:" + exception);
                            }
                            if (subject == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (subject != null) {
                                SecurityHelper.popInvocationSubject(serializable);
                            }
                            throw throwable;
                        }
                        SecurityHelper.popInvocationSubject((Subject)serializable);
                        continue;
                    }
                    SecurityHelper.popInvocationSubject((Subject)serializable);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Last / Current ", new Object[]{this.lastReport, NodeAgentStatusCache.this.currentReport});
                }
                if (this.lastReport == NodeAgentStatusCache.this.currentReport) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending Notification");
                }
                this.lastReport = NodeAgentStatusCache.this.currentReport;
                serializable = new Notification("websphere.status.report", NodeAgentStatusCache.this.getObjectName(), NodeAgentStatusCache.this._notif_num++);
                ((Notification)serializable).setUserData(NodeAgentStatusCache.this.currentReport);
                this.cache.sendReportNotification((Notification)serializable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatusCacheTimedThread run");
            }
        }
    }
}

