/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class StatusCacheClient
implements NotificationListener {
    private static final TraceComponent tc = Tr.register(StatusCacheClient.class, null, null);
    private String mbean;
    private StatusCacheClient client = null;
    private StatusReport currentReport = null;
    private static final Integer STATUS_CACHE_LISTENER = new Integer(0);

    protected StatusCacheClient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StatusCacheClient");
        }
        String string = AdminServiceFactory.getAdminService().getNodeName();
        String string2 = AdminServiceFactory.getAdminService().getProcessName();
        this.mbean = "WebSphere:*,type=StatusCache,node=" + string + ",process=" + string2;
        this.listenForCacheReportNotifications(this.mbean);
        this.requestReport(this.mbean);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StatusCacheClient");
        }
    }

    protected synchronized void setReport(StatusReport statusReport) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setReport", statusReport);
        }
        this.currentReport = statusReport;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setReport");
        }
    }

    public StatusReport getReport() {
        if (this.currentReport == null) {
            this.requestReport(this.mbean);
        }
        return this.currentReport;
    }

    public void requestReport(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RequestReport: ObjectName " + string);
        }
        ObjectName objectName = this.getMBean(string.toString());
        try {
            if (objectName == null) {
                Tr.debug(tc, "Could not request Status Cache report");
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking on" + objectName.toString());
            }
            this.invoke(objectName, "sendReport", null, null);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.status.StatusCacheClient.requestReport", "135", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not invoke function sendReport on: " + objectName);
                Tr.debug(tc, "Exception in requestReport", mBeanException);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.StatusCacheClient.requestReport", "142", this);
            Tr.debug(tc, "Exception in requestReport", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notification, object});
        }
        if (object.equals(STATUS_CACHE_LISTENER) && notification.getType().equals("websphere.status.report")) {
            ObjectName objectName = (ObjectName)notification.getSource();
            String string = objectName.getKeyProperty("process");
            String string2 = objectName.getKeyProperty("node");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received a report from: " + string + " on node " + string2);
            }
            StatusReport statusReport = (StatusReport)notification.getUserData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Report: " + statusReport);
            }
            if (statusReport != null) {
                this.currentReport = statusReport;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting new report: " + this.currentReport);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification", new Object[]{this.currentReport});
        }
    }

    private void listenForCacheReportNotifications(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForCacheReportNotifications");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = new ObjectName(string);
            adminService.addNotificationListenerExtended(objectName, this, null, STATUS_CACHE_LISTENER);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.status.StatusCacheClient.listenForCacheReportNotifications", "191", this);
            Tr.debug(tc, "JMX Exception in listenForCacheReportNotifications", jMException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForCacheReportNotifications");
        }
    }

    private ObjectName getMBean(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean", new Object[]{string});
        }
        try {
            ObjectName objectName = new ObjectName(string);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                if (iterator.hasNext()) {
                    Tr.debug(tc, "Multiple MBeans found when only one was expected");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean", new Object[]{objectName2});
                }
                return objectName2;
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.status.StatusCacheClient.getMBean", "217", this);
            Tr.error(tc, "Invalid MBean filter passed to getMBean: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws MBeanException {
        Subject subject = null;
        Subject subject2 = null;
        subject2 = SecurityHelper.getOwnedSubject();
        try {
            if (subject2 != null) {
                subject = SecurityHelper.pushInvocationSubject(subject2);
            }
            if (objectName == null) {
                Tr.error(tc, "Can not perform operation {0} on a null object name", string);
                Object var7_7 = null;
                return var7_7;
            }
            Object object = AdminServiceFactory.getAdminService().invoke(objectName, string, objectArray, stringArray);
            return object;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.status.StatusCacheClient.invoke", "280", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in StatusCacheClient:" + exception);
            }
        }
        finally {
            if (subject2 != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
        }
        return null;
    }
}

