/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.sync.EpochFileHelper;
import com.ibm.ws.management.sync.FolderCompareTask;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncTask;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.management.transform.TransformCacheInvalidator;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;

public class CellSync
extends RuntimeCollaborator
implements ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register(CellSync.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static CellSync cellSync = new CellSync();
    HashMap nameMap = null;
    private ConfigRepository repository = null;
    String cellName = null;
    HashMap epochs = null;
    private Set distributionDisabledApps = null;
    protected static final String HOT_RESTART_SYNC = "hotRestartSync";
    private boolean hotRestartSync = false;
    private String epochDir = null;
    private final String FOLDER_EPOCH_FILE_NAME = "cellFolderLevel.epoch";

    protected void addDisabledApp(String string) {
        this.distributionDisabledApps.add(string);
    }

    protected void removeDisabledApp(String string) {
        this.distributionDisabledApps.remove(string);
    }

    protected boolean isDisabledApp(String string) {
        return this.distributionDisabledApps.contains(string);
    }

    protected int disabledAppsCount() {
        int n = 0;
        if (this.distributionDisabledApps != null) {
            n = this.distributionDisabledApps.size();
        }
        return n;
    }

    private CellSync() {
    }

    public static CellSync getCellSync() {
        return cellSync;
    }

    public void initialize(VariableMap variableMap) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.distributionDisabledApps = new HashSet();
        try {
            AdminServiceFactory.getMBeanFactory().activateMBean("CellSync", this, "cellSync", null);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.sync.CellSync.initialize", "91", this);
            Tr.error(tc, "ADMS0100E", adminException);
            throw adminException;
        }
        this.repository = ConfigRepositoryFactory.getConfigRepository();
        if (this.repository == null) {
            Tr.error(tc, "ADMS0101E");
            throw new AdminException("Unable to get the configuration repository");
        }
        this.repository.addListener(this);
        this.cellName = AdminServiceFactory.getAdminService().getCellName();
        this.epochs = new HashMap();
        String string = System.getProperty(HOT_RESTART_SYNC);
        if (string != null && string.equalsIgnoreCase("true")) {
            this.hotRestartSync = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hot restart sync is enabled for cell sync, transform cache in a mixed cell will also be saved.");
            }
            this.loadFolderEpochFromFile();
        }
        this.nameMap = new HashMap();
        TransformCacheInvalidator.initialize(this.repository, this.hotRestartSync);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Boolean syncNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "syncNode");
        }
        boolean bl = false;
        ObjectName objectName = this.getObjectName(string);
        if (objectName != null) {
            AdminHelper.getInstance().audit("ADMN1006I", "ADMN1007I", new Object[]{string, null});
            bl = this.invokeRequestSync(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "syncNode", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private ObjectName getObjectName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", string);
        }
        ObjectName objectName = null;
        try {
            String string2 = "WebSphere:type=NodeSync,node=" + string + ",process=nodeagent,*";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "query string is " + string2);
            }
            ObjectName objectName2 = new ObjectName(string2);
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName2, null);
            if (set.size() != 0) {
                if (set.size() > 1) {
                    Tr.service(tc, "ADMS0109I", new Object[]{new Integer(set.size()), string});
                }
                Object[] objectArray = set.toArray();
                objectName = (ObjectName)objectArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Object name is " + objectName.getCanonicalName());
                }
            } else {
                Tr.service(tc, "ADMS0111I", string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.CellSync.getObjectName", "173", this);
            Tr.service(tc, "ADMS0107E", new Object[]{string, exception});
            objectName = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName");
        }
        return objectName;
    }

    private boolean invokeRequestSync(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeRequestSync");
        }
        boolean bl = false;
        try {
            Object object = AdminServiceFactory.getAdminService().invoke(objectName, "requestSync", null, null);
            bl = (Boolean)object;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.CellSync.invokeRequestSync", "360", this);
            Tr.error(tc, "ADMS0104I", new Object[]{objectName, exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeRequestSync", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    protected String getCellName() {
        return this.cellName;
    }

    public ConfigChangeNotifier[] getModifiedFolders(String string, HashMap hashMap, Properties properties) throws AdminException {
        FolderCompareTask folderCompareTask = new FolderCompareTask();
        folderCompareTask.setNodeName(string);
        folderCompareTask.setCellName(this.getCellName());
        folderCompareTask.setNodeEpochTable(hashMap);
        folderCompareTask.setCellEpochTable(this.epochs);
        folderCompareTask.setRepository(this.repository);
        folderCompareTask.setProperties(properties);
        folderCompareTask.execute();
        ArrayList arrayList = folderCompareTask.getResults();
        ConfigChangeNotifier[] configChangeNotifierArray = new ConfigChangeNotifier[arrayList.size()];
        arrayList.toArray(configChangeNotifierArray);
        return configChangeNotifierArray;
    }

    public ConfigChangeNotifier[] getModifiedFolders(String string, HashMap hashMap) throws AdminException {
        return this.getModifiedFolders(string, hashMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderSyncUpdate[] getFolderSyncUpdates(String string, List list, FolderSyncRequest[] folderSyncRequestArray, Properties properties) throws AdminException {
        FolderSyncTask folderSyncTask = new FolderSyncTask();
        folderSyncTask.setNodeName(string);
        folderSyncTask.setCellName(this.getCellName());
        folderSyncTask.setExclusionList(list);
        folderSyncTask.setRepository(this.repository);
        folderSyncTask.setProperties(properties);
        FolderSyncUpdate[] folderSyncUpdateArray = new FolderSyncUpdate[folderSyncRequestArray.length];
        for (int i = 0; i < folderSyncRequestArray.length; ++i) {
            ConfigEpoch configEpoch = null;
            Cloneable cloneable = this.epochs;
            synchronized (cloneable) {
                configEpoch = (ConfigEpoch)this.epochs.get(folderSyncRequestArray[i].getFolderUri());
                if (configEpoch == null) {
                    configEpoch = new ConfigEpoch();
                    this.epochs.put(folderSyncRequestArray[i].getFolderUri(), configEpoch);
                }
            }
            folderSyncTask.setRequest(folderSyncRequestArray[i]);
            folderSyncTask.execute();
            cloneable = folderSyncTask.getResults();
            SyncElement[] syncElementArray = new SyncElement[((ArrayList)cloneable).size()];
            ((ArrayList)cloneable).toArray(syncElementArray);
            folderSyncUpdateArray[i] = new FolderSyncUpdate(folderSyncRequestArray[i].getFolderUri(), configEpoch, syncElementArray);
        }
        return folderSyncUpdateArray;
    }

    public FolderSyncUpdate[] getFolderSyncUpdates(String string, List list, FolderSyncRequest[] folderSyncRequestArray) throws AdminException {
        return this.getFolderSyncUpdates(string, list, folderSyncRequestArray, null);
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRepositoryEpochRefresh() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Repository epoch was refreshed so clear the folder epochs");
        }
        HashMap hashMap = this.epochs;
        synchronized (hashMap) {
            this.epochs.clear();
        }
        TransformCacheInvalidator.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            String string = configChangeNotifierArray[i].getUri().substring(0, configChangeNotifierArray[i].getUri().lastIndexOf("/"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Document " + configChangeNotifierArray[i].getUri() + " was updated.  Updating epoch for folder " + string);
            }
            HashMap hashMap = this.epochs;
            synchronized (hashMap) {
                this.epochs.put(string, new ConfigEpoch());
                TransformCacheInvalidator.invalidate(configChangeNotifierArray[i].getUri());
                continue;
            }
        }
    }

    private void loadFolderEpochFromFile() {
        String string;
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadFolderEpochFromFile");
        }
        if (!(vector = EpochFileHelper.loadEpochFromFile(string = this.getEpochFileDir() + "cellFolderLevel.epoch")).isEmpty()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if ((string2 = string2.trim()).length() <= 0) continue;
                int n = string2.indexOf(61);
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                this.epochs.put(string3, new ConfigEpoch(string4));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Loading from file into epochs: folder = " + string3 + " epoch = " + string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadFolderEpochFromFile");
        }
    }

    public void persistFolderLevelEpochs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistFolderLevelEpochs:");
        }
        String string = this.getEpochFileDir() + "cellFolderLevel.epoch";
        Vector<String> vector = new Vector<String>();
        if (this.epochs != null) {
            Iterator iterator = this.epochs.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                String string2 = this.epochs.get(k).toString();
                vector.add(k.toString() + "=" + string2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Create epoch entry: " + k.toString() + "= " + string2);
            }
        }
        EpochFileHelper.persistEpochData(string, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistFolderLevelEpochs");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this.hotRestartSync) {
            this.persistFolderLevelEpochs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public String getEpochFileDir() {
        String string;
        if (this.epochDir == null && (string = System.getProperty("user.install.root")) != null && !string.equals("")) {
            String string2 = AdminServiceFactory.getAdminService().getProcessName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminServiceFactory.getAdminService().getProcessName() = " + string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "System property user.intsall.root = " + string);
            }
            this.epochDir = string + File.separator + "logs" + File.separator + string2 + File.separator;
        }
        return this.epochDir;
    }
}

