/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class EpochFileHelper {
    private static TraceComponent tc = Tr.register(EpochFileHelper.class, "Sync", "com.ibm.ws.management.resources.sync");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector loadEpochFromFile(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadEpochFromFile");
        }
        BufferedReader bufferedReader = null;
        Vector<String> vector = new Vector<String>();
        try {
            File file = new File(string);
            if (file.exists()) {
                String string2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading epoch from file = " + file.getName());
                }
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    vector.add(string2);
                }
                if (vector.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No epoch found in file:  " + string);
                    }
                    file.delete();
                    Vector<String> vector2 = vector;
                    return vector2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "epoch found in file.");
                }
                file.delete();
                Vector<String> vector3 = vector;
                return vector3;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "File " + string + " does not exist, returning null for epoch");
            }
            Vector<String> vector4 = vector;
            return vector4;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.management.sync.EpochFileHelper.loadEpochFromFile", "516");
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.management.sync.EpochFileHelper.loadEpochFromFile", "523");
            }
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistEpochData(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistEpochData");
        }
        BufferedWriter bufferedWriter = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "epoch file created: " + string);
                }
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write((String)enumeration.nextElement());
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception thrown writing to epoch file:" + iOException);
            }
            FFDCFilter.processException(iOException, "com.ibm.ws.management.sync.EpochFileHelper.persistEpochData", "640");
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.management.sync.EpochFileHelper.persistEpochData", "652");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistEpochData");
        }
    }
}

