/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.sync.CellSync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class FolderCompareTask {
    private static TraceComponent tc = Tr.register(FolderCompareTask.class, "Sync", "com.ibm.ws.management.resources.sync");
    protected String nodeName;
    protected String cellName;
    protected HashMap nodeEpochTable;
    protected HashMap cellEpochTable;
    protected ArrayList results = new ArrayList();
    protected ConfigRepository repository;
    protected Properties taskProps;
    private boolean recoveryNode = false;
    protected String cellPath;
    protected String myNodePath;
    protected String nodesPath;
    protected String applicationsPath;
    protected ArrayList appDeps;
    protected Set appBins;
    static final String DIR_NODES = "/nodes";
    static final String DIR_APPLICATIONS = "/applications";
    static final String DIR_DEPLOYMENTS = "/deployments";
    static final String DIR_DELTAS = "/deltas";
    public static final String SKIP_WEBSERVER_SYSTEM_PROPERTY = "com.ibm.websphere.management.nodesync.skipWebServerTarget";

    public HashMap getCellEpochTable() {
        return this.cellEpochTable;
    }

    public ArrayList getResults() {
        return this.results;
    }

    public void setCellEpochTable(HashMap hashMap) {
        this.cellEpochTable = hashMap;
    }

    public void setNodeEpochTable(HashMap hashMap) {
        this.nodeEpochTable = hashMap;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public void setProperties(Properties properties) {
        String string;
        this.taskProps = properties;
        if (this.taskProps != null && (string = this.taskProps.getProperty("recoveryNode")) != null && !string.equals("")) {
            this.recoveryNode = Boolean.valueOf(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFolder(String string) {
        Object object;
        Object object2;
        boolean bl = false;
        if (!this.recoveryNode && string.indexOf("/applications/") != -1) {
            object2 = string.substring(0, string.lastIndexOf(47));
            boolean bl2 = bl = object2.endsWith(DIR_APPLICATIONS) && !this.appBins.contains(string);
            if (bl && ((String)(object = object2.substring(object2.indexOf(DIR_APPLICATIONS) + DIR_APPLICATIONS.length()))).endsWith(DIR_APPLICATIONS)) {
                bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "don't skip this \"/applications\" directory for nodesync: " + (String)object2);
                }
            }
        } else if (string.startsWith("templates") || string.startsWith("xforms") || string.startsWith("xformed") || string.startsWith(".repository")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "filtering out :" + string);
            }
            bl = true;
        }
        if (!bl) {
            object2 = this.cellEpochTable;
            synchronized (object2) {
                if (!this.cellEpochTable.containsKey(string)) {
                    this.cellEpochTable.put(string, new ConfigEpoch());
                }
            }
            if (this.nodeEpochTable.containsKey(string)) {
                object2 = (ConfigEpoch)this.cellEpochTable.get(string);
                if (!object2.equals(object = (ConfigEpoch)this.nodeEpochTable.get(string))) {
                    this.results.add(new ConfigChangeNotifier(string, 2));
                }
                this.nodeEpochTable.remove(string);
            } else {
                this.results.add(new ConfigChangeNotifier(string, 0));
            }
            object2 = this.repository.listResourceNames(string, 2, 1);
            object2 = this.sortFolders(string, (String[])object2);
            object2 = this.limitFoldersToNode(string, (String[])object2);
            for (int i = 0; i < ((String[])object2).length; ++i) {
                this.processFolder(object2[i]);
            }
        }
    }

    public void setRepository(ConfigRepository configRepository) {
        this.repository = configRepository;
    }

    protected void setupMetadata() throws AdminException {
        this.cellPath = "cells/" + this.cellName;
        this.nodesPath = this.cellPath + DIR_NODES;
        this.myNodePath = this.nodesPath + "/" + this.nodeName;
        this.applicationsPath = this.cellPath + DIR_APPLICATIONS;
        this.updateNodeAppList();
    }

    protected void updateNodeAppList() throws AdminException {
        this.getApps();
        this.getDistribApps();
    }

    protected String[] sortFolders(String string, String[] stringArray) {
        if (string.equals(this.cellPath)) {
            int n;
            String[] stringArray2 = new String[stringArray.length];
            int n2 = -1;
            int n3 = -1;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].endsWith(DIR_NODES)) {
                    n2 = n;
                    continue;
                }
                if (!stringArray[n].endsWith(DIR_APPLICATIONS)) continue;
                n3 = n;
            }
            if (n3 == -1 && n2 == -1) {
                return stringArray;
            }
            n = 0;
            if (n3 != -1) {
                stringArray2[n] = stringArray[n3];
                ++n;
            }
            if (n2 != -1) {
                stringArray2[n] = stringArray[n2];
                ++n;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == n2 || i == n3) continue;
                stringArray2[n] = stringArray[i];
                ++n;
            }
            return stringArray2;
        }
        return stringArray;
    }

    protected String[] limitFoldersToNode(String string, String[] stringArray) {
        if (this.recoveryNode) {
            return stringArray;
        }
        if (this.otherNodeSubfolder(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found different node's subdir: ", string);
            }
            return new String[0];
        }
        if (string.endsWith(DIR_DEPLOYMENTS)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.appDeps.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            return stringArray2;
        }
        if (string.endsWith(DIR_DELTAS)) {
            return this.filterDeltas(string, stringArray);
        }
        return stringArray;
    }

    private boolean otherNodeSubfolder(String string) {
        boolean bl = false;
        if (string.startsWith(this.nodesPath)) {
            String string2 = string.substring(this.nodesPath.length());
            if (string2.length() > 0) {
                string2 = string2.substring(1);
            }
            if (!string2.startsWith(this.nodeName + "/") && string2.indexOf(47) > 0) {
                bl = true;
            }
        }
        return bl;
    }

    private String[] filterDeltas(String string, String[] stringArray) {
        String string2 = string.substring(0, string.length() - DIR_DELTAS.length());
        String[] stringArray2 = this.appBins.contains(string2) ? stringArray : new String[]{};
        return stringArray2;
    }

    public void execute() throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Beginning FolderCompareTask for node ", this.nodeName);
        }
        this.setupMetadata();
        this.processFolder("/");
        Iterator iterator = this.nodeEpochTable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.startsWith(".repository") || string.startsWith("templates")) continue;
            this.results.add(new ConfigChangeNotifier(string, 1));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Folder compare result: ", this.results);
        }
    }

    public void setCellName(String string) {
        this.cellName = string;
    }

    private AdminException getAdminException(Throwable throwable) {
        AdminException adminException = throwable instanceof AdminException ? (AdminException)throwable : new AdminException(throwable);
        return adminException;
    }

    /*
     * Loose catch block
     */
    private List getApps() throws AdminException {
        block20: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "getApps", this.nodeName);
            }
            String string = this.myNodePath + "/serverindex.xml";
            ServerIndex serverIndex = null;
            Resource resource = null;
            this.appDeps = new ArrayList();
            WASResourceSetImpl wASResourceSetImpl = null;
            DocumentContentSource documentContentSource = null;
            documentContentSource = this.repository.extract(string);
            wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
            resource = wASResourceSetImpl.createResource(uRI);
            if (resource == null) {
                throw new AdminException("Unable to create resource: " + string);
            }
            resource.load(documentContentSource.getSource(), new HashMap());
            serverIndex = (ServerIndex)resource.getContents().get(0);
            boolean bl = Boolean.getBoolean(SKIP_WEBSERVER_SYSTEM_PROPERTY);
            if (serverIndex != null) {
                EList eList = serverIndex.getServerEntries();
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    if (serverEntry.getServerType().equals("WEB_SERVER") && bl) continue;
                    EList eList2 = serverEntry.getDeployedApplications();
                    for (int j = 0; j < eList2.size(); ++j) {
                        if (this.appDeps.contains(eList2.get(j))) continue;
                        this.appDeps.add(this.applicationsPath + "/" + eList2.get(j));
                    }
                }
            } else {
                throw new AdminException("Unable to load serverIndex from document: " + string);
            }
            Object var14_14 = null;
            try {
                if (documentContentSource != null) {
                    documentContentSource.getSource().close();
                }
                if (serverIndex == null) break block20;
                ResourceSet resourceSet = resource.getResourceSet();
                if (resourceSet != null) {
                    EList eList = resourceSet.getResources();
                    if (eList != null) {
                        eList.remove((Object)resource);
                        break block20;
                    }
                    throw new AdminException("Unable to remove resource: " + string);
                }
                throw new AdminException("Unable to get resources for: " + string);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.FolderCompareTask.updateNodeAppList", "294", this);
            }
            break block20;
            {
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.FolderCompareTask.updateNodeAppList", "259", this);
                    throw this.getAdminException(throwable);
                }
            }
            catch (Throwable throwable) {
                block21: {
                    Object var14_15 = null;
                    try {
                        if (documentContentSource != null) {
                            documentContentSource.getSource().close();
                        }
                        if (serverIndex == null) break block21;
                        ResourceSet resourceSet = resource.getResourceSet();
                        if (resourceSet != null) {
                            EList eList = resourceSet.getResources();
                            if (eList != null) {
                                eList.remove((Object)resource);
                                break block21;
                            }
                            throw new AdminException("Unable to remove resource: " + string);
                        }
                        throw new AdminException("Unable to get resources for: " + string);
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException(throwable2, "com.ibm.ws.management.sync.FolderCompareTask.updateNodeAppList", "294", this);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getApps", this.nodeName);
        }
        return this.appDeps;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getDistribApps() throws AdminException {
        if (FolderCompareTask.tc.isDebugEnabled()) {
            Tr.entry(FolderCompareTask.tc, "getDistribApps", this.nodeName);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        this.appBins = new HashSet<E>();
        var5_5 = this.appDeps.iterator();
        while (true) {
            if (!var5_5.hasNext()) {
                if (FolderCompareTask.tc.isDebugEnabled() == false) return this.appBins;
                Tr.exit(FolderCompareTask.tc, "getDistribApps", this.nodeName);
                return this.appBins;
            }
            var6_6 = (String)var5_5.next();
            var7_7 = var6_6 + "/deployment.xml";
            var8_8 = var6_6.substring(0, var6_6.lastIndexOf("/deployments/"));
            try {
                var3_3 = this.repository.extract(var7_7);
                var2_2 = new WASResourceSetImpl();
                var9_9 = URI.createFileURI((String)var3_3.getDocument().getURI());
                var1_1 = var2_2.createResource(var9_9);
                if (var1_1 == null) throw new AdminException("Unable to create resource: " + var7_7);
                var1_1.load(var3_3.getSource(), new HashMap<K, V>());
                var4_4 = (Deployment)var1_1.getContents().get(0);
                if (var4_4 == null) throw new AdminException("Unable to load deployment from document: " + var7_7);
                var10_11 = (ApplicationDeployment)var4_4.getDeployedObject();
                if (!var10_11.isEnableDistribution()) {
                    CellSync.getCellSync().addDisabledApp(var8_8);
                } else {
                    CellSync.getCellSync().removeDisabledApp(var8_8);
                }
                this.appBins.add(var8_8);
                var12_12 = null;
                ** GOTO lbl-1000
            }
            catch (Throwable var9_10) {
                FFDCFilter.processException(var9_10, "com.ibm.ws.management.sync.FolderCompareTask.updateNodeAppList", "342", this);
                throw this.getAdminException(var9_10);
            }
            {
                catch (Throwable var11_15) {
                    var12_12 = null;
                    try {
                        if (var3_3 != null) {
                            var3_3.getSource().close();
                        }
                        if (var4_4 == null) throw var11_15;
                        var13_13 = var1_1.getResourceSet();
                        if (var13_13 == null) throw new AdminException("Unable to get resources for: " + var7_7);
                        var14_14 = var13_13.getResources();
                        if (var14_14 == null) throw new AdminException("Unable to remove resource: " + var7_7);
                        var14_14.remove((Object)var1_1);
                        throw var11_15;
                    }
                    catch (Throwable var13_13) {
                        FFDCFilter.processException(var13_13, "com.ibm.ws.management.sync.FolderCompareTask.updateNodeAppList", "377", this);
                    }
                    throw var11_15;
                }
lbl-1000:
                // 1 sources

                try {}
                catch (Throwable var13_13) {}
                FFDCFilter.processException(var13_13, "com.ibm.ws.management.sync.FolderCompareTask.updateNodeAppList", "377", this);
                continue;
                if (var3_3 != null) {
                    var3_3.getSource().close();
                }
                if (var4_4 == null) continue;
                var13_13 = var1_1.getResourceSet();
                if (var13_13 == null) throw new AdminException("Unable to get resources for: " + var7_7);
                var14_14 = var13_13.getResources();
                if (var14_14 == null) throw new AdminException("Unable to remove resource: " + var7_7);
                var14_14.remove((Object)var1_1);
                continue;
            }
            break;
        }
    }
}

