/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.management.transform.RepositoryAdapter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class FolderSyncTask
implements ResourceNameFilter {
    private static TraceComponent tc = Tr.register(FolderSyncTask.class, "Sync", "com.ibm.ws.management.resources.sync");
    String nodeName;
    FolderSyncRequest request;
    ConfigRepository repository;
    RepositoryAdapter repositoryAdapter;
    ArrayList results = new ArrayList();
    List exclusionList;
    String nodesPath;
    String cellName;
    Properties taskProps;
    boolean recoveryNode;

    public ArrayList getResults() {
        return this.results;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public void setRepository(ConfigRepository configRepository) throws AdminException {
        this.repository = configRepository;
    }

    public void setRequest(FolderSyncRequest folderSyncRequest) {
        this.request = folderSyncRequest;
    }

    public void setExclusionList(List list) {
        this.exclusionList = list;
    }

    public void setProperties(Properties properties) {
        String string;
        this.taskProps = properties;
        if (this.taskProps != null && (string = this.taskProps.getProperty("recoveryNode")) != null && !string.equals("")) {
            this.recoveryNode = Boolean.valueOf(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws AdminException {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Beginning FolderSyncTask for node/folder: " + this.nodeName + ", " + this.request.getFolderUri());
        }
        this.setupStaticMetadata();
        this.repositoryAdapter = RepositoryAdapter.getRepositoryAdapter(this.repository, this.nodeName);
        this.results.clear();
        String[] stringArray = this.repositoryAdapter.listResourceNames(this.request.getFolderUri(), 1, 1, this);
        stringArray = this.filterDocs(this.request.getFolderUri(), stringArray);
        HashMap hashMap = this.request.getDocuments();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (this.request.getDocumentDigest(stringArray[i]) == null) {
                    this.results.add(new SyncElement(this.repositoryAdapter.extract(stringArray[i]), 2));
                    continue;
                }
                try {
                    object = this.repositoryAdapter.getDigest(stringArray[i]);
                    if (object.equals(this.request.getDocumentDigest(stringArray[i]))) continue;
                    this.results.add(new SyncElement(this.repositoryAdapter.extract(stringArray[i]), 1));
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.FolderSyncTask.execute", "132", this);
                    continue;
                }
                finally {
                    hashMap.remove(stringArray[i]);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.FolderSyncTask.execute", "145", this);
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (this.accept(null, (String)object)) {
                DocumentContentSource documentContentSource = new DocumentContentSource(new Document((String)object), (InputStream)null);
                this.results.add(new SyncElement(documentContentSource, 3));
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Excluding " + (String)object);
        }
    }

    protected void setupStaticMetadata() {
        this.nodesPath = "cells/" + this.cellName + "/nodes/";
    }

    protected String[] filterDocs(String string, String[] stringArray) {
        if (stringArray.length < 1) {
            return stringArray;
        }
        if (!this.recoveryNode && string.startsWith(this.nodesPath)) {
            String string2 = string.substring(this.nodesPath.length());
            if (string2.indexOf("/") != -1) {
                return stringArray;
            }
            if (string2.equals(this.nodeName)) {
                return stringArray;
            }
            ArrayList<String> arrayList = new ArrayList<String>(2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith("/serverindex.xml")) {
                    arrayList.add(stringArray[i]);
                    continue;
                }
                if (!stringArray[i].endsWith("/node-metadata.properties")) continue;
                arrayList.add(stringArray[i]);
            }
            return arrayList.toArray(new String[0]);
        }
        if (CellSync.getCellSync().disabledAppsCount() > 0) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (CellSync.getCellSync().isDisabledApp(string) && stringArray[i].endsWith(".ear")) {
                    bl = true;
                    continue;
                }
                arrayList.add(stringArray[i]);
            }
            if (bl) {
                String[] stringArray2 = new String[arrayList.size()];
                arrayList.toArray(stringArray2);
                return stringArray2;
            }
        }
        return stringArray;
    }

    public boolean accept(String string, String string2) {
        String string3 = null;
        string3 = string == null ? string2 : (string.endsWith("/") ? string + string2 : string + "/" + string2);
        if (string2.equals("node-metadata.properties")) {
            if (string.startsWith(this.nodesPath + this.nodeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Excluding " + string3);
                }
                return false;
            }
            return true;
        }
        if (this.exclusionList != null) {
            Iterator iterator = this.exclusionList.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (!(string4.endsWith("*") && string3.startsWith(string4.substring(0, string4.length() - 1)) || string4.startsWith("*") && string3.endsWith(string4.substring(1))) && !string3.equalsIgnoreCase(string4)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Excluding " + string3);
                }
                return false;
            }
        }
        return true;
    }

    public void setCellName(String string) {
        this.cellName = string;
    }
}

