/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class J2CRAProcessor
implements ConfigRepositoryListener,
NotificationListener {
    private static TraceComponent tc = Tr.register(J2CRAProcessor.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    protected static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String SERVERS_CONTEXT = "servers/";
    private static final long SYNC_ID = -1L;
    private static final Long BAD_ID = new Long(-2L);
    private ConfigRepository repository;
    private boolean isLocal;
    private String cellName = null;
    private String nodeName = null;
    private boolean isInNodeSync = false;
    private Vector globalSyncQ = null;
    private Hashtable changeTable = null;
    private Hashtable changeTableRA = null;

    public J2CRAProcessor(Boolean bl, ConfigRepository configRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "J2CRAProcessor: " + bl);
        }
        this.isLocal = bl;
        this.repository = configRepository;
        String string = "getBundle";
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.application.AppUtils");
            Class<?> clazz2 = Class.forName("java.util.Hashtable");
            Class[] classArray = new Class[]{clazz2};
            Object var7_8 = null;
            Object[] objectArray = new Object[]{var7_8};
            Method method2 = clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMS0024W", exception);
        }
        this.changeTable = new Hashtable();
        this.changeTableRA = new Hashtable();
        NodeSync.addLocalSyncEventListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "J2CRAProcessor");
        }
    }

    private void printBinTable(String string, long l, Vector vector) {
        if (tc.isDebugEnabled()) {
            if (vector == null || vector.size() == 0) {
                Tr.debug(tc, "xxxxxxxxxxx " + string + "(BinTable) : " + l + " xxxxxxxxxx: NULL");
                return;
            }
            Tr.debug(tc, "xxxxxxxxxxx " + string + " ( BinTable ) : " + l + " xxxxxxxxxx");
            Object e2 = vector.elementAt(0);
            Tr.debug(tc, "---->" + e2);
            for (int i = 1; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                Tr.debug(tc, "-------->" + string2);
            }
            Tr.debug(tc, "xxxxENDxxxx id: " + l + " xxxxENDxxxx");
        }
    }

    private void printRATable(String string, long l, Hashtable hashtable) {
        if (tc.isDebugEnabled()) {
            if (hashtable == null || hashtable.size() == 0) {
                Tr.debug(tc, "xxxxxxxxxxx " + string + "( RATable ) : " + l + " xxxxxxxxxx: NULL");
                return;
            }
            Tr.debug(tc, "xxxxxxxxxxx " + string + " ( RATable ) : " + l + " xxxxxxxxxx");
            Object[] objectArray = hashtable.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)objectArray[i];
                J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)hashtable.get(string2);
                Tr.debug(tc, "-------->" + j2CResourceAdapter.getName() + " : " + string2);
            }
            Tr.debug(tc, "xxxxENDxxxx id: " + l + " xxxxENDxxxx");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        long l;
        if (this.isLocal && !this.isInNodeSync) {
            return;
        }
        long l2 = l = this.isInNodeSync ? -1L : configRepositoryEvent.getId();
        if (this.changeTable.get(new Long(l)) != null) {
            return;
        }
        if (this.changeTableRA.get(new Long(l)) != null) {
            return;
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            try {
                Vector vector = (Vector)this.changeTable.get(new Long(l));
                if (vector != null) {
                    return;
                }
                Hashtable hashtable = (Hashtable)this.changeTableRA.get(new Long(l));
                if (hashtable != null) {
                    return;
                }
                if (!this.shouldProcess(configChangeNotifierArray[i].getUri())) continue;
                String string = configChangeNotifierArray[i].getUri();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "process: " + string + " id=" + l);
                }
                vector = new Vector();
                hashtable = new Hashtable();
                this.changeTable.put(new Long(l), vector);
                this.changeTableRA.put(new Long(l), hashtable);
                this.buildBin2RARelation(string, vector, hashtable, this.createVarMap());
                break;
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMS0025W", new Object[]{throwable});
            }
        }
        if (!this.isInNodeSync) {
            this.printBinTable("pre ", l, (Vector)this.changeTable.get(new Long(l)));
            this.printRATable("pre ", l, (Hashtable)this.changeTableRA.get(new Long(l)));
        }
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (this.isLocal && !this.isInNodeSync) {
            return;
        }
        if (!this.isInNodeSync) {
            this.postProcess(configRepositoryEvent.getId(), true);
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            this.isInNodeSync = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            Vector vector = this.globalSyncQ;
            this.isInNodeSync = false;
            this.globalSyncQ = null;
            this.printBinTable("pre ", -1L, (Vector)this.changeTable.get(new Long(-1L)));
            this.printRATable("pre ", -1L, (Hashtable)this.changeTableRA.get(new Long(-1L)));
            if (notification.getUserData() != null && Boolean.TRUE.equals(notification.getUserData())) {
                this.postProcess(-1L, this.isLocal);
            }
        }
    }

    private boolean shouldProcess(String string) throws Exception {
        String string2 = null;
        try {
            if (!string.endsWith("resources.xml")) {
                return false;
            }
            if (string.indexOf(SERVERS_CONTEXT) != -1) {
                return false;
            }
            int n = string.indexOf(NODES_CONTEXT);
            if (n == -1) {
                return false;
            }
            string2 = string.substring(n + 6);
            string2 = string2.substring(0, string2.indexOf(47));
            Tr.debug(tc, "rnode = " + string2);
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMS0027W", new Object[]{string, throwable});
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            this.cellName = adminService.getCellName();
            this.nodeName = adminService.getNodeName();
        } else {
            this.cellName = System.getProperty("local.cell");
            this.nodeName = System.getProperty("local.node");
        }
        if (this.cellName == null) {
            this.cellName = NodeSync.getNodeSync().getCellName();
            this.nodeName = NodeSync.getNodeSync().getNodeName();
        }
        Tr.debug(tc, "cellName = " + this.cellName + " nodeName = " + this.nodeName);
        return this.nodeName.equals(string2);
    }

    private VariableMap createVarMap() throws Exception {
        VariableMap variableMap;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createVarMap");
            }
            variableMap = null;
            try {
                String string = (String)this.repository.getConfig().get("was.repository.root");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cRoot = " + string + " ,cellName = " + this.cellName + " ,nodeName = " + this.nodeName);
                }
                String string2 = "createVarMap";
                Class<?> clazz = Class.forName("com.ibm.ws.management.application.AppUtils");
                Class<?> clazz2 = Class.forName("java.lang.String");
                Class[] classArray = new Class[]{clazz2, clazz2, clazz2, clazz2};
                Object var7_8 = null;
                Object[] objectArray = new Object[]{string, this.cellName, this.nodeName, var7_8};
                Method method2 = clazz.getMethod(string2, classArray);
                variableMap = (VariableMap)method2.invoke(null, objectArray);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "createVarMap: failed " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + variableMap);
        }
        return variableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBin2RARelation(String string, Vector vector, Hashtable hashtable, VariableMap variableMap) {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildBin2RARelation: " + string);
        }
        if ((resource = J2CRAProcessor.getResource(string, "/resources.xml", this.repository)) == null) {
            return;
        }
        try {
            EList eList = resource.getContents();
            vector.add(string);
            for (int i = 0; i < eList.size(); ++i) {
                EObject eObject = (EObject)eList.get(i);
                if (!(eObject instanceof J2CResourceAdapter)) continue;
                J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)eObject;
                String string2 = resource.getURIFragment(eObject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RA key=" + string2 + " ra=" + j2CResourceAdapter);
                }
                hashtable.put(string2, j2CResourceAdapter);
                String string3 = j2CResourceAdapter.getArchivePath();
                string3 = J2CRAProcessor.normalizePath(variableMap, string3);
                vector.add(string3);
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMS0028E", new Object[]{throwable});
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildBin2RARelation: ");
        }
    }

    protected static Resource getResource(String string, String string2, ConfigRepository configRepository) {
        try {
            DocumentContentSource documentContentSource = configRepository.extract(string);
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI((String)string2);
            Resource resource = wASResourceSetImpl.createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(documentContentSource.getSource(), hashMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res for: " + string + " is: " + resource);
            }
            return resource;
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMS0029W", new Object[]{string});
            Tr.debug(tc, "Exception" + throwable);
            return null;
        }
    }

    protected static String normalizePath(VariableMap variableMap, String string) {
        String string2 = string;
        if (variableMap != null) {
            string2 = variableMap.expand(string);
        }
        string2 = string2.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        return string2;
    }

    public void postProcess(long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postProcess: " + l + ", synchronous=: " + bl);
        }
        try {
            Vector vector = (Vector)this.changeTable.remove(new Long(l));
            Hashtable hashtable = (Hashtable)this.changeTableRA.remove(new Long(l));
            if (vector == null || vector.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  oldTable is null or BAD !!!! " + l);
                }
                return;
            }
            if (hashtable == null || hashtable.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  oldTable is null or BAD !!!! " + l);
                }
                return;
            }
            String string = (String)vector.elementAt(0);
            Vector vector2 = new Vector();
            Hashtable hashtable2 = new Hashtable();
            VariableMap variableMap = this.createVarMap();
            this.buildBin2RARelation(string, vector2, hashtable2, variableMap);
            for (int i = 1; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                if (vector2.contains(string2) || this.checkCellLevel(variableMap, string2) || this.checkDeleteDisabled(variableMap, string2, hashtable)) continue;
                this.deleteRar(string2);
            }
            Object[] objectArray = hashtable.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)objectArray[i];
                J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)hashtable2.get(string3);
                if (j2CResourceAdapter != null) continue;
                J2CResourceAdapter j2CResourceAdapter2 = (J2CResourceAdapter)hashtable.get(string3);
                this.stopRA(j2CResourceAdapter2);
            }
            this.printBinTable("post bin", l, vector2);
            this.printRATable("post RA ", l, hashtable2);
            if (vector2.size() == 0 && vector.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  both old and new are of size 0. id=" + l);
                }
                return;
            }
            if (hashtable2.size() == 0 && hashtable.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  both old and new are of size 0. id=" + l);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "ADMS0030E", new Object[]{throwable, new Long(l)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postProcess: " + l);
        }
    }

    public static ResourceBundle getBundle(Hashtable hashtable) {
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        ResourceBundle resourceBundle = J2CRAProcessor.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        return resourceBundle;
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(string, locale2);
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException(missingResourceException, "com.ibm.ws.management.application.AppUtils.getBundle", "90");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error loading class: " + string + ", locale " + locale2 + ", " + missingResourceException);
            }
            return null;
        }
    }

    public static String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = J2CRAProcessor.getMessage(resourceBundle, string);
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static String getMessage(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            return string;
        }
        try {
            String string2 = resourceBundle.getString(string);
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Translation key not found: " + string);
                }
                return string;
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException(missingResourceException, "com.ibm.ws.management.application.AppUtils.getMessage", "114");
            return string;
        }
    }

    private void deleteRar(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " ---- Delete from " + string);
        }
        if (string == null) {
            return;
        }
        try {
            String string2 = "deleteDirTree";
            Class<?> clazz = Class.forName("com.ibm.ws.management.application.AppUtils");
            Class<?> clazz2 = Class.forName("java.lang.String");
            Class[] classArray = new Class[]{clazz2};
            Object[] objectArray = new Object[]{string};
            Method method2 = clazz.getMethod(string2, classArray);
            method2.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            Tr.error(tc, "ADMS0031E", new Object[]{throwable, string});
        }
    }

    private boolean checkDeleteDisabled(VariableMap variableMap, String string, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkDeleteDisabled: " + string);
        }
        boolean bl = false;
        try {
            Object[] objectArray = hashtable.keySet().toArray();
            block2: for (int i = 0; i < objectArray.length; ++i) {
                J2EEResourcePropertySet j2EEResourcePropertySet;
                String string2 = (String)objectArray[i];
                J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)hashtable.get(string2);
                if (j2CResourceAdapter == null) continue;
                String string3 = j2CResourceAdapter.getArchivePath();
                string3 = J2CRAProcessor.normalizePath(variableMap, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "arPath=" + string3);
                }
                if (!string.equals(string3) || (j2EEResourcePropertySet = j2CResourceAdapter.getPropertySet()) == null) continue;
                EList eList = j2EEResourcePropertySet.getResourceProperties();
                for (int j = 0; j < eList.size(); ++j) {
                    J2EEResourceProperty j2EEResourceProperty = (J2EEResourceProperty)eList.get(j);
                    if (!j2EEResourceProperty.getName().equals("WebSphereV5J2CRADisableDistribution") || !j2EEResourceProperty.getValue().equals("DISABLED")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This entry will be ignored.");
                    }
                    bl = true;
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMS0028E", new Object[]{throwable});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkDeleteDisabled: " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCellLevel(VariableMap variableMap, String string) {
        boolean bl;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, " checkCellLevel: " + string);
            }
            String string2 = CELLS_CONTEXT + this.cellName + "/resources.xml";
            Resource resource = J2CRAProcessor.getResource(string2, "/resources.xml", this.repository);
            bl = false;
            try {
                EList eList = resource.getContents();
                if (eList == null) break block9;
                for (int i = 0; i < eList.size(); ++i) {
                    EObject eObject = (EObject)eList.get(i);
                    if (!(eObject instanceof J2CResourceAdapter)) continue;
                    J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)eObject;
                    String string3 = j2CResourceAdapter.getArchivePath();
                    if (!(string3 = J2CRAProcessor.normalizePath(variableMap, string3)).equals(string)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMS0028E", new Object[]{throwable});
            }
            finally {
                if (resource != null) {
                    resource.unload();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " checkCellLevel: " + bl);
        }
        return bl;
    }

    private void stopRA(J2CResourceAdapter j2CResourceAdapter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopRA: " + j2CResourceAdapter);
        }
        Properties properties = new Properties();
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService == null) {
            return;
        }
        String string = j2CResourceAdapter.getName();
        try {
            ObjectName objectName = new ObjectName("*:type=J2CResourceAdapter,name=" + string + ",*");
            Set set = adminService.queryNames(objectName, null);
            if (set.isEmpty()) {
                Tr.exit(tc, "stopRA: " + string);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "J2CRA " + string + "is found");
            }
            String string2 = "stop";
            String[] stringArray = new String[]{};
            Object[] objectArray = new Object[]{};
            ObjectName objectName2 = (ObjectName)set.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBean objectname=" + objectName2);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "J2CRA " + string + " was stopped.");
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            String string3 = malformedObjectNameException.getMessage();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception=" + malformedObjectNameException);
            }
            Tr.warning(tc, "ADMS0024W", new Object[]{malformedObjectNameException});
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMS0024W", new Object[]{exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopRA: " + j2CResourceAdapter);
        }
    }
}

