/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.metadata.NodeAgentCollector;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.NodeSyncTask;
import com.ibm.ws.management.sync.SyncResult;
import com.ibm.ws.management.sync.SyncResultImpl;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticProvider;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NodeSync
extends RuntimeCollaborator
implements RoutingListener,
DiagnosticProvider {
    private static TraceComponent tc = Tr.register(NodeSync.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static NodeSync nodeSync = null;
    private boolean autoSyncEnabled = true;
    private boolean origAutoSyncEnabled;
    private int syncInterval = 1;
    private int origSyncInterval;
    private NodeSyncTask nodeSyncTask = null;
    private boolean serverStartupSyncEnabled = false;
    private boolean origServerStartupSyncEnabled;
    ArrayList exclusionList = null;
    private Properties serviceProps = null;
    private Properties connProps = null;
    private AdminClient adminClient = null;
    private ObjectName cellSyncObjName = null;
    private ObjectName cellRepositoryObjName = null;
    private String nodeName = null;
    private String cellName = null;
    boolean inServer = false;
    private SyncHandler syncHandler = new SyncHandler();
    private ServerInfo netmgr;
    private boolean connected = false;
    private static List localListeners = new ArrayList(2);
    private long notifSeq = 0L;
    public static final String AUTOSYNC_ENABLED = "was.sync.autoSyncEnabled";
    public static final String SYNC_INTERVAL = "was.sync.syncInterval";
    public static final String SERVER_STARTUP_SYNC_ENABLED = "was.sync.serverStartupSyncEnabled";
    public static final String EXCLUSION_LIST = "was.sync.exclusionList";
    public static final String PROCESS_TYPE = "was.sync.processType";
    private String dpName = "NodeSyncDP";
    private DiagnosticProviderInfo dpInfo;
    private boolean hotRestartSync = false;

    private NodeSync() {
        this.connProps = new Properties();
    }

    public static synchronized NodeSync createNodeSync() throws AdminException {
        if (nodeSync != null) {
            throw new AdminException("NodeSync component is initialzied already");
        }
        nodeSync = new NodeSync();
        return nodeSync;
    }

    public static NodeSync getNodeSync() {
        return nodeSync;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isInServer() {
        return this.inServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocalSyncEventListener(NotificationListener notificationListener) {
        List list = localListeners;
        synchronized (list) {
            localListeners.add(notificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLocalSyncEeventListener(NotificationListener notificationListener) {
        List list = localListeners;
        synchronized (list) {
            localListeners.remove(notificationListener);
        }
    }

    public void initialize(Properties properties, List list, VariableMap variableMap) throws AdminException {
        Object object;
        Object object2;
        Properties properties2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if ((properties2 = (Properties)properties.clone()) != null) {
            String string;
            object2 = properties2.getProperty(AUTOSYNC_ENABLED);
            if (object2 != null && !((String)object2).equals("")) {
                this.autoSyncEnabled = Boolean.valueOf((String)object2);
                properties2.remove(AUTOSYNC_ENABLED);
            }
            this.origAutoSyncEnabled = this.autoSyncEnabled;
            object = properties2.getProperty(SYNC_INTERVAL);
            if (object != null && !((String)object).equals("")) {
                int n = Integer.parseInt((String)object);
                if (n > 0) {
                    this.syncInterval = n;
                }
                properties2.remove(SYNC_INTERVAL);
            }
            this.origSyncInterval = this.syncInterval;
            String string2 = properties2.getProperty(SERVER_STARTUP_SYNC_ENABLED);
            if (string2 != null && !string2.equals("")) {
                this.serverStartupSyncEnabled = Boolean.valueOf(string2);
                properties2.remove(SERVER_STARTUP_SYNC_ENABLED);
            }
            this.origServerStartupSyncEnabled = this.serverStartupSyncEnabled;
            String string3 = properties2.getProperty(PROCESS_TYPE);
            if (string3 != null && !string3.equals("")) {
                if (string3.equalsIgnoreCase("NodeAgent")) {
                    this.inServer = true;
                }
                properties2.remove(PROCESS_TYPE);
            }
            if ((string = System.getProperty("hotRestartSync")) != null && string.equalsIgnoreCase("true")) {
                this.hotRestartSync = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hot restart sync is enabled for NodeSync via system property.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "autoSyncEnabled = " + this.autoSyncEnabled);
                Tr.debug(tc, "syncInterval = " + this.syncInterval);
                Tr.debug(tc, "serverStartupSyncEnabled = " + this.serverStartupSyncEnabled);
                Tr.debug(tc, "processType = " + string3);
                Tr.debug(tc, "hotRestartSync = " + this.hotRestartSync);
            }
            this.serviceProps = properties2;
        }
        if (this.inServer) {
            try {
                object2 = new Properties();
                ((Properties)object2).setProperty("diagnosticProvider", "true");
                AdminServiceFactory.getMBeanFactory().activateMBean("NodeSync", this, "nodeSync", null, (Properties)object2);
                tc.setDiagnosticProviderID(this.getDiagnosticProviderId());
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.sync.NodeSync.initialize", "179", this);
                Tr.error(tc, "ADMS0100E", adminException);
                throw adminException;
            }
            object2 = AdminServiceFactory.getAdminService();
            this.nodeName = object2.getNodeName();
            this.cellName = object2.getCellName();
            object = RoutingTable.getInstance();
            ((RoutingTable)object).addRoutingListener(this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering as RoutingListener");
            }
            DiagnosticProviderHelper.registerMBeanWithDiagnosticService(this.dpName, this.getObjectName());
        } else {
            this.getConnectionProps(properties2);
            try {
                object2 = ConfigRepositoryFactory.getConfigRepository();
                if (object2 != null) {
                    object2.initialize(properties2);
                } else {
                    ConfigRepositoryFactory.createConfigRepository(true).initialize(properties2);
                }
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.sync.NodeSync.initialize", "194", this);
                throw adminException;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName = " + this.nodeName);
            Tr.debug(tc, "cellName = " + this.cellName);
        }
        this.nodeSyncTask = new NodeSyncTask(this);
        this.initializeExclusions(list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Boolean requestSync() {
        return this.nodeSyncTask.initiate(false);
    }

    public Boolean sync() throws AdminException {
        Boolean bl = new Boolean(this.syncHandler.sync());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sync result is " + bl);
        }
        return bl;
    }

    public Boolean isNodeSynchronized() throws AdminException {
        Boolean bl = new Boolean(this.syncHandler.isNodeSynchronized());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sync result is " + bl);
        }
        return bl;
    }

    public boolean isHotRestartSyncEnabled() {
        return this.hotRestartSync;
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this.hotRestartSync) {
            this.nodeSyncTask.persistNodeGlobalEpoch();
            this.nodeSyncTask.persistFolderLevelEpochs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    ConfigEpoch getCellRepositoryEpoch() throws AdminException {
        ConfigEpoch configEpoch;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryEpoch");
        }
        try {
            AdminClient adminClient = this.getAdminClient();
            ObjectName objectName = this.getCellRepositoryObjName();
            String string = "getRepositoryEpoch";
            configEpoch = (ConfigEpoch)adminClient.invoke(objectName, string, null, null);
        }
        catch (ConnectorNotAvailableException connectorNotAvailableException) {
            Tr.error(tc, "ADMS0015E");
            throw new AdminException(connectorNotAvailableException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSync.getCellRepositoryEpoch", "320", this);
            Tr.error(tc, "ADMS0005E", exception);
            throw AdminException.getAdminException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryEpoch", configEpoch);
        }
        return configEpoch;
    }

    public ConfigChangeNotifier[] invokeGetModifiedFolders(HashMap hashMap) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeGetModifiedFolders");
        }
        ConfigChangeNotifier[] configChangeNotifierArray = null;
        try {
            Object[] objectArray;
            String[] stringArray;
            Object object;
            AdminClient adminClient = this.getAdminClient();
            ObjectName objectName = this.getCellSyncName();
            String string = "getModifiedFolders";
            if (objectName.getKeyProperty("version").equals("5.0")) {
                object = new String[]{"java.lang.String", "java.util.HashMap"};
                Object[] objectArray2 = new Object[]{this.nodeName, hashMap};
                stringArray = object;
                objectArray = objectArray2;
            } else {
                object = new String[]{"java.lang.String", "java.util.HashMap", "java.util.Properties"};
                Object[] objectArray3 = new Object[]{this.nodeName, hashMap, this.serviceProps};
                stringArray = object;
                objectArray = objectArray3;
            }
            object = adminClient.invoke(objectName, string, objectArray, stringArray);
            configChangeNotifierArray = (ConfigChangeNotifier[])object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifiedFolders", configChangeNotifierArray);
            }
        }
        catch (ConnectorNotAvailableException connectorNotAvailableException) {
            Tr.error(tc, "ADMS0015E");
            throw new AdminException(connectorNotAvailableException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSync.invokeGetModifiedFolders", "418", this);
            Tr.error(tc, "ADMS0005E", exception);
            throw AdminException.getAdminException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeGetModifiedFolders");
        }
        return configChangeNotifierArray;
    }

    FolderSyncUpdate[] invokeGetFolderSyncUpdate(FolderSyncRequest[] folderSyncRequestArray) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeGetFolderSyncUpdate");
        }
        FolderSyncUpdate[] folderSyncUpdateArray = null;
        try {
            Object[] objectArray;
            String[] stringArray;
            AdminClient adminClient = this.getAdminClient();
            ObjectName objectName = this.getCellSyncName();
            String string = "getFolderSyncUpdates";
            if (objectName.getKeyProperty("version").equals("5.0")) {
                String[] stringArray2 = new String[]{"java.lang.String", "java.util.List", "[Lcom.ibm.ws.management.sync.FolderSyncRequest;"};
                Object[] objectArray2 = new Object[]{this.nodeName, this.exclusionList, folderSyncRequestArray};
                stringArray = stringArray2;
                objectArray = objectArray2;
            } else {
                String[] stringArray3 = new String[]{"java.lang.String", "java.util.List", "[Lcom.ibm.ws.management.sync.FolderSyncRequest;", "java.util.Properties"};
                Object[] objectArray3 = new Object[]{this.nodeName, this.exclusionList, folderSyncRequestArray, this.serviceProps};
                stringArray = stringArray3;
                objectArray = objectArray3;
            }
            folderSyncUpdateArray = (FolderSyncUpdate[])adminClient.invoke(objectName, string, objectArray, stringArray);
        }
        catch (ConnectorNotAvailableException connectorNotAvailableException) {
            Tr.error(tc, "ADMS0015E");
            throw new AdminException(connectorNotAvailableException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSync.invokeGetFolderSyncUpdate", "453", this);
            Tr.error(tc, "ADMS0005E", exception);
            throw AdminException.getAdminException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeGetFolderSyncUpdate", folderSyncUpdateArray);
        }
        return folderSyncUpdateArray;
    }

    public SyncResult getSyncResult() {
        return this.nodeSyncTask.getCurrentResult();
    }

    public com.ibm.websphere.management.sync.SyncResult getResult() {
        SyncResult syncResult = this.nodeSyncTask.getCurrentResult();
        if (syncResult != null) {
            return new SyncResultImpl(syncResult);
        }
        return null;
    }

    private AdminClient getAdminClient() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient");
        }
        if (this.adminClient == null) {
            try {
                if (this.inServer) {
                    throw new AdminException("Admin client connection to deployment manager is unavailable; nodeagent has not discovered the dmgr");
                }
                this.adminClient = AdminClientFactory.createAdminClient(this.connProps);
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMS0012E", exception);
                throw AdminException.getAdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return this.adminClient;
    }

    private void getConnectionProps(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionProps", DebugUtils.createPropertiesMaskPlainTextPassword(properties));
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (properties != null) {
            string = properties.getProperty("type");
            string2 = properties.getProperty("host");
            string3 = properties.getProperty("port");
            string4 = properties.getProperty("username");
            string5 = properties.getProperty("password");
            string6 = properties.getProperty("securityEnabled");
        }
        if (string != null && string2 != null && string3 != null) {
            this.connProps.setProperty("type", string);
            this.connProps.setProperty("host", string2);
            this.connProps.setProperty("port", string3);
            if (string4 != null) {
                this.connProps.setProperty("username", string4);
            }
            if (string5 != null) {
                this.connProps.setProperty("password", string5);
            }
            if (new Boolean(string6).booleanValue()) {
                this.connProps.setProperty("securityEnabled", "true");
            }
            this.nodeName = properties.getProperty("nodeName");
            this.cellName = properties.getProperty("cellName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionProps", DebugUtils.createPropertiesMaskPlainTextPassword(this.connProps));
        }
    }

    private ObjectName getCellSyncName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellSyncName");
        }
        if (this.cellSyncObjName == null) {
            try {
                String string = Utils.getNetmgrName(this.adminClient);
                String string2 = "WebSphere:type=CellSync,process=" + string + ",*";
                ObjectName objectName = new ObjectName(string2);
                Set set = this.getAdminClient().queryNames(objectName, null);
                if (set != null && set.size() != 0) {
                    if (set.size() != 1) {
                        Tr.service(tc, "ADMS0013I", new Integer(set.size()));
                    }
                    Object[] objectArray = set.toArray();
                    this.cellSyncObjName = (ObjectName)objectArray[0];
                    String string3 = this.cellSyncObjName.getKeyProperty("version");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CellSync name is " + this.cellSyncObjName.getCanonicalName());
                    }
                }
            }
            catch (ConnectorNotAvailableException connectorNotAvailableException) {
                Tr.error(tc, "ADMS0015E");
                throw new AdminException(connectorNotAvailableException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSync.getCellSyncName", "740", this);
                Tr.error(tc, "ADMS0005E", exception);
                throw AdminException.getAdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellSyncName");
        }
        return this.cellSyncObjName;
    }

    private ObjectName getCellRepositoryObjName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryObjName");
        }
        if (this.cellRepositoryObjName == null) {
            try {
                String string = Utils.getNetmgrName(this.adminClient);
                String string2 = "WebSphere:type=ConfigRepository,process=" + string + ",*";
                ObjectName objectName = new ObjectName(string2);
                Set set = this.getAdminClient().queryNames(objectName, null);
                if (set != null && set.size() != 0) {
                    if (set.size() != 1) {
                        Tr.service(tc, "ADMS0021I", new Integer(set.size()));
                    }
                    Object[] objectArray = set.toArray();
                    this.cellRepositoryObjName = (ObjectName)objectArray[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cell repository name is " + this.cellRepositoryObjName.getCanonicalName());
                    }
                }
            }
            catch (ConnectorNotAvailableException connectorNotAvailableException) {
                Tr.error(tc, "ADMS0015E");
                throw new AdminException(connectorNotAvailableException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSync.getCellRepositoryObjName", "740", this);
                Tr.error(tc, "ADMS0005E", exception);
                throw AdminException.getAdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryObjName");
        }
        return this.cellRepositoryObjName;
    }

    public void childAdded(ServerInfo serverInfo) {
    }

    public void childRemoved(ServerInfo serverInfo) {
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentAdded");
        }
        this.cellSyncObjName = null;
        this.cellRepositoryObjName = null;
        this.netmgr = serverInfo;
        try {
            this.adminClient = this.netmgr.getAdminClient();
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMR0012E", exception);
        }
        try {
            NodeAgentCollector.collectMetadataAndSendToDmgr(this.adminClient);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSync.parentAdded", "626", this);
        }
        this.connected = true;
        this.nodeSyncTask.triggerAutoSync();
    }

    public void parentRemoved(ServerInfo serverInfo) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentRemoved");
        }
        this.connected = false;
    }

    private void initializeExclusions(List list) {
        this.exclusionList = new ArrayList();
        this.exclusionList.add("cells/" + this.cellName + "/nodes/" + this.nodeName + "/namestore.xml");
        this.exclusionList.add("*/namestore-cell.xml");
        this.exclusionList.add("*/namestore-node.xml");
        this.exclusionList.add("*/node-metadata.properties");
        if (AdminHelper.getPlatformHelper().isControlJvm()) {
            this.exclusionList.add("*/was.env");
            this.exclusionList.add("*/control.jvm.options");
            this.exclusionList.add("*/servant.jvm.options");
            this.exclusionList.add("*/adjunct.jvm.options");
        }
        if (list != null) {
            this.exclusionList.addAll(list);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exclusionList = ", this.exclusionList);
        }
    }

    public Boolean getAutoSyncEnabled() {
        return this.autoSyncEnabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAutoSyncEnabled(Boolean bl) {
        if (this.autoSyncEnabled != bl) {
            this.autoSyncEnabled = bl;
            if (this.autoSyncEnabled) {
                Tr.audit(tc, "ADMS0018I");
            } else {
                Tr.audit(tc, "ADMS0019I");
            }
            if (this.autoSyncEnabled) {
                this.nodeSyncTask.triggerAutoSync();
            }
        }
    }

    public Integer getSyncInterval() {
        return new Integer(this.syncInterval);
    }

    public void setSyncInterval(Integer n) {
        int n2 = n;
        if (n2 > 0) {
            Tr.audit(tc, "ADMS0001I", n);
            this.syncInterval = n2;
        } else {
            Tr.warning(tc, "ADMS0002W", n);
        }
    }

    public Boolean getServerStartupSyncEnabled() {
        return this.serverStartupSyncEnabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setServerStartupSyncEnabled(Boolean bl) {
        this.serverStartupSyncEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLocalEvent(Notification notification) {
        List list = localListeners;
        synchronized (list) {
            for (int i = 0; i < localListeners.size(); ++i) {
                try {
                    ((NotificationListener)localListeners.get(i)).handleNotification(notification, null);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSync.sendLocalEvent", "671", this);
                }
            }
        }
    }

    void sendCompletionEvent(boolean bl) {
        ObjectName objectName = null;
        if (this.inServer) {
            objectName = this.getObjectName();
        } else {
            try {
                objectName = new ObjectName("WebSphere:type=NodeSync,cell=" + this.cellName + ",node=" + this.nodeName);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.sync.NodeSync.sendCompletionEvent", "717", this);
            }
        }
        long l = this.notifSeq++;
        Notification notification = new Notification("websphere.nodesync.complete", objectName, l);
        notification.setUserData(bl ? Boolean.TRUE : Boolean.FALSE);
        this.sendLocalEvent(notification);
        if (this.inServer) {
            try {
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSync.sendCompletionEvent", "737", this);
                Tr.warning(tc, "ADMS0014W", throwable);
            }
        }
    }

    void sendStartEvent() {
        ObjectName objectName = null;
        if (this.inServer) {
            objectName = this.getObjectName();
        } else {
            try {
                objectName = new ObjectName("WebSphere:type=NodeSync,cell=" + this.cellName + ",node=" + this.nodeName);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.sync.NodeSync.sendStartEvent", "760", this);
            }
        }
        long l = this.notifSeq++;
        Notification notification = new Notification("websphere.nodesync.initiated", objectName, l);
        this.sendLocalEvent(notification);
        if (this.inServer) {
            try {
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSync.sendStartEvent", "766", this);
                Tr.warning(tc, "ADMS0022W", throwable);
            }
        }
    }

    public boolean syncForServerStartup() throws AdminException {
        boolean bl = true;
        if (this.serverStartupSyncEnabled) {
            bl = false;
            if (this.isConnected()) {
                bl = this.syncHandler.sync();
                CommonAppUtils.waitSyncForAppManagement();
            }
        }
        return bl;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    public boolean isConnected(long l) {
        while (!this.isConnected() && l > 0L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l -= 500L;
        }
        return this.isConnected();
    }

    public String getDiagnosticProviderName() {
        return this.dpName;
    }

    public String getDiagnosticProviderId() {
        return this.getObjectName().toString();
    }

    public DiagnosticProviderInfo getRegisteredDiagnostics() {
        if (this.dpInfo == null) {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/ws/management/sync/NodeSyncDiagnosticProvider.xml");
            this.dpInfo = DiagnosticProviderHelper.loadRegistry(inputStream, this.dpName);
        }
        return this.dpInfo;
    }

    public DiagnosticEvent[] configDump(String string, boolean bl) {
        DiagnosticEvent[] diagnosticEventArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{string, new Boolean(bl)});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("startup-autoSyncEnabled", new DiagnosticTypedValue(this.origAutoSyncEnabled, "NodeSync.autoSyncEnabled.descriptionKey"));
        hashMap.put("startup-syncInterval", new DiagnosticTypedValue(this.origSyncInterval, "NodeSync.syncInterval.descriptionKey"));
        hashMap.put("startup-serverStartupSyncEnabled", new DiagnosticTypedValue(this.origServerStartupSyncEnabled, "NodeSync.serverStartupSyncEnabled.descriptionKey"));
        HashMap<String, DiagnosticTypedValue> hashMap2 = new HashMap<String, DiagnosticTypedValue>();
        Iterator iterator = this.exclusionList.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            hashMap2.put("exclusion" + n, new DiagnosticTypedValue((String)iterator.next(), "NodeSync.exclusions.descriptionKey"));
            ++n;
        }
        hashMap.put("startup-exclusions", hashMap2);
        hashMap.put("current-autoSyncEnabled", new DiagnosticTypedValue(this.autoSyncEnabled, "NodeSync.autoSyncEnabled.descriptionKey"));
        hashMap.put("current-syncInterval", new DiagnosticTypedValue(this.syncInterval, "NodeSync.syncInterval.descriptionKey"));
        hashMap.put("current-serverStartupSyncEnabled", new DiagnosticTypedValue(this.serverStartupSyncEnabled, "NodeSync.serverStartupSyncEnabled.descriptionKey"));
        HashMap<DiagnosticEvent[], DiagnosticTypedValue> hashMap3 = new HashMap<DiagnosticEvent[], DiagnosticTypedValue>();
        Enumeration<Object> enumeration = this.serviceProps.keys();
        while (enumeration.hasMoreElements()) {
            diagnosticEventArray = (DiagnosticEvent[])enumeration.nextElement();
            hashMap3.put(diagnosticEventArray, new DiagnosticTypedValue(this.serviceProps.getProperty((String)diagnosticEventArray), "NodeSync.prop.descriptionKey"));
        }
        hashMap.put("startup-serviceProps", hashMap3);
        diagnosticEventArray = new DiagnosticEvent[]{DiagnosticEventFactory.createConfigDump(this.getDiagnosticProviderId(), NodeSync.class.getName(), "configDump", hashMap)};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configDump", diagnosticEventArray);
        }
        return diagnosticEventArray;
    }

    public DiagnosticEvent[] stateDump(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateDump", new Object[]{string, new Boolean(bl)});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("connected", new DiagnosticTypedValue(this.connected, "NodeSync.connected.descriptionKey"));
        HashMap<String, DiagnosticTypedValue> hashMap2 = new HashMap<String, DiagnosticTypedValue>();
        com.ibm.websphere.management.sync.SyncResult syncResult = this.getResult();
        if (syncResult != null) {
            hashMap2.put("startTime", new DiagnosticTypedValue(new Date(syncResult.getInitTime()), "NodeSync.initTime.descriptionKey"));
            hashMap2.put("completeTime", new DiagnosticTypedValue(new Date(syncResult.getCompleteTime()), "NodeSync.completeTime.descriptionKey"));
            hashMap2.put("successful", new DiagnosticTypedValue(syncResult.isSuccessful(), "NodeSync.successful.descriptionKey"));
            hashMap2.put("updated", new DiagnosticTypedValue(syncResult.isUpdated(), "NodeSync.updated.descriptionKey"));
        }
        hashMap.put("currentResult", hashMap2);
        DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[]{DiagnosticEventFactory.createStateDump(this.getDiagnosticProviderId(), NodeSync.class.getName(), "stateDump", hashMap)};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateDump", diagnosticEventArray);
        }
        return diagnosticEventArray;
    }

    public DiagnosticEvent[] selfDiagnostic(String string, boolean bl) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfDiagnostic", new Object[]{string, new Boolean(bl)});
        }
        HashMap<String, DiagnosticTypedValue> hashMap = new HashMap<String, DiagnosticTypedValue>();
        hashMap.put("connected", new DiagnosticTypedValue(this.connected, "NodeSync.connected.descriptionKey"));
        if (this.connected) {
            hashMap.put("fileTransferAvailable", new DiagnosticTypedValue(this.isFileTransferAvailable(), "NodeSync.ftapp.descriptionKey"));
            object = null;
            try {
                object = this.isNodeSynchronized();
                hashMap.put("synchronized", new DiagnosticTypedValue((Boolean)object, "NodeSync.ftapp.descriptionKey"));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSync.selfDiagnostic", "952", this);
            }
        }
        object = new DiagnosticEvent[]{DiagnosticEventFactory.createDiagnosticEvent(this.getDiagnosticProviderId(), "selfDiagnostic", 10, NodeSync.class.getName(), "selfDiagnostic", "", "", hashMap)};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfDiagnostic", object);
        }
        return object;
    }

    public String[] localize(String[] stringArray, Locale locale) {
        if (this.dpInfo == null) {
            this.dpInfo = this.getRegisteredDiagnostics();
        }
        if (this.dpInfo == null) {
            return null;
        }
        return DiagnosticProviderHelper.localize(this.dpInfo.resourceBundleName, stringArray, locale);
    }

    private boolean isFileTransferAvailable() {
        boolean bl = false;
        if (this.getFileTransferObjName() != null) {
            bl = true;
        }
        return bl;
    }

    private ObjectName getFileTransferObjName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileTransferObjName");
        }
        ObjectName objectName = null;
        try {
            String string = Utils.getNetmgrName(this.adminClient);
            String string2 = "WebSphere:type=Application,name=filetransfer,process=" + string + ",*";
            ObjectName objectName2 = new ObjectName(string2);
            Set set = this.getAdminClient().queryNames(objectName2, null);
            if (set != null && set.size() != 0) {
                Object[] objectArray = set.toArray();
                objectName = (ObjectName)objectArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "file transfer name is " + this.cellRepositoryObjName.getCanonicalName());
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSync.getFileTransferObjName", "1008", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileTransferObjName", objectName);
        }
        return objectName;
    }

    private class SyncHandler {
        private SyncHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sync() {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sync");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                if (NodeSync.this.nodeSyncTask.isIdle()) {
                    NodeSync.this.requestSync();
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().isSuccessful();
                } else {
                    boolean bl2 = this.waitForNextCompareFolder();
                    if (!bl2) {
                        NodeSync.this.requestSync();
                    }
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().isSuccessful();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sync", bl ? Boolean.TRUE : Boolean.FALSE);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isNodeSynchronized() {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isNodeSynchronized");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                if (NodeSync.this.nodeSyncTask.isIdle()) {
                    NodeSync.this.nodeSyncTask.initiate(true);
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().getResult() == 1;
                } else {
                    boolean bl2 = this.waitForNextCompareFolder();
                    if (!bl2) {
                        NodeSync.this.nodeSyncTask.initiate(true);
                    }
                    this.waitForCurrentSync();
                    bl = NodeSync.this.getSyncResult().getResult() == 1;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isNodeSynchronized", bl ? Boolean.TRUE : Boolean.FALSE);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForCurrentSync() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForCurrentSync");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                while (!NodeSync.this.nodeSyncTask.isIdle()) {
                    try {
                        NodeSync.this.nodeSyncTask.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForCurrentSync");
            }
        }

        private boolean waitForNextCompareFolder() {
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                while (true) {
                    try {
                        NodeSync.this.nodeSyncTask.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    switch (NodeSync.this.nodeSyncTask.getCurrentState()) {
                        case 0: {
                            return false;
                        }
                        case 1: {
                            return true;
                        }
                    }
                }
            }
        }
    }
}

