/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.sync.EpochFileHelper;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.management.sync.SyncResult;
import com.ibm.ws.management.util.SecurityHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.security.auth.Subject;

class NodeSyncTask
implements AlarmListener,
Runnable,
ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register(NodeSyncTask.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static Logger logger = null;
    public static final int IDLE = 0;
    public static final int COMPARE_FOLDERS = 1;
    public static final int PROCESSING_UPDATE = 2;
    public static final int PROCESSING_UPDATE_WITH_ERROR = 3;
    public static final int VERIFY_SYNC_RESULT = 4;
    private static final int SYNC_ITERATION_LIMIT = 5;
    private int state = 0;
    private NodeSync nodeSync;
    private boolean syncStatusOnly = false;
    private SyncResult currentResult = null;
    private ConfigEpoch nodeGlobalEpoch = null;
    private ConfigRepository repository;
    private HashMap folderEpoch = null;
    private boolean folderEpochInvalid = false;
    private boolean alarmSet = false;
    static final String CLASSNAME = NodeSyncTask.class.getName();
    private int consecutiveFailures = 0;
    private boolean autoSyncDisabled = false;
    private String epochDir = null;
    private final String FOLDER_EPOCH_FILE_NAME = "nodeagentFolderLevel.epoch";
    private final String CELL_EPOCH_FILE_NAME = "nodeGlobal.epoch";

    public NodeSyncTask(NodeSync nodeSync) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating NodeSyncTask");
        }
        this.nodeSync = nodeSync;
        this.state = 0;
        this.repository = ConfigRepositoryFactory.getConfigRepository();
        this.repository.addListener(this);
        if (this.nodeGlobalEpoch == null && nodeSync.isHotRestartSyncEnabled()) {
            this.nodeGlobalEpoch = this.loadNodeGlobalEpochFromFile();
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            logger = Logger.getLogger(CLASSNAME, "com.ibm.ws.management.resources.sync");
        }
    }

    synchronized Boolean initiate(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initiate: " + bl);
        }
        boolean bl2 = false;
        if (this.state == 0) {
            this.syncStatusOnly = bl;
            if (this.currentResult == null) {
                this.currentResult = new SyncResult();
            } else {
                this.currentResult.initialize();
            }
            if (this.folderEpochInvalid) {
                this.nodeGlobalEpoch = null;
                this.folderEpoch = null;
                this.folderEpochInvalid = false;
            }
            this.setState(1);
            if (!bl) {
                this.nodeSync.sendStartEvent();
            }
            Thread thread = new Thread(this);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                thread.setDaemon(true);
                thread.setName("NodeSync");
            }
            thread.start();
            bl2 = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initiate," + bl2);
        }
        return new Boolean(bl2);
    }

    boolean isIdle() {
        return this.state == 0;
    }

    SyncResult getCurrentResult() {
        return this.currentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "run");
        }
        try {
            this.doSync();
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.sync.NodeSyncTask.run", "157", this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSyncTask.run", "162", this);
        }
        finally {
            this.setState(0);
        }
    }

    public void alarm(Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Handling alarm");
        }
        this.alarmSet = false;
        this.triggerAutoSync();
    }

    void triggerAutoSync() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "triggerAutoSync");
        }
        if (this.nodeSync.getAutoSyncEnabled().booleanValue()) {
            if (this.nodeSync.isConnected()) {
                try {
                    this.initiate(false);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.sync.NodeSyncTask.triggerAutoSync", "174", this);
                    Tr.service(tc, "ADMS0017I");
                }
                if (!this.alarmSet) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting alarm for interval of  " + this.nodeSync.getSyncInterval());
                    }
                    AlarmManager.createNonDeferrable(this.nodeSync.getSyncInterval() * 60000, this);
                    this.alarmSet = true;
                }
            } else {
                Tr.error(tc, "ADMS0015E");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "autoSync is disabled");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "triggerAutoSync");
        }
    }

    int getCurrentState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSync() throws AdminException {
        block75: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doSync");
            }
            boolean bl3 = false;
            int n = 0;
            ConfigEpoch configEpoch = null;
            boolean bl2 = false;
            boolean bl = false;
            try {
                try {}
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSyncTask.doSync", "8891", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error in SecurityHelper ");
                    }
                    Object var15_17 = null;
                    if (bl3) {
                        this.currentResult.setResult(1);
                    } else if (this.syncStatusOnly) {
                        switch (this.state) {
                            case 1: {
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 2: {
                                this.currentResult.setResult(3);
                                break;
                            }
                        }
                    } else {
                        switch (this.state) {
                            case 1: {
                                if (bl) {
                                    this.currentResult.setResult(2);
                                    break;
                                }
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 4: {
                                this.currentResult.setResult(2);
                                break;
                            }
                        }
                    }
                    if (!this.syncStatusOnly) {
                        this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
                        if (this.currentResult.isSuccessful()) {
                            if (AdminHelper.getPlatformHelper().isZOS() && bl2) {
                                this.logWTO("doSync", "ADMS0003I");
                            }
                            Tr.audit(tc, "ADMS0003I");
                        } else {
                            if (AdminHelper.getPlatformHelper().isZOS() && bl2) {
                                this.logWTO("doSync", "ADMS0036E");
                            }
                            Tr.audit(tc, "ADMS0036E");
                        }
                        this.manageConsecutiveFailures(this.currentResult.isSuccessful());
                    }
                    break block75;
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (bl3) {
                    this.currentResult.setResult(1);
                } else if (this.syncStatusOnly) {
                    switch (this.state) {
                        case 1: {
                            this.currentResult.setResult(4);
                            break;
                        }
                        case 2: {
                            this.currentResult.setResult(3);
                            break;
                        }
                    }
                } else {
                    switch (this.state) {
                        case 1: {
                            if (bl) {
                                this.currentResult.setResult(2);
                                break;
                            }
                            this.currentResult.setResult(4);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.currentResult.setResult(4);
                            break;
                        }
                        case 4: {
                            this.currentResult.setResult(2);
                            break;
                        }
                    }
                }
                if (!this.syncStatusOnly) {
                    this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
                    if (this.currentResult.isSuccessful()) {
                        if (AdminHelper.getPlatformHelper().isZOS() && bl2) {
                            this.logWTO("doSync", "ADMS0003I");
                        }
                        Tr.audit(tc, "ADMS0003I");
                    } else {
                        if (AdminHelper.getPlatformHelper().isZOS() && bl2) {
                            this.logWTO("doSync", "ADMS0036E");
                        }
                        Tr.audit(tc, "ADMS0036E");
                    }
                    this.manageConsecutiveFailures(this.currentResult.isSuccessful());
                }
                throw throwable;
            }
            do {
                Subject subject;
                if ((subject = SecurityHelper.getOwnedSubject()) != null) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
                configEpoch = this.nodeSync.getCellRepositoryEpoch();
                boolean bl4 = bl3 = this.nodeGlobalEpoch != null && this.nodeGlobalEpoch.equals(configEpoch);
                if (bl3) break;
                this.setState(1);
                ConfigChangeNotifier[] configChangeNotifierArray = this.nodeSync.invokeGetModifiedFolders(this.getFolderEpoch());
                this.setState(2);
                if (AdminHelper.getPlatformHelper().isZOS() && configChangeNotifierArray.length > 0) {
                    bl2 = true;
                }
                if (this.syncStatusOnly) {
                    bl3 = configChangeNotifierArray.length == 0;
                    break;
                }
                this.setState(2);
                int n2 = 10;
                ArrayList<FolderSyncUpdate[]> arrayList = new ArrayList<FolderSyncUpdate[]>(n2);
                int n3 = 0;
                while (n3 < configChangeNotifierArray.length) {
                    FolderSyncUpdate[] folderSyncUpdateArray;
                    arrayList.clear();
                    for (int i = 0; i < n2 && n3 < configChangeNotifierArray.length; ++n3, ++i) {
                        folderSyncUpdateArray = this.createFolderSyncRequest(configChangeNotifierArray[n3]);
                        if (folderSyncUpdateArray == null) continue;
                        arrayList.add(folderSyncUpdateArray);
                    }
                    if (arrayList.size() <= 0) continue;
                    FolderSyncRequest[] folderSyncRequestArray = new FolderSyncRequest[arrayList.size()];
                    arrayList.toArray(folderSyncRequestArray);
                    folderSyncUpdateArray = this.nodeSync.invokeGetFolderSyncUpdate(folderSyncRequestArray);
                    for (int i = 0; i < folderSyncUpdateArray.length; ++i) {
                        this.processFolderSyncUpdate(folderSyncUpdateArray[i]);
                    }
                }
                if (this.state == 3) {
                    bl3 = false;
                    break;
                }
                this.setState(4);
                this.nodeGlobalEpoch = configEpoch;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Set node global epoch", this.nodeGlobalEpoch);
                }
                bl = true;
            } while (!bl3 && n++ < 5);
            if (n == 5) {
                Tr.audit(tc, "ADMS0023I");
            }
            Object var15_16 = null;
            if (bl3) {
                this.currentResult.setResult(1);
            } else if (this.syncStatusOnly) {
                switch (this.state) {
                    case 1: {
                        this.currentResult.setResult(4);
                        break;
                    }
                    case 2: {
                        this.currentResult.setResult(3);
                        break;
                    }
                }
            } else {
                switch (this.state) {
                    case 1: {
                        if (bl) {
                            this.currentResult.setResult(2);
                            break;
                        }
                        this.currentResult.setResult(4);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.currentResult.setResult(4);
                        break;
                    }
                    case 4: {
                        this.currentResult.setResult(2);
                        break;
                    }
                }
            }
            if (!this.syncStatusOnly) {
                this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
                if (this.currentResult.isSuccessful()) {
                    if (AdminHelper.getPlatformHelper().isZOS() && bl2) {
                        this.logWTO("doSync", "ADMS0003I");
                    }
                    Tr.audit(tc, "ADMS0003I");
                } else {
                    if (AdminHelper.getPlatformHelper().isZOS() && bl2) {
                        this.logWTO("doSync", "ADMS0036E");
                    }
                    Tr.audit(tc, "ADMS0036E");
                }
                this.manageConsecutiveFailures(this.currentResult.isSuccessful());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doSync");
        }
    }

    private void manageConsecutiveFailures(boolean bl) {
        if (bl) {
            this.consecutiveFailures = 0;
            if (this.autoSyncDisabled) {
                Tr.audit(tc, "ADMS0211I");
                this.autoSyncDisabled = false;
                this.nodeSync.setAutoSyncEnabled(new Boolean(true));
            }
        } else {
            ++this.consecutiveFailures;
            if (this.consecutiveFailures >= 5 && this.nodeSync.getAutoSyncEnabled() == Boolean.TRUE && !"true".equalsIgnoreCase(System.getProperty("com.ibm.websphere.management.sync.allowfailure"))) {
                Tr.audit(tc, "ADMS0212I");
                this.autoSyncDisabled = true;
                this.nodeSync.setAutoSyncEnabled(new Boolean(false));
            }
        }
    }

    private FolderSyncRequest createFolderSyncRequest(ConfigChangeNotifier configChangeNotifier) throws AdminException {
        if (configChangeNotifier.getChangeType() == 1) {
            this.currentResult.updated();
            this.deleteFolder(configChangeNotifier.getUri());
            return null;
        }
        return this.generateFolderSyncRequest(configChangeNotifier);
    }

    private void deleteFolder(String string) throws AdminException {
        String[] stringArray = this.repository.listResourceNames(string, 1, Integer.MAX_VALUE);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.repository.delete(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSyncTask.deleteFolder", "357", this);
                this.setState(3);
            }
        }
        if (this.state == 2) {
            this.folderEpoch.remove(string);
        }
    }

    private void processFolderSyncUpdate(FolderSyncUpdate folderSyncUpdate) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processFolderSyncUpdate: " + folderSyncUpdate.getFolderUri());
        }
        boolean bl = false;
        SyncElement[] syncElementArray = folderSyncUpdate.getFolderSyncElements();
        if (syncElementArray.length > 0) {
            this.currentResult.updated();
        }
        for (int i = 0; i < syncElementArray.length; ++i) {
            SyncElement syncElement = syncElementArray[i];
            int n = syncElement.getStatus();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, syncElement.getDocumentContentSource().getDocument().getURI() + ": " + n);
            }
            try {
                if (n == 2) {
                    this.repository.create(syncElement.getDocumentContentSource());
                    continue;
                }
                if (n == 1) {
                    syncElement.getDocumentContentSource().getDocument().setOverwrite(true);
                    this.repository.modify(syncElement.getDocumentContentSource());
                    continue;
                }
                if (n == 3) {
                    this.repository.delete(syncElement.getDocumentContentSource().getDocument().getURI());
                    continue;
                }
                Tr.warning(tc, "ADMS0009W", syncElement);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.sync.NodeSyncTask.processFolderSyncUpdate", "405", this);
                Tr.service(tc, "ADMS0020E", new Object[]{syncElement.getDocumentContentSource().getDocument().getURI(), exception});
                bl = true;
                this.setState(3);
            }
        }
        if (!bl) {
            this.getFolderEpoch().put(folderSyncUpdate.getFolderUri(), folderSyncUpdate.getFolderEpoch());
        }
    }

    private FolderSyncRequest generateFolderSyncRequest(ConfigChangeNotifier configChangeNotifier) throws AdminException {
        FolderSyncRequest folderSyncRequest = new FolderSyncRequest(configChangeNotifier.getUri());
        if (configChangeNotifier.getChangeType() == 2) {
            String[] stringArray = this.repository.listResourceNames(configChangeNotifier.getUri(), 1, 1);
            for (int i = 0; i < stringArray.length; ++i) {
                folderSyncRequest.setDocumentDigest(stringArray[i], this.repository.getDigest(stringArray[i]));
            }
        }
        return folderSyncRequest;
    }

    private HashMap getFolderEpoch() {
        if (this.folderEpoch == null && this.nodeSync.isHotRestartSyncEnabled()) {
            this.loadFolderEpochFromFile();
        }
        if (this.folderEpoch == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new folder epoch map");
            }
            this.folderEpoch = new HashMap();
            String[] stringArray = this.repository.listResourceNames("/", 2, Integer.MAX_VALUE);
            this.folderEpoch.put("/", null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith(".repository") || stringArray[i].startsWith("templates")) continue;
                this.folderEpoch.put(stringArray[i], null);
            }
        }
        return this.folderEpoch;
    }

    private void loadFolderEpochFromFile() {
        String string;
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadFolderEpochFromFile");
        }
        if (!(vector = EpochFileHelper.loadEpochFromFile(string = this.getEpochFileDir() + "nodeagentFolderLevel.epoch")).isEmpty()) {
            this.folderEpoch = new HashMap();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.length() <= 0) continue;
                int n = string2.indexOf(61);
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                this.folderEpoch.put(string3, new ConfigEpoch(string4));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Loading from file into epochs: epoch = " + string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadFolderEpochFromFile");
        }
    }

    public void persistFolderLevelEpochs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistFolderLevelEpochs: ");
        }
        if (this.folderEpoch == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "folderEpoch is null, no need to persist anything");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistFolderLevelEpochs");
            }
            return;
        }
        String string = this.getEpochFileDir() + "nodeagentFolderLevel.epoch";
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.folderEpoch.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String string2 = this.folderEpoch.get(k).toString();
            vector.add(k.toString() + "=" + string2);
        }
        EpochFileHelper.persistEpochData(string, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistFolderLevelEpochs");
        }
    }

    private ConfigEpoch loadNodeGlobalEpochFromFile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadNodeGlobalEpochFromFile");
        }
        ConfigEpoch configEpoch = null;
        String string = this.getEpochFileDir() + "nodeGlobal.epoch";
        Vector vector = EpochFileHelper.loadEpochFromFile(string);
        if (!vector.isEmpty()) {
            configEpoch = new ConfigEpoch((String)vector.firstElement());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading cell epoch from file: epoch = " + configEpoch.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadNodeGlobalEpochFromFile");
        }
        return configEpoch;
    }

    public void persistNodeGlobalEpoch() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistNodeGlobalEpoch: ");
        }
        String string = this.getEpochFileDir() + "nodeGlobal.epoch";
        Vector<String> vector = new Vector<String>();
        if (this.nodeGlobalEpoch != null) {
            vector.add(this.nodeGlobalEpoch.toString());
        }
        EpochFileHelper.persistEpochData(string, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistNodeGlobalEpoch");
        }
    }

    public String getEpochFileDir() {
        String string;
        if (this.epochDir == null && (string = System.getProperty("user.install.root")) != null && !string.equals("")) {
            String string2 = AdminServiceFactory.getAdminService().getProcessName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminServiceFactory.getAdminService().getProcessName() = " + string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "System property user.intsall.root = " + string);
            }
            this.epochDir = string + File.separator + "logs" + File.separator + string2 + File.separator;
        }
        return this.epochDir;
    }

    private synchronized void setState(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setState: " + n);
        }
        this.state = n;
        this.notifyAll();
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onRepositoryEpochRefresh() {
        this.folderEpochInvalid = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Received repository epoch refresh notification");
        }
    }

    private void logWTO(String string, String string2) {
        LoggerHelper.addExtension(logger, "handler_preference", "operator");
        logger.logp(WsLevel.INFO, CLASSNAME, string, string2);
        LoggerHelper.removeExtension(logger, "handler_preference");
    }
}

