/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SyncResult
implements Serializable {
    private static final long serialVersionUID = 3288474355450479721L;
    private static TraceComponent tc;
    private static final String DATE_PROPERTY = "com.ibm.ws.management.sync.DateFormat";
    private static final String DATE_FORMAT_12HR = "yyyy.MM.dd 'at' hh:mm:ss:SSS a zzz";
    private static final String DATE_FORMAT_24HR = "yyyy.MM.dd 'at' HH:mm:ss:SSS zzz";
    private static final String DATE_FORMAT_DEFAULT = "yyyy.MM.dd 'at' hh:mm:ss:SSS zzz";
    private static SimpleDateFormat formatter;
    private long initTime = 0L;
    private long completeTime = 0L;
    public static final int IN_PROGRESS = 0;
    public static final int COMPLETE = 1;
    public static final int NOT_VERIFIED = 2;
    public static final int OUT_OF_SYNC = 3;
    public static final int ERROR = 4;
    private int result;
    private boolean updated;

    SyncResult() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SyncResult");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SyncResult");
        }
    }

    public int getResult() {
        return this.result;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }

    public boolean isSuccessful() {
        return this.result == 1 || this.result == 2;
    }

    void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.initTime = System.currentTimeMillis();
        this.completeTime = 0L;
        this.updated = false;
        this.result = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    void updated() {
        this.updated = true;
    }

    void setResult(int n) {
        this.result = n;
        this.completeTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("initiate time: ").append(formatter.format(new Date(this.initTime))).append('\n');
        if (this.completeTime > 0L) {
            stringBuffer.append("complete time: ").append(formatter.format(new Date(this.completeTime))).append('\n');
        }
        stringBuffer.append("result: ");
        switch (this.result) {
            case 0: {
                stringBuffer.append("In Progress");
                break;
            }
            case 1: {
                stringBuffer.append("Complete");
                break;
            }
            case 4: {
                stringBuffer.append("Error");
                break;
            }
            case 2: {
                stringBuffer.append("Not Verfied");
                break;
            }
            case 3: {
                stringBuffer.append("Out of Sync");
            }
        }
        stringBuffer.append("\n");
        if (this.updated) {
            stringBuffer.append("Update occurred\n");
        } else {
            stringBuffer.append("No update occurred.\n");
        }
        return stringBuffer.toString();
    }

    static {
        block12: {
            tc = Tr.register(SyncResult.class, "Sync", "com.ibm.ws.management.resources.sync");
            formatter = null;
            try {
                String string = System.getProperty(DATE_PROPERTY);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Value for system property 'com.ibm.ws.management.sync.DateFormat' is " + (string == null ? "<null>" : "'" + string + "'"));
                }
                if (string != null) {
                    if (string.equalsIgnoreCase("12hr")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using 12 hour date format");
                        }
                        formatter = new SimpleDateFormat(DATE_FORMAT_12HR);
                    } else if (string.equalsIgnoreCase("24hr")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using 24 hour date format");
                        }
                        formatter = new SimpleDateFormat(DATE_FORMAT_24HR);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Ignoring unrecognized system property value");
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception getting system property 'com.ibm.ws.management.sync.DateFormat': " + exception, exception);
            }
        }
        if (formatter == null) {
            formatter = new SimpleDateFormat(DATE_FORMAT_DEFAULT);
        }
    }
}

