/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tam.application.client;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.security.AuthorizationConfig;
import com.ibm.websphere.models.config.security.AuthorizationProvider;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.tam.application.JaccUtil;
import com.ibm.ws.management.tam.application.TAMLogger;
import com.tivoli.pd.as.jacc.TAMPolicy;
import com.tivoli.pd.as.jacc.cfg.TAMConfigStringGenerator;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.rbpf.AmasSession;
import com.tivoli.pd.as.util.AmasMessage;
import com.tivoli.pd.as.util.AmasPDHelper;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class TAMJACCAppInstallSyncTask
extends AbstractAppSyncTask {
    private final String TAMJACCAppInstallSyncTask_java_sourceCodeID = "$Id: @(#)41  1.6 src/ws/code/tam/src/com/ibm/ws/management/tam/application/client/TAMJACCAppInstallSyncTask.java, amemb.jacc.gui, amemb600, 051118a 05/03/01 23:31:10 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected static TAMLogger logger = TAMLogger.getLogger(class$com$ibm$ws$management$tam$application$client$TAMJACCAppInstallSyncTask == null ? (class$com$ibm$ws$management$tam$application$client$TAMJACCAppInstallSyncTask = TAMJACCAppInstallSyncTask.class$("com.ibm.ws.management.tam.application.client.TAMJACCAppInstallSyncTask")) : class$com$ibm$ws$management$tam$application$client$TAMJACCAppInstallSyncTask);
    private static final String REPOSITORY_CELLS = "cells";
    private static final String REPOSITORY_NODES = "nodes";
    private static final String SECURITY_FILE = "security.xml";
    private static final String TAM_CLASS_NAME = "com.tivoli.pd.as.jacc.TAMPolicy";
    private static final String NULL_OBJ_STRING_GEN = "TAMConfigStringGenerator";
    private static final String NULL_OBJ_AMAS_SESSION = "AmasSession";
    private static final String NULL_OBJ_PD_SERVER_NAME = "pdAppServName";
    private static final String NULL_OBJ_NEWSIMAP = "_newSIMap";
    private static final String NULL_OBJ_NEW_APP_DATA = "newAppData.getAppName()";
    private static final String NULL_OBJ_SERV_VECTOR = "ServerNames vector";
    private static boolean _hasDMGRBeenChecked = false;
    private static boolean _isDMGR = false;
    static /* synthetic */ Class class$com$ibm$ws$management$tam$application$client$TAMJACCAppInstallSyncTask;

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        block14: {
            logger.entry("performTask");
            try {
                Object object;
                if (this.isDMGR() || !this.isJACCandTAM()) break block14;
                String string = null;
                TAMConfigStringGenerator tAMConfigStringGenerator = TAMConfigUtils.getStringGeneratorForCtx();
                string = NULL_OBJ_STRING_GEN;
                if (tAMConfigStringGenerator != null) {
                    object = TAMPolicy.getSess();
                    string = NULL_OBJ_AMAS_SESSION;
                    if (object != null) {
                        string = NULL_OBJ_NEWSIMAP;
                        if (this._newSIMap != null) {
                            string = NULL_OBJ_NEW_APP_DATA;
                            if (appData2 != null) {
                                Vector vector = (Vector)this._newSIMap.get(appData2.getAppName());
                                string = NULL_OBJ_SERV_VECTOR;
                                if (vector != null) {
                                    Enumeration enumeration = vector.elements();
                                    while (enumeration.hasMoreElements()) {
                                        Object object2;
                                        String string2 = (String)enumeration.nextElement();
                                        logger.debug("performTask", "About to attempt TAM db refresh for WAS server " + string2);
                                        try {
                                            String string3 = tAMConfigStringGenerator.getFileFromTemplate("${WAS_PROFILES_ROOT}/etc/tam/amwas.${NODE_NAME}_${SERVER_NAME}.pdperm.properties", string2);
                                            logger.debug("performTask", "PdPerm filename retrieved for server " + string2 + " is " + string3);
                                            if (string3 != null) {
                                                object2 = new URL(TAMConfigUtils.filenameToURL(string3));
                                                String string4 = AmasPDHelper.getPDServerName((URL)object2);
                                                logger.debug("performTask", "Calling policyRefresh() on " + string4);
                                                ((AmasSession)object).policyRefresh(string4);
                                            }
                                        }
                                        catch (Exception exception) {
                                            object2 = new AmasMessage(864296961, exception.toString());
                                            logger.error("performTask", ((AmasMessage)object2).getMessageString());
                                        }
                                        try {
                                            if (!TAMConfigUtils.isZOS()) continue;
                                            logger.debug("performTask", "Calling policyRefresh for ZOS servants.");
                                            TAMConfigUtils.refreshServants((AmasSession)object, string2);
                                        }
                                        catch (Exception exception) {
                                            object2 = new AmasMessage(864296961, exception.toString());
                                            logger.error("performTask", ((AmasMessage)object2).getMessageString());
                                        }
                                    }
                                    string = null;
                                }
                            }
                        }
                    }
                }
                if (string != null) {
                    object = new AmasMessage(864636992, string);
                    logger.error("performTask", ((AmasMessage)object).getMessageString());
                }
            }
            catch (Exception exception) {
                AmasMessage amasMessage = new AmasMessage(864296961, exception.toString());
                logger.error("performTask", amasMessage.getMessageString());
            }
        }
        logger.exit("performTask");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJACCandTAM() throws RepositoryException, IOException, Exception {
        boolean bl;
        block10: {
            logger.entry("isJACCandTAM");
            bl = false;
            if (!JaccUtil.hasTamBeenChecked()) {
                Security security2 = null;
                String string = null;
                Resource resource = null;
                try {
                    Object object;
                    String string2 = System.getProperty("file.separator");
                    StringBuffer stringBuffer = new StringBuffer(REPOSITORY_CELLS);
                    stringBuffer.append(string2);
                    stringBuffer.append(this._cellName);
                    stringBuffer.append(string2);
                    stringBuffer.append(SECURITY_FILE);
                    logger.debug("isJACCandTAM", "Extracting " + stringBuffer.toString() + " from repository");
                    DocumentContentSource documentContentSource = this._repository.extract(stringBuffer.toString());
                    string = "DocumentContentSource";
                    if (documentContentSource != null) {
                        object = new WASResourceSetImpl();
                        URI uRI = URI.createURI((String)SECURITY_FILE);
                        resource = object.createResource(uRI);
                        HashMap hashMap = new HashMap();
                        resource.load(documentContentSource.getSource(), hashMap);
                        security2 = (Security)resource.getContents().get(0);
                        string = "Security";
                        if (security2 != null) {
                            AuthorizationConfig authorizationConfig = security2.getAuthConfig();
                            string = "AuthorizationConfig";
                            if (authorizationConfig != null) {
                                if (authorizationConfig.isUseJACCProvider()) {
                                    AuthorizationProvider authorizationProvider;
                                    logger.debug("isJACCandTAM", "AuthConfig UseJACCProvider : true");
                                    EList eList = authorizationConfig.getAuthorizationProviders();
                                    if (!eList.isEmpty() && (authorizationProvider = (AuthorizationProvider)eList.get(0)).getJ2eePolicyImplClassName().equals(TAM_CLASS_NAME)) {
                                        bl = true;
                                    }
                                    logger.debug("isJACCandTAM", "Using TAM AuthProvider : " + bl);
                                }
                                string = null;
                            }
                        }
                        JaccUtil.setIsTamEnabled(bl);
                    }
                    if (string != null) {
                        object = new AmasMessage(864636992, string);
                        logger.error("isJACCandTAM", ((AmasMessage)object).getMessageString());
                    }
                    Object var15_14 = null;
                    if (resource == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    if (resource != null) {
                        resource.unload();
                        resource = null;
                    }
                    throw throwable;
                }
                resource.unload();
                resource = null;
            }
        }
        bl = JaccUtil.isTAM(null, null);
        logger.exit("isJACCandTAM", new Boolean(bl));
        return bl;
    }

    private boolean isDMGR() throws RepositoryException, IOException, Exception {
        logger.entry("isDMGR");
        if (!_hasDMGRBeenChecked) {
            if (!this._isLocal) {
                String string;
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null && (string = adminService.getProcessType()) != null) {
                    if (string.equals("DeploymentManager")) {
                        logger.debug("isDMGR", "Process type is Deployment Manager.");
                        _isDMGR = true;
                    }
                    _hasDMGRBeenChecked = true;
                }
            } else {
                if (!this._isStandAlone) {
                    _isDMGR = true;
                }
                _hasDMGRBeenChecked = true;
            }
        }
        logger.exit("isDMGR", new Boolean(_isDMGR));
        return _isDMGR;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

