/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tam.application.client;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import com.ibm.ws.management.tam.application.JaccUtil;
import com.ibm.ws.management.tam.application.TAMLogger;
import com.ibm.ws.management.tam.application.client.TAMMapRolesToUsers;
import com.tivoli.pd.as.jacc.admin.JACCAdmin;
import com.tivoli.pd.as.jacc.admin.JACCAdminMgr;
import com.tivoli.pd.as.jacc.admin.MgmtContext;
import com.tivoli.pd.as.jacc.cfg.TAMConfigUtils;
import com.tivoli.pd.as.jacc.util.JACCException;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class TAMMapRolesToUsersHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private final String TAMMapRolesToUsersHelper_java_sourceCodeID = "$Id: @(#)30  1.15 src/ws/code/tam/src/com/ibm/ws/management/tam/application/client/TAMMapRolesToUsersHelper.java, amemb.jacc.gui, amemb600, 060111a 06/01/06 08:59:34 @(#) $";
    public static final String sCopyright = "IBM Confidential\nObject Code Only Source Materials\n5747-SM3\n(c) Copyright International Business Machines Corp. 1994-2002.  All Rights Reserved.\nThe source code for this program is not published or otherwise divested\nof its trade secrets, irrespective of what has been deposited with the\nU.S. Copyright Office.\n";
    protected static TAMLogger logger = TAMLogger.getLogger(class$com$ibm$ws$management$tam$application$client$TAMMapRolesToUsersHelper == null ? (class$com$ibm$ws$management$tam$application$client$TAMMapRolesToUsersHelper = TAMMapRolesToUsersHelper.class$("com.ibm.ws.management.tam.application.client.TAMMapRolesToUsersHelper")) : class$com$ibm$ws$management$tam$application$client$TAMMapRolesToUsersHelper);
    protected static final String CLASSNAME = "TAMMapRolesToUsersHelper";
    protected static final String JACC_ADMIN_KEY = "TAMMapRolesToUsers";
    private ConfigService configService_ = null;
    private Session configSession_ = null;
    protected static final String groupNameForEveryone_ = JACCAdminMgr.getGroupNameForEveryone();
    protected static final String groupNameForAllAuthenticated_ = JACCAdminMgr.getGroupNameForAllAuthenticated();
    static /* synthetic */ Class class$com$ibm$ws$management$tam$application$client$TAMMapRolesToUsersHelper;
    static /* synthetic */ Class class$com$ibm$websphere$management$application$client$AppDeploymentController;

    public ConfigService getConfigService() {
        return this.configService_;
    }

    public Session getConfigSession() {
        return this.configSession_;
    }

    public JACCAdmin getJACCAdmin() throws Exception {
        Object object;
        logger.entry("getJACCAdmin");
        JACCAdmin jACCAdmin = null;
        try {
            jACCAdmin = JACCAdminMgr.getInstance(JACC_ADMIN_KEY);
            if (jACCAdmin == null) {
                object = new Properties();
                FileInputStream fileInputStream = new FileInputStream(TAMConfigUtils.getAMJACCConfigFilename());
                ((Properties)object).load(fileInputStream);
                jACCAdmin = JACCAdminMgr.initialize(JACC_ADMIN_KEY, (Properties)object, TAMConfigUtils.getAMJACCAuthnCfgFilename());
                if (jACCAdmin == null) {
                    jACCAdmin = JACCAdminMgr.getInstance(JACC_ADMIN_KEY);
                }
            }
        }
        catch (JACCException jACCException) {
            logger.debug("getJACCAdmin", "Unable to initialize JACCAdminMgr. ", jACCException);
            jACCException.printStackTrace();
            throw new Exception(jACCException.toString());
        }
        catch (Exception exception) {
            logger.debug("getJACCAdmin", "Unable to load TAM JACC configuration: ", exception);
            exception.printStackTrace();
            throw exception;
        }
        if (jACCAdmin == null) {
            object = "Unable to create TAM JACCAdminMgr.";
            logger.error("getJACCAdmin", (String)object);
            throw new Exception((String)object);
        }
        logger.exit("getJACCAdmin");
        return jACCAdmin;
    }

    public MgmtContext getMgmtContext(AppDeploymentTask appDeploymentTask) throws Exception {
        Object object;
        logger.entry("getMgmtContext");
        MgmtContext mgmtContext = null;
        String string = null;
        try {
            String string2;
            string = appDeploymentTask.getAppDeploymentController().getAppOptions().get("appname").toString();
            logger.debug("getMgmtContext", "App name is " + string);
            object = appDeploymentTask.getAppDeploymentController().getAppOptions().get("edition");
            if (object != null) {
                string2 = object.toString();
                if (string2 != null) {
                    string = EditionHelper.getCompositeName(string, string2);
                }
                logger.debug("getMgmtContext", "XD App name is " + string);
            } else {
                logger.debug("getMgmtContext", "No app edition ");
            }
            if (string != null) {
                this.configService_ = appDeploymentTask.getAppDeploymentController().getConfigService();
                this.configSession_ = appDeploymentTask.getAppDeploymentController().getConfigSession();
                string2 = JaccUtil.getAppContextID(this.configService_, this.configSession_, string);
                logger.debug("getMgmtContext", "AppContextID is " + string2);
                if (string2 == null) {
                    String string3 = "Null contextid from WAS";
                    logger.error("getMgmtContext", string3);
                    throw new Exception(string3);
                }
                mgmtContext = new MgmtContext(string2);
            }
        }
        catch (Exception exception) {
            String string4 = "Unable to create mgmt context base on ID. ";
            logger.error("getMgmtContext", string4);
            throw exception;
        }
        if (mgmtContext == null) {
            object = "Unable to create TAM JACC context.";
            logger.error("getMgmtContext", (String)object);
            throw new Exception((String)object);
        }
        logger.exit("getMgmtContext");
        return mgmtContext;
    }

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        logger.entry("createTask");
        try {
            String string2 = this.getClass().getName();
            int n = string2.lastIndexOf("Helper");
            Class<?> clazz = Class.forName(string2.substring(0, n));
            Constructor<?> constructor = clazz.getDeclaredConstructor(class$com$ibm$websphere$management$application$client$AppDeploymentController == null ? (class$com$ibm$websphere$management$application$client$AppDeploymentController = TAMMapRolesToUsersHelper.class$("com.ibm.websphere.management.application.client.AppDeploymentController")) : class$com$ibm$websphere$management$application$client$AppDeploymentController);
            this.configSession_ = appDeploymentController.getConfigSession();
            this.configService_ = appDeploymentController.getConfigService();
            return (AppDeploymentTask)constructor.newInstance(appDeploymentController);
        }
        catch (Exception exception) {
            logger.debug("createTask", "Error instantiating task" + exception);
            exception.printStackTrace();
            logger.exit("createTask");
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        logger.entry("prepareTask");
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = appDeploymentTask.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        appDeploymentTask.setTaskData(util.buildTaskData(vector, stringArray.length));
        try {
            MgmtContext mgmtContext = this.getMgmtContext(appDeploymentTask);
            if (mgmtContext == null) {
                logger.error("prepareTask", "Unable to create management context");
                logger.exit("prepareTask");
                return;
            }
            JACCAdmin jACCAdmin = this.getJACCAdmin();
            if (jACCAdmin == null) {
                logger.error("prepareTask", "Unable to create admin context interface");
                logger.exit("prepareTask");
                return;
            }
            String[] stringArray2 = jACCAdmin.getRoles(mgmtContext);
            logger.debug("prepareTask", "Roles : " + Arrays.asList(stringArray2));
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].equals("Unchecked") || stringArray2[i].equals("Excluded") || stringArray2[i].equals("DenyAllRole")) continue;
                this.addTaskData(jACCAdmin, mgmtContext, vector, stringArray2[i]);
            }
        }
        catch (JACCException jACCException) {
            logger.error("prepareTask", "Unable to retrieve role bindings " + jACCException);
            throw new AppDeploymentException(util.getMessage(appDeploymentTask, "CWWJA0001E"), jACCException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AppDeploymentException(util.getMessage(appDeploymentTask, "CWWJA0002E"), exception);
        }
        try {
            if (vector.size() > 0) {
                appDeploymentTask.setTaskData(util.buildTaskData(vector, stringArray.length));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AppDeploymentException(util.getMessage(appDeploymentTask, "CWWJA0003E"), exception);
        }
        logger.exit("prepareTask");
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        logger.entry("completeTask");
        if (appDeploymentInfo.getApplication() == null) {
            logger.exit("completeTask");
            return;
        }
        if (appDeploymentTask.isTaskEmpty()) {
            logger.debug("completeTask", "Empty task");
            logger.exit("completeTask");
            return;
        }
        MgmtContext mgmtContext = null;
        JACCAdmin jACCAdmin = null;
        String[] stringArray = null;
        try {
            mgmtContext = this.getMgmtContext(appDeploymentTask);
            if (mgmtContext == null) {
                logger.debug("completeTask", "Unable to create management context");
                logger.exit("completeTask");
                return;
            }
            jACCAdmin = this.getJACCAdmin();
            if (jACCAdmin == null) {
                logger.debug("completeTask", "Unable to create admin context interface");
                logger.exit("completeTask");
                return;
            }
            stringArray = jACCAdmin.getRoles(mgmtContext);
        }
        catch (JACCException jACCException) {
            logger.error("completeTask", "Unable to retrieve role bindings");
            throw new AppDeploymentException(util.getMessage(appDeploymentTask, "CWWJA0001E"), jACCException);
        }
        catch (Exception exception) {
            logger.error("completeTask", "Unable to retrieve role bindings");
            throw new AppDeploymentException(util.getMessage(appDeploymentTask, "CWWJA0001E"), exception);
        }
        if (stringArray == null) {
            logger.exit("completeTask");
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = null;
                String[][] stringArray3 = appDeploymentTask.getTaskData();
                TAMMapRolesToUsers tAMMapRolesToUsers = (TAMMapRolesToUsers)appDeploymentTask;
                for (int j = 0; j < stringArray3.length; ++j) {
                    if (stringArray3[j].length <= 0) continue;
                    if (!stringArray3[j][0].equals(stringArray[i])) continue;
                    stringArray2 = stringArray3[j];
                    break;
                }
                if (stringArray2 == null) {
                    logger.debug("completeTask", "No matching task data for role " + stringArray[i]);
                    continue;
                }
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (stringArray2.length > 1) {
                    string = stringArray2[1];
                }
                if (stringArray2.length > 2) {
                    string2 = stringArray2[2];
                }
                if (stringArray2.length > 3) {
                    string3 = stringArray2[3];
                }
                if (stringArray2.length > 4) {
                    string4 = stringArray2[4];
                }
                this.updateAuthTable(jACCAdmin, mgmtContext, stringArray[i], string, string2, string3, string4);
            }
        }
        catch (JACCException jACCException) {
            logger.debug("completeTask", "JACCAdmin exception updating auth table: " + jACCException);
            String string = util.getMessage(appDeploymentTask, "CWWJA0004E");
            throw new AppDeploymentException(string, jACCException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AppDeploymentException(util.getMessage(appDeploymentTask, "CWWJA0004E"), exception);
        }
        logger.exit("completeTask");
    }

    private void updateAuthTable(JACCAdmin jACCAdmin, MgmtContext mgmtContext, String string, String string2, String string3, String string4, String string5) throws JACCException {
        String[] stringArray;
        StringTokenizer stringTokenizer;
        String[] stringArray2;
        logger.entry("updateAuthTable");
        if (jACCAdmin == null) {
            logger.debug("updateAuthTable", "Admin context is null.");
            logger.exit("updateAuthTable");
            return;
        }
        if (mgmtContext == null) {
            logger.debug("updateAuthTable", "Management context is null.");
            logger.exit("updateAuthTable");
            return;
        }
        try {
            stringArray2 = jACCAdmin.getPrincipalsForRole(mgmtContext, string);
            logger.debug("updateAuthTable", "Removing all users from " + string + ":" + Arrays.asList(stringArray2));
            jACCAdmin.removePrincipalsFromRole(mgmtContext, string, stringArray2);
            if (string4 != null && !string4.trim().equals("")) {
                stringTokenizer = new StringTokenizer(string4, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray = new String[]{stringTokenizer.nextToken().trim()};
                    logger.debug("updateAuthTable", "Adding user " + stringArray[0] + " to role " + string);
                    jACCAdmin.addPrincipalsToRole(mgmtContext, string, stringArray);
                }
            }
        }
        catch (JACCException jACCException) {
            logger.debug("updateAuthTable", "Unable to update auth table: ", jACCException);
            jACCException.printStackTrace();
            throw jACCException;
        }
        try {
            stringArray2 = jACCAdmin.getGroupsForRole(mgmtContext, string);
            logger.debug("updateAuthTable", "Removing all groups from " + string + ":" + Arrays.asList(stringArray2));
            jACCAdmin.removeGroupsFromRole(mgmtContext, string, stringArray2);
            if (string5 != null && !string5.trim().equals("")) {
                stringTokenizer = new StringTokenizer(string5, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray = new String[]{stringTokenizer.nextToken().trim()};
                    logger.debug("updateAuthTable", "Adding group " + stringArray + " to role " + string);
                    jACCAdmin.addGroupsToRole(mgmtContext, string, stringArray);
                }
            }
        }
        catch (JACCException jACCException) {
            logger.debug("updateAuthTable", "Unable to update auth table: ", jACCException);
            jACCException.printStackTrace();
            throw jACCException;
        }
        try {
            stringArray2 = new String[1];
            if (string2 != null && !string2.trim().equals("")) {
                stringArray2[0] = groupNameForEveryone_;
                if (string2.equals("AppDeploymentOption.Yes")) {
                    logger.debug("updateAuthTable", "Adding Everyone group " + stringArray2[0] + " to role " + string);
                    jACCAdmin.addGroupsToRole(mgmtContext, string, stringArray2);
                }
            }
            if (string3 != null && !string3.trim().equals("")) {
                stringArray2[0] = groupNameForAllAuthenticated_;
                if (string3.equals("AppDeploymentOption.Yes")) {
                    logger.debug("updateAuthTable", "Adding AllAuthenticated group " + stringArray2[0] + " to role " + string);
                    jACCAdmin.addGroupsToRole(mgmtContext, string, stringArray2);
                }
            }
        }
        catch (JACCException jACCException) {
            logger.debug("updateAuthTable", "Unable to update auth table: ", jACCException);
            jACCException.printStackTrace();
            throw jACCException;
        }
        logger.exit("updateAuthTable");
    }

    protected void addTaskData(JACCAdmin jACCAdmin, MgmtContext mgmtContext, Vector vector, String string) throws AppDeploymentException {
        logger.entry("addTaskData");
        vector.addElement(string);
        StringBuffer stringBuffer = null;
        try {
            int n;
            String string2 = "AppDeploymentOption.No";
            String string3 = "AppDeploymentOption.No";
            String[] stringArray = jACCAdmin.getGroupsForRole(mgmtContext, string);
            logger.debug("addTaskData", "Current groups for role " + string + " " + Arrays.asList(stringArray));
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(JACCAdminMgr.getGroupNameForEveryone())) {
                    string2 = "AppDeploymentOption.Yes";
                    continue;
                }
                if (!stringArray[i].equals(JACCAdminMgr.getGroupNameForAllAuthenticated())) continue;
                string3 = "AppDeploymentOption.Yes";
            }
            vector.addElement(string2);
            vector.addElement(string3);
            stringBuffer = null;
            String[] stringArray2 = jACCAdmin.getPrincipalsForRole(mgmtContext, string);
            logger.debug("addTaskData", "Current users for role " + string + " " + Arrays.asList(stringArray2));
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append("| ");
                }
                stringBuffer.append(stringArray2[n]);
            }
            if (stringBuffer == null) {
                vector.addElement("");
            } else {
                vector.addElement(stringBuffer.toString());
            }
            stringBuffer = null;
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals(JACCAdminMgr.getGroupNameForEveryone()) || stringArray[n].equals(JACCAdminMgr.getGroupNameForAllAuthenticated())) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append("| ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringBuffer == null) {
                vector.addElement("");
            } else {
                vector.addElement(stringBuffer.toString());
            }
        }
        catch (JACCException jACCException) {
            logger.debug("addTaskData", "Unable to add task data: ", jACCException);
            jACCException.printStackTrace();
            throw new AppDeploymentException("", jACCException);
        }
        logger.exit("addTaskData");
    }

    public Hashtable getXPathInfo(Vector vector) {
        return null;
    }

    public void taskData2DCBean(AppDeploymentTask appDeploymentTask, DConfigBeanImpl dConfigBeanImpl, String string) {
        logger.entry("taskData2DCBean ");
        J2EEDeployUtil.task2DC(appDeploymentTask, dConfigBeanImpl, new String[]{dConfigBeanImpl.getDDBean().getText()}, new int[]{0}, false);
        logger.exit("taskData2DCBean ");
    }

    public void dcBean2TaskData(AppDeploymentTask appDeploymentTask, Hashtable hashtable, Hashtable hashtable2) {
        logger.entry("dcBean2TaskData ");
        J2EEDeployUtil.dcBean2TaskData(appDeploymentTask, hashtable, hashtable2);
        logger.exit("dcBean2TaskData ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

