/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandMgrInitializer;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.RepositoryService;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.CellType;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.util.EncodingUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.management.tools.ExtensionChecker;
import com.ibm.wsspi.management.tools.NodeSideExtensionChecker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public abstract class AbstractNodeConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register(AbstractNodeConfigUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    protected static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    protected String connType = "SOAP";
    protected String connHost = null;
    protected String connPort = null;
    protected AdminClient adminClient = null;
    protected ObjectName notificationService = null;
    protected Properties notificationUserData = null;
    protected String netmgrName = null;
    private ConfigServiceProxy configService = null;
    private WASProduct wasProduct = null;
    private Object addOrRemoveNodeToken = null;
    private boolean zos = false;
    private boolean zos_set = false;

    protected abstract VariableMap getVariableMap() throws Exception;

    protected abstract Repository getLocalRepository() throws Exception;

    protected void toolFailed() {
        try {
            this.completeAddOrRemoveNode();
        }
        catch (Exception exception) {
            this.issueMessage("ADMU0042E", null, null);
        }
    }

    protected boolean isMemberOfCell() throws Exception {
        Resource resource = this.getResource("cells/" + this.cellName + "/cell.xml", "cell.xml");
        Cell cell = (Cell)resource.getContents().get(0);
        return cell.getCellType().equals(CellType.DISTRIBUTED_LITERAL);
    }

    private Resource getResource(String string, String string2) throws Exception {
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(0, string2);
        return resource;
    }

    protected Properties getClientProperties() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("type", this.connType);
        properties.setProperty("host", this.connHost);
        properties.setProperty("port", this.connPort);
        properties.setProperty("nodeName", this.nodeName);
        properties.setProperty("cellName", this.cellName);
        properties.setProperty("was.install.root", System.getProperty("was.install.root"));
        properties.setProperty("user.install.root", this.getUserInstallRootIfSetElseGetWasInstallRoot());
        properties.setProperty("location", "remote");
        if (this.userid != null) {
            properties.setProperty("username", this.userid);
        }
        if (this.pwd != null) {
            properties.setProperty("password", this.pwd);
        }
        return properties;
    }

    protected String getUserInstallRootIfSetElseGetWasInstallRoot() {
        return System.getProperty("user.install.root", System.getProperty("was.install.root"));
    }

    protected AdminClient getAdminClient(Properties properties) throws Exception {
        AdminClient adminClient = null;
        try {
            adminClient = AdminClientFactory.createAdminClient(properties);
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0006E", exception);
            throw exception;
        }
        return adminClient;
    }

    protected ObjectName getMBeanByType(String string) throws Exception {
        return this.getMBeanByType(string, this.getNetmgrName());
    }

    protected ObjectName getMBeanByType(String string, String string2) throws Exception {
        if (this.adminClient == null) {
            return null;
        }
        ObjectName objectName = null;
        try {
            Iterator iterator;
            String string3 = "WebSphere:*,process=" + string2 + ",type=" + string;
            ObjectName objectName2 = new ObjectName(string3);
            Set set = this.adminClient.queryNames(objectName2, null);
            if (set.size() != 1) {
                Tr.debug(tc, "There are " + set.size() + " " + string + "s!");
            }
            if ((iterator = set.iterator()).hasNext()) {
                objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " handle is ==> " + objectName.getCanonicalName());
                }
            } else {
                Tr.warning(tc, "ADMU0008E", new Object[]{string, "No ObjectName found."});
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0008E", new Object[]{string, exception});
            throw exception;
        }
        return objectName;
    }

    protected Object invokeMBean(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws Exception {
        Object object = null;
        if (objectName != null) {
            try {
                object = this.adminClient.invoke(objectName, string, objectArray, stringArray);
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMU0040E", new Object[]{objectName, string, exception});
                throw exception;
            }
        }
        return object;
    }

    protected boolean beginAddOrRemoveNode() throws Exception {
        ObjectName objectName = this.getMBeanByType("AdminOperations");
        if (objectName != null) {
            String string = Utils.getProductVersion();
            this.addOrRemoveNodeToken = this.invokeMBean(objectName, "getTokenForNodeFederationOrRemoval", new Object[]{string}, new String[]{"java.lang.String"});
            if (this.addOrRemoveNodeToken == null) {
                return false;
            }
        }
        return true;
    }

    protected void completeAddOrRemoveNode() throws Exception {
        ObjectName objectName;
        if (this.addOrRemoveNodeToken != null && (objectName = this.getMBeanByType("AdminOperations")) != null) {
            this.invokeMBean(objectName, "completeNodeFederationOrRemoval", new Object[]{this.addOrRemoveNodeToken}, new String[]{"java.lang.Object"});
            this.addOrRemoveNodeToken = null;
        }
    }

    protected ObjectName getNotificationServiceMBean() throws Exception {
        String string = "WebSphere:*,type=NotificationService,process=" + this.getNetmgrName();
        try {
            Set set = this.adminClient.queryNames(new ObjectName(string), null);
            if (set.isEmpty()) {
                Tr.error(tc, "ADMU0008E", new Object[]{string, "none"});
                return null;
            }
            this.notificationUserData = new Properties();
            this.notificationUserData.setProperty("nodeName", this.nodeName);
            return (ObjectName)set.iterator().next();
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0008E", new Object[]{string, exception});
            return null;
        }
    }

    protected void copyDocuments(String string, String string2) throws Exception {
        File file = new File(string);
        File file2 = new File(string2);
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.copyDocuments(string + File.separator + fileArray[i].getName(), string2 + File.separator + fileArray[i].getName());
                continue;
            }
            File file3 = new File(string2 + File.separator + fileArray[i].getName());
            this.copyDocument(fileArray[i], file3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDocument(File file, File file2) throws Exception {
        if (file == null || file2 == null) {
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            file2.createNewFile();
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n2 = 2048;
            byte[] byArray = new byte[n2];
            while ((n = inputStream.read(byArray, 0, n2)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    public void fix390SetupCmdLine(String string, String string2) throws Exception {
        File file = new File(string);
        String string3 = null;
        if (file.exists()) {
            Vector<String> vector = new Vector<String>();
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Cp1047"));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line is " + string3);
                }
                if (string3 != null && string3.indexOf("WAS_CELL=") >= 0 && !string3.startsWith("#")) {
                    string3 = string3.substring(0, string3.indexOf("=") + 1) + string2;
                }
                vector.add(string3);
            }
            bufferedReader.close();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1047"));
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                printWriter.println((String)vector.get(i));
            }
            printWriter.flush();
            printWriter.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{string});
        }
    }

    protected void fixSetupCmdLine(String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixSetupCmdLine, cellName=" + string);
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string2);
        Tr.debug(tc, "LaunchScriptCollaborator: " + launchScriptPlatformCollaborator.getClass());
        String string3 = properties.getProperty("user.install.root") + "/bin/setupCmdLine";
        string3 = launchScriptPlatformCollaborator.customizeScriptFilename(string3);
        if (this.isZOS()) {
            this.fix390SetupCmdLine(string3, string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fixSetupCmdLine");
            }
            return;
        }
        File file = new File(string3);
        if (file.exists()) {
            Vector<String> vector = new Vector<String>();
            FileInputStream fileInputStream = new FileInputStream(string3);
            BufferedReader bufferedReader = null;
            String string4 = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned readerencoding = " + string4);
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string4));
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                if (string5.indexOf("WAS_CELL=") >= 0) {
                    if (!string5.startsWith(launchScriptPlatformCollaborator.getPlatformComment())) {
                        string5 = string5.substring(0, string5.indexOf("=") + 1) + string;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "modified WAS_CELL in setupCmdLine: " + string5);
                        }
                    }
                } else if (string5.indexOf("WAS_NODE=") >= 0 && !string5.startsWith(launchScriptPlatformCollaborator.getPlatformComment())) {
                    string5 = string5.substring(0, string5.indexOf("=") + 1) + this.nodeName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "modified WAS_NODE in setupCmdLine: " + string5);
                    }
                }
                vector.add(string5);
            }
            bufferedReader.close();
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "System.getProperty(\"file.encoding\") is: " + System.getProperty("file.encoding"));
            }
            String string6 = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned writer encoding = " + string6);
            }
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string6));
            for (int i = 0; i < vector.size(); ++i) {
                string5 = (String)vector.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line", string5);
                }
                printWriter.println((String)vector.get(i));
            }
            printWriter.flush();
            printWriter.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{string3});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSetupCmdLine");
        }
    }

    protected void removeFromCell(AdminClient adminClient, boolean bl) throws Exception {
        if (adminClient != null) {
            Properties properties = new Properties();
            properties.setProperty("CELL_NAME_KEY", this.cellName);
            properties.setProperty("NODE_NAME_KEY", this.nodeName);
            ObjectName objectName = this.getMBeanByType("AdminOperations");
            if (objectName != null) {
                this.invokeMBean(objectName, "doUnMergeConfigDataOnDmgr", new Object[]{properties}, new String[]{"java.util.Properties"});
            }
            if (bl) {
                this.issueMessage("ADMU2018I", new Object[]{this.nodeName}, null);
            }
        }
    }

    protected void removeFromCell(AdminClient adminClient) throws Exception {
        this.removeFromCell(adminClient, false);
    }

    protected ConfigServiceProxy getConfigService(AdminClient adminClient) throws Exception {
        if (this.configService == null) {
            this.configService = new ConfigServiceProxy(adminClient);
        }
        return this.configService;
    }

    protected void deleteDirs(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteDirs(string + File.separator + fileArray[i].getName());
                }
                fileArray[i].delete();
            }
        }
        file.delete();
    }

    private Properties createPropsWithoutPlainTextPassword(Properties properties) {
        Properties properties2 = new Properties(properties);
        String string = properties2.getProperty("password");
        if (string != null) {
            properties2.setProperty("password", "****");
        }
        return properties2;
    }

    protected void fixWsadminProps(Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixWsadminProps", this.createPropsWithoutPlainTextPassword(properties));
        }
        String string = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string);
        String string2 = null;
        String string3 = System.getProperty("user.install.root");
        string2 = string3 != null ? string3 : properties.getProperty("was.install.root");
        File file = new File(string2 = string2 + "/properties/wsadmin.properties");
        if (file.exists()) {
            Vector vector = new Vector();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            long l = randomAccessFile.getFilePointer();
            while (l < randomAccessFile.length()) {
                try {
                    this.fixWsadminLine(randomAccessFile.readLine(), properties, vector);
                }
                catch (EOFException eOFException) {
                    break;
                }
                l = randomAccessFile.getFilePointer();
            }
            randomAccessFile.close();
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < vector.size(); ++i) {
                fileWriter.write((String)vector.get(i) + launchScriptPlatformCollaborator.getPlatformLineEnd());
            }
            fileWriter.flush();
            fileWriter.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixWsadminProps");
        }
    }

    private void fixWsadminLine(String string, Properties properties, Vector vector) throws IOException {
        if (string != null) {
            if (string.startsWith("com.ibm.ws.scripting.connectionType=")) {
                string = this.makeCorrectLine(string, vector, properties.getProperty("type"));
            } else if (string.startsWith("com.ibm.ws.scripting.port=")) {
                string = this.makeCorrectLine(string, vector, properties.getProperty("port"));
            } else if (string.startsWith("com.ibm.ws.scripting.host=")) {
                string = this.makeCorrectLine(string, vector, properties.getProperty("host"));
            }
        }
        vector.add(string);
    }

    private String makeCorrectLine(String string, Vector vector, String string2) {
        String string3 = string;
        String string4 = string.substring(string.indexOf(61) + 1).trim();
        if (!string4.equals(string2)) {
            this.commentOutLine(string, vector);
            string = string.substring(0, string.indexOf(61) + 1) + string2;
        }
        return string;
    }

    private void commentOutLine(String string, Vector vector) {
        vector.add("#" + string);
    }

    protected WASProduct getWASProduct() {
        if (this.wasProduct == null) {
            this.wasProduct = new WASProduct();
        }
        return this.wasProduct;
    }

    protected void checkProductExtensionsNew(Properties properties, AdminClient adminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkProductExtensionsNew", properties);
        }
        String string = "com.ibm.wsspi.extension.node-side-extension-checker";
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        Properties properties2 = null;
        if (iExtensionPoint == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkProductExtensionsNew - ext point not defined");
            }
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            NodeSideExtensionChecker nodeSideExtensionChecker;
            try {
                nodeSideExtensionChecker = (NodeSideExtensionChecker)iConfigurationElementArray[i].createExecutableExtension("class");
            }
            catch (Exception exception) {
                throw new AdminException("At extension point " + string + ", the extension class " + iConfigurationElementArray[i].getAttribute("class") + " failed to load");
            }
            if (properties2 == null) {
                Object var10_10 = null;
                String string2 = adminClient.getServerMBean().getKeyProperty("node");
                CommandMgrInitializer.initializeClientMode(adminClient);
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("getMetadataProperties");
                adminCommand.setParameter("nodeName", string2);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (!commandResult.isSuccessful()) {
                    throw new Exception(commandResult.getException());
                }
                properties2 = (Properties)commandResult.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Dmgr node metadata:", properties2);
                }
            }
            nodeSideExtensionChecker.checkCompatibility(properties, properties2, adminClient);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProductExtensionsNew");
        }
    }

    protected void checkProductExtensions(WASProduct wASProduct, AdminClient adminClient) throws Exception {
        String string = "com.ibm.wsspi.extension.extension-checker";
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            ExtensionChecker extensionChecker = (ExtensionChecker)iConfigurationElementArray[i].createExecutableExtension("class");
            extensionChecker.checkExtension(wASProduct, adminClient);
        }
    }

    public String getNetmgrName() throws Exception {
        if (this.netmgrName == null) {
            this.netmgrName = Utils.getNetmgrName(this.adminClient);
        }
        return this.netmgrName;
    }

    protected String getBackupRoot(Repository repository2, VariableMap variableMap) {
        String string = null;
        try {
            block11: {
                block10: {
                    string = System.getProperty("was.repository.backup");
                    if (string == null) break block10;
                    if (!(string = string.replace('\\', '/')).endsWith("/")) break block11;
                    string = string.substring(0, string.length() - 1);
                    break block11;
                }
                Resource resource = repository2.getConfigRoot().getResource(4, "server.xml");
                Server server2 = (Server)resource.getContents().get(0);
                EList eList = server2.getServices();
                for (int i = 0; i < eList.size(); ++i) {
                    Service service = (Service)eList.get(i);
                    if (!(service instanceof AdminService)) continue;
                    AdminService adminService = (AdminService)service;
                    RepositoryService repositoryService = adminService.getConfigRepository();
                    EList eList2 = repositoryService.getProperties();
                    for (int j = 0; j < eList2.size(); ++j) {
                        Property property = (Property)eList2.get(j);
                        String string2 = property.getName();
                        String string3 = property.getValue();
                        if (string2 == null || !string2.equals("was.repository.backup") || string3 == null) continue;
                        try {
                            string = variableMap.expand(string3);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.management.tools.NodeRemoveUtility.getBackupRoot", "300", this);
                        }
                    }
                    break;
                }
            }
            if (string == null) {
                string = this.configRoot + "/backup";
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: " + fileNotFoundException.getMessage() + " Setting backupRoot to use default configRoot/backup.");
            }
            string = this.configRoot + "/backup";
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.CellManagerImpl.start", "190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred initializing config: " + exception.getMessage());
            }
            string = this.configRoot + "/backup";
        }
        return string;
    }

    protected VariableMap getVarMap(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVarMap: " + string + ", " + string2 + ", " + string3);
        }
        try {
            Repository repository2 = RepositoryFactory.createRepository("ws-server", string, string2, string3, null);
            VariableMap variableMap = VariableMapFactory.createVariableMap(repository2);
            variableMap.initialize(null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVarMap: " + variableMap);
            }
            return variableMap;
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU2027E", new Object[]{throwable, string, string2, string3}, null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVarMap: NULL returned");
            }
            return null;
        }
    }

    protected void expandEar(String string, Vector vector, VariableMap variableMap) {
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(variableMap.expand((String)vector.elementAt(i)));
        }
        this.expandEar(string, vector2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandEar(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandEar: " + string + ", " + vector);
        }
        if (vector == null || vector.size() == 0) {
            return;
        }
        EARFile eARFile = null;
        try {
            eARFile = EarUtils.getEarFile(string, false, true);
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expanding at: " + vector.elementAt(i));
                    }
                    EarUtils.extractEar(eARFile, (String)vector.elementAt(i), true);
                    continue;
                }
                catch (Throwable throwable) {
                    this.issueMessage("ADMU2028E", new Object[]{throwable, string, vector.elementAt(i)}, null);
                }
            }
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU2029E", new Object[]{throwable, string}, null);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "expandEar: " + string);
            }
            if (eARFile != null) {
                eARFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getDeploymentPaths(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentPaths: " + string);
        }
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        if (!file.exists()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeploymentPaths: " + string + " does not exist.");
            }
            return vector;
        }
        File[] fileArray = file.listFiles();
        ResourceSet resourceSet = this.createResourceSet(string);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            String string2 = fileArray[i].getName() + "/deployment.xml";
            Resource resource = null;
            try {
                String string3;
                URI uRI;
                Deployment deployment;
                ApplicationDeployment applicationDeployment;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading: " + string2);
                }
                if (!(applicationDeployment = (ApplicationDeployment)(deployment = (Deployment)(resource = resourceSet.getResource(uRI = URI.createURI((String)string2), true)).getContents().get(0)).getDeployedObject()).isEnableDistribution() || vector.contains(string3 = applicationDeployment.getBinariesURL().replace('\\', '/'))) continue;
                vector.addElement(string3);
                continue;
            }
            catch (Throwable throwable) {
                this.issueMessage("ADMU2030E", new Object[]{throwable, string + File.pathSeparator + string2}, null);
                continue;
            }
            finally {
                if (resource != null) {
                    resource.unload();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentPaths: " + vector);
                }
            }
        }
        return vector;
    }

    protected ResourceSet createResourceSet(final String string) {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(string + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    protected void terminateAllServers() throws Exception {
        Vector vector = this.getServers();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            String string2 = (String)vector.get(i);
            String string3 = this.getVariableMap().expand("${LOG_ROOT}/" + string2);
            File file = new File(string3, string = string2 + ".pid");
            if (!file.exists()) continue;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = bufferedReader.readLine();
            file.delete();
            Process process = ProcessFactory.bindTo(string4);
            process.stop();
        }
    }

    protected boolean isZOS() {
        if (!this.zos_set) {
            this.zos_set = true;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.zos = true;
            }
        }
        return this.zos;
    }

    protected void transformConfig2Native(String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformConfig2Native");
        }
        String string3 = this.configRoot.substring(0, this.configRoot.lastIndexOf("/config"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "full transformConfig2Native with " + string3 + " and " + string + " and " + string2);
        }
        try {
            AdminServiceImpl.getPlatformUtils().transform(string, string2);
        }
        catch (Exception exception) {
            Tr.error(tc, this.getFormattedMessage("ADMU0011E", new Object[]{exception}, null));
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformConfig2Native");
        }
    }

    class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        public void run() {
            AbstractNodeConfigUtility.this.toolFailed();
        }
    }
}

