/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.profile.WSProfile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.MBeanException;
import javax.management.ObjectName;

public abstract class AdminTool {
    private boolean displayCurrentProfile = true;
    protected Properties adminProperties = new Properties();
    public static String BUNDLE_NAME = "com.ibm.ws.management.resources.nodeutils";
    private static final TraceComponent tc = Tr.register(AdminTool.class, "Admin", BUNDLE_NAME);
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    public static final String ALL_TRACE = "com.ibm.*=all=enabled";
    public static final String TRACE_PROP = "com.ibm.ws.tools.trace.traceString";
    public static final String TRACE_FILE_PROP = "com.ibm.ws.tools.trace.traceFile";
    public static final String DEBUG_PROP = "com.ibm.ws.tools.trace";
    public static final int STATUS_TIMEOUT = 300000;
    public static final int MAX_MSG_LEN = 79;
    public static final String INDENT = "           ";
    protected static final int BAD_OPTION = -1;
    protected static final int EXPECTED_PARAMETER = -2;
    protected static final int INVALID_PARAMETER = -3;
    protected String configRoot;
    protected String cellName;
    protected String nodeName;
    protected boolean nowait = false;
    protected String userid = null;
    protected String pwd = null;
    protected String logfile = null;
    private boolean replacelog = false;
    private boolean trace = false;
    private boolean quiet = false;
    protected boolean help = false;
    private boolean isDoubleByteSystem = false;
    private boolean isDoubleByteTested = false;
    protected boolean parseAndSetTraceCalled = false;
    protected Integer statusPort = null;
    protected ServerSocket statusSocket = null;
    protected int statusTimeout = 0;
    protected boolean invokedByWindowsService = false;
    public static final int BUFFER_SIZE = 1024;
    public static final String[] DO_NOT_COMPRESS_LIST = new String[]{".zip", ".jar", ".ear", ".war", ".rar"};
    private byte[] buffer = new byte[1024];

    protected AdminTool() {
    }

    protected abstract String getDefaultTraceString();

    protected abstract String getDefaultTraceFile();

    protected abstract int getMinimumNumArgs();

    protected abstract void issueUsageMessage();

    protected abstract int parseRequiredArgs(String[] var1) throws AdminException;

    protected abstract int runTool() throws Exception;

    protected void toolFailed(Throwable throwable) {
    }

    protected int executeUtilityWithoutProfileDisplay(String[] stringArray) {
        this.displayCurrentProfile = false;
        int n = this.executeUtility(stringArray);
        this.displayCurrentProfile = true;
        return n;
    }

    protected int parseAndSetTrace(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        try {
            bl = this.parseArgs(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            n = !this.help ? -1 : 12345;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to parse arguments within executeUtility method. Return code " + n + ". Arguments: " + stringArray);
            }
        } else if (!this.setTrace()) {
            n = -1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trace not set within executeUtility method. Return code -1.");
            }
        } else {
            n = 0;
        }
        return n;
    }

    protected int executeUtility(String[] stringArray) {
        int n;
        block13: {
            n = 0;
            if (this.parseAndSetTraceCalled || (n = this.parseAndSetTrace(stringArray)) == 0) {
                if (this.parseAndSetTraceCalled) {
                    String string = this.trace ? ALL_TRACE : "";
                    ManagerAdmin.setTraceState(string);
                }
                if (!this.parseAndSetTraceCalled) {
                    Tr.event(tc, "Executing utility with arguments: " + this.getUtilityArguments(stringArray));
                }
                try {
                    this.displayCurrentProfile();
                    n = this.runTool();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning from auxiliary method runTool with return: " + n);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof MBeanException) {
                        throwable2 = throwable.getCause();
                    }
                    Tr.error(tc, "ADMU0111E", throwable2);
                    this.toolFailed(throwable2);
                    n = -1;
                    int n2 = throwable2.getCause() != null ? this.issueMessage("ADMU0113E", new Object[]{throwable2, AdminTool.getRootCause(throwable2).getMessage()}, null) : this.issueMessage("ADMU0111E", new Object[]{throwable2}, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning from auxiliary method issueMessage with return code: " + n2);
                    }
                    if (this.isMessageInException("ADMN0022E", throwable2)) {
                        n2 = this.issueMessage("ADMU4113E", null, null);
                    } else if (this.isMessageInException("ADMC0016E", throwable2) || this.isMessageInException("ADMC0018E", throwable2)) {
                        n2 = this.issueMessage("ADMU4123E", null, null);
                    }
                    if (!this.trace) {
                        n2 = this.issueMessage("ADMU1211I", null, null);
                    }
                    n2 = this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Returning from auxiliary method issueMessage with return code: " + n2);
                    Tr.debug(tc, "Returning from executeUtility method with return code: " + n);
                }
            }
        }
        if (n == 12345) {
            n = 0;
        }
        return n;
    }

    protected String getUtilityArguments(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (stringArray != null || stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (bl) {
                    stringBuffer.append(" ******** ");
                    bl = false;
                    continue;
                }
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(" ");
                if (stringArray[i].toUpperCase().indexOf("PASSWORD") < 0) continue;
                bl = true;
            }
        }
        return stringBuffer.toString();
    }

    private boolean isMessageInException(String string, Throwable throwable) {
        if (throwable == null || throwable.getMessage() == null) {
            return false;
        }
        if (throwable.getMessage().indexOf(string) >= 0) {
            return true;
        }
        return this.isMessageInException(string, throwable.getCause());
    }

    protected boolean parseArgs(String[] stringArray) throws AdminException {
        if (this.isHelpNeeded(stringArray)) {
            return false;
        }
        if (!this.isGivenMinimumNumArgs(stringArray)) {
            return false;
        }
        this.configRoot = stringArray[0];
        this.cellName = stringArray[1];
        this.nodeName = stringArray[2];
        int n = this.parseRequiredArgs(stringArray);
        if (n < 0) {
            this.issueUsageMessage();
            return false;
        }
        for (int i = n; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-nowait")) {
                this.nowait = true;
                this.adminProperties.setProperty("-nowait", "true");
                continue;
            }
            if (string.equals("-quiet")) {
                this.quiet = true;
                this.adminProperties.setProperty("-quiet", "true");
                continue;
            }
            if (string.equals("-trace")) {
                this.trace = true;
                this.adminProperties.setProperty("-trace", "true");
                continue;
            }
            if (string.equals("-logfile")) {
                if (this.isValidParameter(stringArray, i + 1)) {
                    this.logfile = stringArray[i + 1];
                    ++i;
                    this.adminProperties.setProperty("-logfile", this.logfile);
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            if (string.equals("-replacelog")) {
                this.replacelog = true;
                this.adminProperties.setProperty("-replacelog", "true");
                continue;
            }
            if (string.equals("-username") || string.equals("-user")) {
                if (stringArray.length > i + 1) {
                    this.userid = stringArray[i + 1];
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            if (string.equals("-password")) {
                if (stringArray.length > i + 1) {
                    this.pwd = stringArray[i + 1];
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            if (string.equals("-statusport")) {
                if (this.isValidParameter(stringArray, i + 1)) {
                    this.statusPort = new Integer(stringArray[i + 1]);
                    this.adminProperties.setProperty("-statusport", this.statusPort.toString());
                    ++i;
                    continue;
                }
                this.issueExpectedParameterMessage(stringArray[i]);
                return false;
            }
            int n2 = this.parseUtilitySpecificOption(stringArray, i);
            if (n2 < 0) {
                this.issueBadOptionsMessage(n2, stringArray[i]);
                return false;
            }
            i = n2 - 1;
        }
        return true;
    }

    private void issueBadOptionsMessage(int n, String string) {
        if (n == -1) {
            this.issueUnknownOptionMessage(string);
        } else if (n == -2) {
            this.issueExpectedParameterMessage(string);
        } else if (n == -3) {
            this.issueInvalidParameterMessage(string);
        }
    }

    private void issueUnknownOptionMessage(String string) {
        this.issueMessage("ADMU9991E", new Object[]{string}, null);
        this.issueUsageMessage();
    }

    private void issueExpectedParameterMessage(String string) {
        this.issueMessage("ADMU9992E", new Object[]{string}, null);
        this.issueUsageMessage();
    }

    private void issueInvalidParameterMessage(String string) {
        this.issueMessage("ADMU9993E", new Object[]{string}, null);
        this.issueUsageMessage();
    }

    protected boolean isValidParameter(String[] stringArray, int n) {
        return stringArray.length > n && !stringArray[n].startsWith("-");
    }

    private boolean isHelpNeeded(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-?") && !stringArray[i].equals("-help")) continue;
            this.issueUsageMessage();
            this.help = true;
            return true;
        }
        return false;
    }

    protected boolean isGivenMinimumNumArgs(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length && this.isValidMinimumArgument(stringArray[i]); ++i) {
            ++n;
        }
        if (n < this.getMinimumNumArgs()) {
            this.issueUsageMessage();
            return false;
        }
        return true;
    }

    protected boolean isValidMinimumArgument(String string) {
        return !string.startsWith("-");
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        return -1;
    }

    private void displayCurrentProfile() {
        if (!this.displayCurrentProfile) {
            return;
        }
        File file = this.guessProfileDir();
        if (file != null) {
            try {
                String string = WSProfile.getProfileName(file);
                this.issueMessage("ADMU0128I", new String[]{string}, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private File guessProfileDir() {
        File file = null;
        int n = this.configRoot.indexOf("config");
        if (n >= 0 && !(file = new File(this.configRoot.substring(0, n))).exists()) {
            file = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Our guess at the profile dir: " + file);
        }
        return file;
    }

    protected String[] stopAllServers() throws Exception {
        return this.stopAllServers(this.userid, this.pwd);
    }

    protected String[] stopAllServers(String string, String string2) throws Exception {
        Vector vector = this.getServers();
        this.issueMessage("ADMU2010I", new Object[]{this.nodeName}, null);
        ArrayList arrayList = new ArrayList();
        String string3 = "nodeagent";
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.get(i);
            if (!string4.equals(string3)) {
                this.doStopServer(arrayList, string4, string, string2);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.doStopServer(arrayList, string3, string, string2);
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    private void doStopServer(List list, String string, String string2, String string3) throws Exception {
        if (AdminTool.isPlatformWindows()) {
            WindowsService windowsService;
            block9: {
                windowsService = null;
                try {
                    windowsService = WindowsService.getWindowsServiceInstance(string);
                }
                catch (AdminException adminException) {
                    windowsService = null;
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "after WindowsService.getWindowsServiceInstance " + adminException.getMessage());
                }
            }
            if (windowsService != null && !this.invokedByWindowsService) {
                block10: {
                    try {
                        if (windowsService.getServiceStatus() != 2) {
                            return;
                        }
                    }
                    catch (AdminException adminException) {
                        windowsService = null;
                        return;
                    }
                    try {
                        windowsService.doStopService();
                    }
                    catch (AdminException adminException) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "after windowsSvc.doStopService() " + adminException.getMessage());
                    }
                }
                return;
            }
        }
        this.stopNormalAppServer(list, string, string2, string3);
    }

    private void stopNormalAppServer(List list, String string, String string2, String string3) throws Exception {
        JMXConnector jMXConnector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNormalAppServer:  serverName = " + string + ", _userName = " + string2 + ", _pwd = " + (string3 == null || string3.length() == 0 ? "" : "****"));
        }
        if ((jMXConnector = LaunchUtils.getJMXConnector(this.configRoot, this.cellName, this.nodeName, string)) != null) {
            AdminClient adminClient;
            block6: {
                adminClient = null;
                try {
                    adminClient = LaunchUtils.getAdminClient(jMXConnector, this.configRoot, this.cellName, this.nodeName, string, string2, string3);
                }
                catch (Exception exception) {
                    this.issueMessage("ADMU0512I", new Object[]{string}, null);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, exception.getMessage(), exception);
                }
            }
            if (adminClient != null) {
                this.sendStop(adminClient, string);
                list.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNormalAppServer");
        }
    }

    public void removeAllServices() throws AdminException {
        this.removeAllServices(null);
    }

    public void removeAllServices(List list) throws AdminException {
        Vector vector = null;
        if (!AdminTool.isPlatformWindows()) {
            return;
        }
        try {
            vector = this.getServers();
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName = " + string);
            }
            if (list != null && list.contains(string)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping removal of service for server: " + string);
                continue;
            }
            try {
                WindowsService windowsService = null;
                try {
                    windowsService = WindowsService.getWindowsServiceInstance(string);
                    if (windowsService == null) {
                        continue;
                    }
                }
                catch (AdminException adminException) {
                    // empty catch block
                }
                windowsService.doRemoveService();
                continue;
            }
            catch (AdminException adminException) {
                // empty catch block
            }
        }
    }

    public void stopAndRemoveAllServices() throws Exception {
        this.stopAllServers();
        this.removeAllServices();
    }

    protected static boolean isPlatformWindows() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPlatformWindows()");
        }
        return (string = System.getProperty("os.name")).toLowerCase().indexOf("windows") >= 0;
    }

    protected Vector getServers() throws Exception {
        Vector vector = this.getServerList();
        if (vector == null || vector.size() == 0) {
            this.issueMessage("ADMU0507I", new Object[]{this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers"}, null);
        } else {
            this.issueMessage("ADMU0505I", null, null);
            for (int i = 0; i < vector.size(); ++i) {
                this.issueMessage("ADMU0506I", new Object[]{vector.elementAt(i)}, null);
            }
        }
        return vector;
    }

    protected Vector getServerList() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                String string2 = fileArray[i].getName();
                vector.add(string2);
            }
        }
        return vector;
    }

    private void sendStop(AdminClient adminClient, String string) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        int n = -10;
        ObjectName objectName = this.getServerHandle(adminClient);
        if (this.statusPort == null) {
            this.statusSocket = LaunchUtils.getFreePort(300000);
            this.statusPort = new Integer(this.statusSocket.getLocalPort());
        }
        if (objectName != null) {
            String string2 = "stop";
            String[] stringArray = new String[]{"java.lang.Boolean", "java.lang.Integer"};
            Object[] objectArray = new Object[]{new Boolean(true), this.statusPort};
            try {
                adminClient.invoke(objectName, string2, objectArray, stringArray);
            }
            catch (Exception exception) {
                try {
                    adminClient.isAlive();
                    bl2 = true;
                    throw exception;
                }
                catch (Exception exception2) {
                    if (bl2) {
                        throw exception2;
                    }
                    bl = false;
                    n = 0;
                }
            }
            if (bl) {
                n = LaunchUtils.waitForServer(this.statusSocket);
            }
            if (n == 0) {
                this.issueMessage("ADMU0510I", new Object[]{string, "STOPPED"}, null);
            } else {
                this.issueMessage("ADMU0021E", null, null);
                String string3 = new Integer(this.statusTimeout / 1000).toString();
                throw new AdminException(this.getFormattedMessage("ADMU3060E", new Object[]{string3}, "Timed out waiting for server shutdown."));
            }
        }
    }

    protected Integer getStatusPort() {
        this.initStatusPort();
        return this.statusPort;
    }

    protected ServerSocket getStatusSocket() {
        this.initStatusPort();
        return this.statusSocket;
    }

    private void initStatusPort() {
        if (this.statusSocket != null) {
            return;
        }
        int n = 0;
        if (this.statusPort != null) {
            n = this.statusPort;
        }
        try {
            this.statusSocket = new ServerSocket(n);
            this.statusSocket.setSoTimeout(this.statusTimeout);
            this.statusPort = new Integer(this.statusSocket.getLocalPort());
        }
        catch (IOException iOException) {
            this.issueMessage("ADMU3012E", new Object[]{iOException.getMessage()}, null);
            Tr.error(tc, "ADMU3012E", iOException);
        }
    }

    protected ObjectName getServerHandle(AdminClient adminClient) throws Exception {
        ObjectName objectName = adminClient.getServerMBean();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Repository handle is ==> " + objectName.getCanonicalName());
        }
        return objectName;
    }

    private boolean setTrace() {
        String string = null;
        string = this.trace || this.parseAndSetTraceCalled ? ALL_TRACE : "";
        if (this.logfile == null) {
            this.logfile = this.getDefaultTraceFile();
        }
        boolean bl = true;
        if (!ManagerAdmin.isLogFileWriteable(this.logfile)) {
            this.issueMessage("ADMU0118E", new Object[]{new File(this.logfile).getAbsolutePath()}, null);
            bl = false;
        }
        if (bl) {
            this.issueMessage("ADMU0116I", new Object[]{new File(this.logfile).getAbsolutePath()}, null);
            ManagerAdmin.configureClientTrace(string, "named file", this.logfile, this.replacelog, "basic", false);
        }
        return true;
    }

    protected int issueMessage(String string, Object[] objectArray, String string2) {
        String string3 = this.getFormattedMessage(string, objectArray, string2);
        if (string3 == null) {
            string3 = this.getFormattedMessage("ADMU0123E", new Object[]{string}, null);
        }
        if (!this.quiet) {
            this.printMessage(string3);
        }
        this.emitNotification(string, string3);
        Tr.audit(tc, string, objectArray);
        return this.retcodeFromMessage(string3);
    }

    protected void printMessage(String string) {
        int n = 79;
        if (this.isDoubleByteSystem(string)) {
            n /= 2;
        }
        this.printMessage(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoubleByteSystem(String string) {
        if (!this.isDoubleByteTested) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(string);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    dataOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.isDoubleByteSystem = (double)byArray.length > (double)string.length() + (double)string.length() * 0.1;
        }
        return this.isDoubleByteSystem;
    }

    private void printMessage(String string, int n, boolean bl) {
        int n2 = n;
        if (bl) {
            System.out.print(INDENT);
            n2 -= INDENT.length();
        }
        if (string.length() <= n2) {
            System.out.println(string);
        } else {
            int n3 = string.lastIndexOf(32, n2);
            if (n3 == -1 && (n3 = string.indexOf(32)) == -1) {
                System.out.println(string);
                return;
            }
            this.printMessage(string.substring(0, n3), n, false);
            this.printMessage(string.substring(n3 + 1), n, true);
        }
    }

    protected String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = RESOURCE_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    protected void emitNotification(String string, String string2) {
    }

    private int retcodeFromMessage(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.startsWith("ADM")) {
            String string2 = string.substring(4, 8);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else {
            n = -1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message does not start with expected value. First characters: " + string.substring(0, 8));
            }
        }
        return n;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compressDir(String string, File file) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        int n = 0;
        try {
            File file2 = new File(string);
            n = this.zipFileRecursive(file2, zipOutputStream, n);
        }
        finally {
            if (!this.isQuiet()) {
                System.out.println();
            }
            zipOutputStream.close();
        }
        return n;
    }

    private int zipFileRecursive(File file, ZipOutputStream zipOutputStream, int n) throws IOException {
        int n2 = n;
        if (file.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Backing up directory " + file.getCanonicalPath());
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                n2 = this.zipFileRecursive(fileArray[i], zipOutputStream, n2);
            }
        } else {
            this.zipFile(file, zipOutputStream);
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFile(File file, ZipOutputStream zipOutputStream) throws IOException {
        if (!this.isQuiet()) {
            System.out.print('.');
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Backing up file " + file);
        }
        ZipEntry zipEntry = new ZipEntry(this.getRelativeName(file));
        zipEntry.setSize(file.length());
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(file.length());
        this.setCompressionMethod(zipEntry);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n = 0;
            while ((n = fileInputStream.read(this.buffer)) > -1) {
                zipOutputStream.write(this.buffer, 0, n);
            }
        }
        finally {
            fileInputStream.close();
        }
        zipOutputStream.closeEntry();
    }

    private String getRelativeName(File file) {
        return file.getPath().substring(this.configRoot.length() + 1);
    }

    private void setCompressionMethod(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        for (int i = 0; i < DO_NOT_COMPRESS_LIST.length; ++i) {
            if (!string.endsWith(DO_NOT_COMPRESS_LIST[i])) continue;
            zipEntry.setMethod(0);
        }
        zipEntry.setMethod(8);
    }

    protected static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return throwable;
        }
        return AdminTool.getRootCause(throwable2);
    }
}

