/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.NodeFederationUtility;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class BackupConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register(NodeFederationUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "backupConfig.log";
    public static final String NAME_PREFIX = "WebSphereConfig_";
    private File backupFile;
    private boolean stopServers = true;
    private int numFilesBackedUp = 0;

    public static void main(String[] stringArray) {
        System.exit(new BackupConfigUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU5000I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        int n = 3;
        if (stringArray.length > 3 && !stringArray[3].startsWith("-")) {
            this.backupFile = new File(stringArray[3]);
            n = 4;
        } else {
            this.backupFile = new File(this.generateBackupName());
        }
        return n;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        if (stringArray[n].equals("-nostop")) {
            this.stopServers = false;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        if (this.backupFile.getCanonicalPath().startsWith(new File(this.configRoot).getCanonicalPath())) {
            this.issueMessage("xxxx", null, "ADMU5002E: Cannot create backup file in config directory");
            return -1;
        }
        this.issueMessage("ADMU5001I", new Object[]{this.configRoot, this.backupFile.getCanonicalPath()}, null);
        try {
            ModelMgr.initialize("ws-server");
            Object var1_1 = null;
            if (this.stopServers) {
                this.stopAllServers();
            }
            this.compressConfigDir();
            this.issueMessage("ADMU5002I", new Object[]{new Integer(this.numFilesBackedUp)}, null);
            return 0;
        }
        catch (Exception exception) {
            this.backupFile.delete();
            throw exception;
        }
    }

    private String generateBackupName() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NAME_PREFIX);
        stringBuffer.append(String.valueOf(calendar.get(1)) + "-");
        stringBuffer.append(this.getStringValWithLength2(calendar.get(2) + 1) + "-");
        stringBuffer.append(this.getStringValWithLength2(calendar.get(5)));
        String string = stringBuffer.toString();
        return this.makeNameUnique(string) + ".zip";
    }

    private String getStringValWithLength2(int n) {
        if (n < 10) {
            return "0" + String.valueOf(n);
        }
        return String.valueOf(n);
    }

    private String makeNameUnique(String string) {
        String string2 = string;
        int n = 1;
        while (new File(string2 + ".zip").exists()) {
            string2 = string + "_" + String.valueOf(n++);
        }
        return string2;
    }

    private void compressConfigDir() throws IOException {
        this.numFilesBackedUp = this.compressDir(this.configRoot, this.backupFile);
    }
}

