/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.scheduler.TaskInfo;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.ws.csi.TimerTaskInfo;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class EJBTimersCommand
extends AdminTool {
    private static final String BUNDLE_NAME = "com.ibm.ejs.container.container";
    private static final TraceComponent tc = Tr.register(EJBTimersCommand.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ws.management.tools.EJBTimersCommand";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ejs.container.container", Locale.getDefault());
    private static final String DEFAULT_TRACE_FILE = "EJBTimers.log";
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    protected static final int INCOMPATIBLE_OPTION = -25;
    protected static final int MISSING_PREREQ_OPTION = -26;
    protected static final int UNSUPPORTED_OPTION = -27;
    protected static final int STATUS_CMD_SUCCESSFUL = 0;
    protected static final int STATUS_CONNECT_FAILED = -1;
    protected static final int STATUS_DISPLAY_FAILED = -2;
    protected static final int STATUS_CANCEL_FAILED = -3;
    protected AdminClient ivAdminClient = null;
    protected ObjectName ivSchedulerMBean = null;
    protected String serverName = null;
    protected boolean ivFindAll = false;
    protected String ivTimerId = null;
    protected String ivApplication = null;
    protected String ivModule = null;
    protected String ivBean = null;
    private String hostName = null;
    private String portNumber = null;
    private String connType = null;
    private Properties connProps = null;
    private boolean ivQuiet = false;

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + this.serverName;
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected int parseRequiredArgs(String[] stringArray) throws AdminException {
        this.serverName = stringArray[3];
        if (this.serverName == null || this.serverName.startsWith("-")) {
            this.issueMessage("ADMU3402E", null, null);
            return -1;
        }
        for (int i = 4; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-quiet")) continue;
            this.ivQuiet = true;
            break;
        }
        return 4;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (this.nowait) {
            this.issueMessage("ADMU9991E", new Object[]{"-nowait"}, null);
            this.issueUsageMessage();
            n2 = -27;
        } else if (this.statusPort != null) {
            this.issueMessage("ADMU9991E", new Object[]{"-statusport"}, null);
            this.issueUsageMessage();
            n2 = -27;
        } else if (string.equals("-all")) {
            this.ivFindAll = true;
            if (this.ivTimerId != null) {
                this.issueMessage("CNTR9101E", new Object[]{"-timer", "-all"}, "CNTR9101E: Incompatible options: {0} {1}");
                this.issueUsageMessage();
                n2 = -25;
            }
            if (this.ivApplication != null) {
                this.issueMessage("CNTR9101E", new Object[]{"-app", "-all"}, "CNTR9101E: Incompatible options: {0} {1}");
                this.issueUsageMessage();
                n2 = -25;
            }
        } else if (string.equals("-timer")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.ivTimerId = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
            if (this.ivFindAll) {
                this.issueMessage("CNTR9101E", new Object[]{"-all", "-timer"}, "CNTR9101E: Incompatible options: {0} {1}");
                this.issueUsageMessage();
                n2 = -25;
            }
            if (this.ivApplication != null) {
                this.issueMessage("CNTR9101E", new Object[]{"-app", "-timer"}, "CNTR9101E: Incompatible options: {0} {1}");
                this.issueUsageMessage();
                n2 = -25;
            }
        } else if (string.equals("-app")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.ivApplication = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
            if (this.ivFindAll) {
                this.issueMessage("CNTR9101E", new Object[]{"-all", "-app"}, "CNTR9101E: Incompatible options: {0} {1}");
                this.issueUsageMessage();
                n2 = -25;
            }
            if (this.ivTimerId != null) {
                this.issueMessage("CNTR9101E", new Object[]{"-timer", "-app"}, "CNTR9101E: Incompatible options: {0} {1}");
                this.issueUsageMessage();
                n2 = -25;
            }
        } else if (string.equals("-mod")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.ivModule = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
            if (this.ivApplication == null) {
                this.issueMessage("CNTR9102E", new Object[]{"-mod", "-app"}, "CNTR9102E: Option {0} requires option {1}.");
                this.issueUsageMessage();
                n2 = -26;
            }
        } else if (string.equals("-bean")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.ivBean = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
            if (this.ivModule == null) {
                this.issueMessage("CNTR9102E", new Object[]{"-bean", "-mod"}, "CNTR9102E: Option {0} requires option {1}.");
                this.issueUsageMessage();
                n2 = -26;
            }
        } else if (string.equals("-host")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.hostName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-port")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.portNumber = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-conntype")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.connType = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else {
            n2 = super.parseUtilitySpecificOption(stringArray, n);
        }
        return n2;
    }

    protected void issueUsageMessage() {
        this.issueMessage("CNTR9000I", new Object[]{this.getCommandName()}, "Usage: {0} <server> <filter> [options]");
        this.issueMessage("CNTR9001I", null, "\tfilter : <-all> | <-timer> | <-app [-mod [-bean]]>");
        this.issueMessage("CNTR9002I", null, "\t         -all");
        this.issueMessage("CNTR9003I", null, "\t         -timer <timer id>");
        this.issueMessage("CNTR9004I", null, "\t         -app <application name>");
        this.issueMessage("CNTR9005I", null, "\t         -mod <module name>");
        this.issueMessage("CNTR9006I", null, "\t         -bean <bean name>\n");
        this.issueMessage("CNTR9007I", null, "\toptions: -host <host name>");
        this.issueMessage("ADMU4022I", null, "\t         -port <portnumber>");
        this.issueMessage("ADMU4020I", null, "\t         -conntype <connector type>");
        this.issueMessage("CNTR9008I", null, "\t         -user <userid>");
        this.issueMessage("ADMU4024I", null, "\t         -password <password>");
        this.issueMessage("ADMU4004I", null, "\t         -quiet");
        this.issueMessage("ADMU4010I", null, "\t         -logfile <filename>");
        this.issueMessage("ADMU4012I", null, "\t         -replacelog");
        this.issueMessage("ADMU4011I", null, "\t         -trace");
        this.issueMessage("ADMU4025I", null, "\t         -help");
    }

    protected int issueMessage(String string, Object[] objectArray, String string2) {
        if (string != null && string.startsWith("CNTR")) {
            String string3 = this.getFormattedMessage(string, objectArray, string2);
            if (!this.ivQuiet) {
                this.printMessage(string3);
            }
            Tr.audit(tc, string, objectArray);
            return this.retcodeFromMessage(string3);
        }
        return super.issueMessage(string, objectArray, string2);
    }

    protected String getFormattedMessage(String string, Object[] objectArray, String string2) {
        if (string != null && string.startsWith("CNTR")) {
            try {
                String string3 = RESOURCE_BUNDLE.getString(string);
                if (string3 == null) {
                    return string2;
                }
                return MessageFormat.format(string3, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                if (string2 == null) {
                    return string2;
                }
                return MessageFormat.format(string2, objectArray);
            }
            catch (NullPointerException nullPointerException) {
                return string2;
            }
        }
        return super.getFormattedMessage(string, objectArray, string2);
    }

    protected int runTool() throws Exception {
        int n = 0;
        ObjectName objectName = null;
        TaskInfo[] taskInfoArray = null;
        String string = "";
        Set set = null;
        try {
            this.ivAdminClient = this.getAdminClient();
            if (this.ivAdminClient != null) {
                string = this.getTimerSchedulerMBeanName();
                objectName = new ObjectName("WebSphere:*,type=WASScheduler,name=" + string + ",process=" + this.serverName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "runTool : queryName = " + objectName);
                }
                set = this.ivAdminClient.queryNames(objectName, null);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "runTool : ivAdminClient = null");
            }
            if (set != null && set.size() > 0) {
                Iterator iterator = set.iterator();
                this.ivSchedulerMBean = (ObjectName)iterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "runTool : SchedulerMBean = " + this.ivSchedulerMBean);
                }
                taskInfoArray = this.ivTimerId != null ? this.getTask() : this.findTasksByName();
            } else {
                this.issueMessage("CNTR9104W", new Object[]{string, this.serverName}, "CNTR9104W: EJB Timer service {0} not available on server {1}.");
            }
        }
        catch (ConnectorException connectorException) {
            Tr.error(tc, "CNTR9100E", connectorException.toString());
            Tr.service(tc, "CNTR9100E", connectorException);
            this.issueMessage("ADMU0509I", new Object[]{"server", this.serverName}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            return -1;
        }
        if (taskInfoArray != null) {
            for (int i = 0; i < taskInfoArray.length; ++i) {
                if (taskInfoArray[i] instanceof TimerTaskInfo) {
                    TimerTaskInfo timerTaskInfo = (TimerTaskInfo)taskInfoArray[i];
                    if (this.ivFindAll || this.ivTimerId != null && this.ivTimerId.equals(timerTaskInfo.getTaskId()) || this.ivApplication != null && this.ivApplication.equals(timerTaskInfo.getApplication()) && (this.ivModule == null || this.ivModule.equals(timerTaskInfo.getModule())) && (this.ivBean == null || this.ivBean.equals(timerTaskInfo.getComponent()))) {
                        int n2 = this.performCmdAction(timerTaskInfo);
                        if (n != 0) continue;
                        n = n2;
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "runTool : does not match filter = " + taskInfoArray[i]);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "runTool : not an EJB Timer: " + taskInfoArray[i]);
            }
        }
        this.issueSummaryMessage();
        return n;
    }

    private AdminClient getAdminClient() throws Exception, ConnectorException {
        AdminClient adminClient = null;
        if (this.portNumber != null) {
            if (this.hostName == null) {
                this.hostName = "localhost";
            }
            if (this.connType == null) {
                this.connType = "SOAP";
            }
            this.issueMessage("ADMU3101I", new Object[]{this.hostName, this.portNumber, this.serverName}, null);
            Properties properties = new Properties();
            properties.setProperty("host", this.hostName);
            properties.setProperty("port", this.portNumber);
            properties.setProperty("type", this.connType);
            if (this.userid != null) {
                properties.setProperty("username", this.userid);
            }
            if (this.pwd != null) {
                properties.setProperty("password", this.pwd);
            }
            adminClient = AdminClientFactory.createAdminClient(properties);
        } else {
            if (!this.serverConfigExists()) {
                this.issueMessage("ADMU3522E", new Object[]{this.serverName}, null);
                return adminClient;
            }
            this.issueMessage("ADMU3100I", new Object[]{this.serverName}, null);
            BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
            Repository repository2 = RepositoryFactory.createRepository("ws-server", this.configRoot, this.cellName, this.nodeName, this.serverName);
            beanContextServicesSupport.addService(Repository.class, (BeanContextServiceProvider)((Object)repository2));
            VariableMap variableMap = VariableMapFactory.createVariableMap();
            beanContextServicesSupport.add(variableMap);
            variableMap.initialize(null);
            Resource resource = repository2.getConfigRoot().getResource(4, "server.xml");
            JMXConnector jMXConnector = LaunchUtils.getJMXConnector(resource);
            if (jMXConnector != null) {
                adminClient = LaunchUtils.getAdminClient(repository2, jMXConnector, this.userid, this.pwd);
            }
        }
        return adminClient;
    }

    protected boolean serverConfigExists() {
        boolean bl = false;
        String string = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers/" + this.serverName;
        File file = new File(string);
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    protected String getTimerSchedulerMBeanName() {
        Object object;
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        String string = "WebSphere_EJB_Timer_Service";
        try {
            objectName = new ObjectName("WebSphere:name=EJBContainer,type=EJBContainer,process=" + this.serverName + ",*");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "runTool : queryName = " + objectName);
            }
            if ((object = this.ivAdminClient.queryNames(objectName, null)) != null && object.size() > 0) {
                Iterator iterator = object.iterator();
                objectName2 = (ObjectName)iterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "runTool : ContainerMBean = " + objectName2);
                }
            }
            if (objectName2 != null) {
                string = (String)this.ivAdminClient.getAttribute(objectName2, "timerServiceSchedulerJNDIName");
            }
        }
        catch (Throwable throwable) {
            Tr.error(tc, "CNTR9100E", throwable.toString());
            Tr.service(tc, "CNTR9100E", throwable);
        }
        object = "Scheduler_" + string.replace('/', '.');
        return object;
    }

    private TaskInfo[] getTask() throws ConnectorException, InstanceNotFoundException, MBeanException, ReflectionException {
        TaskInfo[] taskInfoArray = null;
        TaskInfo taskInfo = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTask : taskId = " + this.ivTimerId);
        }
        Object[] objectArray = new Object[]{this.ivTimerId};
        String[] stringArray = new String[]{"java.lang.String"};
        try {
            taskInfo = (TaskInfo)this.ivAdminClient.invoke(this.ivSchedulerMBean, "getTask", objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof TaskInvalid) {
                this.issueMessage("CNTR9103W", new Object[]{this.ivTimerId, this.serverName}, "CNTR9103W: EJB Timer {0} could not be found on server {1}.");
            }
            throw mBeanException;
        }
        taskInfoArray = new TaskInfo[]{taskInfo};
        return taskInfoArray;
    }

    private TaskInfo[] findTasksByName() throws ConnectorException, InstanceNotFoundException, MBeanException, ReflectionException {
        TaskInfo[] taskInfoArray = null;
        String string = "%";
        if (this.ivBean != null) {
            string = this.ivBean + "_" + string;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "findTasksByName : timerName = " + string);
        }
        Object[] objectArray = new Object[]{string, new Integer(0), new Integer(0x7FFFFFFE)};
        String[] stringArray = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.Integer"};
        taskInfoArray = (TaskInfo[])this.ivAdminClient.invoke(this.ivSchedulerMBean, "findTasksByName", objectArray, stringArray);
        return taskInfoArray;
    }

    private int retcodeFromMessage(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.startsWith("CNTR")) {
            String string2 = string.substring(4, 8);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    protected int issueTimerMessage(TimerTaskInfo timerTaskInfo) {
        int n = 0;
        try {
            String string = "   ";
            String string2 = timerTaskInfo.getTaskId();
            Date date = timerTaskInfo.getNextFireTime();
            String string3 = timerTaskInfo.getApplication();
            String string4 = timerTaskInfo.getModule();
            String string5 = timerTaskInfo.getComponent();
            String string6 = timerTaskInfo.getPrimaryKeyString();
            String string7 = timerTaskInfo.getInfoString();
            if (timerTaskInfo.getNumberOfRepeats() == 1) {
                this.issueMessage("CNTR9050I", new Object[]{string2, date}, "EJB Timer : {0}     Expiration: {1}     Single");
            } else {
                this.issueMessage("CNTR9051I", new Object[]{string2, date}, "EJB Timer : {0}     Expiration: {1}     Repeating");
            }
            this.issueMessage("CNTR9052I", new Object[]{string, string3, string4, string5}, "{0}EJB    : {1}, {2}, {3}");
            if (string6 != null) {
                this.issueMessage("CNTR9053I", new Object[]{string, string6}, "{0}EJB Key: {1}");
            }
            if (string7 != null) {
                this.issueMessage("CNTR9054I", new Object[]{string, string7}, "{0}Info   : {1}");
            }
        }
        catch (Throwable throwable) {
            n = -2;
            this.issueDisplayExceptionMessage(timerTaskInfo, throwable);
        }
        return n;
    }

    protected void issueDisplayExceptionMessage(TimerTaskInfo timerTaskInfo, Throwable throwable) {
        String string = "UNKNOWN";
        try {
            string = timerTaskInfo.getTaskId();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        this.issueMessage("CNTR9064I", new Object[]{string}, "Failed to display EJB Timer : {0}");
        this.issueMessage("CNTR9065I", new Object[]{throwable.toString()}, "EJB Timer display failure caused by: {0}");
        Tr.error(tc, "CNTR9100E", throwable.toString());
        Tr.service(tc, "CNTR9100E", throwable);
    }

    protected abstract String getCommandName();

    protected abstract int performCmdAction(TimerTaskInfo var1);

    protected abstract void issueSummaryMessage();
}

