/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class GenericServerProcHelper {
    private static TraceComponent tc = Tr.register(GenericServerProcHelper.class, "Admin", "com.ibm.ws.management.resources.nodeutils");

    private static Repository getRepository(ServerIdentifiers serverIdentifiers) {
        return RepositoryFactory.createRepository("ws-server", serverIdentifiers.getConfigRoot(), serverIdentifiers.getCellName(), serverIdentifiers.getNodeName(), serverIdentifiers.getServerName());
    }

    private static VariableMap getVariableMap(ServerIdentifiers serverIdentifiers) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariableMap(), sid = " + serverIdentifiers.toString());
        }
        Repository repository2 = GenericServerProcHelper.getRepository(serverIdentifiers);
        VariableMap variableMap = VariableMapFactory.createVariableMap(repository2);
        try {
            variableMap.initialize(null);
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        return variableMap;
    }

    private static ProcessDef getProcessDef(ServerIdentifiers serverIdentifiers) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessDef(sid), sid = " + serverIdentifiers.toString());
        }
        Resource resource = null;
        String string = "/servers/" + serverIdentifiers.getServerName() + "/server.xml";
        try {
            resource = GenericServerProcHelper.getRepository(serverIdentifiers).getConfigRoot().getResource(3, string);
        }
        catch (Exception exception) {
            throw new AdminException(exception, serverIdentifiers.toString());
        }
        EList eList = resource.getContents();
        Server server2 = (Server)eList.get(0);
        if (!server2.getName().equals(serverIdentifiers.getServerName())) {
            throw new AdminException(serverIdentifiers.getServerName());
        }
        try {
            return (ProcessDef)server2.getProcessDefinitions().get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return server2.getProcessDefinition();
        }
    }

    public static boolean isServerAnIHSServer(ServerIdentifiers serverIdentifiers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerAnIHSServer, sid = " + serverIdentifiers.toString());
        }
        if (!GenericServerProcHelper.isServerAWebServer(serverIdentifiers)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerAnIHSServer = false");
            }
            return false;
        }
        Resource resource = null;
        String string = "/servers/" + serverIdentifiers.getServerName() + "/server.xml";
        Tr.debug(tc, "server path = " + string);
        try {
            resource = GenericServerProcHelper.getRepository(serverIdentifiers).getConfigRoot().getResource(3, string);
        }
        catch (Exception exception) {
            throw new AdminException(exception, serverIdentifiers.toString());
        }
        EList eList = resource.getContents();
        Server server2 = (Server)eList.get(0);
        WebServer webServer = GenericServerProcHelper.getWebServer(server2);
        if (webServer.getWebserverType().getName().equals("IHS") || webServer.getWebserverType().getName().equals("HTTPSERVER_ZOS")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerAnIHSServer = true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerAnIHSServer = false");
        }
        return false;
    }

    public static boolean isServerAGenericServer(ServerIdentifiers serverIdentifiers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerAGenericServer(), sid = " + serverIdentifiers.toString());
        }
        return GenericServerProcHelper.isItThisTypeOfServer("GENERIC_SERVER", serverIdentifiers);
    }

    public static boolean isServerAWebServer(ServerIdentifiers serverIdentifiers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerAWebServer(), sid = " + serverIdentifiers.toString());
        }
        return GenericServerProcHelper.isItThisTypeOfServer("WEB_SERVER", serverIdentifiers);
    }

    private static boolean isItThisTypeOfServer(String string, ServerIdentifiers serverIdentifiers) throws AdminException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = "serverType = " + string + "\nsid = " + serverIdentifiers.toString();
            Tr.entry(tc, "isItThisTypeOfServer(), input params = " + (String)object);
        }
        object = null;
        String string2 = "/serverindex.xml";
        try {
            object = GenericServerProcHelper.getRepository(serverIdentifiers).getConfigRoot().getResource(3, string2);
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, serverIdentifiers.toString());
        }
        ServerIndex serverIndex = (ServerIndex)object.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerName().equals(serverIdentifiers.getServerName()) || !serverEntry.getServerType().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "server IS a " + string);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "server IS NOT a " + string);
        }
        return false;
    }

    protected static int launchGenericServer(LaunchCommand launchCommand, ServerIdentifiers serverIdentifiers) throws AdminException {
        int n = -2;
        Process process = null;
        try {
            process = launchCommand.launchProcess();
        }
        catch (Exception exception) {
            throw new AdminException(exception, "process for " + serverIdentifiers.toString() + "failed to launch");
        }
        try {
            String string = process.id();
            string = string.toUpperCase();
            GenericServerProcHelper.savePidToFile(string, serverIdentifiers);
            Tr.debug(tc, "Launched process pid: " + string);
            String string2 = serverIdentifiers.getServerName();
            Tr.debug(tc, "Processing as generic server. ");
            if (!GenericServerProcHelper.getStatusUsingPidFile(serverIdentifiers).equals("RUNNING")) {
                throw new AdminException(LaunchUtils.getFormattedMessage("ADML0011E", null, null));
            }
            n = 0;
            Tr.audit(tc, "ADML0000I", new Object[]{string});
            Tr.debug(tc, "processName = " + string2 + " pid = " + string + " status = " + n);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in LaunchCommand.launchProcess():", throwable);
            }
            throw new AdminException(throwable, "Process for: " + serverIdentifiers.toString() + "launched successfully but there was a subsequent problem");
        }
        return n;
    }

    public static String getStatusUsingPidFile(ServerIdentifiers serverIdentifiers) throws AdminException, Exception {
        if (GenericServerProcHelper.isServerAWebServer(serverIdentifiers) || GenericServerProcHelper.isServerAnIHSServer(serverIdentifiers)) {
            String string = GenericServerProcHelper.getStatusUsingPing(serverIdentifiers);
            return string;
        }
        String string = GenericServerProcHelper.getPathToPidFile(serverIdentifiers);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerProcessStatus: ", string);
        }
        boolean bl = true;
        Process process = null;
        String string2 = GenericServerProcHelper.getPidFromFile(string.trim());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " PID ======> " + string2);
        }
        if (string2 != null) {
            try {
                process = ProcessFactory.bindTo(string2);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pid file found but existing pid is invalid! - processing will continue");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerProcessStatus ", "STOPPED");
                }
                return "STOPPED";
            }
            try {
                bl = process.isAlive();
            }
            catch (ProcessOpException processOpException) {
                return "STOPPED";
            }
            if (bl) {
                return "RUNNING";
            }
            return "STOPPED";
        }
        return "STOPPED";
    }

    public static String getStatusUsingPing(ServerIdentifiers serverIdentifiers) throws AdminException, Exception {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        Resource resource = null;
        Resource resource2 = null;
        String string4 = "/servers/" + serverIdentifiers.getServerName() + "/server.xml";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "StatusUsing Ping -> serverPath = " + string4);
        }
        try {
            resource = GenericServerProcHelper.getRepository(serverIdentifiers).getConfigRoot().getResource(3, string4);
            resource2 = GenericServerProcHelper.getRepository(serverIdentifiers).getConfigRoot().getResource(3, "serverindex.xml");
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        EList eList = resource.getContents();
        Server server2 = (Server)eList.get(0);
        string2 = server2.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Check Status for Web Server->  " + string2);
            Tr.debug(tc, "Check Status for Web Server->  " + server2);
        }
        ServerIndex serverIndex = (ServerIndex)resource2.getContents().get(0);
        EList eList2 = serverIndex.getServerEntries();
        block4: for (int i = 0; i < eList2.size(); ++i) {
            object = (ServerEntry)eList2.get(i);
            if (!object.getServerName().equals(string2)) continue;
            EList eList3 = object.getSpecialEndpoints();
            for (int j = 0; j < eList3.size(); ++j) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)eList3.get(j);
                if (!namedEndPoint.getEndPointName().equals("WEBSERVER_ADDRESS")) continue;
                string3 = namedEndPoint.getEndPoint().getHost();
                n = namedEndPoint.getEndPoint().getPort();
                if (!tc.isDebugEnabled()) continue block4;
                Tr.debug(tc, "Found namedEndPoint for Web server on hostname " + string3 + " on port:" + n);
                continue block4;
            }
        }
        if (!string3.equals("")) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string3, n);
            if (inetSocketAddress.isUnresolved()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Socket Address unresolved for web server-> " + server2 + " on hostname " + string3 + " on port:" + n + " =UNAVAILABLE");
                }
                string = "UNAVAILABLE";
            }
            object = new Socket();
            try {
                ((Socket)object).connect(inetSocketAddress, 5000);
                ((Socket)object).close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status for web server-> " + server2 + " on hostname " + string3 + " on port:" + n + " =RUNNING");
                }
                string = "RUNNING";
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status for web server-> " + server2 + " on hostname " + string3 + " on port:" + n + " =STOPPED");
                }
                string = "STOPPED";
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HostName not available form serverIndex for Web server -> " + server2 + "status = UNAVAILABLE");
            }
            string = "UNAVAILABLE";
        }
        return string;
    }

    private static String getPathToPidFile(ServerIdentifiers serverIdentifiers) throws IllegalArgumentException, AdminException, Exception {
        if (GenericServerProcHelper.isServerAnIHSServer(serverIdentifiers)) {
            return GenericServerProcHelper.getIHSPidFile(serverIdentifiers);
        }
        return GenericServerProcHelper.getVariableMap(serverIdentifiers).expand("${LOG_ROOT}/" + serverIdentifiers.getServerName() + "/" + serverIdentifiers.getServerName() + ".pid");
    }

    public static String getIHSPidFile(ServerIdentifiers serverIdentifiers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIHSPidFile(), sid = " + serverIdentifiers.toString());
        }
        if (!GenericServerProcHelper.isServerAWebServer(serverIdentifiers)) {
            return "";
        }
        Resource resource = null;
        String string = "/servers/" + serverIdentifiers.getServerName() + "/server.xml";
        Tr.debug(tc, "server path = " + string);
        try {
            resource = GenericServerProcHelper.getRepository(serverIdentifiers).getConfigRoot().getResource(3, string);
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        EList eList = resource.getContents();
        Server server2 = (Server)eList.get(0);
        WebServer webServer = GenericServerProcHelper.getWebServer(server2);
        if (webServer.getWebserverType().getName().equals("IHS")) {
            String string2 = webServer.getConfigurationFilename();
            if (string2 == null) {
                return "";
            }
            String string3 = "";
            if (string2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "webServer config file name = " + string2);
                }
                string2 = GenericServerProcHelper.getVariableMap(serverIdentifiers).expand(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "webServer config file name expanded = " + string2);
                }
                if ((string3 = GenericServerProcHelper.parseConfFile(string2)) != null) {
                    return string3;
                }
                return "";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseConfFile(String string) {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() <= 0 || !string2.trim().startsWith("PidFile")) continue;
                String string3 = string2.substring(string2.indexOf(" "));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PID FILE got from httpd.conf " + string3);
                }
                String string4 = string3;
                return string4;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, iOException.getMessage(), iOException);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return "";
    }

    public static int stopArbitraryServerProcess(ServerIdentifiers serverIdentifiers) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopAbitraryServerProcess(), sid = " + serverIdentifiers.toString());
        }
        int n = 0;
        CreationParams creationParams = new CreationParams();
        String string = GenericServerProcHelper.getVariableMap(serverIdentifiers).expand(GenericServerProcHelper.getProcessDef(serverIdentifiers).getStopCommand());
        if (string == null) {
            throw new AdminException("Stop Command does not exist - perhaps you should try Terminate");
        }
        creationParams.setExecutable(string);
        creationParams.setProcessName(new File(string).getName());
        String string2 = GenericServerProcHelper.getVariableMap(serverIdentifiers).expand(GenericServerProcHelper.getProcessDef(serverIdentifiers).getWorkingDirectory());
        creationParams.setWorkingDirectory(string2);
        creationParams.setDetachProcess(true);
        String[] stringArray = (String[])GenericServerProcHelper.getProcessDef(serverIdentifiers).getStopCommandArgs().toArray();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = GenericServerProcHelper.getVariableMap(serverIdentifiers).expand(stringArray[i]);
        }
        creationParams.setCommandLineArgs(stringArray);
        try {
            Process process = ProcessFactory.create(creationParams);
            process.waitForTermination(30);
            n = process.getExitCode();
            process.release();
            GenericServerProcHelper.removeFileContainingPid(serverIdentifiers);
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        return n;
    }

    public static void savePidToFile(String string, ServerIdentifiers serverIdentifiers) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePidToFile", string);
        }
        try {
            if (GenericServerProcHelper.isServerAnIHSServer(serverIdentifiers)) {
                return;
            }
            String string2 = GenericServerProcHelper.getPathToPidFile(serverIdentifiers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pid = " + string + " to be saved in " + string2);
            }
            if (string != null) {
                File file = new File(string2);
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = null;
                if (!file.exists()) {
                    file.createNewFile();
                }
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(string.getBytes());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePidToFile");
        }
    }

    private static String getPidFromFile(String string) throws AdminException {
        String string2 = null;
        File file = new File(string);
        try {
            if (file.exists()) {
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new FileReader(file));
                string2 = bufferedReader.readLine();
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        return string2;
    }

    public static String getPidFromSid(ServerIdentifiers serverIdentifiers) throws AdminException {
        String string = null;
        try {
            string = GenericServerProcHelper.getPidFromFile(GenericServerProcHelper.getPathToPidFile(serverIdentifiers));
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        return string;
    }

    public static void removeFileContainingPid(ServerIdentifiers serverIdentifiers) throws AdminException {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFilePid(), sid = " + serverIdentifiers.toString());
        }
        String string = GenericServerProcHelper.getVariableMap(serverIdentifiers).expand("${LOG_ROOT}/" + serverIdentifiers.getServerName() + "/" + serverIdentifiers.getServerName() + ".pid");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pid file to be deleted: " + string);
        }
        if ((file = new File(string)).exists()) {
            file.delete();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFilePid");
        }
    }

    private static WebServer getWebServer(Server server2) throws Exception {
        WebServer webServer = null;
        EList eList = server2.getComponents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof WebServer)) continue;
            webServer = (WebServer)e2;
        }
        return webServer;
    }
}

