/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.resource.WASResourceSetImpl;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class GenericServerTemplateBuilder {
    protected String configRoot;
    protected String fileURI;
    protected ServerindexFactory indexFactory = null;

    public void setConfigRoot(String string) {
        this.configRoot = string;
    }

    public void setFileName(String string) {
        this.fileURI = string;
    }

    public GenericServerTemplateBuilder() {
        this.initializeFactories();
    }

    public void addV6Templates() {
        try {
            ServerEntry serverEntry;
            List list = this.readTemplateFile();
            ServerIndex serverIndex = (ServerIndex)list.get(0);
            EList eList = serverIndex.getServerEntries();
            if (!this.exists((List)eList, "default_60X")) {
                serverEntry = this.indexFactory.createServerEntry();
                serverEntry.setServerName("default_60X");
                serverEntry.setServerType("GENERIC_SERVER");
                eList.add(serverEntry);
            }
            if (!this.exists((List)eList, "defaultZOS_60X")) {
                serverEntry = this.indexFactory.createServerEntry();
                serverEntry.setServerName("defaultZOS_60X");
                serverEntry.setServerType("GENERIC_SERVER");
                eList.add(serverEntry);
            }
            if (!this.exists((List)eList, "default_61X")) {
                serverEntry = this.indexFactory.createServerEntry();
                serverEntry.setServerName("default_61X");
                serverEntry.setServerType("GENERIC_SERVER");
                eList.add(serverEntry);
            }
            if (!this.exists((List)eList, "defaultZOS_61X")) {
                serverEntry = this.indexFactory.createServerEntry();
                serverEntry.setServerName("defaultZOS_61X");
                serverEntry.setServerType("GENERIC_SERVER");
                eList.add(serverEntry);
            }
            this.writeTemplateFile(list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean exists(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string2 = serverEntry.getServerName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void initializeFactories() {
        CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveInit.init();
        ConfigInit.init();
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        this.indexFactory = serverindexPackage.getServerindexFactory();
    }

    private ResourceSet getResourceSet() {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(GenericServerTemplateBuilder.this.configRoot + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    private void writeTemplateFile(List list) {
        try {
            ResourceSet resourceSet = this.getResourceSet();
            URI uRI = URI.createFileURI((String)this.fileURI);
            Resource resource = resourceSet.createResource(uRI);
            resource.getContents().addAll((Collection)list);
            resource.save(new HashMap());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List readTemplateFile() {
        try {
            ResourceSet resourceSet = this.getResourceSet();
            URI uRI = URI.createFileURI((String)this.fileURI);
            Resource resource = resourceSet.createResource(uRI);
            resource.load(new HashMap());
            EList eList = resource.getContents();
            return eList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        GenericServerTemplateBuilder genericServerTemplateBuilder = new GenericServerTemplateBuilder();
        String string = System.getProperty("user.install.root");
        string = string + File.separator + "config";
        String string2 = string + File.separator + "templates" + File.separator + "servertypes" + File.separator + "GENERIC_SERVER" + File.separator + "serverindex.xml";
        System.out.println("Adding V6 serverEntries to " + string2);
        genericServerTemplateBuilder.setConfigRoot(string);
        genericServerTemplateBuilder.setFileName(string2);
        genericServerTemplateBuilder.addV6Templates();
    }
}

