/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import javax.management.InstanceNotFoundException;

public final class NodeCleanupUtility
extends AbstractNodeConfigUtility {
    private static TraceComponent tc = Tr.register(NodeCleanupUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "cleanupNode.log";

    public static void main(String[] stringArray) {
        System.exit(new NodeCleanupUtility().executeUtility(stringArray));
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0600I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        int n = 3;
        if (stringArray.length > 3 && !stringArray[3].startsWith("-")) {
            this.connHost = stringArray[3];
            n = 4;
            if (stringArray.length > 4 && !stringArray[4].startsWith("-")) {
                this.connPort = stringArray[4];
                n = 5;
            } else {
                this.connPort = "8879";
            }
        } else {
            this.connHost = "localhost";
            this.connPort = "8879";
        }
        return n;
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected void emitNotification(String string, String string2) {
    }

    protected int runTool() throws Exception {
        this.issueMessage("ADMU2001I", new Object[]{this.nodeName}, null);
        boolean bl = false;
        try {
            this.adminClient = this.getAdminClient(this.getClientProperties());
            if (this.nodeExistsInCell(this.adminClient)) {
                this.removeFromCell(this.adminClient);
                bl = true;
            } else {
                this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
            }
        }
        catch (Throwable throwable) {
            throw new AdminException(NodeCleanupUtility.getRootCause(throwable), throwable.getMessage());
        }
        if (bl) {
            this.issueMessage("ADMU2024I", new Object[]{this.nodeName}, null);
        }
        return 0;
    }

    private boolean nodeExistsInCell(AdminClient adminClient) throws InstanceNotFoundException, ConnectorException, ConfigServiceException {
        ConfigServiceProxy configServiceProxy = new ConfigServiceProxy(adminClient);
        Session session = new Session();
        if (configServiceProxy.resolve(session, "Node=" + this.nodeName).length > 0) {
            configServiceProxy.discard(session);
            return true;
        }
        configServiceProxy.discard(session);
        return false;
    }

    protected VariableMap getVariableMap() {
        return null;
    }

    protected Repository getLocalRepository() {
        return null;
    }
}

