/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClient;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.DistinguishedEndpointConstants;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.util.WASEcoreUtil;
import com.ibm.websphere.product.WASSystem;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.tools.DoNotDoAddNodeException;
import com.ibm.ws.management.tools.NodeAgentConfigBuilder;
import com.ibm.ws.management.tools.UpdateVirtualHost;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.management.util.PortConflictResolver;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class NodeFederationUtility
extends AbstractNodeConfigUtility
implements DistinguishedEndpointConstants {
    public static final String ADDNODE_ARCHIVE_PATH_KEY = "ADDNODE_ARCHIVE_PATH_KEY";
    public static final String CELL_NAME_KEY = "CELL_NAME_KEY";
    public static final String NODE_NAME_KEY = "NODE_NAME_KEY";
    public static final String NODE_Group_NAME_KEY = "NODE_Group_NAME_KEY";
    public static final String CORE_Group_NAME_KEY = "CORE_Group_NAME_KEY";
    public static final String APPSERVER_BOOTSTRAP_PORT_PROP = "APPSERVER_BOOTSTRAP_PORT";
    public static final int DEFAULT_APPSERVER_BOOTSTRAP_PORT = 9810;
    private static final TraceComponent tc = Tr.register(NodeFederationUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "addNode.log";
    private static final String FSEP = "/";
    protected String newCellName = null;
    private boolean setRollback = false;
    private boolean includeapps = false;
    private boolean includesecurity = true;
    private Vector appsIncluded = null;
    private Hashtable apps2path = null;
    private boolean launchNodeAgent = true;
    private Integer startingPort = null;
    private ObjectName repositoryHandle = null;
    private ConfigRepositoryClient configRepositoryClient = null;
    private Repository localRunTimeRepository = null;
    private VariableMap map = null;
    private IpcFactory ipcFactory = null;
    private ServerindexFactory indexFactory = null;
    private String originalDir = null;
    private String backupDir = null;
    private String backupRoot = null;
    private String origTemplatesDir = null;
    private String backupTemplatesDir = null;
    private String tmpCellDir = null;
    private boolean invokedFromMBean = false;
    private boolean nodeAddedToDmgr = false;
    private boolean registerService = false;
    private String serviceUserName = null;
    private String servicePassword = null;
    private String coreGroupName = "DefaultCoreGroup";
    private boolean includebuses = false;
    private String nodeAgentShortName = null;
    private Integer givenAppserverBootstrapPort = null;
    private String nodeGroupName = "DefaultNodeGroup";
    private ConfigServiceProxy configService = null;
    private CommandMgr cmdMgr = null;
    private static final int NODE_GROUP_CHECK_CONVERT_NEEDED = 2;
    private String fromDir;
    private String toNodeDir;
    private String nodeAgentDir;
    private String appDir;
    private Properties clientProps;
    private Properties nodeProperties = new Properties();
    private Properties portProperties = null;
    private String portPropsFileName = null;
    private String dcsHostName = null;
    private String localUserName = null;
    private String localPassword = null;
    private boolean noAutoSignerRetrieval = false;
    private NodeAgentConfigBuilder naConfigBuilder;
    private List _adminHosts = null;
    private List _adminPorts = null;
    private static final String REGISTER_SERVICE = "register_service";
    private static final String START_NODEAGENT = "start_nodeagent";

    public static void main(String[] stringArray) {
        Properties properties = System.getProperties();
        properties.put("com.ibm.WebSphere.main_class", "NodeFederationUtility");
        System.setProperties(properties);
        System.exit(new NodeFederationUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0000I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        int n = 4;
        this.connHost = stringArray[3];
        if (stringArray.length > 4 && !stringArray[4].startsWith("-")) {
            this.connPort = stringArray[4];
            ++n;
        } else {
            this.connPort = "8879";
        }
        return n;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-includeapps")) {
            this.includeapps = true;
            this.adminProperties.setProperty("-includeapps", "true");
        } else if (string.equals("-conntype")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.connType = stringArray[n + 1];
                this.adminProperties.setProperty("-connType", this.connType);
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-startingport")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.startingPort = new Integer(stringArray[n + 1]);
                this.adminProperties.setProperty("-startingPort", this.startingPort.toString());
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-nodegroupname")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.nodeGroupName = stringArray[n + 1];
                this.adminProperties.setProperty(NODE_Group_NAME_KEY, this.nodeGroupName);
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-noagent")) {
            this.launchNodeAgent = false;
            this.adminProperties.setProperty("-noagent", "false");
        } else if (string.equals("-registerservice")) {
            this.registerService = true;
            this.adminProperties.setProperty("-registerservice", "true");
        } else if (string.equals("-serviceusername")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.serviceUserName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-servicepassword")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.servicePassword = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-coregroupname")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.coreGroupName = stringArray[n + 1];
                this.adminProperties.setProperty(CORE_Group_NAME_KEY, this.coreGroupName);
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-nodeagentshortname")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.nodeAgentShortName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-portprops")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.portPropsFileName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-dcshostname")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.dcsHostName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-localusername")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.localUserName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-localpassword")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.localPassword = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-fromMBean")) {
            this.invokedFromMBean = true;
            this.adminProperties.setProperty("-fromMBean", "true");
        } else if (string.equals("-includebuses")) {
            this.includebuses = true;
            this.adminProperties.setProperty("-includebuses", "true");
        } else if (string.equals("-noautosignerretrieval")) {
            this.noAutoSignerRetrieval = true;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected void toolFailed(Throwable throwable) {
        if (this.setRollback) {
            this.rollbackToBase();
        }
        super.toolFailed();
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    protected int runTool() throws Exception {
        if (!this.noAutoSignerRetrieval) {
            String[] stringArray = new String[]{"CellDefaultTrustStore", "ClientDefaultTrustStore", "-host", this.connHost, "-port", this.connPort, "-user", this.userid, "-password", this.pwd, "-conntype", this.connType, "-autoAcceptBootstrapSigner"};
            RetrieveSignersHelper retrieveSignersHelper = RetrieveSignersHelper.getInstance();
            retrieveSignersHelper.callRetrieveSigners(stringArray);
        }
        this.createAdminClientInstance();
        this.notificationService = this.getNotificationServiceMBean();
        try {
            if (!(this.serviceUserName == null && this.servicePassword == null || this.registerService && this.serviceUserName != null && this.servicePassword != null)) {
                this.issueMessage("ADMU1502E", null, null);
                throw new AdminException(this.getFormattedMessage("ADMU1502E", null, null));
            }
            this.getNodeProperties();
            if (this.portPropsFileName != null) {
                this.validatePortPropsFileName();
                if (this.startingPort != null) {
                    this.startingPort = null;
                    this.issueMessage("ADMU0060W", null, null);
                }
            }
            if (this.nodeAgentShortName != null && !AdminHelper.getPlatformHelper().isZOS()) {
                this.nodeAgentShortName = null;
                this.issueMessage("ADMU0061W", null, null);
            }
            this.doSetUp();
            this.doCheckIfAddNodeIsOkToRun();
            this.doAddNode();
            this.doPostAddNodeProcessing();
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU0027E", new Object[]{NodeFederationUtility.getRootCause(throwable).getMessage()}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            throw Utils.makeAdminException(throwable);
        }
        return 0;
    }

    private void validatePortPropsFileName() throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validatePortProps entry");
        }
        this.portProperties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.portPropsFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AdminException(fileNotFoundException, "Qualified filename, " + this.portPropsFileName + ", not found");
        }
        try {
            this.portProperties.load(fileInputStream);
            String string = this.portProperties.getProperty(APPSERVER_BOOTSTRAP_PORT_PROP);
            if (string != null) {
                this.givenAppserverBootstrapPort = new Integer(string);
                this.portProperties.remove(APPSERVER_BOOTSTRAP_PORT_PROP);
            }
        }
        catch (IOException iOException) {
            throw new AdminException(iOException, "Exception encounter while trying to load properties from " + this.portPropsFileName);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            this.prepareORBLAandBOOTSTRAP_ADDRESS(this.portProperties);
        }
    }

    private void prepareORBLAandBOOTSTRAP_ADDRESS(Properties properties) throws AdminException {
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isZOS = true, prepareORBLAandBOOTSTRAP_ADDRESS entry");
        }
        String string = properties.getProperty("BOOTSTRAP_ADDRESS");
        String string2 = properties.getProperty("ORB_LISTENER_ADDRESS");
        if (string2 != null && string == null) {
            properties.setProperty("BOOTSTRAP_ADDRESS", string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "only ORB_LISTENER_ADDRESS was set " + string2 + ". set BOOTSTRAP_ADDRESS to ORB_LISTENER_ADDRESS in this case");
            }
        }
    }

    private void doRegisterService() throws AdminException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-add");
        arrayList.add(this.nodeName + "_nodeagent");
        arrayList.add("-serverName");
        arrayList.add("nodeagent");
        arrayList.add("-profilePath");
        arrayList.add(System.getProperty("user.install.root").replace('/', '\\'));
        arrayList.add("-restart");
        arrayList.add("false");
        arrayList.add("-startType");
        arrayList.add("automatic");
        Properties properties = this.adminClient.getConnectorProperties();
        if (properties.getProperty("username") != null && properties.getProperty("password") != null && !properties.getProperty("username").equals("") && !properties.getProperty("password").equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting -stopArgs paramaters");
            }
            arrayList.add("-stopArgs");
            arrayList.add("\"-username " + properties.getProperty("username") + " -password " + properties.getProperty("password") + "\"");
            arrayList.add("-encodeParams");
        }
        this.execWASService(REGISTER_SERVICE, arrayList);
    }

    private void doStartService() throws AdminException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-start");
        arrayList.add(this.nodeName + "_nodeagent");
        this.execWASService(START_NODEAGENT, arrayList);
    }

    private void execWASService(String string, List list) throws AdminException {
        String string2 = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "WASService.exe";
        Tr.debug(tc, "Doing " + string + " using WASService");
        Tr.debug(tc, "  Executable: " + string2);
        Tr.debug(tc, "  Arguments: " + list.toString());
        if (this.serviceUserName != null && string.equals(REGISTER_SERVICE)) {
            Tr.debug(tc, "  Using -userid " + this.serviceUserName);
            list.add("-userid");
            list.add(this.serviceUserName);
            Tr.debug(tc, "  Using -password ****");
            list.add("-password");
            list.add(this.servicePassword);
        }
        CreationParams creationParams = new CreationParams();
        Tr.debug(tc, "cmdToXqt = " + string2);
        creationParams.setExecutable(string2);
        creationParams.setProcessName("WAS_" + string);
        creationParams.setDetachProcess(true);
        String[] stringArray = new String[list.size()];
        stringArray = list.toArray(stringArray);
        creationParams.setCommandLineArgs(stringArray);
        try {
            Tr.debug(tc, "Launching " + string + " process ...");
            com.ibm.ws.process.Process process = ProcessFactory.create(creationParams);
            process.waitForTermination();
            Tr.debug(tc, "Exit code from WASService: " + process.getExitCode());
            process.release();
            System.out.println();
        }
        catch (Exception exception) {
            this.issueMessage("ADMU1500W", null, null);
            throw new AdminException(this.getFormattedMessage("ADMU1500W", null, null));
        }
    }

    private void doAddNode() throws Exception, DoNotDoAddNodeException {
        this.collectNodeMetadata(null);
        this.doSetLockOnDMgrForAddAndRemoveNode();
        this.doPreConfigUpdateProcessing();
        if (this.includeapps) {
            this.doRemoveWebServers();
        }
        this.doAllConfigUpdates();
        this.doReleaseLockOnDMgrForAddAndRemoveNode();
    }

    private void doConfigOnDMgr() throws Exception {
        ObjectName objectName = this.getMBeanByType("AdminOperations");
        if (objectName == null) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.invokeMBean(objectName, "mergeConfigDataOnDmgr", new Object[]{this.nodeProperties, this.adminProperties}, new String[]{"java.util.Properties", "java.util.Properties"});
    }

    private void getNodeProperties() throws AdminException {
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
        Properties properties = new Properties();
        properties.setProperty("local.cell", this.cellName);
        properties.setProperty("was.repository.root", this.configRoot);
        managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
        this.nodeProperties = managedObjectMetadataAccessor.getMetadataProperties(this.nodeName);
        this.nodeProperties.setProperty(CELL_NAME_KEY, this.cellName);
        this.nodeProperties.setProperty(NODE_NAME_KEY, this.nodeName);
    }

    private void doDisableRollback() {
        this.setRollback = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRollback = false");
        }
    }

    private void doEnableRollback() {
        this.setRollback = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRollback = true");
        }
    }

    private void doAllConfigUpdates() throws Exception {
        this.doEnableRollback();
        this.doRemoveDeployedAppsFromSystemApps();
        this.copyConfigToNewCell();
        this.addPMIConfigForNodeAgent();
        this.deleteNamestoreFiles();
        this.doUpdateConfigDocumentsOnLocalMachine();
        this.doUploadConfigDocumentsToDMgr();
        this.doConfigOnDMgr();
        this.doRegenNDPluginConfig();
        this.doUpdateVirtualHost();
        this.syncNode();
        this.doValidateAddNodeWasSuccessful();
        this.doDisableRollback();
    }

    private void addPMIConfigForNodeAgent() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPMIConfigForNodeAgent()");
        }
        File file = new File(this.configRoot + "/templates/system/nodes/servers/nodeagent/pmi-config.xml");
        File file2 = new File(this.nodeAgentDir);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File file3 = new File(this.nodeAgentDir + "pmi-config.xml");
        this.copyDocument(file, file3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPMIConfigForNodeAgent()");
        }
    }

    private void doRemoveWebServers() throws Exception {
        String string = null;
        AppManagement appManagement = AppManagementProxy.getLocalProxy();
        Vector vector = this.getNodeList();
        for (int i = 0; i < vector.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeName[" + i + "]: " + vector.get(i));
            }
            if (((String)vector.get(i)).equals(this.nodeName)) continue;
            this.issueMessage("ADMU0129I", new Object[]{vector.get(i)}, "ADMU0129I: Remote server in node {0} will not be propagated to new cell.  Create new server and map applications as necessary using deployment manager.");
            appManagement.removeAllAppsFromNode((String)vector.get(i), this.cellName, null, string);
        }
    }

    private Vector getNodeList() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.configRoot + "/cells/" + this.cellName + "/nodes";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                String string2 = fileArray[i].getName();
                vector.add(string2);
            }
        }
        return vector;
    }

    private void doRemoveDeploymentTargets(List list, List list2) throws AdminException {
        block2: for (int i = 0; i < list.size(); ++i) {
            Deployment deployment = (Deployment)list.get(i);
            EList eList = deployment.getDeploymentTargets();
            while (true) {
                ServerTarget serverTarget = null;
                DeploymentTarget deploymentTarget = null;
                boolean bl = false;
                for (int j = 0; j < eList.size(); ++j) {
                    deploymentTarget = (DeploymentTarget)eList.get(j);
                    if (!(deploymentTarget instanceof ServerTarget) || (serverTarget = (ServerTarget)deploymentTarget).getNodeName().equals(this.nodeName)) continue;
                    if (!this.isInList(deploymentTarget.getName(), list2)) {
                        list2.add(deploymentTarget.getName());
                        this.issueMessage("ADMU0129I", new Object[]{deploymentTarget.getName()}, "ADMU0129I: Remote server {0} will not be propagated to new cell.  Create new server and map applications as necessary using deployment manager.");
                    }
                    WASEcoreUtil.remove((EObject)deploymentTarget);
                    bl = true;
                    break;
                }
                if (!bl) continue block2;
                try {
                    deployment.eResource().save(new HashMap());
                }
                catch (Throwable throwable) {
                    throw Utils.makeAdminException(throwable);
                }
                bl = false;
            }
        }
    }

    private void doRemoveDeployedAppsFromSystemApps() throws Exception {
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = null;
        try {
            resource = configRoot.getResource(3, "systemapps.xml");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        EList eList = resource.getContents();
        Object var4_5 = null;
        ServerIndex serverIndex = null;
        ServerEntry serverEntry = null;
        if (eList == null || eList.isEmpty() || !(eList.get(0) instanceof ServerIndex)) {
            return;
        }
        serverIndex = (ServerIndex)eList.get(0);
        EList eList2 = serverIndex.getServerEntries();
        for (int i = 0; i < eList2.size(); ++i) {
            var4_5 = eList2.get(i);
            if (!(var4_5 instanceof ServerEntry)) continue;
            serverEntry = var4_5;
            Iterator iterator = serverEntry.getDeployedApplications().iterator();
            while (iterator.hasNext()) {
                String string = this.map.expand((String)iterator.next());
                if (this.shouldRetainSystemApp(string)) continue;
                iterator.remove();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "remove sys app - " + string);
            }
            serverEntry.eResource().save(new HashMap());
        }
    }

    private boolean shouldRetainSystemApp(String string) {
        Properties properties = this.getSystemAppProps(string);
        if (properties.isEmpty()) {
            return false;
        }
        if (properties.getProperty("com.ibm.websphere.systemapps.retainND").equals("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ShouldRetainSystemApp = true");
            }
            return true;
        }
        return false;
    }

    private Properties getSystemAppProps(String string) {
        return this.loadPropsFromFile(string + FSEP + "META-INF/ibm-application-sa.props");
    }

    private Properties loadPropsFromFile(String string) {
        Properties properties;
        block4: {
            properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
                fileInputStream.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read props file from " + string);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Warning: Exception in reading " + string + " ex: " + throwable);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "props = " + properties.toString());
        }
        return properties;
    }

    private void doUploadConfigDocumentsToDMgr() throws Exception {
        try {
            this.issueMessage("ADMU0014I", new Object[]{this.nodeName, this.newCellName}, null);
            this.createAppDocuments(this.appDir);
            File file = File.createTempFile(this.nodeName + "__", ".car");
            String string = this.configRoot + "/cells/" + this.cellName;
            this.deleteDirs(string);
            boolean bl = this.isQuiet();
            this.setQuiet(true);
            this.compressDir(this.configRoot + "/cells", file);
            this.setQuiet(bl);
            String string2 = this.copyToServer(file, "upload/addNode/" + this.nodeName + FSEP + this.nodeName + Long.toHexString(System.currentTimeMillis()) + ".car");
            this.nodeProperties.put(ADDNODE_ARCHIVE_PATH_KEY, string2);
            this.nodeAddedToDmgr = true;
        }
        catch (Exception exception) {
            this.nodeAddedToDmgr = false;
            Tr.error(tc, "ADMU0011E", exception);
            throw exception;
        }
    }

    private void doUpdateConfigDocumentsOnLocalMachine() throws Exception {
        block7: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create a new local config directory and server.xml for node agent");
            }
            this.createNodeAgentServerDoc(this.nodeAgentDir);
            this.createHAMgrXml(this.nodeAgentDir);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setup NodeAgent data");
            }
            this.setupNodeAgentData(this.newCellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fix up local serverindex.xml");
            }
            this.addToServerIndex("nodeagent");
            if (System.getProperty("os.name").equals("OS/400")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "os.name is " + System.getProperty("os.name"));
                }
                try {
                    this.doUpdateNodeAgentIPv6();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Exception caught updating nodeagent for IPv6", exception);
                }
            }
        }
    }

    private void doUpdateNodeAgentIPv6() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "determine if nodeagent fix required for IPv6 on i5/OS");
            Tr.debug(tc, "os.version is " + System.getProperty("os.version"));
        }
        if (System.getProperty("os.version").startsWith("V5R4")) {
            String string = System.getProperty("java.net.preferIPv4Stack");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value of java.net.preferIPv4Stack system property is " + string);
            }
            if (string != null && string.equals("false")) {
                this.doAddSystemProperty();
            }
        }
    }

    private void doAddSystemProperty() throws Exception {
        Object object;
        Object object2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "add IPv6 system property to nodeagent");
        }
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(4, "server.xml");
        Server server2 = (Server)resource.getContents().get(0);
        JavaProcessDef javaProcessDef = null;
        EList eList = server2.getProcessDefinitions();
        for (int i = 0; i < eList.size(); ++i) {
            object2 = eList.get(i);
            if (!(object2 instanceof JavaProcessDef)) continue;
            javaProcessDef = (JavaProcessDef)object2;
            break;
        }
        if (javaProcessDef == null) {
            throw new Exception("JavaProcessDef is null");
        }
        EList eList2 = javaProcessDef.getJvmEntries();
        object2 = null;
        for (int i = 0; i < eList2.size(); ++i) {
            object = eList2.get(i);
            if (!(object instanceof JavaVirtualMachine)) continue;
            object2 = (JavaVirtualMachine)object;
            break;
        }
        if (object2 == null) {
            throw new Exception("JavaVirtualMachine is null");
        }
        EList eList3 = object2.getSystemProperties();
        if (eList3 == null) {
            throw new Exception("SystemProperties is null");
        }
        object = PropertiesFactory.eINSTANCE.createProperty();
        object.setName("java.net.preferIPv4Stack");
        object.setValue("false");
        eList3.add(object);
        resource.save(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPreConfigUpdateProcessing() throws Exception {
        this.configRepositoryClient = this.getRepositoryClient(this.clientProps);
        ModelMgr.initialize("ws-server");
        this.fromDir = this.configRoot + "/cells/" + this.cellName;
        this.toNodeDir = this.configRoot + "/cells/" + this.newCellName + "/nodes/" + this.nodeName;
        this.nodeAgentDir = this.toNodeDir + "/servers/nodeagent/";
        this.tmpCellDir = this.configRoot + "/cells/" + this.newCellName;
        this.appDir = this.tmpCellDir + "/applications";
        this.originalDir = this.fromDir;
        this.localRunTimeRepository = null;
        this.map = null;
        Object object = null;
        boolean bl = false;
        if (this.localUserName == null && this.localPassword == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "localUserName is null, setting to value of userid: " + this.userid);
            }
            this.localUserName = this.userid;
            this.localPassword = this.pwd;
        } else {
            object = AdminDataHolder.getData("wsSubject");
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saved subject: " + object);
            }
        }
        try {
            this.stopAllServers(this.localUserName, this.localPassword);
        }
        finally {
            if (bl) {
                if (object == null) {
                    AdminDataHolder.removeData("wsSubject");
                } else {
                    AdminDataHolder.setData("wsSubject", object);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restored subject: " + object);
                }
            }
        }
        this.makeBackups();
    }

    private void doPostAddNodeProcessing() throws Exception {
        this.doPostAddNodeUpdateLocalFiles();
        if (this.isZOS()) {
            this.transformConfig2Native(this.newCellName, this.nodeName);
            System.setProperty("was.serverstart.cell", this.newCellName);
            System.setProperty("was.serverstart.node", this.nodeName);
            System.setProperty("was.serverstart.server", "nodeagent");
        }
        if (this.registerService && NodeFederationUtility.isPlatformWindows()) {
            this.doRegisterService();
            if (this.launchNodeAgent) {
                this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
                this.doStartService();
            }
        } else if (this.launchNodeAgent) {
            try {
                this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
                this.launchNodeAgent();
            }
            catch (Exception exception) {
                this.issueMessage("ADMU0114E", null, null);
                Tr.debug(tc, "Node Agent didn't start successfully - but continuing with Node Federation");
            }
        }
        this.cellName = this.newCellName;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("nodeagent");
        this.removeAllServices(arrayList);
        this.doPostAddNodeIssueMessages();
    }

    private void doPostAddNodeIssueMessages() {
        this.issueMessage("ADMU9990I", null, null);
        if (!this.includeapps) {
            this.issueMessage("ADMU0300I", new Object[]{this.nodeName, this.newCellName}, null);
        } else {
            this.issueMessage("ADMU0308I", new Object[]{this.nodeName, this.newCellName}, null);
        }
        this.issueMessage("ADMU9990I", null, null);
        this.showNextTasks();
    }

    private void doPostAddNodeUpdateLocalFiles() throws Exception {
        File file = new File(this.fromDir);
        file.delete();
        this.fixSetupCmdLine(this.newCellName, this.clientProps);
        this.fixWsadminProps(this.clientProps);
    }

    private void doValidateAddNodeWasSuccessful() throws Exception {
        this.throwExceptionIfNodeCannotPingCellMgr();
    }

    private void doReleaseLockOnDMgrForAddAndRemoveNode() throws Exception {
        this.completeAddOrRemoveNode();
    }

    private void doRegenNDPluginConfig() throws Exception {
        ObjectName objectName;
        ObjectName objectName2 = this.getMBeanByType("PluginCfgGenerator");
        if (objectName2 != null && (objectName = this.getMBeanByType("JVM")) != null) {
            String string = (String)this.adminClient.invoke(objectName, "getProperty", new Object[]{"user.install.root"}, new String[]{"java.lang.String"});
            Object var4_4 = null;
            try {
                this.invokeMBean(objectName2, "generate", new Object[]{string, var4_4, this.newCellName, null, null, "plugin-cfg.xml"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
            }
            catch (MBeanException mBeanException) {
                this.issueMessage("ADMU0040E", new Object[]{objectName2, "generate", mBeanException}, null);
            }
        }
    }

    private void doUpdateVirtualHost() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doUpdateVirtualHost");
        }
        if (this._adminHosts == null) {
            this.getAdminHostPorts();
        }
        UpdateVirtualHost updateVirtualHost = new UpdateVirtualHost(this.configService);
        updateVirtualHost.updateDefaultHostHostAliases(this.connHost, this._adminHosts, this._adminPorts);
    }

    private void doSetLockOnDMgrForAddAndRemoveNode() throws Exception, DoNotDoAddNodeException {
        if (!this.beginAddOrRemoveNode()) {
            this.issueMessage("ADMU0041E", null, null);
            throw new DoNotDoAddNodeException();
        }
        Runtime.getRuntime().addShutdownHook(new AbstractNodeConfigUtility.ShutdownThread());
    }

    private void doCheckIfAddNodeIsOkToRun() throws Exception {
        ObjectName objectName;
        if (this.isMemberOfCell()) {
            this.issueMessage("ADMU0033E", new Object[]{this.nodeName}, null);
            throw new DoNotDoAddNodeException(this.getFormattedMessage("ADMU0033E", new Object[]{this.nodeName}, null));
        }
        if (this.nodeNameAlreadyExistsInCell()) {
            throw new AdminException(this.getFormattedMessage("ADMU0039E", new Object[]{this.nodeName}, null));
        }
        if (!this.isDmgrSameOrLaterVersion()) {
            this.issueMessage("ADMU0126E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null);
            throw new DoNotDoAddNodeException(this.getFormattedMessage("ADMU0126E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null));
        }
        if (!this.isClockInSync()) {
            this.failAddNodeBecauseClocksNotInSync();
        }
        if ((objectName = this.getMBeanByType("AdminOperations")) == null) {
            throw new AdminException("Could not get the deployment manager's AdminOperations MBean");
        }
        MBeanInfo mBeanInfo = this.adminClient.getMBeanInfo(objectName);
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!mBeanOperationInfoArray[i].getName().equals("checkNodeAndDmgrCompatibility")) continue;
            this.invokeMBean(objectName, "checkNodeAndDmgrCompatibility", new Object[]{this.nodeProperties}, new String[]{"java.util.Properties"});
            break;
        }
        this.checkProductExtensionsNew(this.nodeProperties, this.adminClient);
        this.checkProductExtensions(this.getWASProduct(), this.adminClient);
        if (this.sameNodeAsCellMgr()) {
            throw new AdminException(this.getFormattedMessage("ADMU0032E", new Object[]{this.nodeName}, null));
        }
        if (this.sameNameAsCell()) {
            throw new AdminException(this.getFormattedMessage("ADMU0034E", new Object[]{this.newCellName}, "ADMU0034E: The node/cell name of the node being federated must have a different name than the cell name of the ND manager node: {0}"));
        }
        this.checkIfNodeCanJoinNodeGroup();
    }

    private void checkIfNodeCanJoinNodeGroup() throws Exception {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfNodeCanJoinNodeGroup()");
            }
            Throwable throwable = null;
            Session session = new Session();
            try {
                Properties properties = new Properties();
                properties.setProperty("local.cell", this.cellName);
                properties.setProperty("was.repository.root", this.configRoot);
                ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
                String string = managedObjectMetadataHelper.getNodePlatformOS(this.nodeName);
                String string2 = managedObjectMetadataHelper.getNodeBaseProductVersion(this.nodeName);
                Properties properties2 = managedObjectMetadataHelper.getAccessor().getMetadataProperties(this.nodeName);
                String string3 = properties2.getProperty("com.ibm.websphere.nodeSysplexName");
                AdminCommand adminCommand = null;
                if (this.cmdMgr == null) {
                    this.cmdMgr = CommandMgr.getCommandMgr();
                }
                adminCommand = this.cmdMgr.createCommand("canNodeJoinNodeGroup");
                adminCommand.setConfigSession(session);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeGroupName = " + this.nodeGroupName);
                    Tr.debug(tc, "nodeName      = " + this.nodeName);
                    Tr.debug(tc, "platform      = " + string);
                    Tr.debug(tc, "version       = " + string2);
                    Tr.debug(tc, "sysplexName   = " + string3);
                }
                adminCommand.setParameter("nodeGroupName", this.nodeGroupName);
                adminCommand.setParameter("nodeName", this.nodeName);
                adminCommand.setParameter("platform", string);
                adminCommand.setParameter("version", string2);
                adminCommand.setParameter("sysplexName", string3);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                Collection collection = commandResult.getMessages();
                this.issueWarningsIfAny(collection, "ADMU0054W");
                if (commandResult.isSuccessful()) {
                    int n = (Integer)commandResult.getResult();
                    if (n == 2) {
                        adminCommand = this.cmdMgr.createCommand("convertToSysplexNodeGroup");
                        adminCommand.setConfigSession(session);
                        adminCommand.setTargetObject(this.nodeGroupName);
                        this.setConvertToSysplexNodeGroupParams(adminCommand);
                        adminCommand.execute();
                        commandResult = adminCommand.getCommandResult();
                        collection = commandResult.getMessages();
                        this.issueWarningsIfAny(collection, "ADMU0055W");
                        if (!commandResult.isSuccessful()) {
                            throwable = commandResult.getException();
                            throw new AdminException(throwable, this.getFormattedMessage("ADMU0051E", new Object[]{throwable, this.nodeGroupName, this.nodeName}, "ADMU0051E: Exception occurred while converting node group {2} to sysplex node group for node {1}. {0}"));
                        }
                    }
                    this.configService.save(session, true);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfNodeCanJoinNodeGroup()");
                    }
                    break block12;
                }
                throwable = commandResult.getException();
                throw new AdminException(throwable, this.getFormattedMessage("ADMU0050E", new Object[]{throwable, this.nodeName, this.nodeGroupName}, "ADMU0050E: Exception encountered while checking if node {1} can join node group {2}. {0}"));
            }
            catch (Exception exception) {
                throw new AdminException(exception, this.getFormattedMessage("ADMU0050E", new Object[]{exception, this.nodeName, this.nodeGroupName}, "ADMU0050E: Exception encountered while checking if node {1} can join node group {2}. {0}"));
            }
            finally {
                this.configService.discard(session);
            }
        }
    }

    public void setConvertToSysplexNodeGroupParams(AdminCommand adminCommand) throws Exception {
        Properties properties = new Properties();
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        String string = configRoot.getValue(0);
        configRoot.setValue(0, this.cellName);
        Resource resource = configRoot.getResource(0, "nodegroups" + File.separator + this.getSysplexNodeGroup() + File.separator + "nodegroup.xml");
        NodeGroup nodeGroup = (NodeGroup)resource.getContents().get(0);
        EList eList = nodeGroup.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop is: ", property);
            }
            if (!property.getName().startsWith("was.")) continue;
            properties.put(property.getName(), property.getValue());
        }
        configRoot.setValue(0, string);
        adminCommand.setParameter("shortName", nodeGroup.getShortName());
        adminCommand.setParameter("sysplexProps", properties);
    }

    public String getSysplexNodeGroup() throws Exception {
        String string = null;
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        String string2 = configRoot.getValue(3);
        configRoot.setValue(3, this.nodeName);
        Resource resource = configRoot.getResource(3, "node.xml");
        Node node = (Node)resource.getContents().get(0);
        EList eList = node.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals("was.sysplexNodeGroup")) continue;
            string = property.getValue();
            break;
        }
        configRoot.setValue(3, string2);
        return string;
    }

    private void failAddNodeBecauseClocksNotInSync() throws Exception {
        long l = System.currentTimeMillis();
        long l2 = Utils.getRemoteTime(this.adminClient, this.getMBeanByType("JVM"));
        Date date = new Date(l);
        Date date2 = new Date(l2);
        String string = DateFormat.getDateTimeInstance().format(date2);
        String string2 = DateFormat.getDateTimeInstance().format(date);
        this.issueMessage("ADMU0124I", new Object[]{string2, string}, "ADMU0124I: The system clock of the new node {0} is not synchronized with that of the deployment manager {1}.");
        this.issueMessage("ADMU0125E", new Object[]{String.valueOf(5L)}, "ADMU0125E: Change the clock of the new node to be within 5 minutes of the clock of the deployment manager.");
        throw new DoNotDoAddNodeException();
    }

    private void doSetUp() throws Exception {
        this.createAdminClientInstance();
        this.configService = new ConfigServiceProxy(this.adminClient);
        this.cmdMgr = CommandMgr.getClientCommandMgr(this.adminClient);
        if (!this.isConnectedToDeploymentManager()) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.issueMessage("ADMU0009I", new Object[]{this.connHost, this.connPort}, null);
        this.repositoryHandle = this.getMBeanByType("ConfigRepository");
        this.newCellName = ObjectNameHelper.getCellName(this.repositoryHandle);
        this.clientProps.setProperty("cellName", this.newCellName);
        this.appsIncluded = new Vector();
        this.apps2path = new Hashtable();
    }

    private void createAdminClientInstance() throws Exception {
        this.issueMessage("ADMU0001I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        this.clientProps = this.getClientProperties();
        if ("RMI".equals(this.clientProps.getProperty("type")) && this.clientProps.getProperty("host") != null && this.clientProps.getProperty("port") != null) {
            Properties properties = System.getProperties();
            properties.setProperty("com.ibm.CORBA.securityServerHost", this.clientProps.getProperty("host"));
            properties.setProperty("com.ibm.CORBA.securityServerPort", this.clientProps.getProperty("port"));
            System.setProperties(properties);
        }
        this.adminClient = this.getAdminClient(this.clientProps);
        if (AdminDataHolder.getData("adminClient") == null) {
            AdminDataHolder.setData("adminClient", this.adminClient);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adminClient connectorProps = " + DebugUtils.createPropertiesMaskPlainTextPassword(this.adminClient.getConnectorProperties()));
        }
    }

    private boolean nodeNameAlreadyExistsInCell() throws InstanceNotFoundException, ConnectorException, ConfigServiceException {
        Session session = new Session();
        if (this.configService.resolve(session, "Node=" + this.nodeName).length > 0) {
            this.configService.discard(session);
            return true;
        }
        this.configService.discard(session);
        return false;
    }

    private boolean isConnectedToDeploymentManager() throws Exception {
        ObjectName objectName = this.getMBeanByType("DeploymentManager");
        return objectName != null;
    }

    protected boolean isDmgrSameOrLaterVersion() throws Exception {
        String string = Utils.getProductVersion();
        String string2 = this.getDMgrVersion();
        if (string == null || string2 == null) {
            return true;
        }
        int n = Utils.compareVersions(string2, string);
        return n >= 0;
    }

    protected String getDMgrVersion() throws Exception {
        return Utils.getRemoteProductVersion("ND", this.getMBeanByType("Server"), this.adminClient);
    }

    private boolean isClockInSync() throws Exception {
        return Utils.isClockInSync(this.adminClient, this.getMBeanByType("JVM"));
    }

    private void makeBackups() throws Exception {
        this.backupRoot = this.getBackupRoot(this.getLocalRepository(), this.getVariableMap());
        this.backupDir = this.backupRoot + "/base/cells/" + this.cellName;
        this.backupTemplatesDir = this.backupRoot + "/base/templates";
        this.origTemplatesDir = this.configRoot + "/templates";
        this.deleteBackupDirectory();
        this.issueMessage("ADMU0015I", null, null);
        this.backupConfigDirectory();
        this.backupPluginCfg();
        this.backupTemplates();
    }

    private void deleteBackupDirectory() throws Exception {
        this.issueMessage("ADMU0024I", null, null);
        this.deleteDirs(this.backupDir);
        this.deleteDirs(this.backupTemplatesDir);
    }

    private void backupConfigDirectory() throws Exception {
        File file = new File(this.backupDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copying " + this.originalDir + " to " + this.backupDir);
        }
        this.copyDocuments(this.originalDir, this.backupDir);
    }

    private void backupPluginCfg() throws Exception {
        File file = new File(this.configRoot + "/plugin-cfg.xml");
        File file2 = new File(this.backupRoot + "/base/plugin-cfg.xml");
        if (file.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copying " + file + " to " + file2);
            }
            this.copyDocument(file, file2);
        }
        File file3 = new File(this.configRoot + "/plugin-cfg-service.xmi");
        File file4 = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
        if (file3.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copying " + file3 + " to " + file4);
            }
            this.copyDocument(file3, file4);
        }
    }

    private void backupTemplates() throws Exception {
        File file = new File(this.backupTemplatesDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copying " + this.origTemplatesDir + " to " + this.backupTemplatesDir);
        }
        this.copyDocuments(this.origTemplatesDir, this.backupTemplatesDir);
    }

    private void copyConfigToNewCell() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copy files into new structure to match new cell");
        }
        this.copyDocuments(this.originalDir, this.tmpCellDir);
    }

    private void deleteNamestoreFiles() {
        String string = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        String[] stringArray = new String[]{"namestore-cell.xml", "namestore-node.xml"};
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    try {
                        File file2 = new File(fileArray[i], stringArray[j]);
                        if (!file2.exists()) continue;
                        file2.delete();
                        continue;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Error trying to delete exception list", exception);
                    }
                }
            }
        }
    }

    private void createHAMgrXml(String string) throws Exception {
        String string2 = this.configRoot + "/templates/servertypes/APPLICATION_SERVER/servers/default";
        File file = new File(string, "hamanagerservice.xml");
        File file2 = new File(string2, "hamanagerservice.xml");
        this.copyDocument(file2, file);
    }

    private void createNodeAgentServerDoc(String string) throws Exception {
        this.issueMessage("ADMU0012I", new Object[]{this.nodeName}, null);
        this.naConfigBuilder = new NodeAgentConfigBuilder();
        this.naConfigBuilder.setConfigRepositoryRoot(string);
        this.naConfigBuilder.setProcessName("nodeagent");
        this.naConfigBuilder.setNodeName(this.nodeName);
        if (this.nodeAgentShortName != null) {
            this.naConfigBuilder.setNodeAgentShortName(this.nodeAgentShortName);
        }
        if (this.portProperties != null) {
            this.naConfigBuilder.setPortProperties(this.portProperties);
        }
        this.naConfigBuilder.write(this.naConfigBuilder.buildRootElements(), "server.xml");
    }

    protected void syncNode() throws Exception {
        NodeSync nodeSync = NodeSync.createNodeSync();
        try {
            this.clientProps.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            nodeSync.initialize(this.clientProps, null, this.getVariableMap());
            this.issueMessage("ADMU0016I", null, null);
            Boolean bl = nodeSync.sync();
            if (!bl.booleanValue()) {
                throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[]{""}, null));
            }
        }
        catch (AdminException adminException) {
            Tr.error(tc, "ADMU0005E", adminException);
            throw adminException;
        }
    }

    private void rollbackToBase() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackToBase");
        }
        this.issueMessage("ADMU0026I", null, null);
        try {
            File file;
            File file2;
            File file3;
            File file4 = new File(this.originalDir);
            if (!file4.exists()) {
                file4.mkdirs();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy " + this.backupDir + " to " + this.originalDir);
            }
            if ((file3 = new File(this.backupDir)).exists()) {
                this.copyDocuments(this.backupDir, this.originalDir);
            }
            if (!(file2 = new File(this.origTemplatesDir)).exists()) {
                file2.mkdirs();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copying " + this.backupTemplatesDir + " to " + this.origTemplatesDir);
            }
            if (file3.exists()) {
                this.copyDocuments(this.backupTemplatesDir, this.origTemplatesDir);
            }
            File file5 = new File(this.configRoot + "/plugin-cfg.xml");
            File file6 = new File(this.backupRoot + "/base/plugin-cfg.xml");
            if (file6.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copy " + file6 + " to " + file5);
                }
                this.copyDocument(file6, file5);
            }
            File file7 = new File(this.configRoot + "/plugin-cfg-service.xmi");
            File file8 = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
            if (file8.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copy " + file8 + " to " + file7);
                }
                this.copyDocument(file8, file7);
            }
            if (this.apps2path.size() > 0) {
                this.rollbackBinaries();
            }
            if ((file = new File(this.tmpCellDir)).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delete " + this.tmpCellDir);
                }
                this.deleteDirs(this.tmpCellDir);
                file.delete();
            }
            if (this.nodeAddedToDmgr) {
                this.removeFromCell(this.adminClient);
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0007E", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackToBase");
        }
    }

    private void rollbackBinaries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackBinaries");
        }
        try {
            VariableMap variableMap = this.getVarMap(this.backupRoot + "/base", this.cellName, this.nodeName);
            VariableMap variableMap2 = this.getVarMap(this.configRoot, this.newCellName, this.nodeName);
            Enumeration enumeration = this.apps2path.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)this.apps2path.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing: " + string + " for paths: " + vector);
                }
                Vector<String> vector2 = new Vector<String>();
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = variableMap.expand((String)vector.elementAt(i));
                    if (!this.appsIncluded.contains(string)) {
                        vector2.addElement(string2);
                        continue;
                    }
                    String string3 = variableMap2.expand((String)vector.elementAt(i));
                    if (string2.equals(string3)) continue;
                    vector2.addElement(string2);
                    this.deleteDirs(string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Rollback " + string + " to be expanded to: " + vector2);
                }
                this.expandEar(this.originalDir + "/applications/" + string + FSEP + string, vector2);
            }
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU0089E", new Object[]{throwable}, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackBinaries");
        }
    }

    private boolean sameNodeAsCellMgr() throws Exception {
        String string;
        boolean bl = false;
        ObjectName objectName = this.getMBeanByType("DeploymentManager");
        if (objectName != null && (string = objectName.getKeyProperty("node")).equals(this.nodeName)) {
            bl = true;
        }
        return bl;
    }

    private boolean sameNameAsCell() throws Exception {
        boolean bl = false;
        if (this.cellName.compareToIgnoreCase(this.newCellName.toString()) == 0) {
            bl = true;
        }
        return bl;
    }

    private void getFileTransferConfig(Properties properties) throws Exception {
        ObjectName objectName = this.getMBeanByType("FileTransferServer");
        if (objectName != null) {
            FileTransferConfig fileTransferConfig = (FileTransferConfig)this.invokeMBean(objectName, "getServerConfig", null, null);
            this.testLocalhost(fileTransferConfig);
            properties.put("fileTransferConfig", fileTransferConfig);
        }
    }

    private void testLocalhost(FileTransferConfig fileTransferConfig) throws AdminException {
        try {
            int n = 0;
            String string = null;
            String string2 = (String)fileTransferConfig.getProperties().get("host");
            if (string2.equals("localhost") || string2.equals("127.0.0.1")) {
                Socket socket;
                string = (String)fileTransferConfig.getProperties().get("secure_port");
                if (!fileTransferConfig.isSecurityEnabled() || string == null || string.equals("")) {
                    string = (String)fileTransferConfig.getProperties().get("port");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Testing file transfer socket with host=" + string2 + " and port=" + string);
                }
                if ((socket = new Socket(string2, n = Integer.parseInt(string))) != null) {
                    socket.close();
                }
            }
        }
        catch (Exception exception) {
            throw new AdminException(this.getFormattedMessage("ADMU0038E", null, null));
        }
    }

    private ConfigRepositoryClient getRepositoryClient(Properties properties) throws Exception {
        ConfigRepositoryClient configRepositoryClient = null;
        try {
            this.getFileTransferConfig(properties);
            configRepositoryClient = (ConfigRepositoryClient)ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
            configRepositoryClient.initialize(properties);
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0010E", exception);
            throw exception;
        }
        return configRepositoryClient;
    }

    protected ResourceSet createResourceSet() {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(NodeFederationUtility.this.configRoot + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    private void createAppDocuments(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAppDocuments", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "apps to be uploaded: " + this.appsIncluded);
        }
        VariableMap variableMap = this.getVarMap(this.backupRoot + "/base", this.cellName, this.nodeName);
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            Vector vector = this.getDeploymentPaths(string + File.separator + string2 + "/deployments");
            this.apps2path.put(string2, vector);
            if (this.appsIncluded.contains(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ".. uploading .." + string2);
                }
                if (variableMap == null) continue;
                String string3 = null;
                String string4 = null;
                for (int j = 0; j < vector.size(); ++j) {
                    try {
                        string3 = string4 = (String)vector.elementAt(j);
                        string3 = variableMap.expand(string3);
                        string4 = this.getVariableMap().expand(string4);
                        if (string3.equals(string4)) continue;
                        this.copyDocuments(string3, string4);
                        this.deleteDirs(string3);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU0122E", new Object[]{throwable, string3, string4}, null);
                        throw new AdminException(throwable);
                    }
                }
                continue;
            }
            this.deleteDirs(string + File.separator + string2);
            if (variableMap == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    this.deleteDirs(variableMap.expand((String)vector.elementAt(j)));
                    continue;
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Could not delete: " + variableMap.expand((String)vector.elementAt(j)));
                }
            }
        }
        variableMap = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAppDocuments");
        }
    }

    protected void emitNotification(String string, String string2) {
        if (this.notificationService != null) {
            String string3 = null;
            string3 = string.equals("ADMU0001I") && !this.invokedFromMBean ? "websphere.addnode.starting" : (string.equals("ADMU0003I") ? "websphere.addnode.complete" : (string.equals("ADMU0211I") ? "websphere.addnode.failed" : "websphere.addnode.message"));
            try {
                this.adminClient.invoke(this.notificationService, "emitNotification", new Object[]{string3, string2, this.notificationUserData}, NTFY_PARAMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setupNodeAgentData(String string) throws Exception {
        this.setupServerRepository(string, "nodeagent");
    }

    protected Repository getNewLocalRepository(String string) throws Exception {
        return RepositoryFactory.createRepository("ws-server", this.configRoot, this.newCellName, this.nodeName, string);
    }

    protected Repository getLocalRepository() throws Exception {
        if (this.localRunTimeRepository == null) {
            Vector vector = this.getServerList();
            if (vector != null && vector.size() > 0) {
                this.setupServerRepository(this.cellName, (String)vector.elementAt(0));
            } else {
                this.setupServerRepository(this.cellName, "nodeagent");
            }
        }
        return this.localRunTimeRepository;
    }

    protected VariableMap getVariableMap() throws Exception {
        Vector vector;
        if (this.map == null && (vector = this.getServerList()) != null && vector.size() > 0) {
            this.setupServerRepository(this.cellName, (String)vector.elementAt(0));
        }
        return this.map;
    }

    private void setupServerRepository(String string, String string2) throws Exception {
        this.localRunTimeRepository = this.setupServerRepository(string, this.nodeName, string2);
        this.map = VariableMapFactory.createVariableMap(this.localRunTimeRepository);
        this.map.initialize(null);
    }

    private Repository setupServerRepository(String string, String string2, String string3) throws Exception {
        return RepositoryFactory.createRepository("ws-server", this.configRoot, string, string2, string3);
    }

    protected int launchNodeAgent() throws Exception {
        int n = 0;
        try {
            LaunchCommand launchCommand = null;
            ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
            serverIdentifiers.setConfigRoot(this.configRoot);
            serverIdentifiers.setCellName(this.newCellName);
            serverIdentifiers.setNodeName(this.nodeName);
            serverIdentifiers.setServerName("nodeagent");
            this.issueMessage("ADMU0020I", new Object[]{serverIdentifiers.getServerName()}, null);
            launchCommand = this.isZOS() ? new LaunchCommand(this.getNewLocalRepository("nodeagent"), this.getVariableMap(), serverIdentifiers) : new LaunchCommand(this.getLocalRepository(), this.getVariableMap(), serverIdentifiers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Launching a new server process: " + serverIdentifiers.getServerName());
            }
            n = System.getProperty("os.name").equals("OS/400") ? this.launchNodeAgentOnOS400() : this.launchNodeAgentNotOnOS400(launchCommand);
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0114E", exception);
            throw exception;
        }
        return n;
    }

    private int launchNodeAgentOnOS400() throws Exception {
        Object object;
        String string = "";
        if (System.getenv("PROFILE_CONFIG_ACTION") != null && System.getenv("PROFILE_CONFIG_ACTION").equalsIgnoreCase("true") && System.getenv("WAS_USER_SCRIPT") != null) {
            string = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "startServer nodeagent";
        } else {
            object = System.getProperty("instance.name");
            string = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "startServer -profileName " + (String)object + " " + "nodeagent";
        }
        if (this.nowait) {
            string = string + " -nowait";
        }
        object = Runtime.getRuntime();
        Process process = ((Runtime)object).exec(string);
        if (!this.nowait) {
            process.waitFor();
            this.issueMessage("ADMU0022I", null, null);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "cp037"));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream(), "cp037"));
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                if (string3.indexOf("CPC1221") != -1) {
                    string2 = string3.substring(13, 38);
                }
                if (string3.indexOf("CWNATV01I") == -1) continue;
                bl = true;
                break;
            }
            while (!bl && (string3 = bufferedReader2.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
                if (string3.indexOf("CPC1221") != -1) {
                    string2 = string3.substring(13, 38);
                }
                if (string3.indexOf("CWNATV01I") == -1) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.issueMessage("ADMU0030I", new Object[]{string2}, null);
            } else {
                this.issueMessage("ADMU0031E", new Object[]{string2}, null);
            }
        }
        return 0;
    }

    private int launchNodeAgentNotOnOS400(LaunchCommand launchCommand) throws Exception {
        int n = 0;
        if (!this.nowait) {
            launchCommand.setStatusSocketPort(this.getStatusPort());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "status socket = " + this.getStatusPort().toString());
            }
        }
        com.ibm.ws.process.Process process = launchCommand.launchProcess();
        if (!this.nowait) {
            this.issueMessage("ADMU0022I", null, null);
            if (!this.isZOS()) {
                new ProcessWatcher(process);
            }
            if ((n = this.waitForServerInit()) == 0) {
                this.issueMessage("ADMU0030I", new Object[]{process.id()}, null);
            } else {
                this.issueMessage("ADMU0031E", new Object[]{process.id()}, null);
            }
        }
        return n;
    }

    private int waitForServerInit() {
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = this.getStatusSocket().accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                Tr.error(tc, "ADMU0023E", iOException);
                socket = null;
                bl = true;
                n = -1;
            }
            if (socket == null) continue;
            n = this.getStatus(socket);
            if (n == 0 || n == 0 || n == -1) {
                bl = true;
                continue;
            }
            if (n != 2) continue;
            this.issueMessage("ADMU3220I", null, null);
        }
        if (!bl) {
            n = -2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStatus(Socket socket) {
        int n = -1;
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = socket.getInputStream();
            filterInputStream = new DataInputStream(inputStream);
            n = ((DataInputStream)filterInputStream).readInt();
        }
        catch (IOException iOException) {
            Tr.error(tc, "ADMU0023E", iOException);
            int n2 = -1;
            return n2;
        }
        finally {
            try {
                filterInputStream.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                Tr.error(tc, "ADMU0023E", iOException);
            }
            filterInputStream = null;
            inputStream = null;
        }
        return n;
    }

    private String getDCSHostName(ServerEntry serverEntry) {
        String string = null;
        EList eList = serverEntry.getSpecialEndpoints();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)iterator.next();
            if (!namedEndPoint.getEndPointName().equals("DCS_UNICAST_ADDRESS")) continue;
            string = namedEndPoint.getEndPoint().getHost();
            return string;
        }
        return string;
    }

    private void addToServerIndex(String string) throws Exception {
        Object object;
        String[] stringArray;
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        String string2 = serverIndex.getHostName();
        if (string2 == null || string2.length() < 1) {
            string2 = AdminHelper.getInstance().getHostName();
            serverIndex.setHostName(string2);
        }
        this.throwExceptionIfCellMgrCannotPing(string2);
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        this.indexFactory = serverindexPackage.getServerindexFactory();
        IpcPackage ipcPackage = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcPackage.getIpcFactory();
        EList eList = serverIndex.getServerEntries();
        ArrayList arrayList = new ArrayList();
        List list = this.getAdminHostPorts();
        for (int i = 0; i < eList.size(); ++i) {
            stringArray = (String[])eList.get(i);
            if (AdminHelper.getPlatformHelper().isZOS() && this.dcsHostName == null) {
                this.dcsHostName = this.getDCSHostName((ServerEntry)stringArray);
            }
            object = stringArray.getServerName();
            this.adjustServerConfig((String)object, arrayList, list);
            this.addOrRemoveAppsForServer((ServerEntry)stringArray);
        }
        ServerEntry serverEntry = this.indexFactory.createServerEntry();
        serverEntry.setServerName(string);
        serverEntry.setServerDisplayName(string);
        serverEntry.setServerType("NODE_AGENT");
        stringArray = this.getConfigRoots();
        object = new PortConflictResolver(stringArray);
        this.updateAppServerPorts(serverIndex, string, (PortConflictResolver)object);
        if (this.startingPort == null) {
            this.naConfigBuilder.addNodeAgentEndpoints(serverIndex, serverEntry, this.indexFactory, (PortConflictResolver)object, this.dcsHostName);
        } else {
            this.startingPort = new Integer(this.naConfigBuilder.addNodeAgentEndpointsUsingStartingPort(serverIndex, serverEntry, this.indexFactory, this.startingPort, this.dcsHostName));
        }
        serverIndex.getServerEntries().add((Object)serverEntry);
        this.setORBLAandBOOTSTRAP_ADDRESS_toSameValue(serverIndex);
        resource.save(new HashMap());
    }

    private List getAdminHostPorts() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        this._adminHosts = new ArrayList();
        this._adminPorts = new ArrayList();
        Resource resource = this.getLocalRepository().getConfigRoot().getResource(0, "virtualhosts.xml");
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Iterator iterator;
            Object e2 = eList.get(i);
            if (!(eList.get(i) instanceof VirtualHost)) continue;
            VirtualHost virtualHost = (VirtualHost)e2;
            if (virtualHost.getName().equals("admin_host")) {
                iterator = virtualHost.getAliases().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(((HostAlias)iterator.next()).getPort());
                }
                continue;
            }
            if (!virtualHost.getName().equals("default_host")) continue;
            iterator = virtualHost.getAliases().iterator();
            while (iterator.hasNext()) {
                HostAlias hostAlias = (HostAlias)iterator.next();
                this._adminHosts.add(hostAlias.getHostname());
                this._adminPorts.add(hostAlias.getPort());
            }
        }
        return arrayList;
    }

    private String[] getConfigRoots2() throws WSProfileException {
        Tr.entry(tc, "getConfigRoots");
        String[] stringArray = null;
        File file = WSProfile.getRegistryFile();
        Tr.debug(tc, "Using profile registry: " + file);
        List list = WSProfile.listProfileNames(file);
        stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Tr.debug(tc, "Found profile: " + string);
            File file2 = WSProfile.getProfileLocation(string, file);
            Tr.debug(tc, "   Profile location: " + file2);
            stringArray[n++] = file2.getAbsolutePath() + "/config";
        }
        Tr.exit(tc, "getConfigRoots", stringArray);
        return stringArray;
    }

    private String[] getConfigRoots() throws WSProfileException {
        String[] stringArray = this.getAllWASLocations();
        if (stringArray == null || stringArray.length == 0) {
            return this.getConfigRoots2();
        }
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this.getAllConfigLocations(vector, stringArray[i]);
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = (String)vector.get(i);
        }
        return stringArray2;
    }

    private String[] getAllWASLocations() {
        WASSystem wASSystem = null;
        try {
            wASSystem = WASSystem.getWASSystemInstance();
            return wASSystem.getWASLocations();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Vector getAllConfigLocations(Vector vector, String string) {
        block7: {
            if (string == null) {
                return vector;
            }
            if (vector == null) {
                vector = new Vector<String>();
            }
            try {
                File file = WSProfile.getRegistryFile(string);
                if (file != null && file.exists()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing  profile registry: " + file.getAbsolutePath());
                    }
                    List list = WSProfile.getProfileList(file);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Profile profile = (Profile)iterator.next();
                        String string2 = profile.getPath().getAbsolutePath();
                        String string3 = this.getConfigRootFromProfileHome(string2);
                        if (string3 == null) continue;
                        vector.addElement(string3);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Error reading profile registry " + throwable.getMessage());
            }
        }
        return vector;
    }

    private String getConfigRootFromProfileHome(String string) {
        String string2 = "config";
        String string3 = null;
        File file = new File(string + File.separator + string2);
        if (file.exists() && file.isDirectory()) {
            try {
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string3 = null;
            }
        }
        return string3;
    }

    private int getPortValueFromEndPoints(List list, String string) {
        int n = -1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)iterator.next();
            if (!namedEndPoint.getEndPointName().equals(string)) continue;
            n = namedEndPoint.getEndPoint().getPort();
            break;
        }
        return n;
    }

    private void setPortValue(List list, String string, int n) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)iterator.next();
            if (!namedEndPoint.getEndPointName().equals(string)) continue;
            namedEndPoint.getEndPoint().setPort(n);
            break;
        }
    }

    private void setORBLAandBOOTSTRAP_ADDRESS_toSameValue(ServerIndex serverIndex) {
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isZOS = true, setORBLAandBOOTSTRAP_ADDRESS_toSameValue entry");
        }
        int n = -1;
        int n2 = -1;
        EList eList = serverIndex.getServerEntries();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EList eList2 = ((ServerEntry)iterator.next()).getSpecialEndpoints();
            n = this.getPortValueFromEndPoints((List)eList2, "BOOTSTRAP_ADDRESS");
            n2 = this.getPortValueFromEndPoints((List)eList2, "ORB_LISTENER_ADDRESS");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "orbListenerPort = " + n2 + "bootstrapPort = " + n);
            }
            if (n == n2) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "orbListenerPort and bootstrapPort is same, no need to set");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting ORB_LISTENER_ADDRESS to bootStrapPort");
            }
            this.setPortValue((List)eList2, "ORB_LISTENER_ADDRESS", n);
        }
    }

    private void updateAppServerPorts(ServerIndex serverIndex, String string, PortConflictResolver portConflictResolver) {
        EList eList = serverIndex.getServerEntries();
        if (this.givenAppserverBootstrapPort == null) {
            this.replace2809InAppServerPorts((List)eList, string, portConflictResolver);
        } else {
            this.replaceBootstrapInAppServerPorts((List)eList, string, portConflictResolver);
        }
    }

    private void replace2809InAppServerPorts(List list, String string, PortConflictResolver portConflictResolver) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EList eList = ((ServerEntry)iterator.next()).getSpecialEndpoints();
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                int n;
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                if (!namedEndPoint.getEndPointName().equals("BOOTSTRAP_ADDRESS") || (n = namedEndPoint.getEndPoint().getPort()) != 2809) continue;
                int n2 = Utils.resolvePort(9810, portConflictResolver);
                this.replacePort(namedEndPoint, n2, portConflictResolver);
            }
        }
    }

    private void replaceBootstrapInAppServerPorts(List list, String string, PortConflictResolver portConflictResolver) {
        boolean bl = false;
        int n = this.givenAppserverBootstrapPort;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EList eList = ((ServerEntry)iterator.next()).getSpecialEndpoints();
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                if (!namedEndPoint.getEndPointName().equals("BOOTSTRAP_ADDRESS")) continue;
                if (bl) {
                    n = Utils.resolvePort(n, portConflictResolver);
                }
                this.replacePort(namedEndPoint, n, portConflictResolver);
                bl = true;
            }
        }
    }

    private void replacePort(NamedEndPoint namedEndPoint, int n, PortConflictResolver portConflictResolver) {
        int n2 = namedEndPoint.getEndPoint().getPort();
        namedEndPoint.getEndPoint().setPort(n);
        portConflictResolver.reservePort(n);
        portConflictResolver.unreservePort(n2);
    }

    private void issueWarningsIfAny(Collection collection, String string) {
        if (collection != null && !collection.isEmpty()) {
            int n = 0;
            String string2 = "\n";
            String[] stringArray = (String[])collection.toArray();
            for (int i = 0; i < stringArray.length; ++i) {
                n += stringArray[i].length();
                n += string2.length();
            }
            n = (n + 256) / 256 * 256;
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                stringBuffer.append(string2);
                if (string3.length() > 0) {
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append("Warning message missing?");
            }
            String string4 = "" + stringArray.length;
            this.issueMessage(string, new Object[]{string4, this.nodeName, this.nodeGroupName, stringBuffer.toString()}, null);
        }
    }

    private void addOrRemoveAppsForServer(ServerEntry serverEntry) {
        EList eList = serverEntry.getDeployedApplications();
        if (!this.includeapps) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove all apps");
            }
            while (eList.size() > 0) {
                eList.remove(0);
            }
        } else {
            for (int i = 0; i < eList.size(); ++i) {
                String string = (String)eList.get(i);
                if (string.startsWith("adminconsole.ear")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "... skip .. " + string);
                    }
                    eList.remove(string);
                    --i;
                    continue;
                }
                String string2 = string.substring(0, string.indexOf(47));
                try {
                    boolean bl;
                    String string3 = "cells/" + this.newCellName + "/applications/" + string;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for " + string3 + " in " + this.configRepositoryClient);
                    }
                    String[] stringArray = this.configRepositoryClient.listResourceNames(string3, 1, 1);
                    Tr.debug(tc, "result.length = " + stringArray.length);
                    boolean bl2 = bl = stringArray.length == 1;
                    if (bl) {
                        this.issueMessage("ADMU0120I", new Object[]{string2}, null);
                        eList.remove(string);
                        --i;
                        continue;
                    }
                    this.appsIncluded.add(string2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "... include app: " + string2);
                    continue;
                }
                catch (Throwable throwable) {
                    this.issueMessage("ADMU0121E", new Object[]{throwable, string2}, null);
                }
            }
        }
    }

    private void throwExceptionIfCellMgrCannotPing(String string) throws Exception {
        if (this.isZOS()) {
            this.throwExceptionIfCellMgrCannotPing_1(string);
        } else {
            String string2 = (String)this.adminClient.invoke(this.getMBeanByType("JVM"), "getIPAddress", new Object[]{string}, new String[]{"java.lang.String"});
            String string3 = InetAddress.getByName(string).getHostAddress();
            if (string2 == null || !string2.equals(string3)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JVM->getIPAddress->ipAddress: " + string2);
                }
                throw new AdminException(this.getFormattedMessage("ADMU0036E", new Object[]{string, string3}, null));
            }
        }
    }

    private void throwExceptionIfCellMgrCannotPing_1(String string) throws Exception {
        String string2 = null;
        String string3 = (String)this.adminClient.invoke(this.getMBeanByType("JVM"), "getIPAddress", new Object[]{string}, new String[]{"java.lang.String"});
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        for (int i = 0; i < inetAddressArray.length; ++i) {
            string2 = inetAddressArray[i].getHostAddress();
            if (string3 == null || !string3.equals(string2)) continue;
            return;
        }
        throw new AdminException(this.getFormattedMessage("ADMU0036E", new Object[]{string, InetAddress.getByName(string).getHostAddress()}, null));
    }

    private void throwExceptionIfNodeCannotPingCellMgr() throws Exception {
        List list = this.getNewNodes();
        String string = null;
        String string2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = this.getDmgrHostName(string);
            if (string2 == null || string2.length() == 0) continue;
            try {
                InetAddress.getByName(string2);
                break;
            }
            catch (Exception exception) {
                this.issueMessage("ADMU0037E", new Object[]{string2}, null);
                throw new AdminException(exception);
            }
        }
    }

    private String getDmgrHostName(String string) throws Exception {
        String string2 = null;
        Repository repository2 = this.setupServerRepository(this.newCellName, string, null);
        ConfigRoot configRoot = repository2.getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        EList eList = resource.getContents();
        ServerIndex serverIndex = null;
        block0: for (int i = 0; i < eList.size(); ++i) {
            serverIndex = (ServerIndex)resource.getContents().get(i);
            EList eList2 = serverIndex.getServerEntries();
            for (int j = 0; j < eList2.size(); ++j) {
                ServerEntry serverEntry = (ServerEntry)eList2.get(j);
                String string3 = serverEntry.getServerType();
                if (string3.equals("DEPLOYMENT_MANAGER")) break block0;
            }
            serverIndex = null;
        }
        if (serverIndex != null) {
            string2 = serverIndex.getHostName();
        }
        return string2;
    }

    protected List getNewNodes() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.configRoot + "/cells/" + this.newCellName + "/nodes";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                if (!fileArray[i].isDirectory() || (string2 = fileArray[i].getName()).equals(this.nodeName)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void showNextTasks() {
        this.issueMessage("ADMU0306I", null, null);
        this.issueMessage("ADMU0302I", new Object[]{this.cellName}, null);
        this.issueMessage("ADMU0307I", null, null);
        this.issueMessage("ADMU0303I", new Object[]{this.newCellName}, null);
        if (!this.includeapps) {
            this.issueMessage("ADMU9990I", null, null);
            this.issueMessage("ADMU0306I", null, null);
            this.issueMessage("ADMU0304I", null, null);
            this.issueMessage("ADMU0307I", null, null);
            this.issueMessage("ADMU0305I", new Object[]{this.newCellName}, null);
        }
        this.issueMessage("ADMU9990I", null, null);
        this.issueMessage("ADMU0003I", new Object[]{this.nodeName}, null);
    }

    private void adjustServerConfig(String string, List arrayList, List list) throws Exception {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        String string2 = configRoot.getValue(4);
        configRoot.setValue(4, string);
        Resource resource = configRoot.getResource(4, "server.xml");
        configRoot.setValue(4, string2);
        Server server2 = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof Server)) continue;
            server2 = (Server)e2;
            break;
        }
        if (server2 != null) {
            EList eList2;
            String string3;
            Chain chain;
            int n;
            EList eList3;
            AdminService adminService;
            EList eList4 = server2.getServices();
            for (int i = 0; i < eList4.size(); ++i) {
                Service service = (Service)eList4.get(i);
                if (service instanceof AdminService) {
                    adminService = (AdminService)service;
                    adminService.setStandalone(false);
                    continue;
                }
                if (!(service instanceof TransportChannelService)) continue;
                adminService = (TransportChannelService)service;
                eList3 = adminService.getChains();
                for (n = 0; n < eList3.size(); ++n) {
                    chain = (Chain)eList3.get(n);
                    if (chain == null || chain.getTransportChannels().isEmpty()) continue;
                    string3 = (TransportChannel)chain.getTransportChannels().get(0);
                    eList2 = (TransportChannel)chain.getTransportChannels().get(chain.getTransportChannels().size() - 1);
                    if (!(string3 instanceof TCPInboundChannel) || !(eList2 instanceof WebContainerInboundChannel) || !this.isBoundToAdminPort((TCPInboundChannel)string3, string, list)) continue;
                    chain.setEnable(false);
                }
            }
            EList eList5 = server2.getComponents();
            for (int i = 0; i < eList5.size(); ++i) {
                adminService = (Component)eList5.get(i);
                if (adminService instanceof JMSServer) {
                    eList3 = (JMSServer)adminService;
                    EList eList6 = eList3.getQueueNames();
                    for (int j = 0; j < eList6.size(); ++j) {
                        string3 = (String)eList6.get(j);
                        if (arrayList.contains(string3)) continue;
                        arrayList.add(string3);
                    }
                    eList5.remove(adminService);
                    break;
                }
                if (!(adminService instanceof ApplicationServer) || this.isZOS()) continue;
                eList3 = adminService.getComponents();
                for (n = 0; n < eList3.size(); ++n) {
                    chain = (Component)eList3.get(n);
                    if (!(chain instanceof WebContainer)) continue;
                    string3 = (WebContainer)chain;
                    eList2 = string3.getTransports();
                    for (int j = 0; j < eList2.size(); ++j) {
                        HTTPTransport hTTPTransport = (HTTPTransport)eList2.get(j);
                        if (!this.isInList(new Integer(hTTPTransport.getAddress().getPort()).toString(), list)) continue;
                        eList2.remove(j);
                        --j;
                    }
                }
            }
        }
        resource.save(new HashMap());
    }

    private boolean isBoundToAdminPort(TCPInboundChannel tCPInboundChannel, String string, List list) throws Exception {
        ServerEntry serverEntry = this.getServerEntry(string);
        if (serverEntry == null) {
            return false;
        }
        EndPoint endPoint = this.getEndPointByName(serverEntry, tCPInboundChannel.getEndPointName());
        if (serverEntry == null) {
            return false;
        }
        return this.isInList(String.valueOf(endPoint.getPort()), list);
    }

    private EndPoint getEndPointByName(ServerEntry serverEntry, String string) {
        if (string == null) {
            return null;
        }
        EList eList = serverEntry.getSpecialEndpoints();
        for (int i = 0; i < eList.size(); ++i) {
            NamedEndPoint namedEndPoint;
            Object e2 = eList.get(i);
            if (!(e2 instanceof NamedEndPoint) || !string.equals((namedEndPoint = (NamedEndPoint)e2).getEndPointName())) continue;
            return namedEndPoint.getEndPoint();
        }
        return null;
    }

    private ServerEntry getServerEntry(String string) throws Exception {
        if (string == null) {
            return null;
        }
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        EList eList = resource.getContents();
        if (eList == null || eList.isEmpty() || !(eList.get(0) instanceof ServerIndex)) {
            return null;
        }
        ServerIndex serverIndex = (ServerIndex)eList.get(0);
        eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry;
            Object e2 = eList.get(i);
            if (!(e2 instanceof ServerEntry) || !string.equals((serverEntry = (ServerEntry)e2).getServerName())) continue;
            return serverEntry;
        }
        return null;
    }

    private boolean isInList(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String copyToServer(File file, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyToServer", new Object[]{file, string});
        }
        AdminClient adminClient = this.getAdminClient();
        adminClient.getConnectorProperties();
        FileTransferClient fileTransferClient = FileTransferFactory.getFileTransferClient(adminClient);
        String string2 = fileTransferClient.getServerStagingLocation();
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        fileTransferOptions.setDeleteSourceOnCompletion(true);
        fileTransferClient.uploadFile(file, string, fileTransferOptions);
        String string3 = string2 + string;
        string3 = string3.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToServer", string3);
        }
        return string3;
    }

    protected void collectNodeMetadata(AdminClient adminClient) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "collectNodeMetadata");
            }
            try {
                Properties properties = this.getClientProperties();
                properties.setProperty("local.cell", properties.getProperty("cellName"));
                properties.setProperty("local.node", properties.getProperty("nodeName"));
                properties.setProperty("was.repository.root", this.configRoot);
                ManagedObjectMetadataCollectorManager managedObjectMetadataCollectorManager = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(properties, adminClient);
                Properties properties2 = managedObjectMetadataCollectorManager.updateMetadata("Collect Metadata", null);
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Could not run local metadata collection.", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectNodeMetadata");
        }
    }

    public class ProcessWatcher
    extends Thread {
        com.ibm.ws.process.Process process;

        public ProcessWatcher(com.ibm.ws.process.Process process) {
            this.process = process;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                if (this.process.isAlive()) {
                    this.process.waitForTermination();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Socket socket = new Socket("localhost", NodeFederationUtility.this.getStatusSocket().getLocalPort());
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeInt(-1);
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

